/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */


#ifndef _GLOBAL_H_
#define _GLOBAL_H_

#include <QString>
#include <QSettings>

#include <KF5/KWindowSystem/kwindoweffects.h>
#include "kvsqlite.h"
#include "globalsetup.h"
#include "shortcutsetting.h"
#include "ukui-wayland/ukui-decoration-client.h"
#include "ukui-wayland/ukui-decoration-manager.h"
#include "ukui-wayland/plasma-shell-manager.h"

// Some global objects
#define MENUWIDTH 180
#define MENU_BAR_BTN_SIZE 30
#define CONTRAL_BAR_BTN_SIZE 16

class QSettings;
class Translator;
class QGSettings;
class ShortCutSetting;
//using namespace Control;
#define ORG_UKUI_STYLE      "org.ukui.style"
#define STYLE_UKUI_DEFAULT  "ukui"
#define STYLE_UKUI_BLACK    "ukui-dark"
#define ICO_DIR_DEFAULT     "ico_light"
#define ICO_DIR_DBLACK      "ico"

namespace Global {

// 错误类型
enum KERROR_TYPE{
    NO_ERROR = 0
};

extern QGSettings       *g_gsettings;
//! Read and store application settings
extern QSettings        *g_settings;
extern KVSqlite         *g_sqlite;
extern GlobalSetup      *gsetup;
extern ShortCutSetting  *gshortCut;
extern bool isWayland;

//! Translator (for changing language)
extern Translator * translator;

void global_init();
void global_end();
}

#endif

