package junit.test.svg;

import junit.framework.TestCase;
import latexDraw.parsers.svg.SVGLength;
import latexDraw.parsers.svg.SVGLength.LengthType;

import org.junit.Test;

/** 
 * Tests the class SVGLength.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE.  See the GNU General Public License for more details.<br>
 *<br>
 * 10/24/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 0.1<br>
 * @since 0.1<br>
 */
@SuppressWarnings("nls")
public class TestSVGLength extends TestCase
{
	@Test
	public void testConsctrutor()
	{
		try
		{
			new SVGLength(1, null, "1");
			fail();
		}
		catch(IllegalArgumentException e){ /* */ }
		
		try
		{
			new SVGLength(1, LengthType.CM, null);
			fail();
		}
		catch(IllegalArgumentException e){ /* */ }
	}
	
	
	@Test
	public void testGetters()
	{
		SVGLength l = new SVGLength(1, LengthType.MM, "1");
		
		assertEquals(l.getValue(), 1.);
		assertEquals(l.getLengthType(), LengthType.MM);
		assertEquals(l.getValueAsString(), "1");
	}
}
