/// Verifies that DMD using default settings work as expected
/// when using the default configuration + some example programs
module defaults;

import std.algorithm;
import std.file;
import std.path;
import std.stdio;

import dshell;

int main(const string[] args)
{
	// dshellPrebuiltInit("dshell", "defaults");

	try
	{
		testConfigurations();
		return 0;
	}
	catch (Throwable t)
	{
		writeln(t.msg);
		return 1;
	}
}

void testConfigurations()
{
	// Compilation targets
	const string[] targets = [ MODEL ];

	// Configuration file
	version (Windows)
		const string config = `bin\sc.ini`;
	else version (OSX)
		const string config = `bin/dmd.conf`;
	else
		const string config = `bin` ~ MODEL ~ `/dmd.conf`;

	// Static configuration file for the final release
	string configPath = buildNormalizedPath(dirName(__FILE_FULL_PATH__), "..", "..", "ini", OS, config);

	// Flag sets to test
	string[] extraFlags = [
		// Minimal configuration generated by build.d
		"",
		// Predefined, full configuration located in ini
		"-conf=" ~ configPath
	];

	version (Windows) if (MODEL == "32omf")
	{
		// 32-OMF tries to use `optlink.exe` located next to `sc.ini`
		// and also doesn't like the LIB setup, so skip it for now
		extraFlags = [""];
	}

	foreach (const target; targets)
	{
		foreach (const flags; extraFlags)
		{
			run(
				`$DMD ` ~ flags ~ ` -g -m` ~ target
				~ ` -I$EXTRA_FILES/defaults `
				~ DFLAGS
				~ ` $EXTRA_FILES/defaults/hello.d `
				~ ` -of=$OUTPUT_BASE/hello$EXE `,
			);

			auto pipe = std.process.pipe();
			run(`$OUTPUT_BASE/hello$EXE`, pipe.writeEnd, stderr);
			const output = cast(string) pipe.readEnd.byChunk(4096).join();
			stdout.writeln(output);
			assert(output.canFind("Hello, World from D!"));
		}
	}
}
