/***********************************************************************************

    Copyright (C) 2007-2020 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_WIDGETMAP_HEADER
#define LIFEOGRAPH_WIDGETMAP_HEADER


extern "C"
{
#include <champlain-gtk/champlain-gtk.h>
}

#include <gtkmm.h>

#include "../diarydata.hpp"

namespace LIFEO
{

// WRAPPER FOR MAP WIDGET ==========================================================================
class WidgetMap
{
    public:
        WidgetMap();

        void                        refresh()
        {
            if( Glib::RefPtr< Gdk::Window > window = m_W_map->get_window() )
                window->invalidate( false );
        }

        Gtk::Widget&                get_widget()
        { return *m_EBx; }
        double                      get_latitude()
        { return m_latitude; }
        double                      get_longitude()
        { return m_longitude; }

        void                        set_diary( Diary* );
        void                        set_entry( Entry*, bool = true );

        void                        handle_editing_enabled();

        void                        center_on( double, double );


//        SignalVoid                  signal_assign_coord()
//        { return m_Sg_assign_coord; }

    protected:
        void                        show_Po( int, int );

        void                        refresh_entry_locations();

        void                        add_entry_node( Entry* );

        void                        create_entry_at_location();

        static void                 go_to_entry( ChamplainMarker*, ClutterEvent*, gpointer );
        static void                 update_path_point( ChamplainMarker*, ClutterEvent*, gpointer );
        static void                 handle_node_click( GObject*, GParamSpec*, gpointer );

        void                        add_path_point_to_entry();
        void                        add_path_point( const Coords&, const ArrayPosition& );
        void                        remove_last_path_point_from_entry();
        void                        remove_selected_path_point_from_entry();
        void                        refresh_path();
        void                        clear_path();
        Ustring                     get_path_distance();

        bool                        on_scroll_event( GdkEventScroll* );
        bool                        on_button_press_event( GdkEventButton* );
        bool                        on_key_press_event( GdkEventKey* );

        Gtk::EventBox*              m_EBx;
        Gtk::Widget*                m_W_map;
        ChamplainView*              m_ClV_map;

        Glib::RefPtr< Gtk::Builder >
                                    m_builder;
        Gtk::Popover*               m_Po_actions;
        Gtk::ModelButton*           m_B_assign;
        Gtk::ModelButton*           m_B_dismiss;
        Gtk::Box*                   m_Bx_header_path;
        Gtk::ModelButton*           m_B_add_path_point;
        Gtk::ModelButton*           m_B_remove_path_point;
        Gtk::ModelButton*           m_B_clear_path;
        Gtk::Switch*                m_Sw_all_locations;
        Gtk::ModelButton*           m_B_clipboard_copy;

        Cairo::RefPtr< Cairo::ImageSurface >
                                    m_IS_entry_icon;
        Cairo::RefPtr< Cairo::Context >
                                    m_IC_entry_icon;

        ChamplainPathLayer*         m_path_layer;
        ChamplainMarkerLayer*       m_marker_layer_path;
        ChamplainMarkerLayer*       m_marker_layer_entries;
        std::vector< ClutterActor* >    m_path;
        ClutterActor*               m_marker_distance{ nullptr }; // the last node
        ClutterActor*               m_marker_entry_cur{ nullptr };
        gpointer                    m_marker_selected{ nullptr };

        double                      m_latitude;
        double                      m_longitude;

        Diary*                      m_p2diary{ nullptr };
        Entry*                      m_p2entry_cur{ nullptr };

//        SignalVoid                  m_Sg_assign_coord;

        bool                        m_flag_inhibit_deselect{ false };

        const static ClutterColor   s_color_entry;
        const static ClutterColor   s_color_entry_cur;
        const static ClutterColor   s_color_path;
        static ClutterColor         s_color_path_sel;
};

} // end of namespace LIFEO

#endif
