; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals --version 2
; RUN: opt -passes=instcombine -S < %s | FileCheck %s

target datalayout = "e-m:e-p:64:64:64-i64:64-f80:128-n8:16:32:64-S128"

; Check that nonnull metadata is not propagated from dominating load.
define void @combine_metadata_dominance1(ptr %p) {
; CHECK-LABEL: define void @combine_metadata_dominance1
; CHECK-SAME: (ptr [[P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[BB1:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[A:%.*]] = load ptr, ptr [[P]], align 8
; CHECK-NEXT:    store i32 0, ptr [[A]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %a = load ptr, ptr %p, !nonnull !0
  br label %bb1

bb1:
  %b = load ptr, ptr %p
  store i32 0, ptr %a
  store i32 0, ptr %b
  ret void
}

declare i32 @use(ptr, i32) readonly

; Check that nonnull from the dominated load does not get propagated.
; There are some cases where it would be safe to keep it.
define void @combine_metadata_dominance2(ptr %p, i1 %c1) {
; CHECK-LABEL: define void @combine_metadata_dominance2
; CHECK-SAME: (ptr [[P:%.*]], i1 [[C1:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C1]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[A:%.*]] = load ptr, ptr [[P]], align 8
; CHECK-NEXT:    store i32 0, ptr [[A]], align 4
; CHECK-NEXT:    ret void
; CHECK:       bb2:
; CHECK-NEXT:    ret void
;
entry:
  %a = load ptr, ptr %p
  br i1 %c1, label %bb1, label %bb2

bb1:
  %b = load ptr, ptr %p, !nonnull !0
  store i32 0, ptr %a
  store i32 0, ptr %b
  ret void

bb2:
  ret void
}

define void @combine_metadata_dominance3(ptr %p) {
; CHECK-LABEL: define void @combine_metadata_dominance3
; CHECK-SAME: (ptr [[P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[BB1:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[A:%.*]] = load ptr, ptr [[P]], align 8, !nonnull !0, !noundef !0
; CHECK-NEXT:    store i32 0, ptr [[A]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %a = load ptr, ptr %p, !nonnull !0, !noundef !1
  br label %bb1

bb1:
  %b = load ptr, ptr %p
  store i32 0, ptr %a
  store i32 0, ptr %b
  ret void
}

define void @combine_metadata_dominance4(ptr %p) {
; CHECK-LABEL: define void @combine_metadata_dominance4
; CHECK-SAME: (ptr [[P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[BB1:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[A:%.*]] = load ptr, ptr [[P]], align 8
; CHECK-NEXT:    store i32 0, ptr [[A]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %a = load ptr, ptr %p, !nonnull !0
  br label %bb1

bb1:
  %b = load ptr, ptr %p, !noundef !1
  store i32 0, ptr %a
  store i32 0, ptr %b
  ret void
}

define void @combine_metadata_dominance5(ptr %p) {
; CHECK-LABEL: define void @combine_metadata_dominance5
; CHECK-SAME: (ptr [[P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[BB1:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[A:%.*]] = load ptr, ptr [[P]], align 8, !align !1
; CHECK-NEXT:    store i32 0, ptr [[A]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %a = load ptr, ptr %p, !align !2
  br label %bb1

bb1:
  %b = load ptr, ptr %p, !align !3
  store i32 0, ptr %a
  store i32 0, ptr %b
  ret void
}

define void @combine_metadata_dominance6(ptr %p) {
; CHECK-LABEL: define void @combine_metadata_dominance6
; CHECK-SAME: (ptr [[P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[BB1:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[A:%.*]] = load ptr, ptr [[P]], align 8, !align !2, !noundef !0
; CHECK-NEXT:    store i32 0, ptr [[A]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %a = load ptr, ptr %p, !align !2, !noundef !1
  br label %bb1

bb1:
  %b = load ptr, ptr %p, !align !3
  store i32 0, ptr %a
  store i32 0, ptr %b
  ret void
}

!0 = !{}
!1 = !{}
!2 = !{i64 8}
!3 = !{i64 4}
;.
; CHECK: attributes #[[ATTR0:[0-9]+]] = { memory(read) }
;.
; CHECK: [[META0:![0-9]+]] = !{}
; CHECK: [[META1:![0-9]+]] = !{i64 4}
; CHECK: [[META2:![0-9]+]] = !{i64 8}
;.
