/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.remoting.transport.bisocket.ssl.config;

import java.util.Map;

import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.transport.bisocket.Bisocket;
import org.jboss.test.remoting.transport.config.FactoryConfigTestCaseSSLParent;


/**
 * 
 * @author <a href="mailto:ron.sigal@jboss.com">Ron Sigal</a>
 * <p>
 * Copyright (c) May 20, 2006
 * </p>
 */
public class FactoryConfigTestCase extends FactoryConfigTestCaseSSLParent
{
   protected String getTransport()
   {
      return "sslbisocket";
   }
   
   protected void addExtraCallbackConfig(Map config)
   {
      config.put(Bisocket.IS_CALLBACK_SERVER, "true");
      
      // Callback server invoker needs to create a socket factory to contact
      // secondary server socket on server side.
      config.put(SSLSocketBuilder.REMOTING_SOCKET_USE_CLIENT_MODE, "true");
      config.put(SSLSocketBuilder.REMOTING_TRUST_STORE_TYPE, "JKS");
      String trustStoreFilePath = getTruststoreFilePath();
      config.put(SSLSocketBuilder.REMOTING_TRUST_STORE_FILE_PATH, trustStoreFilePath);
      config.put(SSLSocketBuilder.REMOTING_TRUST_STORE_PASSWORD, "unit-tests-client");
   }
}
