/* ----- decode/653x3, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_653x3_checksums[] = {
  "b27ae3aea1c26f6a5fca8c98570889925a1fd8bf554105caf49b73b438463cd7",
  "6bf0b30b8a6d4c2e788ae00f91d1ecc21ee766073911c6cf22c87d6be78065c0",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_653x3_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_653x3_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_653x3_ITEMBYTES

static void *storage_decode_653x3_x;
static unsigned char *test_decode_653x3_x;
static void *storage_decode_653x3_s;
static unsigned char *test_decode_653x3_s;
static void *storage_decode_653x3_x2;
static unsigned char *test_decode_653x3_x2;
static void *storage_decode_653x3_s2;
static unsigned char *test_decode_653x3_s2;

#define precomputed_decode_653x3_NUM 4

static const unsigned char precomputed_decode_653x3_x[precomputed_decode_653x3_NUM][crypto_decode_ITEMS] = {
  {0,-1,0,-1,-1,-1,-1,2,2,-1,1,1,1,0,1,1,-1,2,2,0,2,2,0,-1,-1,0,2,-1,0,-1,0,0,2,-1,-1,1,-1,1,1,2,-1,0,0,2,2,2,0,2,0,2,2,0,-1,0,0,0,1,1,0,0,0,1,0,2,-1,1,0,-1,-1,2,0,0,2,1,2,-1,1,2,0,-1,0,-1,-1,2,1,0,-1,2,-1,2,-1,-1,0,2,1,2,2,-1,0,2,2,-1,-1,-1,1,-1,1,2,-1,1,-1,-1,2,-1,2,1,1,-1,0,2,0,1,2,1,1,-1,1,2,1,0,-1,-1,2,1,1,2,-1,2,2,0,2,2,0,1,0,1,1,2,0,2,2,1,0,1,-1,1,2,1,1,2,1,2,1,2,-1,1,1,1,0,0,0,-1,0,0,2,0,0,1,1,0,2,2,-1,-1,2,1,-1,2,2,-1,0,1,-1,2,1,1,2,1,-1,-1,1,1,2,-1,-1,-1,1,1,0,2,-1,2,1,2,0,0,0,-1,2,1,2,-1,0,1,-1,-1,1,-1,1,0,0,0,1,2,2,1,1,2,2,-1,0,2,2,-1,-1,-1,0,0,1,1,1,0,2,0,-1,1,-1,0,0,-1,-1,1,0,1,1,-1,-1,0,2,-1,0,0,0,1,-1,2,1,-1,2,2,-1,-1,1,2,2,1,1,2,2,-1,-1,0,1,1,0,1,-1,-1,-1,-1,2,2,1,1,0,1,2,2,-1,2,1,-1,0,0,-1,2,-1,2,0,-1,1,2,2,0,2,-1,-1,1,1,2,2,2,1,0,2,1,0,1,-1,2,1,1,1,1,-1,2,-1,-1,1,2,0,1,1,1,1,2,2,-1,2,1,1,2,2,-1,2,0,2,0,2,1,-1,0,0,2,1,2,0,2,-1,-1,0,0,0,2,2,2,0,1,2,0,1,1,-1,1,2,2,2,2,0,2,-1,-1,0,0,1,2,1,0,-1,2,0,1,1,0,0,2,2,2,1,2,1,1,1,-1,0,0,2,2,0,1,-1,0,2,2,-1,2,-1,2,-1,-1,2,0,1,0,2,-1,0,2,1,2,2,0,2,0,1,0,2,2,0,0,0,2,-1,-1,-1,1,-1,2,-1,2,0,2,2,1,1,-1,1,2,-1,1,-1,-1,2,2,1,2,2,0,1,-1,-1,1,0,0,2,-1,1,-1,-1,0,1,1,-1,0,0,-1,-1,-1,2,2,-1,2,0,1,0,2,1,1,2,2,1,2,-1,2,-1,2,0,-1,1,2,0,0,2,0,0,1,-1,1,2,0,2,2,0,0,2,0,2,1,2,1,-1,0,0,0,2,1,2,0,0,0,1,0,0,1,-1,2,1,2,0,-1,0,2,-1,2,-1,2,0,-1,1,0,2,1,0,1,0,0,-1,1,-1,0,1,-1,1,-1,1,2,1,-1,0,2,-1,0,2,1,0,1,0,0,0,0,1,2,0,1,1,-1,2,2,2,0,-1,-1,2,1,2,-1,1,0,-1,0,-1,-1,1,1,0,-1,2,2,-1,0,1,1,0,-1,-1,1,-1,1,-1,0,2,0,-1},
  {0,0,0,2,-1,0,0,0,0,0,-1,0,-1,2,1,1,0,-1,1,0,1,0,2,0,1,1,1,0,2,0,1,2,1,0,2,2,1,2,2,2,-1,0,2,0,0,2,-1,2,1,-1,1,-1,1,2,0,0,1,2,2,-1,2,0,0,0,0,1,0,2,1,1,0,2,1,1,-1,2,1,0,1,2,2,-1,0,2,2,0,2,0,-1,1,0,2,-1,2,2,0,0,-1,2,1,1,-1,2,2,1,2,1,1,-1,-1,2,1,-1,2,2,-1,0,1,2,-1,2,0,2,0,1,2,1,1,0,1,-1,0,2,0,-1,0,-1,-1,-1,1,2,-1,-1,-1,-1,0,2,1,2,2,0,1,2,0,-1,2,-1,-1,-1,2,2,1,0,2,-1,0,2,-1,2,1,-1,2,-1,2,1,-1,2,2,1,2,2,-1,-1,-1,-1,1,0,0,-1,2,-1,0,2,1,2,-1,2,-1,0,0,-1,-1,1,2,-1,2,1,-1,-1,-1,1,-1,2,2,0,1,-1,-1,1,2,1,1,-1,2,2,0,2,1,-1,1,-1,-1,2,-1,-1,-1,0,-1,0,0,-1,0,1,0,2,-1,1,2,0,2,1,1,2,1,1,-1,2,1,2,0,1,-1,1,0,2,0,-1,1,2,-1,1,1,0,-1,0,2,2,-1,-1,1,2,-1,2,2,2,0,-1,2,0,-1,1,0,0,-1,-1,1,1,0,0,1,-1,1,2,0,0,2,0,0,-1,2,-1,-1,-1,0,0,2,1,2,-1,0,2,-1,2,0,2,-1,1,1,-1,1,2,1,2,1,2,0,2,0,0,2,2,1,1,-1,1,0,1,1,2,-1,1,1,1,1,0,-1,1,-1,1,2,0,2,1,0,2,0,0,0,1,2,2,1,0,-1,-1,0,1,-1,2,1,1,-1,-1,0,2,0,2,-1,0,0,0,-1,0,-1,-1,0,2,0,2,2,2,1,2,-1,0,1,0,2,1,0,0,-1,0,1,2,-1,1,2,1,2,2,-1,2,2,1,1,2,1,0,0,0,2,2,1,1,1,-1,1,1,1,-1,-1,1,1,1,0,0,0,2,1,-1,2,2,0,0,-1,2,-1,2,0,1,1,1,0,-1,-1,1,2,0,2,2,0,-1,1,-1,0,2,0,2,0,0,0,-1,0,2,2,0,0,2,2,-1,-1,-1,2,1,1,1,1,-1,-1,-1,-1,2,-1,-1,0,-1,0,0,1,-1,1,2,-1,2,2,2,2,1,-1,1,1,2,0,0,2,-1,-1,1,1,1,1,0,1,0,0,2,-1,0,2,0,2,-1,-1,-1,-1,2,2,0,1,-1,2,2,0,-1,0,2,-1,2,-1,2,2,2,1,1,-1,2,2,1,0,-1,2,2,1,0,0,2,1,1,1,-1,2,2,0,1,2,0,1,0,1,-1,2,1,0,2,0,2,1,2,-1,0,2,2,2,2,-1,-1,0,0,1,-1,1,1,1,0,-1,0,-1,2,2,-1,0,1,2,2,1,0,0,2,0,2,0,-1,1,2,1,-1,1,-1,0,-1,2,-1,2,1,2,-1,1,2,0,1,2,1},
  {0,0,2,0,1,0,0,2,-1,1,-1,2,0,1,-1,2,0,-1,-1,0,0,2,2,2,-1,-1,2,0,-1,2,1,0,1,-1,-1,-1,-1,0,0,-1,2,1,0,-1,-1,-1,0,0,2,-1,2,1,1,2,1,-1,-1,-1,1,0,0,1,1,-1,-1,0,-1,-1,1,-1,1,-1,0,-1,2,1,2,0,-1,1,1,-1,1,-1,0,1,-1,2,1,0,1,1,0,0,1,1,2,-1,2,1,1,2,2,1,0,0,2,0,-1,2,2,2,1,2,0,1,1,1,-1,1,2,0,1,0,-1,0,0,0,-1,1,2,0,0,-1,2,1,-1,1,0,0,1,1,2,2,2,2,2,1,2,-1,0,2,-1,1,1,0,0,2,0,-1,1,0,-1,1,0,0,0,2,-1,-1,0,-1,0,2,-1,-1,-1,-1,0,1,-1,0,0,1,0,0,1,-1,1,1,1,0,2,0,2,2,0,2,1,1,-1,-1,0,2,0,-1,0,2,1,-1,0,1,2,2,-1,1,-1,0,-1,2,-1,2,2,-1,0,1,2,1,-1,-1,1,1,2,1,1,-1,-1,0,1,1,1,1,0,1,0,0,0,2,2,2,0,2,2,1,1,-1,2,-1,1,2,1,1,0,1,0,1,1,0,0,1,2,-1,0,1,0,2,-1,0,0,2,2,1,2,0,0,-1,2,1,0,1,0,1,0,0,1,0,-1,0,-1,-1,0,2,-1,2,2,1,0,0,-1,0,-1,2,2,-1,1,2,-1,0,0,-1,-1,1,2,-1,0,-1,1,1,2,2,1,1,1,1,2,0,-1,-1,-1,1,-1,2,2,0,1,-1,2,-1,2,1,2,-1,-1,-1,2,1,0,1,2,-1,0,1,-1,1,-1,2,1,0,2,0,-1,0,0,-1,0,1,2,2,2,1,2,-1,2,1,0,0,1,1,2,-1,0,2,1,0,1,-1,0,2,2,-1,-1,2,0,1,1,-1,2,0,2,0,-1,2,0,1,1,1,-1,0,1,0,0,1,-1,2,0,-1,1,-1,-1,0,2,-1,2,0,-1,-1,1,1,-1,1,0,1,2,1,2,0,1,1,2,-1,1,1,0,2,-1,2,2,0,0,0,0,2,-1,2,2,2,1,-1,1,2,1,0,2,-1,0,1,-1,2,-1,1,2,2,-1,0,1,0,0,-1,2,2,1,2,0,1,0,1,1,-1,0,-1,-1,2,1,0,2,1,-1,1,2,2,1,2,0,-1,-1,1,1,-1,-1,2,1,1,0,2,2,-1,2,1,1,-1,0,1,0,2,-1,0,-1,-1,0,2,2,-1,0,2,0,1,2,1,2,0,2,1,0,0,0,0,1,-1,2,-1,-1,0,2,2,-1,2,0,2,2,1,1,0,-1,-1,1,1,2,1,-1,-1,-1,2,0,-1,1,-1,0,0,2,1,0,2,-1,-1,2,0,0,2,1,0,-1,2,2,1,0,1,0,0,1,0,2,-1,0,-1,2,-1,0,-1,1,0,2,-1,-1,2,-1,1,1,-1,0,0,-1,1,0,1,2,2,2,0,0,0,2,-1,-1,1,1,-1,1,0,2,-1,2,-1,2},
  {1,-1,2,1,2,1,-1,0,-1,2,2,1,0,0,-1,0,1,2,0,-1,0,1,0,-1,2,1,1,1,0,1,0,0,0,0,1,-1,1,-1,-1,0,0,2,-1,2,1,-1,0,0,-1,0,0,2,2,2,-1,-1,0,-1,2,1,2,0,-1,0,1,1,-1,2,1,0,-1,0,-1,0,0,2,1,2,2,2,0,0,2,-1,-1,2,-1,-1,0,-1,-1,0,2,2,0,2,1,-1,-1,-1,2,1,2,0,0,1,1,2,1,0,0,1,-1,1,0,0,0,0,-1,-1,-1,-1,-1,0,-1,-1,-1,1,-1,1,0,0,2,0,-1,2,0,0,1,2,2,-1,1,-1,-1,1,-1,1,-1,2,0,-1,1,0,2,2,0,2,1,1,1,-1,1,1,-1,1,1,2,-1,2,2,1,1,0,2,2,2,0,0,1,0,-1,0,0,-1,0,1,2,-1,1,1,2,2,1,-1,1,0,2,2,2,1,2,2,2,0,2,0,2,-1,1,1,0,1,0,0,1,0,0,0,0,-1,0,2,2,-1,1,2,0,0,2,1,0,-1,2,0,0,0,-1,2,0,1,2,0,1,1,0,-1,0,2,1,0,0,0,2,0,0,-1,1,-1,2,0,2,2,-1,1,2,1,-1,0,2,-1,-1,-1,2,2,2,-1,2,1,1,0,-1,2,-1,1,-1,0,1,1,1,2,1,2,-1,-1,2,2,-1,-1,2,1,1,1,1,2,1,1,1,-1,0,2,0,-1,0,2,-1,2,0,2,0,2,-1,-1,2,2,2,2,2,1,1,0,1,-1,1,1,-1,-1,2,2,2,-1,2,1,1,1,1,-1,-1,1,-1,1,1,-1,1,1,2,-1,2,1,1,-1,2,0,-1,1,-1,2,2,-1,2,2,1,0,-1,-1,1,2,1,1,-1,0,0,-1,-1,-1,2,-1,-1,2,-1,-1,-1,0,0,1,1,2,1,1,1,0,-1,0,2,1,2,1,0,1,1,1,1,2,-1,2,-1,1,2,0,-1,1,1,0,0,1,1,0,0,0,-1,2,2,0,-1,2,0,0,1,2,-1,-1,2,1,0,2,1,-1,2,2,-1,2,0,1,-1,2,-1,1,0,2,1,1,-1,-1,-1,0,-1,0,2,1,-1,0,2,-1,-1,0,1,0,-1,2,-1,-1,-1,1,0,2,2,-1,2,1,1,-1,1,1,-1,2,2,-1,0,2,2,0,-1,0,2,0,0,-1,-1,2,1,-1,0,2,1,-1,-1,2,2,1,-1,-1,-1,1,-1,0,0,1,1,2,1,-1,1,0,1,1,-1,-1,0,0,-1,-1,2,2,2,0,1,2,1,1,2,1,1,0,2,1,2,1,1,1,0,0,-1,0,1,1,2,2,0,1,-1,-1,2,2,-1,2,0,2,-1,0,0,2,0,1,1,1,-1,0,1,1,0,2,0,-1,1,0,2,2,0,2,1,0,1,1,2,0,0,2,1,2,0,0,0,-1,-1,0,2,2,1,1,0,1,1,-1,1,-1,2,-1,0,-1,2,-1,0,-1,0,0,-1,2,2,0,0,-1,0,-1,1,-1,2,1,0,2,1,0,2,1},
} ;

static const unsigned char precomputed_decode_653x3_s[precomputed_decode_653x3_NUM][crypto_decode_STRBYTES] = {
  {17,192,163,166,124,31,52,81,131,232,212,223,125,84,90,217,24,92,59,30,193,198,12,237,211,3,226,8,179,210,185,226,6,235,124,159,233,189,137,235,238,168,21,117,105,15,203,147,172,11,58,160,205,94,177,147,32,86,190,62,61,80,106,135,20,152,66,83,201,242,224,235,67,154,0,175,249,44,197,28,126,131,254,182,201,170,12,158,234,179,62,119,75,237,13,213,159,167,248,223,80,110,156,214,239,42,245,73,207,12,103,211,126,103,95,13,200,220,43,142,240,126,130,53,66,74,1,207,217,250,206,28,94,151,120,95,183,75,181,87,150,236,209,204,97,155,133,36,226,210,180,89,229,41,127,176,99,4,26,79,26,136,116,104},
  {213,84,69,172,97,118,106,231,246,254,116,205,34,94,62,87,217,218,202,230,211,119,216,124,177,242,174,176,60,57,119,174,73,71,128,3,180,159,199,192,219,52,203,44,239,3,88,76,59,83,224,44,32,159,224,202,183,8,3,81,100,227,173,43,123,98,135,163,209,131,243,199,97,129,150,120,93,12,212,78,115,163,184,123,215,43,166,163,26,226,109,87,190,65,178,66,55,21,65,247,59,217,22,57,238,243,186,213,171,168,160,86,203,23,115,106,224,125,72,119,69,95,15,172,10,48,68,137,243,47,122,13,170,89,211,13,240,201,71,51,191,242,198,91,171,124,158,201,118,59,253,67,137,26,241,228,91,119,184,72,204,142,231,254},
  {117,214,200,201,65,253,112,108,2,20,27,80,179,46,96,41,4,34,177,135,34,201,166,165,179,190,117,252,158,138,103,84,120,177,88,250,191,211,104,29,134,213,16,13,144,148,37,106,247,173,208,209,146,143,196,60,185,160,43,164,154,213,223,43,227,154,105,57,217,212,123,177,153,101,4,205,91,196,227,20,56,161,175,122,128,124,50,59,176,57,137,108,71,145,191,179,165,211,38,61,156,114,199,169,100,201,33,52,7,138,185,167,163,205,87,205,47,110,147,140,79,22,239,153,18,108,139,239,129,194,218,179,146,77,208,211,185,183,85,50,244,220,107,160,11,28,82,219,112,109,188,89,54,49,97,195,40,133,249,87,131,98,51,107},
  {178,75,188,69,30,25,171,89,37,66,205,82,212,15,177,71,202,70,212,254,53,12,65,223,2,123,233,150,88,5,64,128,88,199,229,35,136,28,246,173,162,232,188,246,151,81,228,232,139,253,254,221,104,150,85,244,120,109,92,113,158,70,91,93,200,61,46,13,252,172,49,146,186,195,195,170,171,116,52,119,195,255,154,40,252,172,10,162,232,172,28,242,188,129,43,5,12,3,165,171,209,110,170,51,30,90,90,241,113,57,108,203,115,50,182,2,209,210,144,49,96,207,138,242,244,209,5,75,11,47,32,165,139,41,20,252,185,174,237,106,145,126,194,115,83,167,146,118,216,183,233,181,87,208,107,138,76,76,20,95,132,108,219,222},
} ;

static void test_decode_653x3_impl(long long impl)
{
  unsigned char *x = test_decode_653x3_x;
  unsigned char *s = test_decode_653x3_s;
  unsigned char *x2 = test_decode_653x3_x2;
  unsigned char *s2 = test_decode_653x3_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_653x3_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_653x3(impl);
    printf("decode_653x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_653x3_implementation(impl),ntruprime_dispatch_decode_653x3_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_653x3;
    printf("decode_653x3 selected implementation %s compiler %s\n",ntruprime_decode_653x3_implementation(),ntruprime_decode_653x3_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_653x3_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_653x3_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_653x3_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_653x3_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_653x3_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_653x3_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_653x3(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"653x3")) return;
  storage_decode_653x3_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_653x3_x = aligned(storage_decode_653x3_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_653x3_s = callocplus(crypto_decode_STRBYTES);
  test_decode_653x3_s = aligned(storage_decode_653x3_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_653x3_x2 = callocplus(maxalloc);
  test_decode_653x3_x2 = aligned(storage_decode_653x3_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_653x3_s2 = callocplus(maxalloc);
  test_decode_653x3_s2 = aligned(storage_decode_653x3_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_653x3 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_653x3();++impl)
      forked(test_decode_653x3_impl,impl);
    ++test_decode_653x3_x;
    ++test_decode_653x3_s;
    ++test_decode_653x3_x2;
    ++test_decode_653x3_s2;
  }
  free(storage_decode_653x3_s2);
  free(storage_decode_653x3_x2);
  free(storage_decode_653x3_s);
  free(storage_decode_653x3_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

