/* slist.h
 */
#ifndef SLIST_H
#define SLIST_H

#include "osl/stl/pool_allocator.h"
#ifdef __GNUC__
#  include <ext/slist>
#else
#  include <list>
#endif

namespace osl
{
  namespace stl
  {
    /**
     * pool_allocator を使う slist のラッパ
     */
    template <class T, class Alloc=pool_allocator<T> >
    struct slist :
#ifdef __GNUC__
      __gnu_cxx::slist<T,Alloc>
#else
    std::list<T,Alloc>
#endif
    {
      slist() {}
      slist(const slist&);
      ~slist();

#ifndef __GNUC__
      void erase_after(iterator p) { erase(++p); }
#endif
    };
    template <class T,class Alloc>
    slist<T,Alloc>::slist(const slist& src) :
#ifdef __GNUC__
      __gnu_cxx::slist<T,Alloc>(src)
#else
      std::list<T,Alloc>(src)
#endif
    {
    }
    template <class T,class Alloc>
    slist<T,Alloc>::~slist()
    {
    }
  } // namespace stl
  using stl::slist;
} // namespace stl


#endif /* SLIST_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
