#include "osl/search/simpleHashRecord.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::search;

class SimpleHashRecordTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(SimpleHashRecordTest);
  CPPUNIT_TEST(testSize);
  CPPUNIT_TEST(testAbsoluteBound);
  CPPUNIT_TEST_SUITE_END();
public:
  void testSize()
  {
    CPPUNIT_ASSERT(sizeof(SimpleHashRecord) <= 256);
  }
  void testAbsoluteBound()
  {
    search::SimpleHashRecord record;
    const int limit = 100;
    const int value = 300;
    CPPUNIT_ASSERT_EQUAL(false, record.hasLowerBound(limit));
    CPPUNIT_ASSERT_EQUAL(false, record.hasUpperBound(limit));

    record.setLowerBound(BLACK, limit, MoveLogProb(), value);
    CPPUNIT_ASSERT_EQUAL(true, record.hasLowerBound(limit));
    CPPUNIT_ASSERT_EQUAL(false, record.hasUpperBound(limit));
    
    CPPUNIT_ASSERT_EQUAL(true, record.hasAbsoluteLowerBound(BLACK, limit));
    CPPUNIT_ASSERT_EQUAL(false, record.hasAbsoluteLowerBound(WHITE, limit));
    CPPUNIT_ASSERT_EQUAL(false, record.hasAbsoluteUpperBound(BLACK, limit));
    CPPUNIT_ASSERT_EQUAL(true, record.hasAbsoluteUpperBound(WHITE, limit));

    CPPUNIT_ASSERT_EQUAL(value, record.absoluteLowerBound(BLACK));
    CPPUNIT_ASSERT_EQUAL(value, record.absoluteUpperBound(WHITE));

    record = SimpleHashRecord();
    record.setUpperBound(BLACK, 100, MoveLogProb(), -value);
    CPPUNIT_ASSERT_EQUAL(false, record.hasAbsoluteLowerBound(BLACK, limit));
    CPPUNIT_ASSERT_EQUAL(true, record.hasAbsoluteLowerBound(WHITE, limit));
    CPPUNIT_ASSERT_EQUAL(true, record.hasAbsoluteUpperBound(BLACK, limit));
    CPPUNIT_ASSERT_EQUAL(false, record.hasAbsoluteUpperBound(WHITE, limit));

    CPPUNIT_ASSERT_EQUAL(-value, record.absoluteLowerBound(WHITE));
    CPPUNIT_ASSERT_EQUAL(-value, record.absoluteUpperBound(BLACK));
  }
};

CPPUNIT_TEST_SUITE_REGISTRATION(SimpleHashRecordTest);

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
