------------------------------------------------------------------------------
--                             Templates Parser                             --
--                                                                          --
--                            Copyright (C) 2005                            --
--                                  AdaCore                                 --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
------------------------------------------------------------------------------

--  $Id: context.adb 308 2005-02-16 10:43:11Z obry $

with Ada.Text_IO;

with Templates_Parser;
with Test_Callback;

procedure Context is

   use Ada;

   Context : aliased Test_Callback.Log_Context;

   Translations : Templates_Parser.Translate_Table :=
     (1 => Templates_Parser.Assoc ("NAME", "Ada"));

begin
   Text_IO.Put_Line
     (Templates_Parser.Parse
        ("context.tmplt", Translations, Context => Context'Unchecked_Access));
end Context;
