#!/bin/sh

# **************************** LICENSE START ***********************************
#
# Copyright 2014 ECMWF and INPE. This software is distributed under the terms
# of the Apache License version 2.0. In applying this license, ECMWF does not
# waive the privileges and immunities granted to it by virtue of its status as
# an Intergovernmental Organization or submit itself to any jurisdiction.
#
# ***************************** LICENSE END ************************************

# This script does one thing - it parses VERSION.cmake and echoes the full
# version number of Metview.


# ensure that we fail on errors
set -e


# extract the version number from the CMake version file
MV_MAJOR=`head -3 VERSION.cmake | grep -h  "MAJOR_VERSION_STR"    | cut -d'"' -f2`
MV_MINOR=`head -3 VERSION.cmake | grep -h  "MINOR_VERSION_STR"    | cut -d'"' -f2`
MV_REVIS=`head -3 VERSION.cmake | grep -h  "REVISION_VERSION_STR" | cut -d'"' -f2`

echo "$MV_MAJOR.$MV_MINOR.$MV_REVIS"

