// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Select3D_Projector_HeaderFile
#define _Select3D_Projector_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Select3D_Projector_HeaderFile
#include <Handle_Select3D_Projector.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_Trsf_HeaderFile
#include <gp_Trsf.hxx>
#endif
#ifndef _gp_GTrsf_HeaderFile
#include <gp_GTrsf.hxx>
#endif
#ifndef _Handle_V3d_View_HeaderFile
#include <Handle_V3d_View.hxx>
#endif
#ifndef _Standard_Transient_HeaderFile
#include <Standard_Transient.hxx>
#endif
class V3d_View;
class Standard_NoSuchObject;
class gp_Ax2;
class gp_Trsf;
class gp_GTrsf;
class gp_Vec;
class gp_Pnt;
class gp_Pnt2d;
class gp_Vec2d;
class gp_Lin;


//! A framework to define 3D projectors. <br>
//! Projector provides services for projecting points from <br>
//! world-coordinates to a viewing plane. Projection could be defined by <br>
//! corresponding transformation, or coordinate system. The transformation <br>
//! could be constructed for a view with transposed view transformation <br>
//! matrix ( that represents view-orientation ), including, for perspective <br>
//! view, focal distance ( distance from an eye to the view plane ) and <br>
//! translational part that represents translation of focal point in <br>
//! view-coordinate space. The Select3D_Projector class recognizes the <br>
//! predefined set of popular projections: axonometric, top view, front <br>
//! view and uses more efficient algorithm for projection computations. <br>
//! User-defined transformation could be also defined in constructor. <br>
//! Perspective projection consists of two separate parts, that are <br>
//! composed together during computation: transformation component and <br>
//! focale distance. <br>
class Select3D_Projector : public Standard_Transient {

public:

  //! Constructs the 3D projector object defined by the 3D view aView. <br>
  Standard_EXPORT   Select3D_Projector(const Handle(V3d_View)& aView);
  
  Standard_EXPORT   Select3D_Projector();
  //! Creates an axonometric projector. <CS> represents viewing coordinate <br>
//! system and could be constructed from x direction, view plane normal direction, <br>
//! and view point location in world-coordinate space. <br>
  Standard_EXPORT   Select3D_Projector(const gp_Ax2& CS);
  //! Creates  a  perspective  projector. <CS> represents viewing <br>
//! coordinate system and could be constructed from x direction, <br>
//! view plane normal direction, and focal point location in world-coordinate <br>
//! space. <Focus> should represent distance of an eye from view plane <br>
//! in world-coordinate space (focal distance). <br>
  Standard_EXPORT   Select3D_Projector(const gp_Ax2& CS,const Standard_Real Focus);
  //! build a Projector from the given transformation. <br>
//! In case, when <T> transformation should represent custom view projection, <br>
//! it could be constructed from two separate components: transposed view <br>
//! orientation matrix and translation of focal point in view-coordiante <br>
//! system. <T> could be built up from x direction, up direction, <br>
//! view plane normal direction vectors and translation with SetValues(...) <br>
//! method, where first row arguments (a11, a12, a13, a14)  are x, y, z <br>
//! component of x direction vector, and x value of reversed translation <br>
//! vector. Second row arguments, are x y z for up direction and y value of <br>
//! reversed translation, and the third row defined in the same manner. <br>
//! This also suits for simple perspective view, where <Focus> is the focale <br>
//! distance of an eye from view plane in world-space coordiantes. <br>
//! Note, that in that case amount of perspective distortion (perspective <br>
//! angle) should be defined through focal distance. <br>
  Standard_EXPORT   Select3D_Projector(const gp_Trsf& T,const Standard_Boolean Persp,const Standard_Real Focus);
  //! build a Projector from the given transformation. <br>
//! In case, when <GT> transformation should represent custom view <br>
//! projection, it could be constructed from two separate components: <br>
//! transposed view orientation matrix and translation of a focal point <br>
//! in view-coordinate system. <br>
//! This also suits for perspective view, with <Focus> that could be <br>
//! equal to distance from an eye to a view plane in <br>
//! world-coordinates (focal distance). <br>
//! The 3x3 transformation matrix is built up from three vectors: <br>
//! x direction, up direction and view plane normal vectors, where each <br>
//! vector is a matrix row. Then <GT> is constructed from matrix and <br>
//! reversed translation with methods SetTranslationPart(..) and <br>
//! SetVectorialPart(..). <br>
//! Note, that in that case amount of perspective distortion (perspective <br>
//! angle) should be defined through focal distance. <br>
  Standard_EXPORT   Select3D_Projector(const gp_GTrsf& GT,const Standard_Boolean Persp,const Standard_Real Focus);
  
  Standard_EXPORT     void Set(const gp_Trsf& T,const Standard_Boolean Persp,const Standard_Real Focus) ;
  //! Sets the 3D view V used at the time of construction. <br>
  Standard_EXPORT     void SetView(const Handle(V3d_View)& V) ;
  //! Returns the 3D view used at the time of construction. <br>
       const Handle_V3d_View& View() const;
  //! to compute with the given scale and translation. <br>
  Standard_EXPORT   virtual  void Scaled(const Standard_Boolean On = Standard_False) ;
  //! Returns True if there is a perspective transformation. <br>
      virtual  Standard_Boolean Perspective() const;
  //! Returns the active transformation. <br>
      virtual const gp_GTrsf& Transformation() const;
  //! Returns the active inverted transformation. <br>
      virtual const gp_GTrsf& InvertedTransformation() const;
  //! Returns the original transformation. <br>
      virtual const gp_Trsf& FullTransformation() const;
  //! Returns the focal length. <br>
      virtual  Standard_Real Focus() const;
  
      virtual  void Transform(gp_Vec& D) const;
  
      virtual  void Transform(gp_Pnt& Pnt) const;
  //! Transform and apply perspective if needed. <br>
  Standard_EXPORT   virtual  void Project(const gp_Pnt& P,gp_Pnt2d& Pout) const;
  //! Transform and apply perspective if needed. <br>
  Standard_EXPORT     void Project(const gp_Pnt& P,Standard_Real& X,Standard_Real& Y,Standard_Real& Z) const;
  //! Transform and apply perspective if needed. <br>
  Standard_EXPORT   virtual  void Project(const gp_Pnt& P,const gp_Vec& D1,gp_Pnt2d& Pout,gp_Vec2d& D1out) const;
  //! return a line going through the eye towards the <br>
//!          2d point <X,Y>. <br>
  Standard_EXPORT   virtual  gp_Lin Shoot(const Standard_Real X,const Standard_Real Y) const;
  
      virtual  void Transform(gp_Pnt& P,const gp_GTrsf& T) const;
  
      virtual  void Transform(gp_Lin& D,const gp_GTrsf& T) const;




  DEFINE_STANDARD_RTTI(Select3D_Projector)

protected:


Standard_Boolean myPersp;
Standard_Real myFocus;
gp_Trsf myScaledTrsf;
gp_GTrsf myGTrsf;
gp_GTrsf myInvTrsf;


private: 


Standard_Integer myType;
Handle_V3d_View myView;


};


#include <Select3D_Projector.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
