/*
 * Copyright (C) 2004-2011 David Defour, Catherine Daramy-Loirat,
 * Florent de Dinechin, Matthieu Gallet, Nicolas Gast, Christoph Quirin Lauter,
 * and Jean-Michel Muller
 *
 * This file is part of crlibm, the correctly rounded mathematical library,
 * which has been developed by the Arénaire project at École normale supérieure
 * de Lyon.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */


#include "crlibm.h"
#include "crlibm_private.h"

#define L 8

#define MAXINDEX 106

#define INDEXMASK 255
#define two52 4.50359962737049600000000000000000000000000000000000e+15
#define log2h 6.93147180559890330187045037746429443359375000000000e-01
#define log2m 5.49792301870850242169664946507035702127907939029683e-14
#define log2l -1.31246984177852556920995753667322295879593697972250e-27
#define log210h 0.3010299956639528318191878497600555419921875
#define log210m 0.28363394551042263094578877949012915560267344972089631482958793640137e-13
#define log210l 0.27013429058980534315374921000428327002971066904842912935671669760243e-26

#define RNROUNDCST 1.01587301587301598581442042834326647273327977070694e+00
#define RDROUNDCST 8.67361737988403547205962240695953369140625000000000e-19

#define RECPRLOG2H 0.1442695040888963387004650940070860087871551513671875e1
#define RECPRLOG2L 0.203552737409310331110210900522069120325603861485809498166e-16

#define RECPRLOG10H 0.43429448190325181666793241674895398318767547607421875
#define RECPRLOG10M 0.109831965021676507273885982186335434116483395815071742729340797950499108992516994476318359375e-16
#define RECPRLOG10L 0.3717181233110958966699817676973599714051656514224857273631510154667658260758842841533296404155084502463068929500877857208251953125e-33

#define WORSTCASEACCURACY 0.5316911983139663491615228241121378304e37

#define p_coeff_accu_1h 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000e+00
#define p_coeff_accu_2h -5.00000000000000000000000000000000000000000000000000000000000000000000000000000000e-01
#define p_coeff_accu_3h 3.33333333333333314829616256247390992939472198486328125000000000000000000000000000e-01
#define p_coeff_accu_3m 1.85037170770874789756988228974262968046011237606765509333683894510613754391670227e-17
#define p_coeff_accu_4h -2.50000000000000000000000000000000000000000000000000000000000000000000000000000000e-01
#define p_coeff_accu_5h 2.00000000000000011102230246251565404236316680908203125000000000000000000000000000e-01
#define p_coeff_accu_5m -1.11022359498086234952280980357986354308310664976318371532926221334491856396198273e-17
#define p_coeff_accu_6h -1.66666666666666657414808128123695496469736099243164062500000000000000000000000000e-01
#define p_coeff_accu_6m -9.25186011742975917381555124745579318634206911138887982626322070700553013011813164e-18
#define p_coeff_accu_7h 1.42857142857142876968268296877795364707708358764648437500000000000000000000000000e-01
#define p_coeff_accu_7m -1.29473592850074078984540189203202170950776491657307348814853753538045566529035568e-17
#define p_coeff_accu_8h -1.25000000000000000000000000000000000000000000000000000000000000000000000000000000e-01
#define p_coeff_accu_9h 1.11111111107490570515388128569611581042408943176269531250000000000000000000000000e-01
#define p_coeff_accu_10h -9.99999999987549875735126647668948862701654434204101562500000000000000000000000000e-02
#define p_coeff_accu_11h 9.09099561261329930372809826621960382908582687377929687500000000000000000000000000e-02
#define p_coeff_accu_12h -8.33339031627361587206692661311535630375146865844726562500000000000000000000000000e-02

#define p_coeff_1h 1.00000000000000000000000000000000000000000000000000000000000000000000000000000000e+00
#define p_coeff_2h -5.00000000000000000000000000000000000000000000000000000000000000000000000000000000e-01
#define p_coeff_3h 3.33333333332438030982558530013193376362323760986328125000000000000000000000000000e-01
#define p_coeff_4h -2.49999999998981758952965037678950466215610504150390625000000000000000000000000000e-01
#define p_coeff_5h 2.00000758681036727715252254711231216788291931152343750000000000000000000000000000e-01
#define p_coeff_6h -1.66667399943076749435633132634393405169248580932617187500000000000000000000000000e-01


typedef struct rri_tag {float ri; double logih; double logim; double logil;} rri;  
static const rri argredtable[256] = {
  { 
    1.00000000000000000000000000000000000000000000000000e+00,   /* r[0] */ 
    0.00000000000000000000000000000000000000000000000000e+00, /* logih[0] */ 
    0.00000000000000000000000000000000000000000000000000e+00, /* logim[0] */ 
    0.00000000000000000000000000000000000000000000000000e+00, /* logil[0] */ 
  } , 
  { 
    9.96109008789062500000000000000000000000000000000000e-01,   /* r[1] */ 
    3.89858081101432385473515296325786039233207702636719e-03, /* logih[1] */ 
    1.25346004307267304894640684851581512787262559024016e-19, /* logim[1] */ 
    4.64325168845438317713718561737934247375332721265836e-36, /* logil[1] */ 
  } , 
  { 
    9.92248535156250000000000000000000000000000000000000e-01,   /* r[2] */ 
    7.78166360501043267300369521421998797450214624404907e-03, /* logih[2] */ 
    -4.89592386148351837006945254137918249482580247924126e-20, /* logim[2] */ 
    -1.08409213368413141614035817819969540383455164545947e-36, /* logil[2] */ 
  } , 
  { 
    9.88416671752929687500000000000000000000000000000000e-01,   /* r[3] */ 
    1.16509375949922621557020008253857668023556470870972e-02, /* logih[3] */ 
    -2.25226774360965572201294117569374162214377850269541e-19, /* logim[3] */ 
    -5.11945341084299010662466108636073292979157772198876e-36, /* logil[3] */ 
  } , 
  { 
    9.84615325927734375000000000000000000000000000000000e-01,   /* r[4] */ 
    1.55042461406118062261505485821544425562024116516113e-02, /* logih[4] */ 
    -3.27761516207149627029928635703400435929630184221293e-19, /* logim[4] */ 
    2.95200020707030964072253388818190769795416371257942e-37, /* logil[4] */ 
  } , 
  { 
    9.80842590332031250000000000000000000000000000000000e-01,   /* r[5] */ 
    1.93432906687309343063407851559531991370022296905518e-02, /* logih[5] */ 
    -2.15862131267131143148684267329697650453139578671228e-19, /* logim[5] */ 
    -1.15271369538876060199548423508281675592171686662266e-35, /* logil[5] */ 
  } , 
  { 
    9.77099418640136718750000000000000000000000000000000e-01,   /* r[6] */ 
    2.31668730170368035448102972395645338110625743865967e-02, /* logih[6] */ 
    -1.17910860908392752354910733048566386347187195159043e-18, /* logim[6] */ 
    2.49612518164524848780028044162189727076238619175360e-35, /* logil[6] */ 
  } , 
  { 
    9.73383903503417968750000000000000000000000000000000e-01,   /* r[7] */ 
    2.69767180833710221166121812075289199128746986389160e-02, /* logih[7] */ 
    -5.57795528916207151895634361214250967547427159484621e-20, /* logim[7] */ 
    -3.62294468430332561712587522351589910764493467585522e-36, /* logil[7] */ 
  } , 
  { 
    9.69696998596191406250000000000000000000000000000000e-01,   /* r[8] */ 
    3.07716288644317437217523547587916254997253417968750e-02, /* logih[8] */ 
    1.04316437964092669923942103072089812062131860035492e-18, /* logim[8] */ 
    -8.26837774892530079043982861155759865584698067912967e-36, /* logil[8] */ 
  } , 
  { 
    9.66037750244140625000000000000000000000000000000000e-01,   /* r[9] */ 
    3.45523666054986522411240912333596497774124145507812e-02, /* logih[9] */ 
    -1.65910748103534385407065291371523592570431641990885e-18, /* logim[9] */ 
    3.38525826535166864039714297442413583169978770990777e-35, /* logil[9] */ 
  } , 
  { 
    9.62406158447265625000000000000000000000000000000000e-01,   /* r[10] */ 
    3.83187152905357653054352340404875576496124267578125e-02, /* logih[10] */ 
    -2.35909906471143038057626284336250570775789572626881e-18, /* logim[10] */ 
    -1.85563428635831615187251482536612501452930840707165e-34, /* logil[10] */ 
  } , 
  { 
    9.58801269531250000000000000000000000000000000000000e-01,   /* r[11] */ 
    4.20714523392945807800380464414047310128808021545410e-02, /* logih[11] */ 
    -3.12838632664719081818569863425510803330088438244181e-18, /* logim[11] */ 
    -3.22458892012633541790068267080237442991762885883976e-35, /* logil[11] */ 
  } , 
  { 
    9.55224037170410156250000000000000000000000000000000e-01,   /* r[12] */ 
    4.58093721185345026380986155345453880727291107177734e-02, /* logih[12] */ 
    1.90149189679431067655792024548961427427986403667162e-18, /* logim[12] */ 
    -1.35330568979098264467186032289860101304045776545335e-34, /* logil[12] */ 
  } , 
  { 
    9.51672554016113281250000000000000000000000000000000e-01,   /* r[13] */ 
    4.95342592225851141574111125009949319064617156982422e-02, /* logih[13] */ 
    3.41051514612607272315747347640360336610752192297493e-18, /* logim[13] */ 
    -1.62776077654054345674690342025587161986806134248965e-34, /* logil[13] */ 
  } , 
  { 
    9.48147773742675781250000000000000000000000000000000e-01,   /* r[14] */ 
    5.32449093996618869062409373782429611310362815856934e-02, /* logih[14] */ 
    -1.64505111621921275224226259698905780842959106366420e-18, /* logim[14] */ 
    4.14442397515940112138679619536747848472625603933844e-35, /* logil[14] */ 
  } , 
  { 
    9.44649696350097656250000000000000000000000000000000e-01,   /* r[15] */ 
    5.69411119045622124423822185690369224175810813903809e-02, /* logih[15] */ 
    4.78734188028619786114736923282640611331114908534069e-19, /* logim[15] */ 
    -3.93713999997785260153004737038398583853656485310521e-35, /* logil[15] */ 
  } , 
  { 
    9.41176414489746093750000000000000000000000000000000e-01,   /* r[16] */ 
    6.06246814210813916856679384181916248053312301635742e-02, /* logih[16] */ 
    2.64247317995478646334926909653435556549332769494295e-18, /* logim[16] */ 
    1.55075207452234839722600788456166299408429635417895e-34, /* logil[16] */ 
  } , 
  { 
    9.37728881835937500000000000000000000000000000000000e-01,   /* r[17] */ 
    6.42944103100438063558286216903070453554391860961914e-02, /* logih[17] */ 
    2.60793481490786257498313263319157616690600921511114e-18, /* logim[17] */ 
    -1.45909124358216952997721245377778825212735363222186e-34, /* logil[17] */ 
  } , 
  { 
    9.34306144714355468750000000000000000000000000000000e-01,   /* r[18] */ 
    6.79511163940274415251607820209756027907133102416992e-02, /* logih[18] */ 
    -1.24892173295840496632514736205386405076267738428183e-18, /* logim[18] */ 
    -5.86027190792146940250174345622545434589551590207709e-35, /* logil[18] */ 
  } , 
  { 
    9.30909156799316406250000000000000000000000000000000e-01,   /* r[19] */ 
    7.15935824064956455314856498262088280171155929565430e-02, /* logih[19] */ 
    6.55833354527865440910555403220649032260269042308564e-18, /* logim[19] */ 
    -8.65001743565124847036366836203555319976499748416219e-35, /* logil[19] */ 
  } , 
  { 
    9.27536010742187500000000000000000000000000000000000e-01,   /* r[20] */ 
    7.52236596561950549011399402843380812555551528930664e-02, /* logih[20] */ 
    -5.92608668643342447178482655547063763942218784624419e-18, /* logim[20] */ 
    3.06299284565641653395923152025230697760630110042913e-34, /* logil[20] */ 
  } , 
  { 
    9.24187660217285156250000000000000000000000000000000e-01,   /* r[21] */ 
    7.88401324882942039495858921327453572303056716918945e-02, /* logih[21] */ 
    -3.70086061559488005172131811140468915784794102784056e-18, /* logim[21] */ 
    -9.85152871853396304228341002410386896660946235409677e-36, /* logil[21] */ 
  } , 
  { 
    9.20863151550292968750000000000000000000000000000000e-01,   /* r[22] */ 
    8.24438405744429975152698375495674554258584976196289e-02, /* logih[22] */ 
    5.70211515844839148682574255471016004503183577701328e-18, /* logim[22] */ 
    -2.25007518842967334560085413287805841472581599706844e-34, /* logil[22] */ 
  } , 
  { 
    9.17562484741210937500000000000000000000000000000000e-01,   /* r[23] */ 
    8.60345981121580505313062303685001097619533538818359e-02, /* logih[23] */ 
    -4.22948398727754542981422162560881574021096207871627e-18, /* logim[23] */ 
    6.94601543497627089738149551411013780692459600238783e-35, /* logil[23] */ 
  } , 
  { 
    9.14285659790039062500000000000000000000000000000000e-01,   /* r[24] */ 
    8.96122182943336897942288032936630770564079284667969e-02, /* logih[24] */ 
    -5.42674234758262048883730612286095846547194397615989e-18, /* logim[24] */ 
    -7.94903110897686868047461590865098481976776339992810e-35, /* logil[24] */ 
  } , 
  { 
    9.11031723022460937500000000000000000000000000000000e-01,   /* r[25] */ 
    9.31775601303663630892160085750219877809286117553711e-02, /* logih[25] */ 
    -6.69498457328524671915466867735988222404310795846756e-18, /* logim[25] */ 
    -3.79652072557870206332532254269355336020140715029263e-34, /* logil[25] */ 
  } , 
  { 
    9.07801628112792968750000000000000000000000000000000e-01,   /* r[26] */ 
    9.67293954905792813248055495023436378687620162963867e-02, /* logih[26] */ 
    -5.63846837522303146603627132880140909669766724948486e-19, /* logim[26] */ 
    -1.66000291590412401400936599792255612972352892524385e-35, /* logil[26] */ 
  } , 
  { 
    9.04593467712402343750000000000000000000000000000000e-01,   /* r[27] */ 
    1.00269643153498413945534650792978936806321144104004e-01, /* logih[27] */ 
    4.98554274018507013478029967753506544988890129859642e-18, /* logim[27] */ 
    5.59670179615967929691409415615538777735120155881527e-35, /* logil[27] */ 
  } , 
  { 
    9.01408195495605468750000000000000000000000000000000e-01,   /* r[28] */ 
    1.03797076803746321504995364648493705317378044128418e-01, /* logih[28] */ 
    5.48528900130158927281223188042337652391677694528930e-18, /* logim[28] */ 
    4.14171393686520487202261794304840175447148562557926e-37, /* logil[28] */ 
  } , 
  { 
    8.98245811462402343750000000000000000000000000000000e-01,   /* r[29] */ 
    1.07311515996984602194785907158802729099988937377930e-01, /* logih[29] */ 
    -6.49440034445526829025678761855551439585344802732716e-18, /* logim[29] */ 
    2.57958632702602934657456152939453502266815184956115e-34, /* logil[29] */ 
  } , 
  { 
    8.95105361938476562500000000000000000000000000000000e-01,   /* r[30] */ 
    1.10813844799784330663605658173764823004603385925293e-01, /* logih[30] */ 
    1.13646120297132443922718632465223191456150489503195e-18, /* logim[30] */ 
    -5.28316759830006376644472821184088330546878296734027e-35, /* logil[30] */ 
  } , 
  { 
    8.91985893249511718750000000000000000000000000000000e-01,   /* r[31] */ 
    1.14304961269881905083778406151395756751298904418945e-01, /* logih[31] */ 
    -1.82657204548789933700890276210347276483341044028754e-18, /* logim[31] */ 
    -1.78975695662999910835938906470926846720934095410310e-34, /* logil[31] */ 
  } , 
  { 
    8.88889312744140625000000000000000000000000000000000e-01,   /* r[32] */ 
    1.17782558819338939448684300259628798812627792358398e-01, /* logih[32] */ 
    -1.23330863425085901895045843903611194329827297821512e-18, /* logim[32] */ 
    -3.52820989557939438405682761152717048907334161666144e-35, /* logil[32] */ 
  } , 
  { 
    8.85812759399414062500000000000000000000000000000000e-01,   /* r[33] */ 
    1.21249683217221515540984455583384260535240173339844e-01, /* logih[33] */ 
    5.31311945158451973155842240649445065131843549390499e-18, /* logim[33] */ 
    2.54343506313921505744140357189546013839546072665324e-34, /* logil[33] */ 
  } , 
  { 
    8.82759094238281250000000000000000000000000000000000e-01,   /* r[34] */ 
    1.24702942059298146904033899318164912983775138854980e-01, /* logih[34] */ 
    -4.70371819449250479521866847789744043656802774985674e-18, /* logim[34] */ 
    1.97104582593396093851604773181347759433213428836825e-35, /* logil[34] */ 
  } , 
  { 
    8.79725456237792968750000000000000000000000000000000e-01,   /* r[35] */ 
    1.28145401734214903211039882080513052642345428466797e-01, /* logih[35] */ 
    1.14781745994570133838663940952936924060234053388495e-17, /* logim[35] */ 
    5.58511031530272548588108480038230630258110787014421e-34, /* logil[35] */ 
  } , 
  { 
    8.76712799072265625000000000000000000000000000000000e-01,   /* r[36] */ 
    1.31575821347060167854081669247534591704607009887695e-01, /* logih[36] */ 
    1.10715436488867456364710847828940395046896276123492e-17, /* logim[36] */ 
    -1.96739988161444008557083655799953663793248304761174e-34, /* logil[36] */ 
  } , 
  { 
    8.73720169067382812500000000000000000000000000000000e-01,   /* r[37] */ 
    1.34995127284602528527912568279134575277566909790039e-01, /* logih[37] */ 
    1.13443032556618420511047729873477099334314080223232e-17, /* logim[37] */ 
    7.84084139347542359388184229855467642926900448087157e-35, /* logil[37] */ 
  } , 
  { 
    8.70748519897460937500000000000000000000000000000000e-01,   /* r[38] */ 
    1.38402069539410921272803989268140867352485656738281e-01, /* logih[38] */ 
    4.44235871792103837022419240194760193308637586385155e-18, /* logim[38] */ 
    -2.41881295582206144619569746427861787915591569677161e-34, /* logil[38] */ 
  } , 
  { 
    8.67796897888183593750000000000000000000000000000000e-01,   /* r[39] */ 
    1.41797580309475756976667071285191923379898071289062e-01, /* logih[39] */ 
    -7.24160172735387143794870117732197886365507642151672e-18, /* logim[39] */ 
    -5.22451781240386018101218933838001385853101358775197e-34, /* logil[39] */ 
  } , 
  { 
    8.64865303039550781250000000000000000000000000000000e-01,   /* r[40] */ 
    1.45181503205145640000850448814162518829107284545898e-01, /* logih[40] */ 
    8.19907012376636936299584542046629720669747968826019e-18, /* logim[40] */ 
    -6.12684085112129298490441309408007876014850876364407e-34, /* logil[40] */ 
  } , 
  { 
    8.61952781677246093750000000000000000000000000000000e-01,   /* r[41] */ 
    1.48554787455398934481465289536572527140378952026367e-01, /* logih[41] */ 
    6.78516779658958104936774808506523119026706496843219e-18, /* logim[41] */ 
    -3.27826043728243463792408633436129695451318517711142e-34, /* logil[41] */ 
  } , 
  { 
    8.59060287475585937500000000000000000000000000000000e-01,   /* r[42] */ 
    1.51916176136301706023346014262642711400985717773438e-01, /* logih[42] */ 
    6.48466714403849150058443502305577974475027830695770e-18, /* logim[42] */ 
    -1.48928080867016213912478822372262107645375280995355e-34, /* logil[42] */ 
  } , 
  { 
    8.56186866760253906250000000000000000000000000000000e-01,   /* r[43] */ 
    1.55266624374856387902354981633834540843963623046875e-01, /* logih[43] */ 
    1.18940768999581165815608386146027685954807862619905e-18, /* logim[43] */ 
    -2.19216119241235749930116667974585541598333050913847e-35, /* logil[43] */ 
  } , 
  { 
    8.53333473205566406250000000000000000000000000000000e-01,   /* r[44] */ 
    1.58604866263878874210746516837389208376407623291016e-01, /* logih[44] */ 
    1.12555359025026447024891292897564756165016667291108e-17, /* logim[44] */ 
    2.51566303827199528440805207088944780959353108097571e-34, /* logil[44] */ 
  } , 
  { 
    8.50498199462890625000000000000000000000000000000000e-01,   /* r[45] */ 
    1.61932984182099809489230324288655538111925125122070e-01, /* logih[45] */ 
    9.77539264526997233823717660784682214608240520802842e-18, /* logim[45] */ 
    5.24985245146816572034425662478272808361990734810588e-34, /* logil[45] */ 
  } , 
  { 
    8.47681999206542968750000000000000000000000000000000e-01,   /* r[46] */ 
    1.65249714456348534286078688637644518166780471801758e-01, /* logih[46] */ 
    -1.00939900169186480779679825710639265028332267691135e-17, /* logim[46] */ 
    3.90825918506438654133771548917512854530368619051813e-34, /* logil[46] */ 
  } , 
  { 
    8.44884872436523437500000000000000000000000000000000e-01,   /* r[47] */ 
    1.68554906544493537934314986159733962267637252807617e-01, /* logih[47] */ 
    -4.88067069357233088835045523845127031889038644659894e-18, /* logim[47] */ 
    -2.74436628602599193485144954170980402729323560852447e-34, /* logil[47] */ 
  } , 
  { 
    8.42104911804199218750000000000000000000000000000000e-01,   /* r[48] */ 
    1.71850674159259697582058379339287057518959045410156e-01, /* logih[48] */ 
    -5.99824278835946286993892764844703773122678476390412e-18, /* logim[48] */ 
    3.70682933452027240591056472269948014540566701592829e-34, /* logil[48] */ 
  } , 
  { 
    8.39344024658203125000000000000000000000000000000000e-01,   /* r[49] */ 
    1.75134615249951913762416211284289602190256118774414e-01, /* logih[49] */ 
    -3.58390218411179180194443037963547505253027562280581e-18, /* logim[49] */ 
    3.31228661881018068740534361547868152976577021044761e-34, /* logil[49] */ 
  } , 
  { 
    8.36601257324218750000000000000000000000000000000000e-01,   /* r[50] */ 
    1.78407717077464861299418430462537799030542373657227e-01, /* logih[50] */ 
    -1.24324832026190372515095573175819374097319572461178e-17, /* logim[50] */ 
    -5.99222696564577786410580709003476847421843326905428e-34, /* logil[50] */ 
  } , 
  { 
    8.33876609802246093750000000000000000000000000000000e-01,   /* r[51] */ 
    1.81669837446455789686794446424755733460187911987305e-01, /* logih[51] */ 
    1.01814383360123408182300498809467596332645378664897e-18, /* logim[51] */ 
    -3.86254258528557102676238695420952114271137939703806e-35, /* logil[51] */ 
  } , 
  { 
    8.31169128417968750000000000000000000000000000000000e-01,   /* r[52] */ 
    1.84921980866207286142710586318571586161851882934570e-01, /* logih[52] */ 
    3.00841482639628279758161917890436573438957544374876e-18, /* logim[52] */ 
    -4.99319538644221397164613342913055299248197716579930e-36, /* logil[52] */ 
  } , 
  { 
    8.28478813171386718750000000000000000000000000000000e-01,   /* r[53] */ 
    1.88164014957424269303132291497604455798864364624023e-01, /* logih[53] */ 
    2.44293806976014644991303628324646254244852750452761e-18, /* logim[53] */ 
    -1.81631690797919082130114101842168376499919500191654e-34, /* logil[53] */ 
  } , 
  { 
    8.25806617736816406250000000000000000000000000000000e-01,   /* r[54] */ 
    1.91394651833973583610060131832142360508441925048828e-01, /* logih[54] */ 
    -1.21322104713829577894210219067304263334028383887345e-17, /* logim[54] */ 
    5.04102454790153462302483289986561437522938374164401e-34, /* logil[54] */ 
  } , 
  { 
    8.23151588439941406250000000000000000000000000000000e-01,   /* r[55] */ 
    1.94614905180994807176730887476878706365823745727539e-01, /* logih[55] */ 
    -2.40704484907151006187800247197019539577410611794596e-18, /* logim[55] */ 
    1.66766736549683531224402325253460134456943558772782e-34, /* logil[55] */ 
  } , 
  { 
    8.20512771606445312500000000000000000000000000000000e-01,   /* r[56] */ 
    1.97825802934566419288842098467284813523292541503906e-01, /* logih[56] */ 
    1.28212649590622342007825921152819823725126964367518e-17, /* logim[56] */ 
    4.34712978477783827374998481132430084872238812357849e-34, /* logil[56] */ 
  } , 
  { 
    8.17891120910644531250000000000000000000000000000000e-01,   /* r[57] */ 
    2.01026055259733327229554333825944922864437103271484e-01, /* logih[57] */ 
    -1.14998212245338630994656980851947792972358234996197e-17, /* logim[57] */ 
    5.79624076358083101943179592654253175121330546055049e-34, /* logil[57] */ 
  } , 
  { 
    8.15286636352539062500000000000000000000000000000000e-01,   /* r[58] */ 
    2.04215526527529805944638496839615982025861740112305e-01, /* logih[58] */ 
    2.73382699896480606605004885268461286375739934002155e-18, /* logim[58] */ 
    1.88415596219599490517606146615135776386751947516623e-34, /* logil[58] */ 
  } , 
  { 
    8.12698364257812500000000000000000000000000000000000e-01,   /* r[59] */ 
    2.07395253950717145530191487523552495986223220825195e-01, /* logih[59] */ 
    -6.62391092234198860395870331818350936803399446817708e-18, /* logim[59] */ 
    3.21769751525760188204600268636020811532764524000701e-34, /* logil[59] */ 
  } , 
  { 
    8.10126304626464843750000000000000000000000000000000e-01,   /* r[60] */ 
    2.10565111834115831213054548243235331028699874877930e-01, /* logih[60] */ 
    -4.23598623593001075035023138647901308953697217452223e-18, /* logim[60] */ 
    -1.60116079297919794843846440200207561215761229589523e-34, /* logil[60] */ 
  } , 
  { 
    8.07571411132812500000000000000000000000000000000000e-01,   /* r[61] */ 
    2.13723792956059033265603375184582546353340148925781e-01, /* logih[61] */ 
    1.19332110118934137902010996837627215742078591974979e-17, /* logim[61] */ 
    -7.02796906150255788492393691981023760796809185404715e-34, /* logil[61] */ 
  } , 
  { 
    8.05031776428222656250000000000000000000000000000000e-01,   /* r[62] */ 
    2.16873528518765484873753734973433893173933029174805e-01, /* logih[62] */ 
    4.52808917121474736889640990984402645764765520737700e-18, /* logim[62] */ 
    2.11628056886638280859096959251776961524147228058240e-34, /* logil[62] */ 
  } , 
  { 
    8.02507400512695312500000000000000000000000000000000e-01,   /* r[63] */ 
    2.20014202197813590888841872583725489675998687744141e-01, /* logih[63] */ 
    -1.00259431805058570834488582628193862678340769016279e-17, /* logim[63] */ 
    2.36589934049562797440015684747135353020590849639512e-35, /* logil[63] */ 
  } , 
  { 
    8.00000190734863281250000000000000000000000000000000e-01,   /* r[64] */ 
    2.23143312895659085004496091642067767679691314697266e-01, /* logih[64] */ 
    -9.09578810556902738974378981655445966403155329846157e-18, /* logim[64] */ 
    -5.51860343858009857142907585246296630664802326325794e-34, /* logil[64] */ 
  } , 
  { 
    7.97508239746093750000000000000000000000000000000000e-01,   /* r[65] */ 
    2.26263112406488331451726025989046320319175720214844e-01, /* logih[65] */ 
    7.84336071516770930915783866759877344054363308944707e-18, /* logim[65] */ 
    -7.43454080890818906474334427543025223771612621973504e-34, /* logil[65] */ 
  } , 
  { 
    7.95030593872070312500000000000000000000000000000000e-01,   /* r[66] */ 
    2.29374682210301245044448137377912644296884536743164e-01, /* logih[66] */ 
    9.99309522150144532067602885659542180850459285940861e-18, /* logim[66] */ 
    -4.39495185580213541392726686857289780092191688844937e-34, /* logil[66] */ 
  } , 
  { 
    7.92570114135742187500000000000000000000000000000000e-01,   /* r[67] */ 
    2.32474305048552654096027936247992329299449920654297e-01, /* logih[67] */ 
    1.04347973999915730650942527525177991072062294027967e-17, /* logim[67] */ 
    -1.80285268643432323262428865765338414917111027539735e-34, /* logil[67] */ 
  } , 
  { 
    7.90122985839843750000000000000000000000000000000000e-01,   /* r[68] */ 
    2.35566667359392301062115393506246618926525115966797e-01, /* logih[68] */ 
    -2.32375103902642573879242169796960376755737712824341e-18, /* logim[68] */ 
    -7.21655842491838760103086913983188439028934238517299e-35, /* logil[68] */ 
  } , 
  { 
    7.87692070007324218750000000000000000000000000000000e-01,   /* r[69] */ 
    2.38648039598734706956406625977251678705215454101562e-01, /* logih[69] */ 
    4.46784339552128548812794219055404768324811281554067e-18, /* logim[69] */ 
    3.43429150836221389256015518963937864776602443392546e-34, /* logil[69] */ 
  } , 
  { 
    7.85276412963867187500000000000000000000000000000000e-01,   /* r[70] */ 
    2.41719504753563907417657219411921687424182891845703e-01, /* logih[70] */ 
    8.87409122027180881908249517818731600449617581699438e-18, /* logim[70] */ 
    3.56004039882748459631384958577457237860217830111311e-34, /* logil[70] */ 
  } , 
  { 
    7.82875061035156250000000000000000000000000000000000e-01,   /* r[71] */ 
    2.44782160173725865659477562985557597130537033081055e-01, /* logih[71] */ 
    7.08526813357121959967478591264305016478056070347997e-19, /* logim[71] */ 
    -2.15778795199788554090353514030659386443684641384067e-35, /* logil[71] */ 
  } , 
  { 
    7.80488014221191406250000000000000000000000000000000e-01,   /* r[72] */ 
    2.47835895683715751180997699520958121865987777709961e-01, /* logih[72] */ 
    -1.24386417338518064252295447791954905943026800534449e-17, /* logim[72] */ 
    -7.44029524146381752722089691180123292021312364800709e-34, /* logil[72] */ 
  } , 
  { 
    7.78115272521972656250000000000000000000000000000000e-01,   /* r[73] */ 
    2.50880600583786306234657104141660965979099273681641e-01, /* logih[73] */ 
    -5.50964893191169223547312201897322976952633356221949e-18, /* logim[73] */ 
    1.08676143776419160887508248412493151436373152102143e-34, /* logil[73] */ 
  } , 
  { 
    7.75757789611816406250000000000000000000000000000000e-01,   /* r[74] */ 
    2.53914934309519335631222247684490866959095001220703e-01, /* logih[74] */ 
    1.97004950260539049796252522941686709480407437591843e-17, /* logim[74] */ 
    -4.67670757123999808225422970015919189294430827275674e-34, /* logil[74] */ 
  } , 
  { 
    7.73413658142089843750000000000000000000000000000000e-01,   /* r[75] */ 
    2.56941240096642986578956424636999145150184631347656e-01, /* logih[75] */ 
    1.32566282149745092578207739537715284043427717085946e-17, /* logim[75] */ 
    4.53175814618419018222032309863239909606680701492128e-34, /* logil[75] */ 
  } , 
  { 
    7.71084785461425781250000000000000000000000000000000e-01,   /* r[76] */ 
    2.59956943291808351137461841062759049236774444580078e-01, /* logih[76] */ 
    2.06326460492966557658914107366598455972739008175724e-17, /* logim[76] */ 
    -7.60856026131926782522027611178961885575241901312259e-34, /* logil[76] */ 
  } , 
  { 
    7.68768310546875000000000000000000000000000000000000e-01,   /* r[77] */ 
    2.62965641547506734365668989994446747004985809326172e-01, /* logih[77] */ 
    7.11583631875541699557981308503843876478401404595290e-18, /* logim[77] */ 
    -3.16162183522749672668805346311289437550800994700732e-34, /* logil[77] */ 
  } , 
  { 
    7.66467094421386718750000000000000000000000000000000e-01,   /* r[78] */ 
    2.65963511244235673025571031757863238453865051269531e-01, /* logih[78] */ 
    -2.24162125724264292804912034054420308588570407662844e-17, /* logim[78] */ 
    4.90471140265143981765909599584287898945638617268867e-34, /* logil[78] */ 
  } , 
  { 
    7.64179229736328125000000000000000000000000000000000e-01,   /* r[79] */ 
    2.68952923432744239740088687540264800190925598144531e-01, /* logih[79] */ 
    2.05657969150984247532516778784947182213125204986197e-17, /* logim[79] */ 
    8.79232077986017876500084195761038723390008355613575e-34, /* logil[79] */ 
  } , 
  { 
    7.61904716491699218750000000000000000000000000000000e-01,   /* r[80] */ 
    2.71933775088288309795814257086021825671195983886719e-01, /* logih[80] */ 
    7.83390223779535346513505580003968001040971161798700e-19, /* logim[80] */ 
    -3.02585215101390470982866376614279464778757620082138e-35, /* logil[80] */ 
  } , 
  { 
    7.59643554687500000000000000000000000000000000000000e-01,   /* r[81] */ 
    2.74905962710071116728016704655601643025875091552734e-01, /* logih[81] */ 
    2.24378545796980422658699919057279901542517325778057e-17, /* logim[81] */ 
    -3.78062443833687207202366076315857540989955154523774e-34, /* logil[81] */ 
  } , 
  { 
    7.57396697998046875000000000000000000000000000000000e-01,   /* r[82] */ 
    2.77868123177963777248322685409220866858959197998047e-01, /* logih[82] */ 
    -9.27762050905122039629311187603838349834122732550062e-19, /* logim[82] */ 
    9.57930007453583023320781825922648925161484087998588e-35, /* logil[82] */ 
  } , 
  { 
    7.55162239074707031250000000000000000000000000000000e-01,   /* r[83] */ 
    2.80822666626178107929234784023719839751720428466797e-01, /* logih[83] */ 
    -1.78889070415104263420345604636729594822616937899043e-17, /* logim[83] */ 
    -8.11660316854587609717942096562096327563941648142083e-34, /* logil[83] */ 
  } , 
  { 
    7.52941131591796875000000000000000000000000000000000e-01,   /* r[84] */ 
    2.83768232735291170421021433867281302809715270996094e-01, /* logih[84] */ 
    -2.03265852251844689554711830689719609838328388091381e-17, /* logim[84] */ 
    3.99265876662456660849597520210659365811534845502505e-34, /* logil[84] */ 
  } , 
  { 
    7.50733375549316406250000000000000000000000000000000e-01,   /* r[85] */ 
    2.86704716154329075639140000930638052523136138916016e-01, /* logih[85] */ 
    3.24928817686474637809609763405716794874549598154899e-18, /* logim[85] */ 
    7.05436161547905729808903355104769078626665732260995e-35, /* logil[85] */ 
  } , 
  { 
    7.48538017272949218750000000000000000000000000000000e-01,   /* r[86] */ 
    2.89633285132462114930262941925320774316787719726562e-01, /* logih[86] */ 
    -7.21962253363417273270454867455071277489833577725373e-18, /* logim[86] */ 
    -2.16150227221931053192432009592422674631830770048369e-34, /* logil[86] */ 
  } , 
  { 
    7.46356010437011718750000000000000000000000000000000e-01,   /* r[87] */ 
    2.92552566827507520841322730120737105607986450195312e-01, /* logih[87] */ 
    -1.44160166726851833613115205797213493080706067439112e-17, /* logim[87] */ 
    1.50883511667334677559761930721175960406498771143078e-33, /* logil[87] */ 
  } , 
  { 
    7.44186401367187500000000000000000000000000000000000e-01,   /* r[88] */ 
    2.95463736056791381745512126144603826105594635009766e-01, /* logih[88] */ 
    -2.16822486635513901824879610162201037763987226540717e-17, /* logim[88] */ 
    -1.40892440842074578649628629534891601913263524738738e-33, /* logil[88] */ 
  } , 
  { 
    7.42029190063476562500000000000000000000000000000000e-01,   /* r[89] */ 
    2.98366696880353166054788971450761891901493072509766e-01, /* logih[89] */ 
    2.66045054346745240447394933749591251388042727860864e-17, /* logim[89] */ 
    -3.07182222949536546434743015167904826317676758257458e-34, /* logil[89] */ 
  } , 
  { 
    7.39884376525878906250000000000000000000000000000000e-01,   /* r[90] */ 
    3.01261352929903802877475982313626445829868316650391e-01, /* logih[90] */ 
    1.87070681938931680167624656750430985298856099421569e-17, /* logim[90] */ 
    1.51413799416501325421897094776870076323182009328971e-33, /* logil[90] */ 
  } , 
  { 
    7.37751960754394531250000000000000000000000000000000e-01,   /* r[91] */ 
    3.04147607413525478126103962495108135044574737548828e-01, /* logih[91] */ 
    3.98176030022005428666814320744852118370551740170454e-18, /* logim[91] */ 
    3.59055661804361869634622461801260435821255127014094e-34, /* logil[91] */ 
  } , 
  { 
    7.35631942749023437500000000000000000000000000000000e-01,   /* r[92] */ 
    3.07025363120511873837870098213898018002510070800781e-01, /* logih[92] */ 
    -1.23081724383312479171164681702153119269476305242331e-17, /* logim[92] */ 
    -6.24921351181214466368980458020870680109978000216335e-34, /* logil[92] */ 
  } , 
  { 
    7.33524322509765625000000000000000000000000000000000e-01,   /* r[93] */ 
    3.09894522426349294796921185479732230305671691894531e-01, /* logih[93] */ 
    -2.61915759435025688106872344425103515717035435880289e-17, /* logim[93] */ 
    4.37310119650947955282720454157502418725525261502025e-34, /* logil[93] */ 
  } , 
  { 
    7.31428146362304687500000000000000000000000000000000e-01,   /* r[94] */ 
    3.12756291149352327884969326987629756331443786621094e-01, /* logih[94] */ 
    -1.44526601334660927537554677783431908198308471431891e-17, /* logim[94] */ 
    -3.16489425801456252779886240767137743149201554486977e-34, /* logil[94] */ 
  } , 
  { 
    7.29344367980957031250000000000000000000000000000000e-01,   /* r[95] */ 
    3.15609274450035781622858621631166897714138031005859e-01, /* logih[95] */ 
    -9.15211307104414041770693082901206817295591874336170e-18, /* logim[95] */ 
    6.92571319717017620584068946677928779786499453239802e-34, /* logil[95] */ 
  } , 
  { 
    7.27272987365722656250000000000000000000000000000000e-01,   /* r[96] */ 
    3.18453373490729885197936255281092599034309387207031e-01, /* logih[96] */ 
    2.70995327783651104083044967572356846238550856314185e-17, /* logim[96] */ 
    1.34600088520445299315193549306530996100489980654781e-33, /* logil[96] */ 
  } , 
  { 
    7.25212097167968750000000000000000000000000000000000e-01,   /* r[97] */ 
    3.21291119093343235935122947921627201139926910400391e-01, /* logih[97] */ 
    -1.12319519421036650171892375714176815116984091579206e-17, /* logim[97] */ 
    1.04447652287031956508644916042846488744189014580391e-34, /* logil[97] */ 
  } , 
  { 
    7.23163604736328125000000000000000000000000000000000e-01,   /* r[98] */ 
    3.24119796479811983491714499905356205999851226806641e-01, /* logih[98] */ 
    -7.94647062012309773892598593677083791992627350537440e-18, /* logim[98] */ 
    4.59384159170382657706167409359736689725722940359763e-34, /* logil[98] */ 
  } , 
  { 
    7.21126556396484375000000000000000000000000000000000e-01,   /* r[99] */ 
    3.26940628117956100240348860097583383321762084960938e-01, /* logih[99] */ 
    -1.74837694038376657608222314076357694142138010418063e-17, /* logim[99] */ 
    -1.40581148273538852383687808274899460858762058571376e-34, /* logil[99] */ 
  } , 
  { 
    7.19100952148437500000000000000000000000000000000000e-01,   /* r[100] */ 
    3.29753524791075502964332599731278605759143829345703e-01, /* logih[100] */ 
    2.12653812605676265381615743640534834022512048496019e-18, /* logim[100] */ 
    5.25095014117827902230536920855568345417341287940175e-35, /* logil[100] */ 
  } , 
  { 
    7.17086791992187500000000000000000000000000000000000e-01,   /* r[101] */ 
    3.32558396904723163611805603068205527961254119873047e-01, /* logih[101] */ 
    -1.04519949901622285684034183132329427334699936682984e-17, /* logim[101] */ 
    4.45654546722256244026954176794662799321355430560371e-34, /* logil[101] */ 
  } , 
  { 
    7.15084075927734375000000000000000000000000000000000e-01,   /* r[102] */ 
    3.35355154491021822948937369801569730043411254882812e-01, /* logih[102] */ 
    1.83262596742990833823701524552706571217123614816200e-17, /* logim[102] */ 
    -1.29569615760463452723681409704842983753419687255982e-33, /* logil[102] */ 
  } , 
  { 
    7.13091850280761718750000000000000000000000000000000e-01,   /* r[103] */ 
    3.38145044591559529312263521205750294029712677001953e-01, /* logih[103] */ 
    -1.46763527756214729603846930349999949900828274067634e-17, /* logim[103] */ 
    3.85996984621058858499977696727737728999708408076829e-34, /* logil[103] */ 
  } , 
  { 
    7.11111068725585937500000000000000000000000000000000e-01,   /* r[104] */ 
    3.40926646575239744585417156486073508858680725097656e-01, /* logih[104] */ 
    1.74672070296268393919501631375949801326271042364782e-17, /* logim[104] */ 
    1.28757784323920807504216254145051967795248381758825e-33, /* logil[104] */ 
  } , 
  { 
    7.09141731262207031250000000000000000000000000000000e-01,   /* r[105] */ 
    3.43699869378304490030728857163921929895877838134766e-01, /* logih[105] */ 
    -5.19524092664710997838651465181771916951448804942375e-18, /* logim[105] */ 
    2.01852276300632912138205204757451068299686003381730e-34, /* logil[105] */ 
  } , 
  { 
    1.41436386108398437500000000000000000000000000000000e+00,   /* r[106] */ 
    -3.46679861870620553698785215601674281060695648193359e-01, /* logih[106] */ 
    -1.28487666876426526117753107153366705047319625953434e-17, /* logim[106] */ 
    1.35559275452957780052106182147355087625385646501787e-37, /* logil[106] */ 
  } , 
  { 
    1.41046905517578125000000000000000000000000000000000e+00,   /* r[107] */ 
    -3.43922312315162792550893300358438864350318908691406e-01, /* logih[107] */ 
    4.92019729190951095471164720202037831908390366509329e-18, /* logim[107] */ 
    3.82551714632527355673617639808721263761194697351796e-34, /* logil[107] */ 
  } , 
  { 
    1.40659332275390625000000000000000000000000000000000e+00,   /* r[108] */ 
    -3.41170697798120592381110327551141381263732910156250e-01, /* logih[108] */ 
    1.93668606486849623510457675345565515553170548397263e-17, /* logim[108] */ 
    -6.31924577586791945681481090971933602378723267089765e-34, /* logil[108] */ 
  } , 
  { 
    1.40274047851562500000000000000000000000000000000000e+00,   /* r[109] */ 
    -3.38427807898675381270692241741926409304141998291016e-01, /* logih[109] */ 
    6.54538052872786451417312049621269831217791334849587e-18, /* logim[109] */ 
    -1.38134173915396180632358800838166951094785757798298e-34, /* logil[109] */ 
  } , 
  { 
    1.39890670776367187500000000000000000000000000000000e+00,   /* r[110] */ 
    -3.35691008516038780218337933547445572912693023681641e-01, /* logih[110] */ 
    7.19133786441628176722646778964275817014488601387322e-18, /* logim[110] */ 
    2.28260205775013127550656696784879220819429866829588e-36, /* logil[110] */ 
  } , 
  { 
    1.39509582519531250000000000000000000000000000000000e+00,   /* r[111] */ 
    -3.32963104810430066127224790761829353868961334228516e-01, /* logih[111] */ 
    2.31257782383773679965596591934497042170211009414751e-17, /* logim[111] */ 
    -8.99899918826696456699888760884182179403739540341569e-34, /* logil[111] */ 
  } , 
  { 
    1.39130401611328125000000000000000000000000000000000e+00,   /* r[112] */ 
    -3.30241448451969343835799008957110345363616943359375e-01, /* logih[112] */ 
    1.08328391473436749190918194684471671377932692613855e-17, /* logim[112] */ 
    2.05469820214513767177005852735365876929387324182847e-34, /* logil[112] */ 
  } , 
  { 
    1.38753318786621093750000000000000000000000000000000e+00,   /* r[113] */ 
    -3.27527485535248186199197562018525786697864532470703e-01, /* logih[113] */ 
    2.56707416856969394221064681139222300535027158809986e-17, /* logim[113] */ 
    2.48018075170015936943477306695127673525907564478115e-34, /* logil[113] */ 
  } , 
  { 
    1.38378334045410156250000000000000000000000000000000e+00,   /* r[114] */ 
    -3.24821299026220644545759341781376861035823822021484e-01, /* logih[114] */ 
    -2.40283588419711964440744928607170649222918319264531e-17, /* logim[114] */ 
    1.40448044142609986920740213180800276002578003774456e-33, /* logil[114] */ 
  } , 
  { 
    1.38005447387695312500000000000000000000000000000000e+00,   /* r[115] */ 
    -3.22122972213921499040623075416078791022300720214844e-01, /* logih[115] */ 
    -1.66818907547914379914312063731519121720479863896485e-17, /* logim[115] */ 
    -8.55009499177937534961617974327717063975398325813083e-34, /* logil[115] */ 
  } , 
  { 
    1.37634468078613281250000000000000000000000000000000e+00,   /* r[116] */ 
    -3.19431202899942479067618705812492407858371734619141e-01, /* logih[116] */ 
    -1.38115565915964367886690142912485000070964727867745e-18, /* logim[116] */ 
    -1.22984664179014233019202567735778158211873499167925e-35, /* logil[116] */ 
  } , 
  { 
    1.37265396118164062500000000000000000000000000000000e+00,   /* r[117] */ 
    -3.16746063834650870560949442733544856309890747070312e-01, /* logih[117] */ 
    -1.15419278228466239427477637425076471306644591952148e-17, /* logim[117] */ 
    3.41592451858080777739018945315482424309486529068749e-34, /* logil[117] */ 
  } , 
  { 
    1.36898422241210937500000000000000000000000000000000e+00,   /* r[118] */ 
    -3.14069021340052600965719875603099353611469268798828e-01, /* logih[118] */ 
    -7.31349707246752102101544908905981332227259572261770e-18, /* logim[118] */ 
    -3.93910979025310412654744290737242169075928226381889e-34, /* logil[118] */ 
  } , 
  { 
    1.36533355712890625000000000000000000000000000000000e+00,   /* r[119] */ 
    -3.11398762981856647158451778523158282041549682617188e-01, /* logih[119] */ 
    -2.10262028332851499303996266991953733885100475347425e-17, /* logim[119] */ 
    3.10172118073247334983412381313166324533523917848591e-34, /* logil[119] */ 
  } , 
  { 
    1.36170196533203125000000000000000000000000000000000e+00,   /* r[120] */ 
    -3.08735362440316629673020543123129755258560180664062e-01, /* logih[120] */ 
    1.61997507738300932313233656106715605269821143050038e-17, /* logim[120] */ 
    -4.94737397643073988821957091336118905427415985059196e-34, /* logil[120] */ 
  } , 
  { 
    1.35808944702148437500000000000000000000000000000000e+00,   /* r[121] */ 
    -3.06078893698965515124399416890810243785381317138672e-01, /* logih[121] */ 
    -2.14383901488893084851347644248966504652364110743417e-17, /* logim[121] */ 
    -1.04285659471621119336484757092986113762774232464117e-34, /* logil[121] */ 
  } , 
  { 
    1.35449790954589843750000000000000000000000000000000e+00,   /* r[122] */ 
    -3.03430839201768942636761039466364309191703796386719e-01, /* logih[122] */ 
    -2.36272540975444581798067226838922324791286981755800e-17, /* logim[122] */ 
    7.63193414263891924102062717951976678650366075861562e-34, /* logil[122] */ 
  } , 
  { 
    1.35092353820800781250000000000000000000000000000000e+00,   /* r[123] */ 
    -3.00788460935273893603891792736249044537544250488281e-01, /* logih[123] */ 
    1.31911240315125569456750230823426654574574756805059e-17, /* logim[123] */ 
    6.09798153293836260383095031169419558002984888039367e-34, /* logil[123] */ 
  } , 
  { 
    1.34736824035644531250000000000000000000000000000000e+00,   /* r[124] */ 
    -2.98153238208616611082391045783879235386848449707031e-01, /* logih[124] */ 
    1.72077626940949324831538094445960560173054776887669e-17, /* logim[124] */ 
    1.50419727472329867273356373006418522570851500586450e-33, /* logil[124] */ 
  } , 
  { 
    1.34383201599121093750000000000000000000000000000000e+00,   /* r[125] */ 
    -2.95525246187516521523264145798748359084129333496094e-01, /* logih[125] */ 
    6.61166908095413536634982853435304018965741335429843e-18, /* logim[125] */ 
    -1.66439777489787908751728074566359602553422366675323e-34, /* logil[125] */ 
  } , 
  { 
    1.34031486511230468750000000000000000000000000000000e+00,   /* r[126] */ 
    -2.92904560325168261680772729960153810679912567138672e-01, /* logih[126] */ 
    -6.83776292620451776752481870270640194860145197512462e-18, /* logim[126] */ 
    1.55562105120034357822530615049801316732267321042243e-34, /* logil[126] */ 
  } , 
  { 
    1.33681488037109375000000000000000000000000000000000e+00,   /* r[127] */ 
    -2.90289829573938562568002907937625423073768615722656e-01, /* logih[127] */ 
    1.05531301797230420241902730814804872346105655886287e-17, /* logim[127] */ 
    4.79041533288401481752223531420283794797478252934091e-34, /* logil[127] */ 
  } , 
  { 
    1.33333396911621093750000000000000000000000000000000e+00,   /* r[128] */ 
    -2.87682549288825417654891225538449361920356750488281e-01, /* logih[128] */ 
    -2.61077462239171302791459888459712394960284043875709e-17, /* logim[128] */ 
    2.49074425570525367279357114033805399391008799131216e-34, /* logil[128] */ 
  } , 
  { 
    1.32987022399902343750000000000000000000000000000000e+00,   /* r[129] */ 
    -2.85081361532236732259093514585401862859725952148438e-01, /* logih[129] */ 
    5.43627399844908067645917310959280553768099267155506e-18, /* logim[129] */ 
    -1.40940968647840734289903124482303996508342832614184e-34, /* logil[129] */ 
  } , 
  { 
    1.32642555236816406250000000000000000000000000000000e+00,   /* r[130] */ 
    -2.82487769664605981034810611163266003131866455078125e-01, /* logih[130] */ 
    1.40579607152920466183148026056253132184915242828454e-17, /* logim[130] */ 
    8.55245308058326661171909652892008079386885810342353e-35, /* logil[130] */ 
  } , 
  { 
    1.32299804687500000000000000000000000000000000000000e+00,   /* r[131] */ 
    -2.79900408846770476500864788249600678682327270507812e-01, /* logih[131] */ 
    -1.83143097611448426823122105710887862843742634907885e-17, /* logim[131] */ 
    7.32680743617844937675707357797053020869120027100328e-34, /* logil[131] */ 
  } , 
  { 
    1.31958770751953125000000000000000000000000000000000e+00,   /* r[132] */ 
    -2.77319345020877350282972884087939746677875518798828e-01, /* logih[132] */ 
    7.44521346975934828880026635948320543669274837358637e-18, /* logim[132] */ 
    -5.41922476182319969711469733445405189836277342215443e-34, /* logil[132] */ 
  } , 
  { 
    1.31619453430175781250000000000000000000000000000000e+00,   /* r[133] */ 
    -2.74744644396217541082449997702497057616710662841797e-01, /* logih[133] */ 
    -1.35539016985663678510001485327198622349128587937948e-17, /* logim[133] */ 
    -2.47605212552478755864671758320404239244847510600429e-34, /* logil[133] */ 
  } , 
  { 
    1.31282043457031250000000000000000000000000000000000e+00,   /* r[134] */ 
    -2.72177826311169102080356196893262676894664764404297e-01, /* logih[134] */ 
    -1.94604737767255604321061638736698666324990178271015e-17, /* logim[134] */ 
    4.93318792723831633917605655356651628446409622108869e-34, /* logil[134] */ 
  } , 
  { 
    1.30946350097656250000000000000000000000000000000000e+00,   /* r[135] */ 
    -2.69617512088877908649209302893723361194133758544922e-01, /* logih[135] */ 
    -4.36842068525796679795304490876810534098425489515634e-19, /* logim[135] */ 
    -2.59640519936698818691794834943491001573704557192093e-35, /* logil[135] */ 
  } , 
  { 
    1.30612182617187500000000000000000000000000000000000e+00,   /* r[136] */ 
    -2.67062308411773363658880953153129667043685913085938e-01, /* logih[136] */ 
    7.36505541266105414954508218919326623562242166589177e-18, /* logim[136] */ 
    4.30859840846165501987206211849479522591226050316009e-34, /* logil[136] */ 
  } , 
  { 
    1.30279922485351562500000000000000000000000000000000e+00,   /* r[137] */ 
    -2.64515199434744108231143400189466774463653564453125e-01, /* logih[137] */ 
    -1.68423739176487233694295158507739753610875825604997e-17, /* logim[137] */ 
    -2.52387133235317228793067248082680461143877917377527e-34, /* logil[137] */ 
  } , 
  { 
    1.29949188232421875000000000000000000000000000000000e+00,   /* r[138] */ 
    -2.61973328311307873672575396994943730533123016357422e-01, /* logih[138] */ 
    -3.75057237736452977469227410853090805509462799202680e-18, /* logim[138] */ 
    -2.50001621249400187276643559364982462572917581991553e-34, /* logil[138] */ 
  } , 
  { 
    1.29620170593261718750000000000000000000000000000000e+00,   /* r[139] */ 
    -2.59438223113541976960760848669451661407947540283203e-01, /* logih[139] */ 
    -1.75050620652398740735421575793594666738296743072718e-18, /* logim[139] */ 
    -1.76879556289338598533013427354560697647411264656770e-34, /* logil[139] */ 
  } , 
  { 
    1.29292869567871093750000000000000000000000000000000e+00,   /* r[140] */ 
    -2.56909951848923512329747609328478574752807617187500e-01, /* logih[140] */ 
    -2.49955762333036735703890989320152300242733956262258e-17, /* logim[140] */ 
    6.46984311731974220303858069024859972656679564537485e-34, /* logil[140] */ 
  } , 
  { 
    1.28967285156250000000000000000000000000000000000000e+00,   /* r[141] */ 
    -2.54388582770868065807690072688274085521697998046875e-01, /* logih[141] */ 
    1.42784459055047481334238305742929320333571952363668e-17, /* logim[141] */ 
    1.44560161052022205741731365640574141772476641472904e-33, /* logil[141] */ 
  } , 
  { 
    1.28643226623535156250000000000000000000000000000000e+00,   /* r[142] */ 
    -2.51872701711453261808060233306605368852615356445312e-01, /* logih[142] */ 
    -2.58573188266130078596915247890597291360969537163785e-17, /* logim[142] */ 
    3.36064630885731507350249551263037246653963144676932e-34, /* logil[142] */ 
  } , 
  { 
    1.28320884704589843750000000000000000000000000000000e+00,   /* r[143] */ 
    -2.49363852624658294265813651691132690757513046264648e-01, /* logih[143] */ 
    6.17564000922762053278709883095158100872225794241962e-18, /* logim[143] */ 
    -3.59696250405991778286139521640842821567504780771091e-34, /* logil[143] */ 
  } , 
  { 
    1.28000068664550781250000000000000000000000000000000e+00,   /* r[144] */ 
    -2.46860614373184877878841803067189175635576248168945e-01, /* logih[144] */ 
    -1.36688909483265210237069537981338704526084198528804e-17, /* logim[144] */ 
    -4.92999816324333714793093560012211883282871708512667e-34, /* logil[144] */ 
  } , 
  { 
    1.27680778503417968750000000000000000000000000000000e+00,   /* r[145] */ 
    -2.44363044996024708632731403668003622442483901977539e-01, /* logih[145] */ 
    1.09486381393098425629951474169192910961933895685875e-17, /* logim[145] */ 
    1.13614657049426843838447103108579796261058240882279e-34, /* logil[145] */ 
  } , 
  { 
    1.27363204956054687500000000000000000000000000000000e+00,   /* r[146] */ 
    -2.41872700333246426485089841662556864321231842041016e-01, /* logih[146] */ 
    3.58546134799758558220376210039678485387885916926961e-18, /* logim[146] */ 
    -2.20085959592144414214775971267831972426029128230714e-34, /* logil[146] */ 
  } , 
  { 
    1.27047157287597656250000000000000000000000000000000e+00,   /* r[147] */ 
    -2.39388148774497988569009976345114409923553466796875e-01, /* logih[147] */ 
    -8.15278529428586557427891691038658199587387144643622e-18, /* logim[147] */ 
    -4.48801512822497796294159745847501737318770920712608e-34, /* logil[147] */ 
  } , 
  { 
    1.26732635498046875000000000000000000000000000000000e+00,   /* r[148] */ 
    -2.36909449055089427194076279192813672125339508056641e-01, /* logih[148] */ 
    -1.95941703600043116666763494344574061919652321991003e-18, /* logim[148] */ 
    -7.12890529228103914163560488030577203415481759502335e-36, /* logil[148] */ 
  } , 
  { 
    1.26419830322265625000000000000000000000000000000000e+00,   /* r[149] */ 
    -2.34438168880390956916315303715236950665712356567383e-01, /* logih[149] */ 
    -6.99651372151112997059366610960978925151468620541361e-18, /* logim[149] */ 
    2.72198075748279584311862548086147097324308430232999e-34, /* logil[149] */ 
  } , 
  { 
    1.26108360290527343750000000000000000000000000000000e+00,   /* r[150] */ 
    -2.31971353679059938412976293875544797629117965698242e-01, /* logih[150] */ 
    -5.77385522134567574535417063256881508583112235194305e-18, /* logim[150] */ 
    3.79366854190657220850283401392416116381504642214271e-34, /* logil[150] */ 
  } , 
  { 
    1.25798606872558593750000000000000000000000000000000e+00,   /* r[151] */ 
    -2.29512084071926747430580917352926917374134063720703e-01, /* logih[151] */ 
    -8.73917888836756753861059666333090512067547544675485e-18, /* logim[151] */ 
    -5.69482104001851921922283043288492925754991621288172e-34, /* logil[151] */ 
  } , 
  { 
    1.25490188598632812500000000000000000000000000000000e+00,   /* r[152] */ 
    -2.27057391030699523559732710964453872293233871459961e-01, /* logih[152] */ 
    -9.55134517665639461592830714479938653876650013848813e-18, /* logim[152] */ 
    -7.00052160915705629865262646818211330004502638341784e-34, /* logil[152] */ 
  } , 
  { 
    1.25183296203613281250000000000000000000000000000000e+00,   /* r[153] */ 
    -2.24608846873032674817949327916721813380718231201172e-01, /* logih[153] */ 
    -2.19162128124331068197096372804387663813879070153910e-18, /* logim[153] */ 
    8.00496321203755877183709886194177284253312594316861e-35, /* logil[153] */ 
  } , 
  { 
    1.24878120422363281250000000000000000000000000000000e+00,   /* r[154] */ 
    -2.22168039035695707994477743341121822595596313476562e-01, /* logih[154] */ 
    1.07342637360833029593335438601345228992436813797418e-17, /* logim[154] */ 
    -7.67553083967135214121581596311206028889095496603001e-34, /* logil[154] */ 
  } , 
  { 
    1.24574279785156250000000000000000000000000000000000e+00,   /* r[155] */ 
    -2.19731976787238214576802874944405630230903625488281e-01, /* logih[155] */ 
    -1.35345511944004269567659266993040497754817745842460e-17, /* logim[155] */ 
    -7.06055747414660075242875132218211703222886262645151e-34, /* logil[155] */ 
  } , 
  { 
    1.24271774291992187500000000000000000000000000000000e+00,   /* r[156] */ 
    -2.17300709445695711119483917173056397587060928344727e-01, /* logih[156] */ 
    -1.55632648024565809587441742115549412481509415401206e-18, /* logim[156] */ 
    -2.73645872916697873734554009814155050548437865470935e-35, /* logil[156] */ 
  } , 
  { 
    1.23970985412597656250000000000000000000000000000000e+00,   /* r[157] */ 
    -2.14877363629256634691699900940875522792339324951172e-01, /* logih[157] */ 
    5.51412653363101081432833599630524903528204879298177e-18, /* logim[157] */ 
    1.93479402223180105608082323440368830737884048556178e-34, /* logil[157] */ 
  } , 
  { 
    1.23671531677246093750000000000000000000000000000000e+00,   /* r[158] */ 
    -2.12458926885637500170389557752059772610664367675781e-01, /* logih[158] */ 
    9.62416986757368333294762208707250932658825738879454e-18, /* logim[158] */ 
    1.34243694982089823913061491133601163572475339258708e-34, /* logil[158] */ 
  } , 
  { 
    1.23373413085937500000000000000000000000000000000000e+00,   /* r[159] */ 
    -2.10045449157502006620745760301360860466957092285156e-01, /* logih[159] */ 
    -1.14897192287332807026526402359503839328475948011071e-17, /* logim[159] */ 
    3.22998731854659925401919707956820087718358954278512e-34, /* logil[159] */ 
  } , 
  { 
    1.23077011108398437500000000000000000000000000000000e+00,   /* r[160] */ 
    -2.07640080033725998864824191514344420284032821655273e-01, /* logih[160] */ 
    -1.21752158956595077938199084785214052668704102263663e-17, /* logim[160] */ 
    3.85113498704488412720849922642321502513839838743598e-34, /* logil[160] */ 
  } , 
  { 
    1.22781753540039062500000000000000000000000000000000e+00,   /* r[161] */ 
    -2.05238231877337917730130811833078041672706604003906e-01, /* logih[161] */ 
    -6.49170319816279074800980031896509389281475760737419e-18, /* logim[161] */ 
    7.54230794214336863035202362512077511130553782508548e-35, /* logil[161] */ 
  } , 
  { 
    1.22488021850585937500000000000000000000000000000000e+00,   /* r[162] */ 
    -2.02843058404291731733337655896320939064025878906250e-01, /* logih[162] */ 
    -2.09733857251185914090082750810867355591642377167668e-18, /* logim[162] */ 
    -7.58503055294887496788011335562125472007511746053015e-35, /* logil[162] */ 
  } , 
  { 
    1.22195625305175781250000000000000000000000000000000e+00,   /* r[163] */ 
    -2.00453060641940739028399320886819623410701751708984e-01, /* logih[163] */ 
    -6.53774572382445798876000474193661396320697712784592e-18, /* logim[163] */ 
    3.51772439194901607097398534803672574024027259307605e-34, /* logil[163] */ 
  } , 
  { 
    1.21904754638671875000000000000000000000000000000000e+00,   /* r[164] */ 
    -1.98069854157447239328959653903439175337553024291992e-01, /* logih[164] */ 
    -3.74277289637934596837745314540095849706853736054736e-18, /* logim[164] */ 
    2.20940287174632344749918330821286328950105212564345e-34, /* logil[164] */ 
  } , 
  { 
    1.21615219116210937500000000000000000000000000000000e+00,   /* r[165] */ 
    -1.95691932918147681874643240007571876049041748046875e-01, /* logih[165] */ 
    -7.08261236288433014439133183526990067310528978959932e-18, /* logim[165] */ 
    -1.96435463626369637687474243037286042706661477855383e-34, /* logil[165] */ 
  } , 
  { 
    1.21327018737792968750000000000000000000000000000000e+00,   /* r[166] */ 
    -1.93319348256398265695210625381150748580694198608398e-01, /* logih[166] */ 
    -4.63045754803609100012916107813305239709411987466506e-18, /* logim[166] */ 
    3.81311992624323390610440652445847060246376140730432e-34, /* logil[166] */ 
  } , 
  { 
    1.21040153503417968750000000000000000000000000000000e+00,   /* r[167] */ 
    -1.90952151695252925200918525661109015345573425292969e-01, /* logih[167] */ 
    -5.80616769316522716849138580075656569977606755839734e-18, /* logim[167] */ 
    1.34601476508880492535970189187338024694052031880198e-34, /* logil[167] */ 
  } , 
  { 
    1.20754623413085937500000000000000000000000000000000e+00,   /* r[168] */ 
    -1.88590394946867745407104166588396765291690826416016e-01, /* logih[168] */ 
    7.58724192474608110981409818070149841661745061197758e-18, /* logim[168] */ 
    5.09865531698430288976485112090438508546399086848170e-34, /* logil[168] */ 
  } , 
  { 
    1.20470619201660156250000000000000000000000000000000e+00,   /* r[169] */ 
    -1.86235713160088522943880207094480283558368682861328e-01, /* logih[169] */ 
    9.83598941678855625746040824683214800947055255023752e-18, /* logim[169] */ 
    2.46513729584939313689642856331884108597210035577156e-35, /* logil[169] */ 
  } , 
  { 
    1.20187759399414062500000000000000000000000000000000e+00,   /* r[170] */ 
    -1.83884995648034593740405284734151791781187057495117e-01, /* logih[170] */ 
    -6.70852935530959296202331099325187741392981643909817e-18, /* logim[170] */ 
    3.00844769658087560728352059501736867279973513368500e-34, /* logil[170] */ 
  } , 
  { 
    1.19906234741210937500000000000000000000000000000000e+00,   /* r[171] */ 
    -1.81539874203132112207015325111569836735725402832031e-01, /* logih[171] */ 
    9.29803006036969326009349085152256934923841308327213e-18, /* logim[171] */ 
    -5.87687279777529126455867415463448459437016045941915e-34, /* logil[171] */ 
  } , 
  { 
    1.19626235961914062500000000000000000000000000000000e+00,   /* r[172] */ 
    -1.79201995701676053407425115437945351004600524902344e-01, /* logih[172] */ 
    1.07244987411303504039951333305926418667267361291349e-17, /* logim[172] */ 
    6.96460410267841846987295265759921471979042436315030e-34, /* logil[172] */ 
  } , 
  { 
    1.19347381591796875000000000000000000000000000000000e+00,   /* r[173] */ 
    -1.76868227651996584581794991208880674093961715698242e-01, /* logih[173] */ 
    -1.10573571536398568326433843554050954952961171968919e-17, /* logim[173] */ 
    -7.15366049912217554019889444240641484300247544429326e-34, /* logil[173] */ 
  } , 
  { 
    1.19069862365722656250000000000000000000000000000000e+00,   /* r[174] */ 
    -1.74540213563705776111945056072727311402559280395508e-01, /* logih[174] */ 
    1.41441535586615290351432125355737755606926544229499e-18, /* logim[174] */ 
    -9.09232357027904656212336285800609485022315015052927e-35, /* logil[174] */ 
  } , 
  { 
    1.18793487548828125000000000000000000000000000000000e+00,   /* r[175] */ 
    -1.72216400825300264276762618464999832212924957275391e-01, /* logih[175] */ 
    4.70555006507071052711499439464966393443028017169630e-18, /* logim[175] */ 
    -2.05933939394796488034283377335053411303251320729741e-36, /* logil[175] */ 
  } , 
  { 
    1.18518447875976562500000000000000000000000000000000e+00,   /* r[176] */ 
    -1.69898440748772083797035747920745052397251129150391e-01, /* logih[176] */ 
    5.57386986936216704195834036089361797810285720893573e-19, /* logim[176] */ 
    1.95979458384118524767836145844611746655750937760436e-35, /* logil[176] */ 
  } , 
  { 
    1.18244743347167968750000000000000000000000000000000e+00,   /* r[177] */ 
    -1.67586386672116810503396777676243800669908523559570e-01, /* logih[177] */ 
    -2.10518678245997312072852724987229988978414584927966e-18, /* logim[177] */ 
    1.28828497071302497365120049253927765655050473764692e-34, /* logil[177] */ 
  } , 
  { 
    1.17972373962402343750000000000000000000000000000000e+00,   /* r[178] */ 
    -1.65280292104758808058306840393925085663795471191406e-01, /* logih[178] */ 
    6.23517789601925714710479118600106051919949505966744e-19, /* logim[178] */ 
    -3.18208255979837719298953172591840257465716328738635e-35, /* logil[178] */ 
  } , 
  { 
    1.17701148986816406250000000000000000000000000000000e+00,   /* r[179] */ 
    -1.62978590225533376267819107852119486778974533081055e-01, /* logih[179] */ 
    -9.90718539912068708756719628839252162668848272704435e-18, /* logim[179] */ 
    2.65318297676807803018499365510556573456222990710937e-34, /* logil[179] */ 
  } , 
  { 
    1.17431259155273437500000000000000000000000000000000e+00,   /* r[180] */ 
    -1.60682947934438519199673578441434074193239212036133e-01, /* logih[180] */ 
    3.58966483931976449925223154468506323464461604873135e-18, /* logim[180] */ 
    -2.61108466517449169019772324573366398622685617699208e-35, /* logil[180] */ 
  } , 
  { 
    1.17162513732910156250000000000000000000000000000000e+00,   /* r[181] */ 
    -1.58391791297011308436992749193450435996055603027344e-01, /* logih[181] */ 
    1.17290336952422323777350005767652445704229453391095e-17, /* logim[181] */ 
    -2.09345211610593757799592941150206031045717866622119e-34, /* logil[181] */ 
  } , 
  { 
    1.16894912719726562500000000000000000000000000000000e+00,   /* r[182] */ 
    -1.56105163319945505762120774306822568178176879882812e-01, /* logih[182] */ 
    1.28628359267905556190943307276740736661339408993324e-17, /* logim[182] */ 
    -5.95304689974676498338427563732575867009069071311929e-34, /* logil[182] */ 
  } , 
  { 
    1.16628646850585937500000000000000000000000000000000e+00,   /* r[183] */ 
    -1.53824742577648665431411245663184672594070434570312e-01, /* logih[183] */ 
    -1.21520306098644174029034710109981732360242413879415e-18, /* logim[183] */ 
    -3.46376210577156535712238040881332980606390914922373e-35, /* logil[183] */ 
  } , 
  { 
    1.16363716125488281250000000000000000000000000000000e+00,   /* r[184] */ 
    -1.51550583580380926473907265972229652106761932373047e-01, /* logih[184] */ 
    -5.27431191607729841894071463956904781997884546886957e-18, /* logim[184] */ 
    -2.12312727053942207829403955523840244683485282807904e-34, /* logil[184] */ 
  } , 
  { 
    1.16099739074707031250000000000000000000000000000000e+00,   /* r[185] */ 
    -1.49279455294684920696468566347903106361627578735352e-01, /* logih[185] */ 
    1.30791371646357520506414737413216453391959478831327e-17, /* logim[185] */ 
    7.56862790077388154224564404755685931026804721911961e-34, /* logil[185] */ 
  } , 
  { 
    1.15837097167968750000000000000000000000000000000000e+00,   /* r[186] */ 
    -1.47014683357163111754317696977523155510425567626953e-01, /* logih[186] */ 
    4.46701777108311388441189058844554903695616000674812e-18, /* logim[186] */ 
    -1.53168389834566630100313932781112142055948393405761e-34, /* logil[186] */ 
  } , 
  { 
    1.15575599670410156250000000000000000000000000000000e+00,   /* r[187] */ 
    -1.44754672455130850572402323450660333037376403808594e-01, /* logih[187] */ 
    -1.11765997308804560786725769664171557832093187263628e-17, /* logim[187] */ 
    -2.54391351083201803872348589456916885864191215547753e-34, /* logil[187] */ 
  } , 
  { 
    1.15315246582031250000000000000000000000000000000000e+00,   /* r[188] */ 
    -1.42499466560657650493482151432544924318790435791016e-01, /* logih[188] */ 
    9.99697434471805963116106325782098963574947115358262e-18, /* logim[188] */ 
    -4.16991647873877558887722645601154258382043780560798e-34, /* logil[188] */ 
  } , 
  { 
    1.15056228637695312500000000000000000000000000000000e+00,   /* r[189] */ 
    -1.40250767556271416225399661925621330738067626953125e-01, /* logih[189] */ 
    -2.42967383902664590341317347111432842699638485445637e-18, /* logim[189] */ 
    1.89046895909651011241835667303830696393887263209723e-35, /* logil[189] */ 
  } , 
  { 
    1.14798164367675781250000000000000000000000000000000e+00,   /* r[190] */ 
    -1.38005307940927829379873514881182927638292312622070e-01, /* logih[190] */ 
    3.09897250271566693336611278140158537034235759176630e-18, /* logim[190] */ 
    4.18076944171954954430079149735725094064207802954500e-35, /* logil[190] */ 
  } , 
  { 
    1.14541435241699218750000000000000000000000000000000e+00,   /* r[191] */ 
    -1.35766451383654063178596516081597656011581420898438e-01, /* logih[191] */ 
    -1.26737144704388924877419888090078242028004784977676e-17, /* logim[191] */ 
    -6.55254988981886759240332153938275164053851414525063e-34, /* logil[191] */ 
  } , 
  { 
    1.14285659790039062500000000000000000000000000000000e+00,   /* r[192] */ 
    -1.33530915787250736848079668561695143580436706542969e-01, /* logih[192] */ 
    3.70059774900097017560711245248993036856587443848886e-18, /* logim[192] */ 
    -1.44076022950175208091543146453702789322369025821334e-34, /* logil[192] */ 
  } , 
  { 
    1.14031219482421875000000000000000000000000000000000e+00,   /* r[193] */ 
    -1.31302080023902228989030049888242501765489578247070e-01, /* logih[193] */ 
    9.77595259647047985795328829376646744546732643730202e-18, /* logim[193] */ 
    7.14001485916042767804723486534578453220499721661498e-34, /* logil[193] */ 
  } , 
  { 
    1.13777732849121093750000000000000000000000000000000e+00,   /* r[194] */ 
    -1.29076647394292753912026228135800920426845550537109e-01, /* logih[194] */ 
    1.29614980241403171231290027930196525012258765738554e-17, /* logim[194] */ 
    -5.85566533144206341645149580771754974185386331638589e-34, /* logil[194] */ 
  } , 
  { 
    1.13525581359863281250000000000000000000000000000000e+00,   /* r[195] */ 
    -1.26858011968173783889923811329936143010854721069336e-01, /* logih[195] */ 
    -1.69678439390834976532815985483256409225876795508054e-18, /* logim[195] */ 
    -2.71228529760193445477650881984529057919186509828788e-35, /* logil[195] */ 
  } , 
  { 
    1.13274383544921875000000000000000000000000000000000e+00,   /* r[196] */ 
    -1.24642862439702989396650423259416129440069198608398e-01, /* logih[196] */ 
    5.78470166144150337574069781581246057448668006106709e-18, /* logim[196] */ 
    -1.51194875373975987733573028833303263737665603241701e-34, /* logil[196] */ 
  } , 
  { 
    1.13024330139160156250000000000000000000000000000000e+00,   /* r[197] */ 
    -1.22432920514188886551565360605309251695871353149414e-01, /* logih[197] */ 
    -1.49693760153482569091449280029762521944027633466473e-18, /* logim[197] */ 
    -5.39965434369591591869001705818915138621233644825736e-35, /* logil[197] */ 
  } , 
  { 
    1.12775421142578125000000000000000000000000000000000e+00,   /* r[198] */ 
    -1.20228231660540529901481932029128074645996093750000e-01, /* logih[198] */ 
    2.66388161368585650190234204294063114917602653271451e-18, /* logim[198] */ 
    -4.74069350504018899441229048102955157835045789801575e-35, /* logil[198] */ 
  } , 
  { 
    1.12527465820312500000000000000000000000000000000000e+00,   /* r[199] */ 
    -1.18027146483910813645756832102051703259348869323730e-01, /* logih[199] */ 
    -3.60219775645429345296067350839693560520470018134018e-18, /* logim[199] */ 
    -2.54791949912299670752413217558541051658120178578709e-36, /* logil[199] */ 
  } , 
  { 
    1.12280654907226562500000000000000000000000000000000e+00,   /* r[200] */ 
    -1.15831398292521231541130077857815194875001907348633e-01, /* logih[200] */ 
    -4.31427333715618757910709691609269654043220111432066e-18, /* logim[200] */ 
    -9.92584460384660583856113744874441511647452425237725e-35, /* logil[200] */ 
  } , 
  { 
    1.12034988403320312500000000000000000000000000000000e+00,   /* r[201] */ 
    -1.13641032979606732000732449705537874251604080200195e-01, /* logih[201] */ 
    -2.80052852737773106136039129617512559000765084602728e-18, /* logim[201] */ 
    1.05442382041672403942755754838681010220413395137635e-34, /* logil[201] */ 
  } , 
  { 
    1.11790466308593750000000000000000000000000000000000e+00,   /* r[202] */ 
    -1.11456096576200411329971018403739435598254203796387e-01, /* logih[202] */ 
    -5.77990794389030241792168588642671979086900695176190e-18, /* logim[202] */ 
    -1.69142770089478743453734869721080946466526879559136e-35, /* logil[202] */ 
  } , 
  { 
    1.11546897888183593750000000000000000000000000000000e+00,   /* r[203] */ 
    -1.09274925343603279692672458622837439179420471191406e-01, /* logih[203] */ 
    -3.85400236141315267161376748908212877710726873076641e-18, /* logim[203] */ 
    -2.42661397467022652703862793756433704621690971685882e-34, /* logil[203] */ 
  } , 
  { 
    1.11304283142089843750000000000000000000000000000000e+00,   /* r[204] */ 
    -1.07097554410911677269524489020113833248615264892578e-01, /* logih[204] */ 
    1.80247443768247945406811707831640352654515433418144e-18, /* logim[204] */ 
    -1.85453257375612125088595374639844790140667033156959e-34, /* logil[204] */ 
  } , 
  { 
    1.11062812805175781250000000000000000000000000000000e+00,   /* r[205] */ 
    -1.04925736401603963976469913177425041794776916503906e-01, /* logih[205] */ 
    2.91414777009923095944264947235313742597856028896167e-18, /* logim[205] */ 
    -3.61510340016815217927552346757607780248730263443438e-35, /* logil[205] */ 
  } , 
  { 
    1.10822486877441406250000000000000000000000000000000e+00,   /* r[206] */ 
    -1.02759517890908286252837910978996660560369491577148e-01, /* logih[206] */ 
    4.71099321843214355541046112004586746562119362394250e-18, /* logim[206] */ 
    -1.09517195512805323092039219231698490527876281773580e-34, /* logil[206] */ 
  } , 
  { 
    1.10583114624023437500000000000000000000000000000000e+00,   /* r[207] */ 
    -1.00597220775924339752904757006035652011632919311523e-01, /* logih[207] */ 
    -3.42156695637354590153605355608799216036823724345522e-18, /* logim[207] */ 
    -1.24284989441486949568174045668508613287571207046391e-36, /* logil[207] */ 
  } , 
  { 
    1.10344886779785156250000000000000000000000000000000e+00,   /* r[208] */ 
    -9.84406092549116179535317883164680097252130508422852e-02, /* logih[208] */ 
    4.38755240283229348312039895902645159531255023723883e-18, /* logim[208] */ 
    1.60705777926564974905947594633801050091055265351041e-34, /* logil[208] */ 
  } , 
  { 
    1.10107612609863281250000000000000000000000000000000e+00,   /* r[209] */ 
    -9.62879980375207500387091386073734611272811889648438e-02, /* logih[209] */ 
    -3.66395854119785801784314943749236711112635925431669e-18, /* logim[209] */ 
    1.90682128658230085463599916944170383720123953153313e-34, /* logil[209] */ 
  } , 
  { 
    1.09871292114257812500000000000000000000000000000000e+00,   /* r[210] */ 
    -9.41394230474431603639118293358478695154190063476562e-02, /* logih[210] */ 
    -1.52427934389046025790404533372637255540123275063242e-18, /* logim[210] */ 
    2.38117709862259339359946293808333798071470115227448e-35, /* logil[210] */ 
  } , 
  { 
    1.09635925292968750000000000000000000000000000000000e+00,   /* r[211] */ 
    -9.19949203356747319260122708328708540648221969604492e-02, /* logih[211] */ 
    -5.76786325743187763097260207334809269062162873149715e-18, /* logim[211] */ 
    -1.16076884637403681975821590448659743070392522145404e-34, /* logil[211] */ 
  } , 
  { 
    1.09401702880859375000000000000000000000000000000000e+00,   /* r[212] */ 
    -8.98562695172144959565585509153606835752725601196289e-02, /* logih[212] */ 
    6.27446602451052736319026996501069657057280086335290e-19, /* logim[212] */ 
    -3.52284010127094716016693656249620808330731317587528e-35, /* logil[212] */ 
  } , 
  { 
    1.09168434143066406250000000000000000000000000000000e+00,   /* r[213] */ 
    -8.77217709115478833092893751199881080538034439086914e-02, /* logih[213] */ 
    -1.37126670070706012825933173130657669787213551002177e-18, /* logim[213] */ 
    -1.23989072968810371061913173649528401394932986260312e-36, /* logil[213] */ 
  } , 
  { 
    1.08936119079589843750000000000000000000000000000000e+00,   /* r[214] */ 
    -8.55914609487157390654843425181752536445856094360352e-02, /* logih[214] */ 
    -6.73539996941766729916657848715943989064126863847235e-18, /* logim[214] */ 
    3.21430126927804602931832802266482628675064054148856e-34, /* logil[214] */ 
  } , 
  { 
    1.08704948425292968750000000000000000000000000000000e+00,   /* r[215] */ 
    -8.34671307946482227135831521991349291056394577026367e-02, /* logih[215] */ 
    -2.59301417543796652810804139098455715391427697882095e-18, /* logim[215] */ 
    1.65211492395331390788992293150317962555299571277512e-34, /* logil[215] */ 
  } , 
  { 
    1.08474540710449218750000000000000000000000000000000e+00,   /* r[216] */ 
    -8.13453116283524013674366415216354653239250183105469e-02, /* logih[216] */ 
    -5.06533259416045510334473576398828704896081639774469e-18, /* logim[216] */ 
    3.58554694819254814251485471545002207143063628923407e-34, /* logil[216] */ 
  } , 
  { 
    1.08245277404785156250000000000000000000000000000000e+00,   /* r[217] */ 
    -7.92295531972000560694269211126083973795175552368164e-02, /* logih[217] */ 
    3.08430116625330602805431897032551509181475376762118e-18, /* logim[217] */ 
    1.27521745632715758795764081462338721511029897619340e-34, /* logil[217] */ 
  } , 
  { 
    1.08016967773437500000000000000000000000000000000000e+00,   /* r[218] */ 
    -7.71181378091099767324578806437784805893898010253906e-02, /* logih[218] */ 
    -2.75912394291266277302481383554992246538214466259557e-18, /* logim[218] */ 
    5.96984502944699741108276688448842397927326332487835e-35, /* logil[218] */ 
  } , 
  { 
    1.07789421081542968750000000000000000000000000000000e+00,   /* r[219] */ 
    -7.50093329917183998523100285638065543025732040405273e-02, /* logih[219] */ 
    1.21553538095744083798831566922580286219799129072055e-18, /* logim[219] */ 
    -5.89842100461659880732549401024388472535698324065996e-35, /* logil[219] */ 
  } , 
  { 
    1.07563018798828125000000000000000000000000000000000e+00,   /* r[220] */ 
    -7.29067112034412351251333461732428986579179763793945e-02, /* logih[220] */ 
    6.30693084361487082247322771068486204374546343933133e-18, /* logim[220] */ 
    3.44825082371128400572272238979928316738696119124015e-34, /* logil[220] */ 
  } , 
  { 
    1.07337570190429687500000000000000000000000000000000e+00,   /* r[221] */ 
    -7.08085439330154442494347222236683592200279235839844e-02, /* logih[221] */ 
    6.21205862241802265972824064219836764844223885696046e-18, /* logim[221] */ 
    -2.58313322603855039499688568243180373305456453270216e-34, /* logil[221] */ 
  } , 
  { 
    1.07112884521484375000000000000000000000000000000000e+00,   /* r[222] */ 
    -6.87130878850236020971564698811562266200780868530273e-02, /* logih[222] */ 
    2.70354961689989817022493816753711952290500355166865e-18, /* logim[222] */ 
    -4.32103888921541828258452321965605627074720991923399e-35, /* logil[222] */ 
  } , 
  { 
    1.06889343261718750000000000000000000000000000000000e+00,   /* r[223] */ 
    -6.66239382216213954501782268380338791757822036743164e-02, /* logih[223] */ 
    5.70083134370999669291082348348689873755740434296954e-18, /* logim[223] */ 
    -8.10096531474775368286716199375642728810684749797528e-35, /* logil[223] */ 
  } , 
  { 
    1.06666755676269531250000000000000000000000000000000e+00,   /* r[224] */ 
    -6.45393556022498676716381282858492340892553329467773e-02, /* logih[224] */ 
    6.27679858230689064724912619776653321119382603385890e-18, /* logim[224] */ 
    3.82578436460361832583744997495972964625953636902884e-34, /* logil[224] */ 
  } , 
  { 
    1.06444931030273437500000000000000000000000000000000e+00,   /* r[225] */ 
    -6.24575859017184389920807063845131779089570045471191e-02, /* logih[225] */ 
    3.12396238135026689723293065657341228563060732941880e-18, /* logim[225] */ 
    -2.56480637242869270592951014242676091679089182875022e-35, /* logil[225] */ 
  } , 
  { 
    1.06224060058593750000000000000000000000000000000000e+00,   /* r[226] */ 
    -6.03804513842609302809449900450999848544597625732422e-02, /* logih[226] */ 
    2.15703432342306119511642925211564389619524247753812e-18, /* logim[226] */ 
    -3.99051054966201464148223117427430962485432571249835e-35, /* logil[226] */ 
  } , 
  { 
    1.06004142761230468750000000000000000000000000000000e+00,   /* r[227] */ 
    -5.83079900133864140188144631338218459859490394592285e-02, /* logih[227] */ 
    -2.26614868674930470856533040936568995022733760870024e-18, /* logim[227] */ 
    4.93654463845011924979397150953449636718851245018416e-36, /* logil[227] */ 
  } , 
  { 
    1.05785179138183593750000000000000000000000000000000e+00,   /* r[228] */ 
    -5.62402398633818634277048431613366119563579559326172e-02, /* logih[228] */ 
    3.23622784070623643425179422456037835068049704948076e-18, /* logim[228] */ 
    8.21211163681263455010708306384902557377035880000243e-35, /* logil[228] */ 
  } , 
  { 
    1.05566978454589843750000000000000000000000000000000e+00,   /* r[229] */ 
    -5.41754323534648848936789988783857552334666252136230e-02, /* logih[229] */ 
    -1.63682825416879776300941023746021061378436290037990e-18, /* logim[229] */ 
    -7.00922691871793498425237363067495151340436490327669e-35, /* logil[229] */ 
  } , 
  { 
    1.05349731445312500000000000000000000000000000000000e+00,   /* r[230] */ 
    -5.21154050923886280610730636908556334674358367919922e-02, /* logih[230] */ 
    -6.39781587823151025739574281786018493556176254138154e-19, /* logim[230] */ 
    3.56720195764935648932285840665933091100063235873938e-35, /* logil[230] */ 
  } , 
  { 
    1.05133438110351562500000000000000000000000000000000e+00,   /* r[231] */ 
    -5.00601964830668655359602325916057452559471130371094e-02, /* logih[231] */ 
    2.51984665593202228822706788872411441168875867302045e-18, /* logim[231] */ 
    -2.18342737706092628156578807143832418432366157819325e-35, /* logil[231] */ 
  } , 
  { 
    1.04918098449707031250000000000000000000000000000000e+00,   /* r[232] */ 
    -4.80098450349349045729319129804935073480010032653809e-02, /* logih[232] */ 
    -1.52080250600506339582829684987843924335937235135276e-18, /* logim[232] */ 
    -9.24379674215907095849380058311583825692328514013958e-35, /* logil[232] */ 
  } , 
  { 
    1.04703521728515625000000000000000000000000000000000e+00,   /* r[233] */ 
    -4.59625676982170078277434299707238096743822097778320e-02, /* logih[233] */ 
    -3.31972713633937264538106994059359671095924053342216e-18, /* logim[233] */ 
    -1.13937339607744860727400568917500096969385851217146e-34, /* logil[233] */ 
  } , 
  { 
    1.04489707946777343750000000000000000000000000000000e+00,   /* r[234] */ 
    -4.39183920188736254264227909516193903982639312744141e-02, /* logih[234] */ 
    -1.56343240701227240066055187635828001828861125718036e-18, /* logim[234] */ 
    -3.02746820911254374279963651479509453045839237097215e-35, /* logil[234] */ 
  } , 
  { 
    1.04277038574218750000000000000000000000000000000000e+00,   /* r[235] */ 
    -4.18810038843394558116806081216054735705256462097168e-02, /* logih[235] */ 
    7.08767348853067953695390709296896788518980234122108e-19, /* logim[235] */ 
    5.81746887353045891576525685995993541223272544408687e-36, /* logil[235] */ 
  } , 
  { 
    1.04065132141113281250000000000000000000000000000000e+00,   /* r[236] */ 
    -3.98467877153236421650106535707891453057527542114258e-02, /* logih[236] */ 
    2.90303379363907111194760685579166515046306452777543e-18, /* logim[236] */ 
    -1.87179669992551157656392090580258428294705323369769e-34, /* logil[236] */ 
  } , 
  { 
    1.03853988647460937500000000000000000000000000000000e+00,   /* r[237] */ 
    -3.78157713717320251300968436680705053731799125671387e-02, /* logih[237] */ 
    1.31557218113972830753744753624727966873659341218890e-19, /* logim[237] */ 
    3.06309949074642996410908941009119700992862883848855e-36, /* logil[237] */ 
  } , 
  { 
    1.03643798828125000000000000000000000000000000000000e+00,   /* r[238] */ 
    -3.57898231070667913189531361695117084309458732604980e-02, /* logih[238] */ 
    2.61901199505080724827733891681136430570574020973310e-18, /* logim[238] */ 
    -1.03901456915381040350545966439681190782130708435783e-34, /* logil[238] */ 
  } , 
  { 
    1.03434371948242187500000000000000000000000000000000e+00,   /* r[239] */ 
    -3.37671381422615726752844977909262524917721748352051e-02, /* logih[239] */ 
    5.67782765535494174549017056202204751471356116304136e-19, /* logim[239] */ 
    2.53528355791248032893098939659784274260892498065275e-35, /* logil[239] */ 
  } , 
  { 
    1.03225898742675781250000000000000000000000000000000e+00,   /* r[240] */ 
    -3.17495923838522486892799179258872754871845245361328e-02, /* logih[240] */ 
    -3.27645416513913885099937157154221271265660318847254e-18, /* logim[240] */ 
    8.28856608327529296008590058532581223963810647767730e-35, /* logil[240] */ 
  } , 
  { 
    1.03018188476562500000000000000000000000000000000000e+00,   /* r[241] */ 
    -2.97353738029609328263891399046769947744905948638916e-02, /* logih[241] */ 
    -1.42123656023807324094007557899495837832764341820361e-18, /* logim[241] */ 
    6.91675602259020207318590223540920124856020443401708e-35, /* logil[241] */ 
  } , 
  { 
    1.02811241149902343750000000000000000000000000000000e+00,   /* r[242] */ 
    -2.77245107619511835239656249996187398210167884826660e-02, /* logih[242] */ 
    1.56537436220084983093655029081028016172956628311065e-18, /* logim[242] */ 
    -4.26959324792631463690822650182944301609062827136870e-35, /* logil[242] */ 
  } , 
  { 
    1.02605247497558593750000000000000000000000000000000e+00,   /* r[243] */ 
    -2.57188906410827818060926830412427079863846302032471e-02, /* logih[243] */ 
    -4.32555496623632207496744723792774270215720987145012e-19, /* logim[243] */ 
    1.52055580639983796045911400446456477822011205599594e-35, /* logil[243] */ 
  } , 
  { 
    1.02400016784667968750000000000000000000000000000000e+00,   /* r[244] */ 
    -2.37166905300757423213919850013553514145314693450928e-02, /* logih[244] */ 
    1.57595637918687487090746306283132097902404584964498e-18, /* logim[244] */ 
    9.74151980884630209236553635927232431547283770922398e-36, /* logil[244] */ 
  } , 
  { 
    1.02195549011230468750000000000000000000000000000000e+00,   /* r[245] */ 
    -2.17179390838950908682036811114812735468149185180664e-02, /* logih[245] */ 
    1.51145445644716133590266967637567408648790588957093e-19, /* logim[245] */ 
    -6.02620888867536172611371375475252817876600211415641e-36, /* logil[245] */ 
  } , 
  { 
    1.01992034912109375000000000000000000000000000000000e+00,   /* r[246] */ 
    -1.97245351501005340699723689112943247891962528228760e-02, /* logih[246] */ 
    1.34458916305708123412045028332259969564528051018263e-18, /* logim[246] */ 
    -6.02768376061644464555810636396264987280148524662430e-35, /* logil[246] */ 
  } , 
  { 
    1.01789283752441406250000000000000000000000000000000e+00,   /* r[247] */ 
    -1.77346449295557526126820846457121660932898521423340e-02, /* logih[247] */ 
    7.79495017362897286873974720552694669993891890935313e-19, /* logim[247] */ 
    1.36178679065204639598156495958075391845124350978061e-35, /* logil[247] */ 
  } , 
  { 
    1.01587295532226562500000000000000000000000000000000e+00,   /* r[248] */ 
    -1.57482973634926158579272481574662378989160060882568e-02, /* logih[248] */ 
    -1.00208727697080412925749596659626020152032796409604e-18, /* logim[248] */ 
    7.75790823155383991507800579878754988160969197338737e-35, /* logil[248] */ 
  } , 
  { 
    1.01386070251464843750000000000000000000000000000000e+00,   /* r[249] */ 
    -1.37655214863766119093302364717601449228823184967041e-02, /* logih[249] */ 
    -5.48983179446608237058051237183129839336112673134214e-19, /* logim[249] */ 
    -1.07124914949087525209371623912638443397942890041101e-35, /* logil[249] */ 
  } , 
  { 
    1.01185798645019531250000000000000000000000000000000e+00,   /* r[250] */ 
    -1.17882314234863290469679242278289166279137134552002e-02, /* logih[250] */ 
    -2.27798661830469484283633290231243375517062716277910e-19, /* logim[250] */ 
    -1.39810745565350762832359759144648110107303965002540e-35, /* logil[250] */ 
  } , 
  { 
    1.00986099243164062500000000000000000000000000000000e+00,   /* r[251] */ 
    -9.81269012531632393858682661402781377546489238739014e-03, /* logih[251] */ 
    -6.97507609288120398034926564017756235032809786202962e-19, /* logim[251] */ 
    -4.77223430605379546730200636004016887477665718525716e-35, /* logil[251] */ 
  } , 
  { 
    1.00787353515625000000000000000000000000000000000000e+00,   /* r[252] */ 
    -7.84270062375400263399161104871382121928036212921143e-03, /* logih[252] */ 
    -2.40330730071604899669779379793438954457155324844264e-19, /* logim[252] */ 
    1.77453639459760487861944622725812265877091856705197e-36, /* logil[252] */ 
  } , 
  { 
    1.00589370727539062500000000000000000000000000000000e+00,   /* r[253] */ 
    -5.87640732328869111467106733925902517512440681457520e-03, /* logih[253] */ 
    -4.48574348377346892833940286850982368331573394791167e-20, /* logim[253] */ 
    -1.60289170664661311448886936584931944274496990139304e-36, /* logil[253] */ 
  } , 
  { 
    1.00392150878906250000000000000000000000000000000000e+00,   /* r[254] */ 
    -3.91383971648977691676352108629544090945273637771606e-03, /* logih[254] */ 
    -4.28019276224719221462393891683495367484578724177817e-19, /* logim[254] */ 
    -2.25272542183557712010826889962617244762256960750126e-35, /* logil[254] */ 
  } , 
  { 
    1.00195693969726562500000000000000000000000000000000e+00,   /* r[255] */ 
    -1.95502738522272592053274919976502133067697286605835e-03, /* logih[255] */ 
    4.23091354502479132756026938785685564809899588018682e-20, /* logim[255] */ 
    2.38479717170645227429169885358660522796868401607905e-36, /* logil[255] */ 
  } }; 
 
