/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_SOFTWAREIDENTITYRESOURCE_H_
#define OPENDRIM_SOFTWAREIDENTITYRESOURCE_H_

#include <Instance.h>

const static char* OpenDRIM_SoftwareIdentityResource_classnames[] = {"OpenDRIM_SoftwareIdentityResource"};
static string OpenDRIM_SoftwareIdentityResource_NAMESPACE = _NAMESPACE;

class OpenDRIM_SoftwareIdentityResource {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string InstallDate;
	bool InstallDate_isNULL;
	
	vector<unsigned short> OperationalStatus;
	bool OperationalStatus_isNULL;
	
	vector<string> StatusDescriptions;
	bool StatusDescriptions_isNULL;
	
	string Status;
	bool Status_isNULL;
	
	unsigned short HealthState;
	bool HealthState_isNULL;
	
	unsigned short PrimaryStatus;
	bool PrimaryStatus_isNULL;
	
	unsigned short DetailedStatus;
	bool DetailedStatus_isNULL;
	
	unsigned short OperatingStatus;
	bool OperatingStatus_isNULL;
	
	unsigned short CommunicationStatus;
	bool CommunicationStatus_isNULL;
	
	unsigned short EnabledState;
	bool EnabledState_isNULL;
	
	string OtherEnabledState;
	bool OtherEnabledState_isNULL;
	
	unsigned short RequestedState;
	bool RequestedState_isNULL;
	
	unsigned short EnabledDefault;
	bool EnabledDefault_isNULL;
	
	string TimeOfLastStateChange;
	bool TimeOfLastStateChange_isNULL;
	
	vector<unsigned short> AvailableRequestedStates;
	bool AvailableRequestedStates_isNULL;
	
	unsigned short TransitioningToState;
	bool TransitioningToState_isNULL;
	
	string SystemCreationClassName;
	bool SystemCreationClassName_isNULL;
	
	string SystemName;
	bool SystemName_isNULL;
	
	string CreationClassName;
	bool CreationClassName_isNULL;
	
	string Name;
	bool Name_isNULL;
	
	string AccessInfo;
	bool AccessInfo_isNULL;
	
	string OtherInfoFormatDescription;
	bool OtherInfoFormatDescription_isNULL;
	
	unsigned short AccessContext;
	bool AccessContext_isNULL;
	
	string OtherAccessContext;
	bool OtherAccessContext_isNULL;
	
	unsigned short InfoFormat;
	bool InfoFormat_isNULL;
	
	unsigned short ResourceType;
	bool ResourceType_isNULL;
	
	unsigned short ExtendedResourceType;
	bool ExtendedResourceType_isNULL;
	
	string OtherResourceType;
	bool OtherResourceType_isNULL;
	
	OpenDRIM_SoftwareIdentityResource() {
		Caption_isNULL = true;
		Description_isNULL = true;
		ElementName_isNULL = true;
		InstallDate_isNULL = true;
		OperationalStatus_isNULL = true;
		StatusDescriptions_isNULL = true;
		Status_isNULL = true;
		HealthState_isNULL = true;
		PrimaryStatus_isNULL = true;
		DetailedStatus_isNULL = true;
		OperatingStatus_isNULL = true;
		CommunicationStatus_isNULL = true;
		EnabledState_isNULL = true;
		OtherEnabledState_isNULL = true;
		RequestedState_isNULL = true;
		EnabledDefault_isNULL = true;
		TimeOfLastStateChange_isNULL = true;
		AvailableRequestedStates_isNULL = true;
		TransitioningToState_isNULL = true;
		SystemCreationClassName_isNULL = true;
		SystemName_isNULL = true;
		CreationClassName_isNULL = true;
		Name_isNULL = true;
		AccessInfo_isNULL = true;
		OtherInfoFormatDescription_isNULL = true;
		AccessContext_isNULL = true;
		OtherAccessContext_isNULL = true;
		InfoFormat_isNULL = true;
		ResourceType_isNULL = true;
		ExtendedResourceType_isNULL = true;
		OtherResourceType_isNULL = true;
	}
	
	~OpenDRIM_SoftwareIdentityResource() {}
	
	string getKeys() const {
		return CF_toLowCase(".SystemCreationClassName=\"" + CF_quoteString(SystemCreationClassName) + "\""".SystemName=\"" + CF_quoteString(SystemName) + "\""".CreationClassName=\"" + CF_quoteString(CreationClassName) + "\""".Name=\"" + CF_quoteString(Name) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getInstallDate(string& value) const {
		if (InstallDate_isNULL==true)
			return NOT_FOUND;
		value = InstallDate;
		return OK;
	}
	
	int setInstallDate(const string& newValue) {
		InstallDate = newValue;
		InstallDate_isNULL = false;
		return OK;
	}

	int getOperationalStatus(vector<unsigned short>& value) const {
		if (OperationalStatus_isNULL==true)
			return NOT_FOUND;
		value = OperationalStatus;
		return OK;
	}
	
	int setOperationalStatus(const vector<unsigned short>& newValue) {
		OperationalStatus = newValue;
		OperationalStatus_isNULL = false;
		return OK;
	}

	int getStatusDescriptions(vector<string>& value) const {
		if (StatusDescriptions_isNULL==true)
			return NOT_FOUND;
		value = StatusDescriptions;
		return OK;
	}
	
	int setStatusDescriptions(const vector<string>& newValue) {
		StatusDescriptions = newValue;
		StatusDescriptions_isNULL = false;
		return OK;
	}

	int getStatus(string& value) const {
		if (Status_isNULL==true)
			return NOT_FOUND;
		value = Status;
		return OK;
	}
	
	int setStatus(const string& newValue) {
		Status = newValue;
		Status_isNULL = false;
		return OK;
	}

	int getHealthState(unsigned short& value) const {
		if (HealthState_isNULL==true)
			return NOT_FOUND;
		value = HealthState;
		return OK;
	}
	
	int setHealthState(const unsigned short& newValue) {
		HealthState = newValue;
		HealthState_isNULL = false;
		return OK;
	}

	int getPrimaryStatus(unsigned short& value) const {
		if (PrimaryStatus_isNULL==true)
			return NOT_FOUND;
		value = PrimaryStatus;
		return OK;
	}
	
	int setPrimaryStatus(const unsigned short& newValue) {
		PrimaryStatus = newValue;
		PrimaryStatus_isNULL = false;
		return OK;
	}

	int getDetailedStatus(unsigned short& value) const {
		if (DetailedStatus_isNULL==true)
			return NOT_FOUND;
		value = DetailedStatus;
		return OK;
	}
	
	int setDetailedStatus(const unsigned short& newValue) {
		DetailedStatus = newValue;
		DetailedStatus_isNULL = false;
		return OK;
	}

	int getOperatingStatus(unsigned short& value) const {
		if (OperatingStatus_isNULL==true)
			return NOT_FOUND;
		value = OperatingStatus;
		return OK;
	}
	
	int setOperatingStatus(const unsigned short& newValue) {
		OperatingStatus = newValue;
		OperatingStatus_isNULL = false;
		return OK;
	}

	int getCommunicationStatus(unsigned short& value) const {
		if (CommunicationStatus_isNULL==true)
			return NOT_FOUND;
		value = CommunicationStatus;
		return OK;
	}
	
	int setCommunicationStatus(const unsigned short& newValue) {
		CommunicationStatus = newValue;
		CommunicationStatus_isNULL = false;
		return OK;
	}

	int getEnabledState(unsigned short& value) const {
		if (EnabledState_isNULL==true)
			return NOT_FOUND;
		value = EnabledState;
		return OK;
	}
	
	int setEnabledState(const unsigned short& newValue) {
		EnabledState = newValue;
		EnabledState_isNULL = false;
		return OK;
	}

	int getOtherEnabledState(string& value) const {
		if (OtherEnabledState_isNULL==true)
			return NOT_FOUND;
		value = OtherEnabledState;
		return OK;
	}
	
	int setOtherEnabledState(const string& newValue) {
		OtherEnabledState = newValue;
		OtherEnabledState_isNULL = false;
		return OK;
	}

	int getRequestedState(unsigned short& value) const {
		if (RequestedState_isNULL==true)
			return NOT_FOUND;
		value = RequestedState;
		return OK;
	}
	
	int setRequestedState(const unsigned short& newValue) {
		RequestedState = newValue;
		RequestedState_isNULL = false;
		return OK;
	}

	int getEnabledDefault(unsigned short& value) const {
		if (EnabledDefault_isNULL==true)
			return NOT_FOUND;
		value = EnabledDefault;
		return OK;
	}
	
	int setEnabledDefault(const unsigned short& newValue) {
		EnabledDefault = newValue;
		EnabledDefault_isNULL = false;
		return OK;
	}

	int getTimeOfLastStateChange(string& value) const {
		if (TimeOfLastStateChange_isNULL==true)
			return NOT_FOUND;
		value = TimeOfLastStateChange;
		return OK;
	}
	
	int setTimeOfLastStateChange(const string& newValue) {
		TimeOfLastStateChange = newValue;
		TimeOfLastStateChange_isNULL = false;
		return OK;
	}

	int getAvailableRequestedStates(vector<unsigned short>& value) const {
		if (AvailableRequestedStates_isNULL==true)
			return NOT_FOUND;
		value = AvailableRequestedStates;
		return OK;
	}
	
	int setAvailableRequestedStates(const vector<unsigned short>& newValue) {
		AvailableRequestedStates = newValue;
		AvailableRequestedStates_isNULL = false;
		return OK;
	}

	int getTransitioningToState(unsigned short& value) const {
		if (TransitioningToState_isNULL==true)
			return NOT_FOUND;
		value = TransitioningToState;
		return OK;
	}
	
	int setTransitioningToState(const unsigned short& newValue) {
		TransitioningToState = newValue;
		TransitioningToState_isNULL = false;
		return OK;
	}

	int getSystemCreationClassName(string& value) const {
		if (SystemCreationClassName_isNULL==true)
			return NOT_FOUND;
		value = SystemCreationClassName;
		return OK;
	}
	
	int setSystemCreationClassName(const string& newValue) {
		SystemCreationClassName = newValue;
		SystemCreationClassName_isNULL = false;
		return OK;
	}

	int getSystemName(string& value) const {
		if (SystemName_isNULL==true)
			return NOT_FOUND;
		value = SystemName;
		return OK;
	}
	
	int setSystemName(const string& newValue) {
		SystemName = newValue;
		SystemName_isNULL = false;
		return OK;
	}

	int getCreationClassName(string& value) const {
		if (CreationClassName_isNULL==true)
			return NOT_FOUND;
		value = CreationClassName;
		return OK;
	}
	
	int setCreationClassName(const string& newValue) {
		CreationClassName = newValue;
		CreationClassName_isNULL = false;
		return OK;
	}

	int getName(string& value) const {
		if (Name_isNULL==true)
			return NOT_FOUND;
		value = Name;
		return OK;
	}
	
	int setName(const string& newValue) {
		Name = newValue;
		Name_isNULL = false;
		return OK;
	}

	int getAccessInfo(string& value) const {
		if (AccessInfo_isNULL==true)
			return NOT_FOUND;
		value = AccessInfo;
		return OK;
	}
	
	int setAccessInfo(const string& newValue) {
		AccessInfo = newValue;
		AccessInfo_isNULL = false;
		return OK;
	}

	int getOtherInfoFormatDescription(string& value) const {
		if (OtherInfoFormatDescription_isNULL==true)
			return NOT_FOUND;
		value = OtherInfoFormatDescription;
		return OK;
	}
	
	int setOtherInfoFormatDescription(const string& newValue) {
		OtherInfoFormatDescription = newValue;
		OtherInfoFormatDescription_isNULL = false;
		return OK;
	}

	int getAccessContext(unsigned short& value) const {
		if (AccessContext_isNULL==true)
			return NOT_FOUND;
		value = AccessContext;
		return OK;
	}
	
	int setAccessContext(const unsigned short& newValue) {
		AccessContext = newValue;
		AccessContext_isNULL = false;
		return OK;
	}

	int getOtherAccessContext(string& value) const {
		if (OtherAccessContext_isNULL==true)
			return NOT_FOUND;
		value = OtherAccessContext;
		return OK;
	}
	
	int setOtherAccessContext(const string& newValue) {
		OtherAccessContext = newValue;
		OtherAccessContext_isNULL = false;
		return OK;
	}

	int getInfoFormat(unsigned short& value) const {
		if (InfoFormat_isNULL==true)
			return NOT_FOUND;
		value = InfoFormat;
		return OK;
	}
	
	int setInfoFormat(const unsigned short& newValue) {
		InfoFormat = newValue;
		InfoFormat_isNULL = false;
		return OK;
	}

	int getResourceType(unsigned short& value) const {
		if (ResourceType_isNULL==true)
			return NOT_FOUND;
		value = ResourceType;
		return OK;
	}
	
	int setResourceType(const unsigned short& newValue) {
		ResourceType = newValue;
		ResourceType_isNULL = false;
		return OK;
	}

	int getExtendedResourceType(unsigned short& value) const {
		if (ExtendedResourceType_isNULL==true)
			return NOT_FOUND;
		value = ExtendedResourceType;
		return OK;
	}
	
	int setExtendedResourceType(const unsigned short& newValue) {
		ExtendedResourceType = newValue;
		ExtendedResourceType_isNULL = false;
		return OK;
	}

	int getOtherResourceType(string& value) const {
		if (OtherResourceType_isNULL==true)
			return NOT_FOUND;
		value = OtherResourceType;
		return OK;
	}
	
	int setOtherResourceType(const string& newValue) {
		OtherResourceType = newValue;
		OtherResourceType_isNULL = false;
		return OK;
	}

};

class OpenDRIM_SoftwareIdentityResource_RequestStateChange_In {

public:

	unsigned short RequestedState;
	bool RequestedState_isNULL;

	Objectpath Job;
	bool Job_isNULL;

	string TimeoutPeriod;
	bool TimeoutPeriod_isNULL;

	OpenDRIM_SoftwareIdentityResource_RequestStateChange_In() {
		RequestedState_isNULL = true;
		Job_isNULL = true;
		TimeoutPeriod_isNULL = true;
	}

	~OpenDRIM_SoftwareIdentityResource_RequestStateChange_In() {}

	int getRequestedState(unsigned short& value) const {
		if (RequestedState_isNULL == true)
			return NOT_FOUND;
		value = RequestedState;
		return OK;
	}
	int setRequestedState(const unsigned short&  newValue) {
		RequestedState = newValue;
		RequestedState_isNULL = false;
		return OK;
	}

	int getJob(Objectpath& value) const {
		if (Job_isNULL == true)
			return NOT_FOUND;
		value = Job;
		return OK;
	}
	int setJob(const Objectpath&  newValue) {
		Job = newValue;
		Job_isNULL = false;
		return OK;
	}

	int getTimeoutPeriod(string& value) const {
		if (TimeoutPeriod_isNULL == true)
			return NOT_FOUND;
		value = TimeoutPeriod;
		return OK;
	}
	int setTimeoutPeriod(const string&  newValue) {
		TimeoutPeriod = newValue;
		TimeoutPeriod_isNULL = false;
		return OK;
	}

};

class OpenDRIM_SoftwareIdentityResource_RequestStateChange_Out {

public:

	Objectpath Job;
	bool Job_isNULL;

	OpenDRIM_SoftwareIdentityResource_RequestStateChange_Out() {
		Job_isNULL = true;
	}

	~OpenDRIM_SoftwareIdentityResource_RequestStateChange_Out() {}

	int getJob(Objectpath& value) const {
		if (Job_isNULL == true)
			return NOT_FOUND;
		value = Job;
		return OK;
	}
	int setJob(const Objectpath&  newValue) {
		Job = newValue;
		Job_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_SOFTWAREIDENTITYRESOURCE_H_*/
