"""
Example:
Concider the LCP problem w = Mz + q
    M = array([
        [0.42956806, -0.40076658, -0.02880148, -0.42956806, 0.40076658, 0.02880148],
        [-0.40076658, 0.47288367, -0.07211709, 0.40076658, -0.47288367, 0.07211709],
        [-0.02880148, -0.07211709, 0.10091857, 0.02880148, 0.07211709, -0.10091857],
        [-0.42956806, 0.40076658, 0.02880148, 0.42956806, -0.40076658, -0.02880148],
        [ 0.40076658, -0.47288367, 0.07211709, -0.40076658, 0.47288367, -0.07211709],
        [ 0.02880148, 0.07211709, -0.10091857, -0.02880148, -0.07211709, 0.10091857]])

    q = array([1.09389333, -0.53851907, -0.05537426, -0.79389333, 0.83851907, 0.35537426])

"""
from numpy import *
from openopt import LCP

M = array([
    [0.42956806, -0.40076658, -0.02880148, -0.42956806, 0.40076658, 0.02880148],
    [-0.40076658, 0.47288367, -0.07211709, 0.40076658, -0.47288367, 0.07211709],
    [-0.02880148, -0.07211709, 0.10091857, 0.02880148, 0.07211709, -0.10091857],
    [-0.42956806, 0.40076658, 0.02880148, 0.42956806, -0.40076658, -0.02880148],
    [ 0.40076658, -0.47288367, 0.07211709, -0.40076658, 0.47288367, -0.07211709],
    [ 0.02880148, 0.07211709, -0.10091857, -0.02880148, -0.07211709, 0.10091857]])
q = array([1.09389333, -0.53851907, -0.05537426, -0.79389333, 0.83851907, 0.35537426])
    

p = LCP(M, q)
r = p.solve('lcpsolve')
f_opt, x_opt = r.ff, r.xf
w, z = x_opt[x_opt.size/2:], x_opt[:x_opt.size/2]
print('w: %s   z: %s' % (w, z))
# w: [ 0.          0.          0.02167615  1.84666668  0.          0.        ]   z: [ 0.3  0.2  0.   0.   0.1  0.3]
