%feature("docstring") OT::DomainComplement
"Complement of a Domain.

A point is inside this domain if it is not contained in domain
passed as argument.

Parameters
----------
domain : :class:`~openturns.Domain`

Examples
--------
>>> import openturns as ot
>>> interval = (ot.Interval([1], [2], [False], [True]))
>>> complement = ot.DomainComplement(interval)
>>> [5] in complement
True
>>> [1.5] in complement
False"

// ---------------------------------------------------------------------

%feature("docstring") OT::DomainComplement::contains
"Check if the given point is inside of the complement of the domain.

Parameters
----------
point : sequence of float
    Point with the same dimension as the current domain's dimension.

Returns
-------
isInside : bool
    Flag telling whether the point is inside the complement of the
    domain."

