%define OT_Graph_doc
"Class Graph containing drawable elements and a graphical context.

Available constructors:
    Graph(*title*)

    Graph(*title, xTitle, yTitle, showAxes, legendPosition*)

Parameters
----------
title : str
    Title of the graph.
xTitle : str
    Legend of the X axe.
yTitle : str
    Legend of the Y axe.
showAxes : bool
    *True* to draw the axes. *False* to hide them.
legendPosition : str, optional
    Indication of the legend's position. If *legendPosition* is not specified,
    the Graph has no legend. The valid strings are given by the
    :meth:`GetValidLegendPositions` method.
"
%enddef
%feature("docstring") OT::GraphImplementation
OT_Graph_doc

// ---------------------------------------------------------------------

%define OT_Graph_getDrawables_doc
"Accessor to the Drawables included in the Graph.

Returns
-------
drawables : list of :class:`~openturns.Drawable`
    Drawables included in the Graph."
%enddef
%feature("docstring") OT::GraphImplementation::getDrawables
OT_Graph_getDrawables_doc

// ---------------------------------------------------------------------

%define OT_Graph_setDrawables_doc
"Accessor to the Drawables included in the Graph.

Parameters
----------
drawables : list of :class:`~openturns.Drawable`
    Drawables included in the Graph.
	
Notes
-----
Drawables that do not have an explicitly set color will be assigned the
default palette color corresponding to their rank in the graph."
%enddef
%feature("docstring") OT::GraphImplementation::setDrawables
OT_Graph_setDrawables_doc

// ---------------------------------------------------------------------

%define OT_Graph_getDrawable_doc
"Accessor to a Drawable included in the Graph.

Parameters
----------
index : positive int
    Position of the Drawable.

Returns
-------
drawable : :class:`~openturns.Drawable`
    Drawable included in the Graph at the index."
%enddef
%feature("docstring") OT::GraphImplementation::getDrawable
OT_Graph_getDrawable_doc

// ---------------------------------------------------------------------

%define OT_Graph_setDrawable_doc
"Accessor to a Drawable included in the Graph.

Parameters
----------
index : int
    Position of the Drawable.
drawable : :class:`~openturns.Drawable`
    Drawable included in the Graph.
	
Notes
-----
If the drawable does not have an explicitly set color, it will be assigned
the default palette color corresponding to its rank in the graph."
%enddef
%feature("docstring") OT::GraphImplementation::setDrawable
OT_Graph_setDrawable_doc

// ---------------------------------------------------------------------

%define OT_Graph_getColors_doc
"Accessor to the colors of the Drawables included in the Graph.

Returns
-------
listColors : :class:`~openturns.Description`
    List of all the colors used for the Drawables contained inside the graph."
%enddef
%feature("docstring") OT::GraphImplementation::getColors
OT_Graph_getColors_doc

// ---------------------------------------------------------------------

%define OT_Graph_setColors_doc
"Update the colors of the Drawables inside the Graph.

Parameters
----------
listColors : sequence of str
    List of the colors used for each Drawable of the Graph.
    If the *listColors*'s size is lower than the number of Drawables, the
    first colors of *listColors* are re-used. If it is greated than
    the number of Drawables, the last colors of the list are ignored.

    The *listColors* argument can be the result of the static method
    :meth:`~openturns.Drawable.BuildDefaultPalette` 
    or :meth:`~openturns.Drawable.BuildTableauPalette` of the Drawable object."
%enddef
%feature("docstring") OT::GraphImplementation::setColors
OT_Graph_setColors_doc

// ---------------------------------------------------------------------

%define OT_Graph_setDefaultColors_doc
"Assign colors to a default palette to all the drawables of the Graph.

Notes
-----
This method ensures that drawables of the Graph have different colors."
%enddef
%feature("docstring") OT::GraphImplementation::setDefaultColors
OT_Graph_setDefaultColors_doc

// ---------------------------------------------------------------------

%define OT_Graph_getLegends_doc
"Accessor to the legends of the Drawables inside the Graph.

Returns
-------
legends : :class:`~openturns.Description`
    Legends used for the drawables contained inside the Graph."
%enddef
%feature("docstring") OT::GraphImplementation::getLegends
OT_Graph_getLegends_doc

// ---------------------------------------------------------------------

%define OT_Graph_setLegends_doc
"Accessor to the legends of the Drawables inside the Graph.

Parameters
----------
legends : sequence of str
    Legends used for the drawables contained inside the Graph."
%enddef
%feature("docstring") OT::GraphImplementation::setLegends
OT_Graph_setLegends_doc

// ---------------------------------------------------------------------

%define OT_Graph_getLegendFontSize_doc
"Accessor to the legends' font size of the Drawables inside the Graph.

Returns
-------
fontSize : float
    Legends' font size used for the drawables contained inside the Graph.

See Also
--------
setLegendFontSize"
%enddef
%feature("docstring") OT::GraphImplementation::getLegendFontSize
OT_Graph_getLegendFontSize_doc

// ---------------------------------------------------------------------

%define OT_Graph_setLegendFontSize_doc
"Accessor to the legend's font size of the Drawables inside the Graph.

Parameters
----------
fontSize : float
    Legend's font size used for the drawables contained inside the Graph.

Examples
--------
>>> import openturns as ot
>>> # Create an empty graph
>>> graph = ot.Graph('Some curves', 'x1', 'x2', True, 'upper right')
>>> graph.setLegendFontSize(15.0)
>>> print(graph.getLegendFontSize())
15.0"
%enddef
%feature("docstring") OT::GraphImplementation::setLegendFontSize
OT_Graph_setLegendFontSize_doc

// ---------------------------------------------------------------------

%define OT_Graph_getLegendPosition_doc
"Accessor to the legend's position of the Drawables inside the Graph.

Returns
-------
position : str
    Legend's position used for the drawables contained inside the Graph.

See Also
--------
setLegendPosition, GetValidLegendPositions"
%enddef
%feature("docstring") OT::GraphImplementation::getLegendPosition
OT_Graph_getLegendPosition_doc

// ---------------------------------------------------------------------

%define OT_Graph_setLegendPosition_doc
"Accessor to the legend's position of the Drawables inside the Graph.

Parameters
----------
position : str
    Legend's position used for the drawables contained inside the Graph.
    The valid positions are given by the method :meth:`GetValidLegendPositions`.

Examples
--------
>>> import openturns as ot
>>> position = 'upper right'
>>> # Create an empty graph
>>> graph = ot.Graph('Some curves', 'x1', 'x2', True, position)
>>> graph.setLegendPosition('lower left')
>>> print(graph.getLegendPosition())
lower left"
%enddef
%feature("docstring") OT::GraphImplementation::setLegendPosition
OT_Graph_setLegendPosition_doc

// ---------------------------------------------------------------------

%define OT_Graph_GetValidLegendPositions_doc
"Accessor to the list of valid legend positions.

Returns
-------
listPositions : :class:`~openturns.Description`
    All the valid legend positions.

Examples
--------
>>> import openturns as ot
>>> print(ot.Graph.GetValidLegendPositions())
[,best,upper right,upper left,lower right,lower left,center right,..."
%enddef
%feature("docstring") OT::GraphImplementation::GetValidLegendPositions
OT_Graph_GetValidLegendPositions_doc

// ---------------------------------------------------------------------

%define OT_Graph_IsValidLegendPosition_doc
"Test if the proposed legend position is valid or not.

Parameters
----------
position : str
    Proposed legend position of the Drawables inside the Graph.

Returns
-------
validity : bool
    *True* if the proposed legend position is valid, *False* if it is not.

See Also
--------
setLegendPosition, GetValidLegendPositions

Examples
--------
>>> import openturns as ot
>>> print(ot.Graph.IsValidLegendPosition('lefttop'))
False
>>> print(ot.Graph.IsValidLegendPosition('upper left'))
True"
%enddef
%feature("docstring") OT::GraphImplementation::IsValidLegendPosition
OT_Graph_IsValidLegendPosition_doc

// ---------------------------------------------------------------------

%define OT_Graph_setLegendCorner_doc
"Accessor to the legend's corner.

Parameters
----------
corner : sequence of float
    Relative coordinates (in [0,1]x[0,1]) of the legend in the graph bounding box.
    The position of the legend relatively to this point will depend on the orientation
    given by the :meth:`getLegendPosition` value.

Examples
--------
>>> import openturns as ot
>>> position = 'upper left'  # the legend's upper left corner with be set below
>>> graph = ot.Graph('Some curves', 'x1', 'x2', True, position)
>>> graph.setLegendCorner([1.0, 1.0])  # legend will begin in top right corner

Notes
-----
This enables the legend to be located outside the graph.
"
%enddef
%feature("docstring") OT::GraphImplementation::setLegendCorner
OT_Graph_setLegendCorner_doc

// ---------------------------------------------------------------------

%define OT_Graph_getLegendCorner_doc
"Accessor to the legend's corner.

Returns
-------
corner : :class:`~openturns.Point`
    Relative coordinates (in [0,1]x[0,1]) of the legend in the graph bounding box.
    The position of the legend relatively to this point will depend on the orientation
    given by the :meth:`getLegendPosition` value.
"
%enddef
%feature("docstring") OT::GraphImplementation::getLegendCorner
OT_Graph_getLegendCorner_doc

// ---------------------------------------------------------------------

%define OT_Graph_getAxes_doc
"Accessor to the indication of axes' presence on the Graph.

Returns
-------
axes : bool
    *True* if the axes are drawn, *False* if they are hidden."
%enddef
%feature("docstring") OT::GraphImplementation::getAxes
OT_Graph_getAxes_doc

// ---------------------------------------------------------------------

%define OT_Graph_setAxes_doc
"Accessor to the indication of axes' presence on the Graph.

Parameters
----------
axes : bool
    *True* to draw the axes, *False* to hide the axes."
%enddef
%feature("docstring") OT::GraphImplementation::setAxes
OT_Graph_setAxes_doc

// ---------------------------------------------------------------------

%define OT_Graph_setTickLocation_doc
"Accessor to the ticks location flag.

Parameters
----------
loc : int
    Indicates the ticks location:

    - ot.GraphImplementation.TICKNONE: no ticks,

    - ot.GraphImplementation.TICKX: horizontal ticks,

    - ot.GraphImplementation.TICKY: vertical ticks,

    - ot.GraphImplementation.TICKXY: horizontal and vertical ticks."
%enddef
%feature("docstring") OT::GraphImplementation::setTickLocation
OT_Graph_setTickLocation_doc

// ---------------------------------------------------------------------

%define OT_Graph_getTickLocation_doc
"Accessor to the ticks location flag.

Returns
-------
loc : int
    Indicates the ticks location."
%enddef
%feature("docstring") OT::GraphImplementation::getTickLocation
OT_Graph_getTickLocation_doc

// ---------------------------------------------------------------------

%define OT_Graph_setIntegerXTick_doc
"Accessor to the integer x-axis ticks flag.

Parameters
----------
integerXTick : bool
    Whether to draw only integer ticks on the x-axis."
%enddef
%feature("docstring") OT::GraphImplementation::setIntegerXTick
OT_Graph_setIntegerXTick_doc

// ---------------------------------------------------------------------

%define OT_Graph_getIntegerXTick_doc
"Accessor to the integer x-axis ticks flag.

Returns
-------
integerXTick : bool
    Whether to draw only integer ticks on the x-axis."
%enddef
%feature("docstring") OT::GraphImplementation::getIntegerXTick
OT_Graph_getIntegerXTick_doc

// ---------------------------------------------------------------------

%define OT_Graph_setIntegerYTick_doc
"Accessor to the integer y-axis ticks flag.

Parameters
----------
integerYTick : bool
    Whether to draw only integer ticks on the y-axis."
%enddef
%feature("docstring") OT::GraphImplementation::setIntegerYTick
OT_Graph_setIntegerYTick_doc

// ---------------------------------------------------------------------

%define OT_Graph_getIntegerYTick_doc
"Accessor to the integer y-axis ticks flag.

Returns
-------
integerYTick : bool
    Whether to draw only integer ticks on the y-axis."
%enddef
%feature("docstring") OT::GraphImplementation::getIntegerYTick
OT_Graph_getIntegerYTick_doc

// ---------------------------------------------------------------------

%define OT_Graph_getLogScale_doc
"Accessor to the indication of axes' scale of the Graph.

Returns
-------
scale : int
    Indicates the type of the axes's scale:

    - 0: no log scale is used,

    - 1: log scale is used only for horizontal data,

    - 2: log scale is used only for vertical data,

    - 3: log scale is used for both data."
%enddef
%feature("docstring") OT::GraphImplementation::getLogScale
OT_Graph_getLogScale_doc

// ---------------------------------------------------------------------

%define OT_Graph_setLogScale_doc
"Accessor to the indication of axes' scale of the Graph.

Parameters
----------
scale : int
    Indicates the type of the axes's scale:

    - ot.GraphImplementation.NONE or 0: no log scale is used,

    - ot.GraphImplementation.LOGX or 1: log scale is used only for horizontal data,

    - ot.GraphImplementation.LOGY or 2: log scale is used only for vertical data,

    - ot.GraphImplementation.LOGXY or 3: log scale is used for both data."
%enddef
%feature("docstring") OT::GraphImplementation::setLogScale
OT_Graph_setLogScale_doc

// ---------------------------------------------------------------------

%define OT_Graph_getXTitle_doc
"Accessor to the title of the X axe.

Returns
-------
Xtitle : str
    Title of the X axe."
%enddef
%feature("docstring") OT::GraphImplementation::getXTitle
OT_Graph_getXTitle_doc

// ---------------------------------------------------------------------

%define OT_Graph_setXTitle_doc
"Accessor to the title of the X axe.

Parameters
----------
Xtitle : str
    Title of the X axe."
%enddef
%feature("docstring") OT::GraphImplementation::setXTitle
OT_Graph_setXTitle_doc

// ---------------------------------------------------------------------

%define OT_Graph_getYTitle_doc
"Accessor to the title of the Y axe.

Returns
-------
Ytitle : str
    Title of the Y axe."
%enddef
%feature("docstring") OT::GraphImplementation::getYTitle
OT_Graph_getYTitle_doc

// ---------------------------------------------------------------------

%define OT_Graph_setYTitle_doc
"Accessor to the title of the Y axe.

Parameters
----------
Ytitle : str
    Title of the Y axe."
%enddef
%feature("docstring") OT::GraphImplementation::setYTitle
OT_Graph_setYTitle_doc

// ---------------------------------------------------------------------

%define OT_Graph_getTitle_doc
"Accessor to the title of the Graph.

Returns
-------
title : str
    Title of the Graph."
%enddef
%feature("docstring") OT::GraphImplementation::getTitle
OT_Graph_getTitle_doc

// ---------------------------------------------------------------------

%define OT_Graph_setTitle_doc
"Accessor to the title of the Graph.

Parameters
----------
title : str
    Title of the Graph."
%enddef
%feature("docstring") OT::GraphImplementation::setTitle
OT_Graph_setTitle_doc

// ---------------------------------------------------------------------

%define OT_Graph_getName_doc
"Accessor to the name of the Graph.

Returns
-------
name : str
    Name of the Graph."
%enddef
%feature("docstring") OT::GraphImplementation::getName
OT_Graph_getName_doc

// ---------------------------------------------------------------------

%define OT_Graph_setName_doc
"Accessor to the name of the Graph.

Parameters
----------
name : str
    Name of the Graph."
%enddef
%feature("docstring") OT::GraphImplementation::setName
OT_Graph_setName_doc

// ---------------------------------------------------------------------

%define OT_Graph_getGrid_doc
"Accessor to the indication of grid's presence on the Graph.

Returns
-------
showGrid : bool
    *True* to show the grid of the Graph, *False* to hide it.
    By default there is a gray grid."
%enddef
%feature("docstring") OT::GraphImplementation::getGrid
OT_Graph_getGrid_doc

// ---------------------------------------------------------------------

%define OT_Graph_setGrid_doc
"Hide or shows grid of the Graph.

Parameters
----------
showGrid : bool
    *True* to show the grid of the Graph, *False* to hide it."
%enddef
%feature("docstring") OT::GraphImplementation::setGrid
OT_Graph_setGrid_doc

// ---------------------------------------------------------------------

%define OT_Graph_getGridColor_doc
"Accessor to the indication of grid's color on the Graph.

Returns
-------
gridColor : str
    Color of the grid. By default the grid is gray."
%enddef
%feature("docstring") OT::GraphImplementation::getGridColor
OT_Graph_getGridColor_doc

// ---------------------------------------------------------------------

%define OT_Graph_setGridColor_doc
"Accessor to the indication of grid's color on the Graph.

Parameters
----------
gridColor : str
    Color of the grid. By default the grid is gray."
%enddef
%feature("docstring") OT::GraphImplementation::setGridColor
OT_Graph_setGridColor_doc

// ---------------------------------------------------------------------

%define OT_Graph_getFileName_doc
"Accessor to the name of the file containing the Graph.

Returns
-------
fileName : str
    Name of the file containing the Graph."
%enddef
%feature("docstring") OT::GraphImplementation::getFileName
OT_Graph_getFileName_doc

// ---------------------------------------------------------------------

%define OT_Graph_getPath_doc
"Accessor to the file path excluding the suffix.

Returns
-------
path : str
    Path of the file containing the Graph."
%enddef
%feature("docstring") OT::GraphImplementation::getPath
OT_Graph_getPath_doc

// ---------------------------------------------------------------------

%define OT_Graph_setXMargin_doc
"Accessor to the horizontal margin size.

Parameters
----------
xMargin : float
    Horizontal margin ratio, defaults to 5% of the range on each side.
    In log-scale, it is interpreted as a power of 10;
    setting a value of 1 means a margin of one decade on each side.
    Defaults to *Graph-DefaultHorizontalMargin* map value."
%enddef
%feature("docstring") OT::GraphImplementation::setXMargin
OT_Graph_setXMargin_doc

// ---------------------------------------------------------------------

%define OT_Graph_setYMargin_doc
"Accessor to the vertical margin size.

Parameters
----------
yMargin : float
    Vertical margin ratio, defaults to 5% of the range on each side.
    In log-scale, it is interpreted as a power of 10;
    setting a value of 1 means a margin of one decade on each side.
    Defaults to *Graph-DefaultVerticalMargin* map value."
%enddef
%feature("docstring") OT::GraphImplementation::setYMargin
OT_Graph_setYMargin_doc

// ---------------------------------------------------------------------

%define OT_Graph_getBoundingBox_doc
"Accessor to the bounding box of the whole plot.

Returns
-------
boundingBox : :class:`~openturns.Interval` of dimension 2
    Bounding box of the drawable element, which is a rectangle determined
    by its range along X and its range along Y.
    This methods adds x/y margins according to the margin attributes."
%enddef
%feature("docstring") OT::GraphImplementation::getBoundingBox
OT_Graph_getBoundingBox_doc

// ---------------------------------------------------------------------

%define OT_Graph_setBoundingBox_doc
"Accessor to the bounding box of the whole plot.

Parameters
----------
boundingBox : :class:`~openturns.Interval` of dimension 2
    Bounding box of the drawable element, which is a rectangle determined
    by its range along X and its range along Y."
%enddef
%feature("docstring") OT::GraphImplementation::setBoundingBox
OT_Graph_setBoundingBox_doc

// ---------------------------------------------------------------------

%define OT_Graph_getAutomaticBoundingBox_doc
"Accessor to the indication of automatic bounding box.

Returns
-------
autoBoundingBox : bool
    Indicates if the bounding box is automatically created or not.
    The bounding box of the drawable element is a rectangle determined
    by its range along X and its range along Y."
%enddef
%feature("docstring") OT::GraphImplementation::getAutomaticBoundingBox
OT_Graph_getAutomaticBoundingBox_doc

// ---------------------------------------------------------------------

%define OT_Graph_setAutomaticBoundingBox_doc
"Accessor to the indication of automatic bounding box.

Parameters
----------
autoBoundingBox : bool
    Indicates if the bounding box is automatically created or not.
    The bounding box of the drawable element is a rectangle determined
    by its range along X and its range along Y."
%enddef
%feature("docstring") OT::GraphImplementation::setAutomaticBoundingBox
OT_Graph_setAutomaticBoundingBox_doc

// ---------------------------------------------------------------------

%define OT_Graph_add_doc
"Add drawable instances to the collection of drawables contained in Graph.

Available usages:
    add(*drawables*)

    add(*aGraph*)

Parameters
----------
drawables : :class:`~openturns.Drawable` or list of :class:`~openturns.Drawable`
    Drawable to add in the Graph.
aGraph : :class:`~openturns.Graph`
    Graph to add in the Graph.

Notes
-----
It adds the new drawables or graph inside the first one, with their legend.
It keeps the graphical context of the first graph. Each drawable keeps
its graphical context.
Drawables that do not have an explicitly set color will be assigned the default
palette color corresponding to their rank in the graph.


.. warning::
    Different drawables might be colored the same..."
%enddef
%feature("docstring") OT::GraphImplementation::add
OT_Graph_add_doc

// ---------------------------------------------------------------------

%define OT_Graph_erase_doc
"Erase a drawable instance from the collection of drawables contained in Graph.

Parameters
----------
index : int
    Index of the drawable instance to erase from the collection of drawables
    contained in Graph."
%enddef
%feature("docstring") OT::GraphImplementation::erase
OT_Graph_erase_doc

