# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1157-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57304);
 script_cve_id("CVE-2006-3694", "CVE-2006-1931", "CVE-2006-3964");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1157-1 (ruby1.8)";
 script_name(name);

 desc = "The remote host is missing an update to ruby1.8
announced via advisory DSA 1157-1.

Several vulnerabilities have been discovered in the interpreter for the
Ruby language, which may lead to the bypass of security restrictions or
denial of service. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2006-1931

It was discovered that the use of blocking sockets can lead to denial
of service.

CVE-2006-3964

It was discovered that Ruby does not properly maintain safe levels
for aliasing, directory accesses and regular expressions, which might
lead to a bypass of security restrictions.

For the stable distribution (sarge) these problem have been fixed in
version 1.8.2-7sarge4.

For the stable distribution (sarge) these problem have been fixed in
version 1.8.4-3.

We recommend that you upgrade your Ruby packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201157-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1157-1 (ruby1.8)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"irb1.8", ver:"1.8.2-7sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"rdoc1.8", ver:"1.8.2-7sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ri1.8", ver:"1.8.2-7sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.8-elisp", ver:"1.8.2-7sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.8-examples", ver:"1.8.2-7sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libdbm-ruby1.8", ver:"1.8.2-7sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdbm-ruby1.8", ver:"1.8.2-7sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopenssl-ruby1.8", ver:"1.8.2-7sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libreadline-ruby1.8", ver:"1.8.2-7sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby1.8", ver:"1.8.2-7sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libruby1.8-dbg", ver:"1.8.2-7sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtcltk-ruby1.8", ver:"1.8.2-7sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.8", ver:"1.8.2-7sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ruby1.8-dev", ver:"1.8.2-7sarge4", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
