# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1983-1 (wireshark)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66805);
 script_cve_id("CVE-2009-4337", "CVE-2010-0304");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1983-1 (wireshark)");

 desc = "The remote host is missing an update to wireshark
announced via advisory DSA 1983-1.

Several remote vulnerabilities have been discovered in the Wireshark
network traffic analyzer, which may lead to the execution of arbitrary
code or denial of service. The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2009-4337

A NULL pointer dereference was found in the SMB/SMB2 dissectors.

CVE-2010-0304

Several buffer overflows were found in the LWRES dissector.

For the stable distribution (lenny), this problem has been fixed in
version 1.0.2-3+lenny8.

For the unstable distribution (sid) these problems have been fixed in
version 1.2.6-1.

We recommend that you upgrade your Wireshark packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201983-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1983-1 (wireshark)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"wireshark-dev", ver:"1.0.2-3+lenny8", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wireshark-common", ver:"1.0.2-3+lenny8", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"wireshark", ver:"1.0.2-3+lenny8", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tshark", ver:"1.0.2-3+lenny8", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
