# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-7337 (phpMyAdmin)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64348);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 9 FEDORA-2009-7337 (phpMyAdmin)";
 script_name(name);

 desc = "The remote host is missing an update to phpMyAdmin
announced via advisory FEDORA-2009-7337.

For details, on the issues addressed, please visit the
referenced security advisories.

ChangeLog:

* Tue Jun 30 2009 Robert Scheck  3.2.0.1-1
- Upstream released 3.2.0.1 (#508879)
* Tue Jun 30 2009 Robert Scheck  3.2.0-1
- Upstream released 3.2.0
* Fri May 15 2009 Robert Scheck  3.1.5-1
- Upstream released 3.1.5
* Sat Apr 25 2009 Robert Scheck  3.1.4-1
- Upstream released 3.1.4
* Tue Apr 14 2009 Robert Scheck  3.1.3.2-1
- Upstream released 3.1.3.2 (#495768)

References:

[ 1 ] Bug #508879 - phpMyAdmin: XSS: Insufficient output sanitizing in bookmarks (PMASA-2009-5)
https://bugzilla.redhat.com/show_bug.cgi?id=508879

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update phpMyAdmin' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-7337

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-7337 (phpMyAdmin)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"phpMyAdmin", rpm:"phpMyAdmin~3.2.0.1~1.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
