###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for licq FEDORA-2008-3909
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860958);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "FEDORA", value: "2008-3909");
  script_cve_id("CVE-2009-1996", "CVE-2008-1996");
  script_name( "Fedora Update for licq FEDORA-2008-3909");
  desc = "

  Vulnerability Insight:
  Licq is a ICQ Client for the common ICQ network. It provides a graphical
  user interface based on QT and is enhanceable with many powerful plugins.
  For more information visit Licq's Homepage <a  rel= &qt nofollow &qt  href= &qt http://www.licq.org &qt >http://www.licq.org</a>


  Affected Software/OS:
  licq on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-May/msg00255.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of licq");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"licq", rpm:"licq~1.3.4~8.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}