###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_maxthon_detect.nasl 4376 2009-09-07 21:53:29Z sep $
#
# Maxthon Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800895);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Maxthon Version Detection");
  desc = "
  Overview: This script detects the installed version of Maxthon Browser
  and sets the result in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set KB for the version of Maxthon Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion"))
{
  exit(0);
}

maxthon = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (make_list("Maxthon", "Maxthon2", "Maxthon3"))
{
  maxthonName = registry_get_sz(key:maxthon + item, item:"DisplayName");

  if("Maxthon" >< maxthonName)
  {
    maxthonVer = registry_get_sz(key:maxthon + item, item:"DisplayVersion");
    if(isnull(maxthonVer))
    {
      maxthonPath = registry_get_sz(key:maxthon + item, item:"DisplayIcon");
      if("Mx3Uninstall.exe" >< maxthonPath)
      maxthonPath = maxthonPath - "Mx3Uninstall.exe" + "Maxthon.exe";

      hare = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:maxthonPath);
      mfile = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:maxthonPath);
      maxthonVer = GetVer(file:mfile, share:share);
    }

    if(!isnull(maxthonVer))
    {
      set_kb_item(name:"Maxthon/Ver", value:maxthonVer);
      security_note(data:"Maxthon version " + maxthonVer + " was detected on the host");
    }
  }
}
