#!/usr/bin/env python
from vtkmodules.vtkCommonMath import vtkMatrix4x4
from vtkmodules.vtkCommonTransforms import (
    vtkIdentityTransform,
    vtkPerspectiveTransform,
    vtkTransform,
)
from vtkmodules.vtkFiltersCore import vtkAppendPolyData
from vtkmodules.vtkFiltersGeneral import vtkTransformPolyDataFilter
from vtkmodules.vtkFiltersSources import vtkPlaneSource
from vtkmodules.vtkRenderingCore import (
    vtkActor,
    vtkDataSetMapper,
    vtkRenderWindow,
    vtkRenderer,
)
import vtkmodules.vtkRenderingFreeType
import vtkmodules.vtkRenderingOpenGL2
from vtkmodules.util.misc import vtkGetDataRoot
VTK_DATA_ROOT = vtkGetDataRoot()

# create a rendering window
renWin = vtkRenderWindow()
renWin.SetMultiSamples(0)
renWin.SetSize(600,300)
# set up first set of polydata
p1 = vtkPlaneSource()
p1.SetOrigin(0.5,0.508,-0.5)
p1.SetPoint1(-0.5,0.508,-0.5)
p1.SetPoint2(0.5,0.508,0.5)
p1.SetXResolution(5)
p1.SetYResolution(5)
p1.Update()
p2 = vtkPlaneSource()
p2.SetOrigin(-0.508,0.5,-0.5)
p2.SetPoint1(-0.508,-0.5,-0.5)
p2.SetPoint2(-0.508,0.5,0.5)
p2.SetXResolution(5)
p2.SetYResolution(5)
p2.Update()
p3 = vtkPlaneSource()
p3.SetOrigin(-0.5,-0.508,-0.5)
p3.SetPoint1(0.5,-0.508,-0.5)
p3.SetPoint2(-0.5,-0.508,0.5)
p3.SetXResolution(5)
p3.SetYResolution(5)
p3.Update()
p4 = vtkPlaneSource()
p4.SetOrigin(0.508,-0.5,-0.5)
p4.SetPoint1(0.508,0.5,-0.5)
p4.SetPoint2(0.508,-0.5,0.5)
p4.SetXResolution(5)
p4.SetYResolution(5)
p4.Update()
p5 = vtkPlaneSource()
p5.SetOrigin(0.5,0.5,-0.508)
p5.SetPoint1(0.5,-0.5,-0.508)
p5.SetPoint2(-0.5,0.5,-0.508)
p5.SetXResolution(5)
p5.SetYResolution(5)
p5.Update()
p6 = vtkPlaneSource()
p6.SetOrigin(0.5,0.5,0.508)
p6.SetPoint1(-0.5,0.5,0.508)
p6.SetPoint2(0.5,-0.5,0.508)
p6.SetXResolution(5)
p6.SetYResolution(5)
p6.Update()
# append together
ap = vtkAppendPolyData()
ap.AddInputData(p1.GetOutput())
ap.AddInputData(p2.GetOutput())
ap.AddInputData(p3.GetOutput())
ap.AddInputData(p4.GetOutput())
ap.AddInputData(p5.GetOutput())
ap.AddInputData(p6.GetOutput())
#--------------------------
# identity transform
t1 = vtkIdentityTransform()
f11 = vtkTransformPolyDataFilter()
f11.SetInputConnection(ap.GetOutputPort())
f11.SetTransform(t1)
m11 = vtkDataSetMapper()
m11.SetInputConnection(f11.GetOutputPort())
a11 = vtkActor()
a11.SetMapper(m11)
a11.GetProperty().SetColor(1,0,0)
a11.GetProperty().SetRepresentationToWireframe()
ren11 = vtkRenderer()
ren11.SetViewport(0.0,0.5,0.25,1.0)
ren11.ResetCamera(-0.5,0.5,-0.5,0.5,-1,1)
ren11.AddActor(a11)
renWin.AddRenderer(ren11)
# inverse identity transform
f12 = vtkTransformPolyDataFilter()
f12.SetInputConnection(ap.GetOutputPort())
f12.SetTransform(t1.GetInverse())
m12 = vtkDataSetMapper()
m12.SetInputConnection(f12.GetOutputPort())
a12 = vtkActor()
a12.SetMapper(m12)
a12.GetProperty().SetColor(0.9,0.9,0)
a12.GetProperty().SetRepresentationToWireframe()
ren12 = vtkRenderer()
ren12.SetViewport(0.0,0.0,0.25,0.5)
ren12.ResetCamera(-0.5,0.5,-0.5,0.5,-1,1)
ren12.AddActor(a12)
renWin.AddRenderer(ren12)
#--------------------------
# linear transform
t2 = vtkTransform()
t2.RotateX(50)
t2.RotateY(30)
t2.Translate(0.2,0.1,-0.15)
f21 = vtkTransformPolyDataFilter()
f21.SetInputConnection(ap.GetOutputPort())
f21.SetTransform(t2)
m21 = vtkDataSetMapper()
m21.SetInputConnection(f21.GetOutputPort())
a21 = vtkActor()
a21.SetMapper(m21)
a21.GetProperty().SetColor(1,0,0)
a21.GetProperty().SetRepresentationToWireframe()
ren21 = vtkRenderer()
ren21.SetViewport(0.25,0.5,0.50,1.0)
ren21.ResetCamera(-0.5,0.5,-0.5,0.5,-1,1)
ren21.AddActor(a21)
renWin.AddRenderer(ren21)
# inverse linear transform
f22 = vtkTransformPolyDataFilter()
f22.SetInputConnection(ap.GetOutputPort())
f22.SetTransform(t2.GetInverse())
m22 = vtkDataSetMapper()
m22.SetInputConnection(f22.GetOutputPort())
a22 = vtkActor()
a22.SetMapper(m22)
a22.GetProperty().SetColor(0.9,0.9,0)
a22.GetProperty().SetRepresentationToWireframe()
ren22 = vtkRenderer()
ren22.SetViewport(0.25,0.0,0.50,0.5)
ren22.ResetCamera(-0.5,0.5,-0.5,0.5,-1,1)
ren22.AddActor(a22)
renWin.AddRenderer(ren22)
#--------------------------
# perspective transform
matrix = vtkMatrix4x4()
matrix.SetElement(3,0,0.1)
matrix.SetElement(3,1,0.2)
matrix.SetElement(3,2,0.5)
t3 = vtkPerspectiveTransform()
t3.SetMatrix(matrix)
f31 = vtkTransformPolyDataFilter()
f31.SetInputConnection(ap.GetOutputPort())
f31.SetTransform(t3)
m31 = vtkDataSetMapper()
m31.SetInputConnection(f31.GetOutputPort())
a31 = vtkActor()
a31.SetMapper(m31)
a31.GetProperty().SetColor(1,0,0)
a31.GetProperty().SetRepresentationToWireframe()
ren31 = vtkRenderer()
ren31.SetViewport(0.50,0.5,0.75,1.0)
ren31.ResetCamera(-0.5,0.5,-0.5,0.5,-1,1)
ren31.AddActor(a31)
renWin.AddRenderer(ren31)
# inverse linear transform
f32 = vtkTransformPolyDataFilter()
f32.SetInputConnection(ap.GetOutputPort())
f32.SetTransform(t3.GetInverse())
m32 = vtkDataSetMapper()
m32.SetInputConnection(f32.GetOutputPort())
a32 = vtkActor()
a32.SetMapper(m32)
a32.GetProperty().SetColor(0.9,0.9,0)
a32.GetProperty().SetRepresentationToWireframe()
ren32 = vtkRenderer()
ren32.SetViewport(0.5,0.0,0.75,0.5)
ren32.ResetCamera(-0.5,0.5,-0.5,0.5,-1,1)
ren32.AddActor(a32)
renWin.AddRenderer(ren32)
#--------------------------
# perspective transform concatenation
t4 = vtkPerspectiveTransform()
t4.Concatenate(t1)
t4.Concatenate(t2)
t4.Concatenate(t3)
f41 = vtkTransformPolyDataFilter()
f41.SetInputConnection(ap.GetOutputPort())
f41.SetTransform(t4)
m41 = vtkDataSetMapper()
m41.SetInputConnection(f41.GetOutputPort())
a41 = vtkActor()
a41.SetMapper(m41)
a41.GetProperty().SetColor(1,0,0)
a41.GetProperty().SetRepresentationToWireframe()
ren41 = vtkRenderer()
ren41.SetViewport(0.75,0.5,1.0,1.0)
ren41.ResetCamera(-0.5,0.5,-0.5,0.5,-1,1)
ren41.AddActor(a41)
renWin.AddRenderer(ren41)
# inverse linear transform
f42 = vtkTransformPolyDataFilter()
f42.SetInputConnection(ap.GetOutputPort())
f42.SetTransform(t4.GetInverse())
m42 = vtkDataSetMapper()
m42.SetInputConnection(f42.GetOutputPort())
a42 = vtkActor()
a42.SetMapper(m42)
a42.GetProperty().SetColor(0.9,0.9,0)
a42.GetProperty().SetRepresentationToWireframe()
ren42 = vtkRenderer()
ren42.SetViewport(0.75,0.0,1.0,0.5)
ren42.ResetCamera(-0.5,0.5,-0.5,0.5,-1,1)
ren42.AddActor(a42)
renWin.AddRenderer(ren42)
renWin.Render()
# --- end of script --
