############## mysql-test\t\max_binlog_cache_size_basic.test ###############
#                                                                             #
# Variable Name: max_binlog_cache_size                                        #
# Scope: GLOBAL                                                               #
# Access Type: Dynamic                                                        #
# Data Type: numeric                                                          #
# Default Value:4294967295                                                    #
# Range: 4096-4294967295                                                      #
#                                                                             #
#                                                                             #
#                                                                             #
#                                                                             #
#                                                                             #
# Creation Date: 2008-02-07                                                   #
# Author:  Salman                                                             #
#                                                                             #
# Description: Test Cases of Dynamic System Variable max_binlog_cache_size    #
#              that checks the behavior of this variable in the following ways#
#              * Default Value                                                #
#              * Valid & Invalid values                                       #
#              * Scope & Access method                                        #
#              * Data Integrity                                               #
#                                                                             #
# Reference: http://dev.mysql.com/doc/refman/5.1/en/                          #
#  server-system-variables.html                                               #
#                                                                             #
###############################################################################

--source include/load_sysvars.inc

######################################################################## 
#              START OF max_binlog_cache_size TESTS                    #
######################################################################## 


######################################################################## 
# Saving initial value of max_binlog_cache_size in a temporary variable#
######################################################################## 

SET @start_value = @@global.max_binlog_cache_size;
SELECT @start_value;


--echo '#--------------------FN_DYNVARS_072_01------------------------#'
######################################################################## 
#           Display the DEFAULT value of max_binlog_cache_size         #
######################################################################## 

SET @@global.max_binlog_cache_size = 5000;
SET @@global.max_binlog_cache_size = DEFAULT;
SELECT @@global.max_binlog_cache_size;


--echo '#---------------------FN_DYNVARS_072_02-------------------------#'
############################################### 
#     Verify default value of variable        #
############################################### 

SET @@global.max_binlog_cache_size = @start_value;
SELECT @@global.max_binlog_cache_size = 4294967295;
--echo 'Bug# 34876: Incorrect Default Value is assigned to variable';

--echo '#--------------------FN_DYNVARS_072_03------------------------#'
######################################################################## 
#    Change the value of max_binlog_cache_size to a valid value        #
######################################################################## 

SET @@global.max_binlog_cache_size = 4096;
SELECT @@global.max_binlog_cache_size;
SET @@global.max_binlog_cache_size = 4294967295;
SELECT @@global.max_binlog_cache_size;
SET @@global.max_binlog_cache_size = 4294967294;
SELECT @@global.max_binlog_cache_size;
SET @@global.max_binlog_cache_size = 4097;
SELECT @@global.max_binlog_cache_size;
SET @@global.max_binlog_cache_size = 65535;
SELECT @@global.max_binlog_cache_size;
--echo 'Bug# 34877: Invalid Values are coming in variable on assigning valid values';


--echo '#--------------------FN_DYNVARS_072_04-------------------------#'
########################################################################### 
#      Change the value of max_binlog_cache_size to invalid value         #
########################################################################### 

SET @@global.max_binlog_cache_size = -1;
SELECT @@global.max_binlog_cache_size;
SET @@global.max_binlog_cache_size = 100000000000;
SELECT @@global.max_binlog_cache_size;
--Error ER_WRONG_TYPE_FOR_VAR
SET @@global.max_binlog_cache_size = 10000.01;
SELECT @@global.max_binlog_cache_size;
SET @@global.max_binlog_cache_size = -1024;
SELECT @@global.max_binlog_cache_size;
SET @@global.max_binlog_cache_size = 1024;
SELECT @@global.max_binlog_cache_size;
SET @@global.max_binlog_cache_size = 4294967296;
SELECT @@global.max_binlog_cache_size;
SET @@global.max_binlog_cache_size = 4095;
SELECT @@global.max_binlog_cache_size;

--echo 'Bug # 34837: Errors are not coming on assigning invalid values to variable';

--Error ER_WRONG_TYPE_FOR_VAR
SET @@global.max_binlog_cache_size = ON;
SELECT @@global.max_binlog_cache_size;
--Error ER_WRONG_TYPE_FOR_VAR
SET @@global.max_binlog_cache_size = 'test';
SELECT @@global.max_binlog_cache_size;


--echo '#-------------------FN_DYNVARS_072_05----------------------------#'
########################################################################### 
#       Test if accessing session max_binlog_cache_size gives error       #
########################################################################### 

--Error ER_GLOBAL_VARIABLE
SET @@session.max_binlog_cache_size = 4096;
--Error ER_INCORRECT_GLOBAL_LOCAL_VAR
SELECT @@session.max_binlog_cache_size;


--echo '#----------------------FN_DYNVARS_072_06------------------------#'
############################################################################## 
# Check if the value in GLOBAL & SESSION Tables matches values in variable   #
##############################################################################

SELECT @@global.max_binlog_cache_size = VARIABLE_VALUE 
FROM INFORMATION_SCHEMA.GLOBAL_VARIABLES 
WHERE VARIABLE_NAME='max_binlog_cache_size';

SELECT @@max_binlog_cache_size = VARIABLE_VALUE 
FROM INFORMATION_SCHEMA.SESSION_VARIABLES 
WHERE VARIABLE_NAME='max_binlog_cache_size';


--echo '#---------------------FN_DYNVARS_072_07----------------------#'
################################################################### 
#      Check if TRUE and FALSE values can be used on variable     #
################################################################### 

SET @@global.max_binlog_cache_size = TRUE;
SELECT @@global.max_binlog_cache_size;
SET @@global.max_binlog_cache_size = FALSE;
SELECT @@global.max_binlog_cache_size;


--echo '#---------------------FN_DYNVARS_072_08----------------------#'
########################################################################################################
#    Check if accessing variable with SESSION,LOCAL and without SCOPE points to same session variable  #
########################################################################################################

SET @@global.max_binlog_cache_size = 5000;
SELECT @@max_binlog_cache_size = @@global.max_binlog_cache_size;


--echo '#---------------------FN_DYNVARS_072_09----------------------#'
################################################################################  
#   Check if max_binlog_cache_size can be accessed with and without @@ sign    #
################################################################################

--Error ER_GLOBAL_VARIABLE
SET max_binlog_cache_size = 6000;
SELECT @@max_binlog_cache_size;
--Error ER_PARSE_ERROR
SET local.max_binlog_cache_size = 7000;
--Error ER_UNKNOWN_TABLE
SELECT local.max_binlog_cache_size;
--Error ER_PARSE_ERROR
SET global.max_binlog_cache_size = 8000;
--Error ER_UNKNOWN_TABLE
SELECT global.max_binlog_cache_size;
--Error ER_BAD_FIELD_ERROR
SELECT max_binlog_cache_size = @@session.max_binlog_cache_size;


##############################  
#   Restore initial value    #
##############################

SET @@global.max_binlog_cache_size = @start_value;
SELECT @@global.max_binlog_cache_size;


######################################################################## 
#              END OF max_binlog_cache_size TESTS                      #
######################################################################## 
