<?php
/**
*
* common [French]
*
* @package language
* @version $Id$
* @copyright (c) 2005 phpBB Group, (c) Maël Soucaze
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> '<a href="https://www.phpbb.com/customise/db/translation/french/">Traduction française officielle</a> &copy; <a href="https://www.maelsoucaze.com/">Maël Soucaze</a>',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|d F Y|',	// 01 January 2007 (with Relative days enabled)
	'USER_LANG'			=> 'fr',

	'1_DAY'			=> '1 jour',
	'1_MONTH'		=> '1 mois',
	'1_YEAR'		=> '1 an',
	'2_WEEKS'		=> '2 semaines',
	'3_MONTHS'		=> '3 mois',
	'6_MONTHS'		=> '6 mois',
	'7_DAYS'		=> '7 jours',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Votre compte a déjà été activé.',
	'ACCOUNT_DEACTIVATED'			=> 'Votre compte a été désactivé manuellement et ne peut être réactivé que par un administrateur.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'Votre compte n’a pas encore été activé.',
	'ACP'							=> 'Panneau de contrôle d’administration',
	'ACTIVE'						=> 'actif',
	'ACTIVE_ERROR'					=> 'Le nom d’utilisateur que vous avez spécifié est actuellement inactif. Si vous rencontrez des difficultés lors de l’activation de votre compte, veuillez contacter un administrateur du forum.',
	'ADMINISTRATOR'					=> 'Administrateur',
	'ADMINISTRATORS'				=> 'Administrateurs',
	'AGE'							=> 'Âge',
	'AIM'							=> 'AIM',
	'ALLOWED'						=> 'Autorisé',
	'ALL_FILES'						=> 'Tous les fichiers',
	'ALL_FORUMS'					=> 'Tous les forums',
	'ALL_MESSAGES'					=> 'Tous les messages privés',
	'ALL_POSTS'						=> 'Tous les messages',
	'ALL_TIMES'						=> 'Le fuseau horaire est réglé sur %1$s %2$s',
	'ALL_TOPICS'					=> 'Tous les sujets',
	'AND'							=> 'et',
	'ARE_WATCHING_FORUM'			=> 'Vous êtes à présent abonné(e) à ce forum. Vous recevrez une notification lorsqu’un nouveau sujet sera publié dans ce dernier.',
	'ARE_WATCHING_TOPIC'			=> 'Vous êtes à présent abonné(e) à ce sujet. Vous recevrez une notification lorsqu’un nouveau message sera publié dans ce dernier.',
	'ASCENDING'						=> 'Croissant',
	'ATTACHMENTS'					=> 'Pièces jointes',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'L’image que vous avez essayé d’insérer est incorrecte.',
	'AUTHOR'						=> 'Auteur',
	'AUTH_NO_PROFILE_CREATED'		=> 'La création du profil d’utilisateur a échoué.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'Le transfert a été interrompu car le fichier que vous avez souhaité transférer a été identifié comme une vulnérabilité potentielle.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Ce fichier ne peut pas être affiché car l’extension <strong>%s</strong> n’est pas autorisée.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'L’avatar que vous avez spécifié n’a pas pu être transféré car les données distantes semblent corrompues ou incorrectes.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'L’avatar que vous avez transféré est vide.',
	'AVATAR_INVALID_FILENAME'		=> '%s est un nom de fichier incorrect.',
	'AVATAR_NOT_UPLOADED'			=> 'L’avatar ne peut pas être transféré.',
	'AVATAR_NO_SIZE'				=> 'La taille de l’avatar lié n’a pas pu être déterminée. Veuillez la saisir manuellement.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'Le fichier que vous avez spécifié n’a été que partiellement transféré.',
	'AVATAR_PHP_SIZE_NA'			=> 'La taille de l’avatar est trop importante.<br />La taille maximale autorisée, située dans le fichier php.ini, n’a pas pu être déterminée.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'La taille de l’avatar est trop importante. La taille maximale autorisée est de %1$d %2$s.<br />Veuillez noter que ce réglage est situé dans le fichier php.ini et qu’il ne peut pas être écrasé.',
	'AVATAR_REMOTE_UPLOAD_TIMEOUT'		=> 'L’avatar que vous avez spécifié n’a pu être transféré car la requête a expiré.',
	'AVATAR_URL_INVALID'			=> 'Le lien que vous avez spécifié est incorrect.',
	'AVATAR_URL_NOT_FOUND'			=> 'Le fichier que vous avez spécifié est introuvable.',
	'AVATAR_WRONG_FILESIZE'			=> 'La taille de l’avatar doit être comprise entre 0 et %1$d %2$s.',
	'AVATAR_WRONG_SIZE'				=> 'La taille de l’avatar que vous avez transféré mesure %5$d pixels de large et %6$d pixels de haut. Cependant, la taille des avatars doit mesurer entre %1$d pixels de large et %2$d pixels de haut, mais ne doit pas dépasser %3$d pixels de large et %4$d pixels de haut.',

	'BACK_TO_TOP'			=> 'Haut',
	'BACK_TO_PREV'			=> 'Revenir à la page précédente',
	'BAN_TRIGGERED_BY_EMAIL'=> 'Votre adresse de courrier électronique a été bannie.',
	'BAN_TRIGGERED_BY_IP'	=> 'Votre adresse IP a été bannie.',
	'BAN_TRIGGERED_BY_USER'	=> 'Votre nom d’utilisateur a été banni.',
	'BBCODE_GUIDE'			=> 'Guide du BBCode',
	'BCC'					=> 'Cci',
	'BIRTHDAYS'				=> 'Anniversaires',
	'BOARD_BAN_PERM'		=> 'Vous avez été <strong>définitivement</strong> banni(e) de ce forum.<br /><br />Pour plus d’informations, veuillez contacter l’%2$sadministrateur du forum%3$s.',
	'BOARD_BAN_REASON'		=> 'Raison du bannissement : <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'Vous avez été banni(e) de ce forum jusqu’au <strong>%1$s</strong>.<br /><br />Pour plus d’informations, veuillez contacter l’%2$sadministrateur du forum%3$s.',
	'BOARD_DISABLE'			=> 'Le forum est actuellement indisponible.',
	'BOARD_DISABLED'		=> 'Le forum est actuellement désactivé.',
	'BOARD_UNAVAILABLE'		=> 'Le forum est actuellement indisponible. Veuillez réessayer ultérieurement.',
	'BROWSING_FORUM'		=> 'Utilisateurs parcourant ce forum : %1$s',
	'BROWSING_FORUM_GUEST'	=> 'Utilisateurs parcourant ce forum : %1$s et %2$d invité',
	'BROWSING_FORUM_GUESTS'	=> 'Utilisateurs parcourant ce forum : %1$s et %2$d invités',
	'BYTES'					=> 'octets',

	'CANCEL'				=> 'Annuler',
	'CHANGE'				=> 'Modifier',
	'CHANGE_FONT_SIZE'		=> 'Modifier la taille de la police de caractères',
	'CHANGING_PREFERENCES'	=> 'Modifie les préférences du forum',
	'CHANGING_PROFILE'		=> 'Modifie les réglages du profil',
	'CLICK_VIEW_PRIVMSG'	=> '%sConsulter votre boîte de réception%s',
	'COLLAPSE_VIEW'			=> 'Réduire',
	'CLOSE_WINDOW'			=> 'Fermer la fenêtre',
	'COLOUR_SWATCH'			=> 'Palette de couleurs',
	'COMMA_SEPARATOR'		=> ', ',	// Comma used to join lists into a single string, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Confirmer',
	'CONFIRM_CODE'			=> 'Code de confirmation',
	'CONFIRM_CODE_EXPLAIN'	=> 'Veuillez saisir le code tel qu’il apparaît dans l’image. Toutes les lettres sont insensibles à la casse.',
	'CONFIRM_CODE_WRONG'	=> 'Le code de confirmation que vous avez spécifié est incorrect.',
	'CONFIRM_OPERATION'		=> 'Êtes-vous sûr(e) de vouloir effectuer cette opération ?',
	'CONGRATULATIONS'		=> 'Félicitations à',
	'CONNECTION_FAILED'		=> 'La connexion a échoué.',
	'CONNECTION_SUCCESS'	=> 'Vous êtes à présent connecté(e) !',
	'COOKIES_DELETED'		=> 'Tous les cookies du forum ont été supprimés.',
	'CURRENT_TIME'			=> 'Nous sommes actuellement le %s',

	'DAY'					=> 'Jour',
	'DAYS'					=> 'Jours',
	'DELETE'				=> 'Supprimer',
	'DELETE_ALL'			=> 'Tout supprimer',
	'DELETE_COOKIES'		=> 'Supprimer tous les cookies du forum',
	'DELETE_MARKED'			=> 'Supprimer la sélection',
	'DELETE_POST'			=> 'Supprimer le message',
	'DELIMITER'				=> 'Séparateur',
	'DESCENDING'			=> 'Décroissant',
	'DISABLED'				=> 'Désactivé',
	'DISPLAY'				=> 'Afficher',
	'DISPLAY_GUESTS'		=> 'Afficher les invités',
	'DISPLAY_MESSAGES'		=> 'Afficher les messages privés publiés depuis',
	'DISPLAY_POSTS'			=> 'Afficher les messages publiés depuis',
	'DISPLAY_TOPICS'		=> 'Afficher les sujets publiés depuis',
	'DOWNLOADED'			=> 'Téléchargé',
	'DOWNLOADING_FILE'		=> 'Téléchargement du fichier',
	'DOWNLOAD_COUNT'		=> 'Téléchargé %d fois',
	'DOWNLOAD_COUNTS'		=> 'Téléchargé %d fois',
	'DOWNLOAD_COUNT_NONE'	=> 'Aucun téléchargement',
	'VIEWED_COUNT'			=> 'Consulté %d fois',
	'VIEWED_COUNTS'			=> 'Consulté %d fois',
	'VIEWED_COUNT_NONE'		=> 'Aucune consultation',

	'EDIT_POST'							=> 'Éditer le message',
	'EMAIL'								=> 'Courrier électronique', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'Adresse de courrier électronique',
	'EMAIL_INVALID_EMAIL'				=> 'L’adresse de courrier électronique que vous avez spécifiée est incorrecte.',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Une erreur est survenue lors de l’envoi du courrier électronique à la <strong>ligne %1$s</strong>. Réponse : %2$s.',
	'EMPTY_SUBJECT'						=> 'Veuillez saisir le titre du nouveau sujet.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Veuillez saisir le titre du nouveau message privé.',
	'ENABLED'							=> 'Activé',
	'ENCLOSURE'							=> 'Pièce jointe',
	'ENTER_USERNAME'					=> 'Saisissez un nom d’utilisateur',
	'ERR_CHANGING_DIRECTORY'			=> 'Impossible de modifier le répertoire.',
	'ERR_CONNECTING_SERVER'				=> 'Une erreur est survenue lors de la connexion au serveur.',
	'ERR_JAB_AUTH'						=> 'Une erreur est survenue lors de l’authentification au serveur Jabber.',
	'ERR_JAB_CONNECT'					=> 'Une erreur est survenue lors de la connexion au serveur Jabber.',
	'ERR_UNABLE_TO_LOGIN'				=> 'Le nom d’utilisateur ou le mot de passe que vous avez spécifié est incorrect.',
	'ERR_UNWATCHING'					=> 'Une erreur est survenue lors du désabonnement.',
	'ERR_WATCHING'						=> 'Une erreur est survenue lors de l’abonnement.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'Le chemin que vous avez spécifié semble incorrect.',
	'EXPAND_VIEW'						=> 'Agrandir',
	'EXTENSION'							=> 'Extension',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'L’extension <strong>%s</strong> a été désactivée et ne peut plus être affichée.',

	'FAQ'					=> 'FAQ',
	'FAQ_EXPLAIN'			=> 'Foire aux questions',
	'FILENAME'				=> 'Nom du fichier',
	'FILESIZE'				=> 'Taille du fichier',
	'FILEDATE'				=> 'Date du fichier',
	'FILE_COMMENT'			=> 'Description du fichier',
	'FILE_NOT_FOUND'		=> 'Le fichier que vous recherchez est introuvable.',
	'FIND_USERNAME'			=> 'Trouver un membre',
	'FOLDER'				=> 'Boîte',
	'FORGOT_PASS'			=> 'J’ai oublié mon mot de passe',
	'FORM_INVALID'			=> 'Le formulaire que vous avez envoyé est incorrect. Veuillez réessayer.',
	'FORUM'					=> 'Forum',
	'FORUMS'				=> 'Forums',
	'FORUMS_MARKED'			=> 'Les forums ont été marqués comme lus.',
	'FORUM_CAT'				=> 'Catégorie du forum',
	'FORUM_INDEX'			=> 'Accueil du forum',
	'FORUM_LINK'			=> 'Forum-lien',
	'FORUM_LOCATION'		=> 'Emplacement du forum',
	'FORUM_LOCKED'			=> 'Forum verrouillé',
	'FORUM_RULES'			=> 'Règles du forum',
	'FORUM_RULES_LINK'		=> 'Veuillez cliquer ici afin de consulter les règles du forum',
	'FROM'					=> 'de',
	'FSOCK_DISABLED'		=> 'L’opération a échoué car la fonction <var>fsockopen</var> a été désactivée ou le serveur interrogé est introuvable.',
	'FSOCK_TIMEOUT'			=> 'Le délai de réponse a expiré lors de la lecture du flux réseau.',

	'FTP_FSOCK_HOST'				=> 'Hôte FTP',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'Le serveur FTP qui est utilisé afin de vous connecter à votre site.',
	'FTP_FSOCK_PASSWORD'			=> 'Mot de passe FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Le mot de passe qui est affilié à votre nom d’utilisateur FTP.',
	'FTP_FSOCK_PORT'				=> 'Port FTP',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Le port qui est utilisé afin de vous connecter à votre serveur.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Chemin vers le forum',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Le chemin relatif à la racine de votre serveur.',
	'FTP_FSOCK_TIMEOUT'				=> 'Délai d’attente FTP',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'La durée de temps, en secondes, que le système attendra afin d’obtenir une réponse de votre serveur.',
	'FTP_FSOCK_USERNAME'			=> 'Nom d’utilisateur FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Le nom d’utilisateur qui est utilisé afin de vous connecter à votre serveur.',

	'FTP_HOST'					=> 'Hôte FTP',
	'FTP_HOST_EXPLAIN'			=> 'Le serveur FTP qui est utilisé afin de vous connecter à votre site.',
	'FTP_PASSWORD'				=> 'Mot de passe FTP',
	'FTP_PASSWORD_EXPLAIN'		=> 'Le mot de passe qui est affilié à votre nom d’utilisateur FTP.',
	'FTP_PORT'					=> 'Port FTP',
	'FTP_PORT_EXPLAIN'			=> 'Le port qui est utilisé afin de vous connecter à votre serveur.',
	'FTP_ROOT_PATH'				=> 'Chemin vers le forum',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Le chemin relatif à la racine de votre serveur.',
	'FTP_TIMEOUT'				=> 'Délai d’attente FTP',
	'FTP_TIMEOUT_EXPLAIN'		=> 'La durée de temps, en secondes, que le système attendra afin d’obtenir une réponse de votre serveur.',
	'FTP_USERNAME'				=> 'Nom d’utilisateur FTP',
	'FTP_USERNAME_EXPLAIN'		=> 'Le nom d’utilisateur qui est utilisé afin de vous connecter à votre serveur.',

	'GENERAL_ERROR'				=> 'Erreur générale',
	'GB'						=> 'Go',
	'GIB'						=> 'Gio',
	'GO'						=> 'Valider',
	'GOTO_PAGE'					=> 'Atteindre la page',
	'GROUP'						=> 'Groupe',
	'GROUPS'					=> 'Groupes',
	'GROUP_ERR_TYPE'			=> 'Le type de groupe que vous avez spécifié est incorrect.',
	'GROUP_ERR_USERNAME'		=> 'Aucun nom de groupe n’a été spécifié.',
	'GROUP_ERR_USER_LONG'		=> 'Le nom de groupe que vous avez spécifié est trop long. Les noms de groupe ne doivent pas dépasser 60 caractères.',
	'GUEST'						=> 'Invité',
	'GUEST_USERS_ONLINE'		=> 'Il y a %d invités en ligne',
	'GUEST_USERS_TOTAL'			=> '%d invités',
	'GUEST_USERS_ZERO_ONLINE'	=> 'Il y a 0 invité en ligne',
	'GUEST_USERS_ZERO_TOTAL'	=> '0 invité',
	'GUEST_USER_ONLINE'			=> 'Il y a %d invité en ligne',
	'GUEST_USER_TOTAL'			=> '%d invité',
	'G_ADMINISTRATORS'			=> 'Administrateurs',
	'G_BOTS'					=> 'Robots',
	'G_GUESTS'					=> 'Invités',
	'G_REGISTERED'				=> 'Utilisateurs inscrits',
	'G_REGISTERED_COPPA'		=> 'Utilisateurs COPPA inscrits',
	'G_GLOBAL_MODERATORS'		=> 'Modérateurs généraux',
	'G_NEWLY_REGISTERED'		=> 'Utilisateurs récemment inscrits',

	'HIDDEN_USERS_ONLINE'			=> '%d utilisateurs invisibles en ligne',
	'HIDDEN_USERS_TOTAL'			=> '%d invisibles',
	'HIDDEN_USERS_TOTAL_AND'		=> '%d invisibles et ',
	'HIDDEN_USERS_ZERO_ONLINE'		=> '0 utilisateur invisible en ligne',
	'HIDDEN_USERS_ZERO_TOTAL'		=> '0 invisible',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> '0 invisible et ',
	'HIDDEN_USER_ONLINE'			=> '%d utilisateur invisible en ligne',
	'HIDDEN_USER_TOTAL'				=> '%d invisible',
	'HIDDEN_USER_TOTAL_AND'			=> '%d invisible et ',
	'HIDE_GUESTS'					=> 'Masquer les invités',
	'HIDE_ME'						=> 'Masquer mon statut en ligne lors de cette session',
	'HOURS'							=> 'Heures',
	'HOME'							=> 'Accueil',

	'ICQ'						=> 'ICQ',
	'ICQ_STATUS'				=> 'Statut ICQ',
	'IF'						=> 'Si',
	'IMAGE'						=> 'Image',
	'IMAGE_FILETYPE_INVALID'	=> 'Le type de l’image %d du standard MIME %s n’est pas supporté.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Le type de l’image ne correspond pas. L’extension %1$s était attendue mais l’extension %2$s a été transférée.',
	'IN'						=> 'dans',
	'INDEX'						=> 'Page d’accueil',
	'INFORMATION'				=> 'Information',
	'INTERESTS'					=> 'Centres d’intérêt',
	'INVALID_DIGEST_CHALLENGE'	=> 'Le Digest Challenge est incorrect.',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> est-elle une adresse de courrier électronique potentiellement incorrecte ?',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'Votre adresse IP %1$s a été bloquée car elle est présente dans la liste noire. Pour plus d’informations, veuillez consulter <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Inscription',
	'JUMP_PAGE'				=> 'Saisissez le numéro de la page que vous souhaitez atteindre',
	'JUMP_TO'				=> 'Atteindre',
	'JUMP_TO_PAGE'			=> 'Cliquez ici afin d’atteindre une page…',

	'KB'					=> 'Ko',
	'KIB'					=> 'Kio',

	'LAST_POST'							=> 'Dernier message',
	'LAST_UPDATED'						=> 'Dernière mise à jour',
	'LAST_VISIT'						=> 'Dernière visite',
	'LDAP_NO_LDAP_EXTENSION'			=> 'L’extension LDAP est indisponible.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Impossible de se connecter au serveur LDAP.',
	'LDAP_SEARCH_FAILED'				=> 'Une erreur est survenue lors de la recherche du répertoire LDAP.',
	'LEGEND'							=> 'Légende',
	'LOCATION'							=> 'Localisation',
	'LOCK_POST'							=> 'Verrouiller le message',
	'LOCK_POST_EXPLAIN'					=> 'Ne pourra plus être édité',
	'LOCK_TOPIC'						=> 'Verrouiller le sujet',
	'LOGIN'								=> 'Connexion',
	'LOGIN_CHECK_PM'					=> 'Connectez-vous afin de consulter vos messages privés.',
	'LOGIN_CONFIRMATION'				=> 'Confirmation de connexion',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Afin d’empêcher tout acte malveillant, vous devez saisir un code de confirmation après avoir échoué un certain nombre de fois lors de vos tentatives de connexion. Le code est affiché dans l’image que vous devriez voir ci-dessous. Si vous êtes visuellement déficient(e) ou que vous éprouvez des difficultés à lire ce code correctement, veuillez contacter l’%sadministrateur du forum%s.', // Unused
	'LOGIN_ERROR_ATTEMPTS'				=> 'Vous avez dépassé le nombre maximal de tentatives de connexion autorisé. En plus de votre nom d’utilisateur et de votre mot de passe, vous devez à présent compléter le CAPTCHA que vous devriez voir ci-dessous.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Vous n’avez pas été authentifié(e) par Apache.',
	'LOGIN_ERROR_PASSWORD'				=> 'Vous avez spécifié un mot de passe incorrect. Veuillez vérifier votre mot de passe et réessayer. Si ce problème persiste, veuillez contacter l’%sadministrateur du forum%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Il n’a pas été possible de convertir votre mot de passe lors de la mise à jour de ce logiciel de forum de discussions. Veuillez %sdemander un nouveau mot de passe%s. Si ce problème persiste, veuillez contacter l’%sadministrateur du forum%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Vous avez spécifié un nom d’utilisateur incorrect. Veuillez vérifier votre nom d’utilisateur et réessayer. Si ce problème persiste, veuillez contacter l’%sadministrateur du forum%s.',
	'LOGIN_FORUM'						=> 'Vous devez saisir le mot de passe de ce forum afin de pouvoir consulter ou publier des sujets et des messages.',
	'LOGIN_INFO'						=> 'Vous devez être inscrit(e) avant de pouvoir vous connecter. L’inscription est rapide et vous offre de nombreux avantages. Par exemple, l’administrateur du forum peut accorder des fonctionnalités supplémentaires aux utilisateurs inscrits. Avant de vous inscrire, assurez-vous d’avoir pris connaissance de nos conditions d’utilisation et de notre politique de confidentialité. Veuillez également consulter attentivement toutes les règles du forum lors de votre navigation.',
	'LOGIN_VIEWFORUM'					=> 'Vous devez être inscrit(e) et connecté(e) afin de pouvoir consulter ce forum.',
	'LOGIN_EXPLAIN_EDIT'				=> 'Vous devez être inscrit(e) et connecté(e) afin de pouvoir éditer les messages de ce forum.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Vous devez être inscrit(e) et connecté(e) afin de pouvoir consulter la liste des utilisateurs en ligne.',
	'LOGOUT'							=> 'Déconnexion',
	'LOGOUT_USER'						=> 'Déconnexion [ %s ]',
	'LOG_ME_IN'							=> 'Se souvenir de moi',

	'MARK'					=> 'Cocher',
	'MARK_ALL'				=> 'Tout cocher',
	'MARK_FORUMS_READ'		=> 'Marquer les forums comme lus',
	'MARK_SUBFORUMS_READ'	=> 'Marquer les sous-forums comme lus',
	'MB'					=> 'Mo',
	'MIB'					=> 'Mio',
	'MCP'					=> 'Panneau de contrôle du modérateur',
	'MEMBERLIST'			=> 'Membres',
	'MEMBERLIST_EXPLAIN'	=> 'Consulter la liste complète des membres',
	'MERGE'					=> 'Fusionner',
	'MERGE_POSTS'			=> 'Déplacer les messages',
	'MERGE_TOPIC'			=> 'Fusionner le sujet',
	'MESSAGE'				=> 'Message',
	'MESSAGES'				=> 'Messages',
	'MESSAGE_BODY'			=> 'Corps du message',
	'MINUTES'				=> 'minutes',
	'MODERATE'				=> 'Modérer',
	'MODERATOR'				=> 'Modérateur',
	'MODERATORS'			=> 'Modérateurs',
	'MODULE_NOT_ACCESS'		=> 'Le module est inaccessible',
	'MODULE_NOT_FIND'		=> 'Le module %s est introuvable',
	'MODULE_FILE_INCORRECT_CLASS'	=> 'Le fichier du module %s ne contient pas la classe correcte [%s]',
	'MONTH'					=> 'Mois',
	'MOVE'					=> 'Déplacer',
	'MSNM'					=> 'MSNM/WLM',

	'NA'						=> 'N/A',
	'NEWEST_USER'				=> 'Notre membre le plus récent est <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Nouveau message',
	'NEW_MESSAGES'				=> 'Nouveaux messages',
	'NEW_PM'					=> '<strong>%d</strong> nouveau message',
	'NEW_PMS'					=> '<strong>%d</strong> nouveaux messages',
	'NEW_POST'					=> 'Nouveau message',	// Not used anymore
	'NEW_POSTS'					=> 'Nouveaux messages',	// Not used anymore
	'NEXT'						=> 'Suivant',		// Used in pagination
	'NEXT_STEP'					=> 'Suivant',
	'NEVER'						=> 'Jamais',
	'NO'						=> 'Non',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Vous ne pouvez pas gérer ce groupe.',
	'NOT_AUTHORISED'			=> 'Vous ne pouvez pas accéder à cette page.',
	'NOT_WATCHING_FORUM'		=> 'Vous n’êtes à présent plus abonné(e) à ce forum. Vous ne recevrez plus de notification lorsqu’un nouveau sujet sera publié dans ce dernier.',
	'NOT_WATCHING_TOPIC'		=> 'Vous n’êtes à présent plus abonné(e) à ce sujet. Vous ne recevrez plus de notification lorsqu’un nouveau message sera publié dans ce dernier.',
	'NOTIFY_ADMIN'				=> 'Veuillez contacter l’administrateur du forum.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Veuillez contacter l’administrateur du forum : <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'Vous ne pouvez pas accéder à ce fichier.',
	'NO_ACTION'					=> 'Aucune opération n’a été sélectionnée.',
	'NO_ADMINISTRATORS'			=> 'Il n’y a aucun administrateur.',
	'NO_AUTH_ADMIN'				=> 'Vous ne pouvez pas accéder au panneau de contrôle d’administration.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Vous ne pouvez pas vous authentifier de nouveau avec un compte d’utilisateur différent au vôtre.',
	'NO_AUTH_OPERATION'			=> 'Vous ne détenez pas les permissions appropriées afin d’effectuer cette opération.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Impossible de se connecter à l’hôte du protocole SMTP : %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'Aucun membre ne fête son anniversaire aujourd’hui.',
	'NO_EMAIL_MESSAGE'			=> 'Le contenu du message de ce courrier électronique était vide.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Impossible de récupérer les codes de réponse du serveur de messagerie électronique.',
	'NO_EMAIL_SUBJECT'			=> 'Vous devez saisir le sujet du courrier électronique.',
	'NO_FORUM'					=> 'Le forum que vous souhaitez consulter n’existe pas.',
	'NO_FORUMS'					=> 'Aucun forum.',
	'NO_GROUP'					=> 'Le groupe d’utilisateurs que vous souhaitez consulter n’existe pas.',
	'NO_GROUP_MEMBERS'			=> 'Ce groupe n’a actuellement aucun membre.',
	'NO_IPS_DEFINED'			=> 'Aucun nom d’hôte ou adresse IP n’a été spécifié.',
	'NO_MEMBERS'				=> 'Aucun membre ne correspond à ce critère.',
	'NO_MESSAGES'				=> 'Aucun message',
	'NO_MODE'					=> 'Aucun mode n’a été sélectionné.',
	'NO_MODERATORS'				=> 'Il n’y a aucun modérateur.',
	'NO_NEW_MESSAGES'			=> 'Aucun nouveau message',
	'NO_NEW_PM'					=> '<strong>0</strong> nouveau message',
	'NO_NEW_POSTS'				=> 'Aucun nouveau message',	// Not used anymore
	'NO_ONLINE_USERS'			=> 'Aucun utilisateur inscrit',
	'NO_POSTS'					=> 'Aucun message',
	'NO_POSTS_TIME_FRAME'		=> 'Aucun message n’a été publié dans ce sujet lors de cette période.',
	'NO_FEED_ENABLED'			=> 'Les flux ne sont pas disponibles sur ce forum.',
	'NO_FEED'					=> 'Le flux que vous recherchez n’est pas disponible.',
	'NO_STYLE_DATA'				=> 'Impossible d’accéder aux données du style',
	'NO_SUBJECT'				=> 'Aucun sujet n’a été spécifié',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'Le module de recherche que vous avez spécifié est introuvable.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Aucune méthode d’authentification n’est supportée.',
	'NO_TOPIC'					=> 'Le sujet que vous souhaitez consulter est introuvable.',
	'NO_TOPIC_FORUM'			=> 'Le forum ou le sujet que vous souhaitez consulter est introuvable.',
	'NO_TOPICS'					=> 'Aucun sujet n’a été publié dans ce forum.',
	'NO_TOPICS_TIME_FRAME'		=> 'Aucun sujet n’a été publié dans ce forum lors de cette période.',
	'NO_UNREAD_PM'				=> '<strong>0</strong> message non lu',
	'NO_UNREAD_POSTS'			=> 'Aucun message non lu',
	'NO_UPLOAD_FORM_FOUND'		=> 'Le transfert a commencé mais aucun formulaire de transfert de fichiers n’a été trouvé.',
	'NO_USER'					=> 'L’utilisateur que vous souhaitez consulter est introuvable.',
	'NO_USERS'					=> 'Les utilisateurs que vous souhaitez consulter sont introuvables.',
	'NO_USER_SPECIFIED'			=> 'Aucun nom d’utilisateur n’a été spécifié.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'Aucun message en attente',		// 0
		1			=> '1 message en attente',		// 1
		2			=> '%d messages en attente',		// 2+
	),

	'OCCUPATION'				=> 'Profession',
	'OFFLINE'					=> 'Hors-ligne',
	'ONLINE'					=> 'En ligne',
	'ONLINE_BUDDIES'			=> 'Amis en ligne',
	'ONLINE_USERS_TOTAL'		=> 'Au total, il y a <strong>%d</strong> utilisateurs en ligne :: ',
	'ONLINE_USERS_ZERO_TOTAL'	=> 'Au total, il y a <strong>0</strong> utilisateur en ligne :: ',
	'ONLINE_USER_TOTAL'			=> 'Au total, il y a <strong>%d</strong> utilisateur en ligne :: ',
	'OPTIONS'					=> 'Options',

	'PAGE_OF'				=> 'Page <strong>%1$d</strong> sur <strong>%2$d</strong>',
	'PASSWORD'				=> 'Mot de passe',
	'PIXEL'					=> 'px',
	'PLAY_QUICKTIME_FILE'	=> 'Lire la vidéo QuickTime',
	'PM'					=> 'MP',
	'PM_REPORTED'			=> 'Cliquez ici afin de consulter le rapport',
	'POSTING_MESSAGE'		=> 'Rédige un message dans %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'Rédige un message privé',
	'POST'					=> 'Message',
	'POST_ANNOUNCEMENT'		=> 'Annonce',
	'POST_STICKY'			=> 'Note',
	'POSTED'				=> 'Publié',
	'POSTED_IN_FORUM'		=> 'dans',
	'POSTED_ON_DATE'		=> 'le',
	'POSTS'					=> 'Messages',
	'POSTS_UNAPPROVED'		=> 'Au moins un message de ce sujet n’a pas été approuvé.',
	'POST_BY_AUTHOR'		=> 'par',
	'POST_BY_FOE'			=> '<strong>%1$s</strong>, qui est actuellement dans votre liste d’utilisateurs ignorés, a publié ce message. %2$sAfficher le message%3$s.',
	'POST_DAY'				=> '%.2f messages par jour',
	'POST_DETAILS'			=> 'Informations sur le message',
	'POST_NEW_TOPIC'		=> 'Publier un nouveau sujet',
	'POST_PCT'				=> '%.2f %% du nombre total de messages',
	'POST_PCT_ACTIVE'		=> '%.2f %% du nombre total de messages de l’utilisateur',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f %% de votre nombre total de messages',
	'POST_REPLY'			=> 'Publier une réponse',
	'POST_REPORTED'			=> 'Cliquez ici afin de consulter le rapport',
	'POST_SUBJECT'			=> 'Sujet du message',
	'POST_TIME'				=> 'Date du message',
	'POST_TOPIC'			=> 'Publier un nouveau sujet',
	'POST_UNAPPROVED'		=> 'Ce message n’a pas été approuvé.',
	'POWERED_BY'			=> 'Développé par %s',
	'PREVIEW'				=> 'Prévisualiser',
	'PREVIOUS'				=> 'Précédent',		// Used in pagination
	'PREVIOUS_STEP'			=> 'Précédent',
	'PRIVACY'				=> 'Politique de confidentialité',
	'PRIVATE_MESSAGE'		=> 'Message privé',
	'PRIVATE_MESSAGES'		=> 'Messages privés',
	'PRIVATE_MESSAGING'		=> 'Messagerie privée',
	'PROFILE'				=> 'Panneau de contrôle de l’utilisateur',

	'RANK'						=> 'Rang',
	'READING_FORUM'				=> 'Consulte des sujets dans %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Consulte une annonce générale',
	'READING_LINK'				=> 'Visite le forum-lien %s',
	'READING_TOPIC'				=> 'Consulte un sujet dans %s',
	'READ_PROFILE'				=> 'Profil',
	'REASON'					=> 'Raison',
	'RECORD_ONLINE_USERS'		=> 'Le nombre maximal d’utilisateurs en ligne simultanément a été de <strong>%1$s</strong> le %2$s',
	'REDIRECT'					=> 'Redirection',
	'REDIRECTS'					=> 'Nombre total de redirections',
	'REGISTER'					=> 'Inscription',
	'REGISTERED_USERS'			=> 'Utilisateurs inscrits :',
	'REG_USERS_ONLINE'			=> 'Il y a %d utilisateurs inscrits et ',
	'REG_USERS_TOTAL'			=> '%d inscrits, ',
	'REG_USERS_TOTAL_AND'		=> '%d inscrits et ',
	'REG_USERS_ZERO_ONLINE'		=> 'Il y a 0 utilisateur inscrit et ',
	'REG_USERS_ZERO_TOTAL'		=> '0 inscrit, ',
	'REG_USERS_ZERO_TOTAL_AND'	=> '0 inscrit et ',
	'REG_USER_ONLINE'			=> 'Il y a %d utilisateur inscrit et ',
	'REG_USER_TOTAL'			=> '%d inscrit, ',
	'REG_USER_TOTAL_AND'		=> '%d inscrit et ',
	'REMOVE'					=> 'Supprimer',
	'REMOVE_INSTALL'			=> 'Veuillez supprimer, déplacer ou renommer le répertoire « install » de votre serveur afin d’utiliser votre forum. Tant que ce répertoire est présent, seul le panneau de contrôle d’administration sera accessible.',
	'REPLIES'					=> 'Réponses',
	'REPLY_WITH_QUOTE'			=> 'Répondre en citant',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Répond à une annonce générale',
	'REPLYING_MESSAGE'			=> 'Répond à un message dans %s',
	'REPORT_BY'					=> 'Rapporté par',
	'REPORT_POST'				=> 'Rapporter le message',
	'REPORTING_POST'			=> 'Rapporte un message',
	'RESEND_ACTIVATION'			=> 'Renvoyer le courrier électronique d’activation',
	'RESET'						=> 'Réinitialiser',
	'RESTORE_PERMISSIONS'		=> 'Restaurer les permissions',
	'RETURN_INDEX'				=> '%sRevenir à la page d’index%s',
	'RETURN_FORUM'				=> '%sRevenir au dernier forum visité%s',
	'RETURN_PAGE'				=> '%sRevenir à la page précédente%s',
	'RETURN_TOPIC'				=> '%sRevenir au dernier sujet visité%s',
	'RETURN_TO'					=> 'Revenir vers',
	'FEED'						=> 'Flux',
	'FEED_NEWS'					=> 'Nouveautés',
	'FEED_TOPICS_ACTIVE'		=> 'Sujets actifs',
	'FEED_TOPICS_NEW'			=> 'Nouveaux sujets',
	'RULES_ATTACH_CAN'			=> 'Vous <strong>pouvez</strong> transférer des pièces jointes dans ce forum',
	'RULES_ATTACH_CANNOT'		=> 'Vous <strong>ne pouvez pas</strong> transférer de pièces jointes dans ce forum',
	'RULES_DELETE_CAN'			=> 'Vous <strong>pouvez</strong> supprimer vos messages dans ce forum',
	'RULES_DELETE_CANNOT'		=> 'Vous <strong>ne pouvez pas</strong> supprimer vos messages dans ce forum',
	'RULES_DOWNLOAD_CAN'		=> 'Vous <strong>pouvez</strong> télécharger des pièces jointes dans ce forum',
	'RULES_DOWNLOAD_CANNOT'		=> 'Vous <strong>ne pouvez pas</strong> télécharger de pièces jointes dans ce forum',
	'RULES_EDIT_CAN'			=> 'Vous <strong>pouvez</strong> éditer vos messages dans ce forum',
	'RULES_EDIT_CANNOT'			=> 'Vous <strong>ne pouvez pas</strong> éditer vos messages dans ce forum',
	'RULES_LOCK_CAN'			=> 'Vous <strong>pouvez</strong> verrouiller vos sujets dans ce forum',
	'RULES_LOCK_CANNOT'			=> 'Vous <strong>ne pouvez pas</strong> verrouiller vos sujets dans ce forum',
	'RULES_POST_CAN'			=> 'Vous <strong>pouvez</strong> publier de nouveaux sujets dans ce forum',
	'RULES_POST_CANNOT'			=> 'Vous <strong>ne pouvez pas</strong> publier de nouveaux sujets dans ce forum',
	'RULES_REPLY_CAN'			=> 'Vous <strong>pouvez</strong> répondre aux sujets dans ce forum',
	'RULES_REPLY_CANNOT'		=> 'Vous <strong>ne pouvez pas</strong> répondre aux sujets dans ce forum',
	'RULES_VOTE_CAN'			=> 'Vous <strong>pouvez</strong> voter aux sondages dans ce forum',
	'RULES_VOTE_CANNOT'			=> 'Vous <strong>ne pouvez pas</strong> voter aux sondages dans ce forum',

	'SEARCH'					=> 'Rechercher',
	'SEARCH_MINI'				=> 'Rechercher…',
	'SEARCH_ADV'				=> 'Recherche avancée',
	'SEARCH_ADV_EXPLAIN'		=> 'Accéder aux réglages avancés de la recherche',
	'SEARCH_KEYWORDS'			=> 'Rechercher par mots-clés',
	'SEARCHING_FORUMS'			=> 'Recherche dans les forums',
	'SEARCH_ACTIVE_TOPICS'		=> 'Sujets actifs',
	'SEARCH_FOR'				=> 'Rechercher',
	'SEARCH_FORUM'				=> 'Rechercher…',
	'SEARCH_NEW'				=> 'Nouveaux messages',
	'SEARCH_POSTS_BY'			=> 'Rechercher les messages de',
	'SEARCH_SELF'				=> 'Vos messages',
	'SEARCH_TOPIC'				=> 'Rechercher…',
	'SEARCH_UNANSWERED'			=> 'Messages sans réponse',
	'SEARCH_UNREAD'				=> 'Messages non lus',
	'SEARCH_USER_POSTS'			=> 'Rechercher les messages de l’utilisateur',
	'SECONDS'					=> 'secondes',
	'SELECT'					=> 'Sélectionner',
	'SELECT_ALL_CODE'			=> 'Tout sélectionner',
	'SELECT_DESTINATION_FORUM'	=> 'Veuillez sélectionner un forum de destination',
	'SELECT_FORUM'				=> 'Sélectionner un forum',
	'SEND_EMAIL'				=> 'Envoyer un courrier électronique',				// Used for submit buttons
	'SEND_EMAIL_USER'			=> 'Envoyer un courrier électronique à',				// Used as: {L_SEND_EMAIL_USER} {USERNAME} -> E-mail UserX
	'SEND_PRIVATE_MESSAGE'		=> 'Envoyer un message privé',
	'SETTINGS'					=> 'Réglages',
	'SIGNATURE'					=> 'Signature',
	'SKIP'						=> 'Accéder au contenu',
	'SMTP_NO_AUTH_SUPPORT'		=> 'Le serveur SMTP ne supporte pas l’authentification.',
	'SORRY_AUTH_READ'			=> 'Vous ne pouvez pas consulter ce forum.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Vous ne pouvez pas télécharger cette pièce jointe.',
	'SORT_BY'					=> 'Trier par',
	'SORT_JOINED'				=> 'Date d’inscription',
	'SORT_LOCATION'				=> 'Localisation',
	'SORT_RANK'					=> 'Rang',
	'SORT_POSTS'				=> 'Messages',
	'SORT_TOPIC_TITLE'			=> 'Titre du sujet',
	'SORT_USERNAME'				=> 'Nom d’utilisateur',
	'SPLIT_TOPIC'				=> 'Diviser le sujet',
	'SQL_ERROR_OCCURRED'		=> 'Une erreur SQL est survenue lors du chargement de la page. Si ce problème persiste, veuillez contacter l’%sadministrateur du forum%s.',
	'STATISTICS'				=> 'Statistiques',
	'START_WATCHING_FORUM'		=> 'S’abonner au forum',
	'START_WATCHING_TOPIC'		=> 'S’abonner au sujet',
	'STOP_WATCHING_FORUM'		=> 'Se désabonner du forum',
	'STOP_WATCHING_TOPIC'		=> 'Se désabonner du sujet',
	'SUBFORUM'					=> 'Sous-forum',
	'SUBFORUMS'					=> 'Sous-forums',
	'SUBJECT'					=> 'Sujet',
	'SUBMIT'					=> 'Envoyer',

	'TB'				=> 'To',
	'TERMS_USE'			=> 'Conditions d’utilisation',
	'TEST_CONNECTION'	=> 'Tester la connexion',
	'THE_TEAM'			=> 'L’équipe',
	'TIB'				=> 'Tio',
	'TIME'				=> 'Date',

	'TOO_LARGE'						=> 'La valeur que vous avez spécifiée est trop importante.',
	'TOO_LARGE_MAX_RECIPIENTS'		=> 'La valeur du réglage <strong>Nombre maximal de destinataires autorisés par message privé</strong> que vous avez spécifiée est trop importante.',

	'TOO_LONG'						=> 'La valeur que vous avez spécifiée est trop longue.',

	'TOO_LONG_AIM'					=> 'Le nom d’utilisateur que vous avez spécifié est trop long.',
	'TOO_LONG_CONFIRM_CODE'			=> 'Le code de confirmation que vous avez spécifié est trop long.',
	'TOO_LONG_DATEFORMAT'			=> 'Le format de date que vous avez spécifié est trop long.',
	'TOO_LONG_ICQ'					=> 'Le numéro ICQ que vous avez spécifié est trop long.',
	'TOO_LONG_INTERESTS'			=> 'Les centres d’intérêt que vous avez spécifiés sont trop longs.',
	'TOO_LONG_JABBER'				=> 'Le nom du compte Jabber que vous avez spécifié est trop long.',
	'TOO_LONG_LOCATION'				=> 'La localisation que vous avez spécifiée est trop longue.',
	'TOO_LONG_MSN'					=> 'Le nom d’utilisateur MSNM/WLM que vous avez spécifié est trop long.',
	'TOO_LONG_NEW_PASSWORD'			=> 'Le mot de passe que vous avez spécifié est trop long.',
	'TOO_LONG_OCCUPATION'			=> 'La profession que vous avez spécifiée est trop long.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'Le mot de passe de confirmation que vous avez spécifié est trop long.',
	'TOO_LONG_USER_PASSWORD'		=> 'Le mot de passe que vous avez spécifié est trop long.',
	'TOO_LONG_USERNAME'				=> 'Le nom d’utilisateur que vous avez spécifié est trop long.',
	'TOO_LONG_EMAIL'				=> 'L’adresse de courrier électronique que vous avez spécifiée est trop longue.',
	'TOO_LONG_EMAIL_CONFIRM'		=> 'L’adresse de courrier électronique de confirmation que vous avez spécifiée est trop longue.',
	'TOO_LONG_WEBSITE'				=> 'L’adresse du site internet que vous avez spécifiée est trop longue.',
	'TOO_LONG_YIM'					=> 'Le nom d’utilisateur Yahoo! Messenger que vous avez spécifié est trop long.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'Vous avez voté pour un trop grand nombre d’options.',

	'TOO_SHORT'						=> 'La valeur que vous avez spécifiée est trop courte.',

	'TOO_SHORT_AIM'					=> 'Le nom d’utilisateur que vous avez spécifié est trop court.',
	'TOO_SHORT_CONFIRM_CODE'		=> 'Le code de confirmation que vous avez spécifié est trop court.',
	'TOO_SHORT_DATEFORMAT'			=> 'Le format de date que vous avez spécifié est trop court.',
	'TOO_SHORT_ICQ'					=> 'Le numéro ICQ que vous avez spécifié est trop court.',
	'TOO_SHORT_INTERESTS'			=> 'Les centres d’intérêt que vous avez spécifiés sont trop courts.',
	'TOO_SHORT_JABBER'				=> 'Le nom du compte Jabber que vous avez spécifié est trop court.',
	'TOO_SHORT_LOCATION'			=> 'La localisation que vous avez spécifiée est trop courte.',
	'TOO_SHORT_MSN'					=> 'Le nom d’utilisateur MSNM/WLM que vous avez spécifié est trop court.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'Le mot de passe que vous avez spécifié est trop court.',
	'TOO_SHORT_OCCUPATION'			=> 'La profession que vous avez spécifiée est trop court.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'Le mot de passe de confirmation que vous avez spécifié est trop court.',
	'TOO_SHORT_USER_PASSWORD'		=> 'Le mot de passe que vous avez spécifié est trop court.',
	'TOO_SHORT_USERNAME'			=> 'Le nom d’utilisateur que vous avez spécifié est trop court.',
	'TOO_SHORT_EMAIL'				=> 'L’adresse de courrier électronique que vous avez spécifiée est trop courte.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'L’adresse de courrier électronique de confirmation que vous avez spécifiée est trop courte.',
	'TOO_SHORT_WEBSITE'				=> 'L’adresse du site internet que vous avez spécifiée est trop courte.',
	'TOO_SHORT_YIM'					=> 'Le nom d’utilisateur Yahoo! Messenger que vous avez spécifié est trop court.',

	'TOO_SMALL'						=> 'La valeur que vous avez spécifiée est trop faible.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'La valeur du réglage <strong>Nombre maximal de destinataires autorisés par message privé</strong> que vous avez spécifiée est trop faible.',

	'TOPIC'				=> 'Sujet',
	'TOPICS'			=> 'Sujets',
	'TOPICS_UNAPPROVED'	=> 'Au moins un des sujets de ce forum n’a pas été approuvé.',
	'TOPIC_ICON'		=> 'Icône de sujet',
	'TOPIC_LOCKED'		=> 'Ce sujet est verrouillé, vous ne pouvez rien publier ou éditer.',
	'TOPIC_LOCKED_SHORT'=> 'Sujet verrouillé',
	'TOPIC_MOVED'		=> 'Sujet déplacé',
	'TOPIC_REVIEW'		=> 'Relecture du sujet',
	'TOPIC_TITLE'		=> 'Titre du sujet',
	'TOPIC_UNAPPROVED'	=> 'Ce sujet n’a pas été approuvé.',
	'TOTAL_ATTACHMENTS'	=> 'Pièces jointes',
	'TOTAL_LOG'			=> '1 historique',
	'TOTAL_LOGS'		=> '%d historiques',
	'TOTAL_NO_PM'		=> '0 message privé',
	'TOTAL_PM'			=> '1 message privé',
	'TOTAL_PMS'			=> '%d messages privés',
	'TOTAL_POSTS'		=> 'Nombre total de messages',
	'TOTAL_POSTS_OTHER'	=> '<strong>%d</strong> messages',
	'TOTAL_POSTS_ZERO'	=> '<strong>0</strong> message',
	'TOPIC_REPORTED'	=> 'Ce sujet a été rapporté',
	'TOTAL_TOPICS_OTHER'=> '<strong>%d</strong> sujets',
	'TOTAL_TOPICS_ZERO'	=> '<strong>0</strong> sujet',
	'TOTAL_USERS_OTHER'	=> '<strong>%d</strong> membres',
	'TOTAL_USERS_ZERO'	=> '<strong>0</strong> membre',
	'TRACKED_PHP_ERROR'	=> 'Erreurs PHP survenues : %s',

	'UNABLE_GET_IMAGE_SIZE'	=> 'Il n’a pas été possible de déterminer les dimensions de l’image. Veuillez vérifier que le lien que vous avez saisi est correct.',
	'UNABLE_TO_DELIVER_FILE'=> 'Impossible de délivrer le fichier.',
	'UNKNOWN_BROWSER'		=> 'Navigateur inconnu',
	'UNMARK_ALL'			=> 'Tout décocher',
	'UNREAD_MESSAGES'		=> 'Messages non lus',
	'UNREAD_PM'				=> '<strong>%d</strong> message non lu',
	'UNREAD_PMS'			=> '<strong>%d</strong> messages non lus',
	'UNREAD_POST'			=> 'Message non lu',
	'UNREAD_POSTS'			=> 'Messages non lus',
	'UNWATCH_FORUM_CONFIRM'		=> 'Êtes-vous sûr(e) de vouloir vous désabonner de ce forum ?',
	'UNWATCH_FORUM_DETAILED'	=> 'Êtes-vous sûr(e) de vouloir vous désabonner du forum « %s » ?',
	'UNWATCH_TOPIC_CONFIRM'		=> 'Êtes-vous sûr(e) de vouloir vous désabonner de ce sujet ?',
	'UNWATCH_TOPIC_DETAILED'	=> 'Êtes-vous sûr(e) de vouloir vous désabonner du sujet « %s » ?',
	'UNWATCHED_FORUMS'			=> 'Vous n’êtes à présent plus abonné(e) aux forums sélectionnés.',
	'UNWATCHED_TOPICS'			=> 'Vous n’êtes à présent plus abonné(e) aux sujets sélectionnés.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Vous n’êtes à présent plus abonné(e) aux éléments sélectionnées.',
	'UPDATE'				=> 'Mettre à jour',
	'UPLOAD_IN_PROGRESS'	=> 'Transfert en cours.',
	'URL_REDIRECT'			=> 'Si votre navigateur ne supporte pas les redirections automatiques, veuillez %scliquer ici%s afin d’être redirigé.',
	'USERGROUPS'			=> 'Groupes',
	'USERNAME'				=> 'Nom d’utilisateur',
	'USERNAMES'				=> 'Noms d’utilisateurs',
	'USER_AVATAR'			=> 'Avatar de l’utilisateur',
	'USER_CANNOT_READ'		=> 'Vous ne pouvez pas consulter les messages de ce forum.',
	'USER_POST'				=> '%d message',
	'USER_POSTS'			=> '%d messages',
	'USERS'					=> 'Utilisateurs',
	'USE_PERMISSIONS'		=> 'Tester les permissions de l’utilisateur',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Vous ne pouvez pas utiliser cette fonctionnalité. Vous devez vous inscrire et participer activement aux discussions du forum.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Consulté',
	'VIEWING_FAQ'				=> 'Consulte la FAQ',
	'VIEWING_MEMBERS'			=> 'Consulte les informations d’un membre',
	'VIEWING_ONLINE'			=> 'Consulte la liste des utilisateurs en ligne',
	'VIEWING_MCP'				=> 'Consulte le panneau de contrôle du modérateur',
	'VIEWING_MEMBER_PROFILE'	=> 'Consulte le profil d’un membre',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Consulte ses messages privés',
	'VIEWING_REGISTER'			=> 'Inscrit un compte',
	'VIEWING_UCP'				=> 'Consulte le panneau de contrôle de l’utilisateur',
	'VIEWS'						=> 'Vues',
	'VIEW_BOOKMARKS'			=> 'Consulter les favoris',
	'VIEW_FORUM_LOGS'			=> 'Consulter l’historique',
	'VIEW_LATEST_POST'			=> 'Consulter le dernier message',
	'VIEW_NEWEST_POST'			=> 'Consulter le message non lu le plus récent',
	'VIEW_NOTES'				=> 'Consulter les remarques sur l’utilisateur',
	'VIEW_ONLINE_TIME'			=> 'selon le nombre d’utilisateurs actifs de la dernière minute',
	'VIEW_ONLINE_TIMES'			=> 'selon le nombre d’utilisateurs actifs des %d dernières minutes',
	'VIEW_TOPIC'				=> 'Consulter le sujet',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Annonce : ',
	'VIEW_TOPIC_GLOBAL'			=> 'Annonce générale : ',
	'VIEW_TOPIC_LOCKED'			=> 'Verrouillé : ',
	'VIEW_TOPIC_LOGS'			=> 'Consulter l’historique',
	'VIEW_TOPIC_MOVED'			=> 'Déplacé : ',
	'VIEW_TOPIC_POLL'			=> 'Sondage : ',
	'VIEW_TOPIC_STICKY'			=> 'Note : ',
	'VISIT_WEBSITE'				=> 'Visiter le site internet',

	'WARNINGS'			=> 'Avertissements',
	'WARN_USER'			=> 'Avertir l’utilisateur',
	'WATCH_FORUM_CONFIRM'	=> 'Êtes-vous sûr(e) de vouloir vous abonner à ce forum ?',
	'WATCH_FORUM_DETAILED'	=> 'Êtes-vous sûr(e) de vouloir vous abonner au forum « %s » ?',
	'WATCH_TOPIC_CONFIRM'	=> 'Êtes-vous sûr(e) de vouloir vous abonner à ce sujet ?',
	'WATCH_TOPIC_DETAILED'	=> 'Êtes-vous sûr(e) de vouloir vous abonner au sujet « %s » ?',
	'WELCOME_SUBJECT'	=> 'Bienvenue sur les forums de %s',
	'WEBSITE'			=> 'Site internet',
	'WHOIS'				=> 'Qui est-ce ?',
	'WHO_IS_ONLINE'		=> 'Qui est en ligne ?',
	'WRONG_PASSWORD'	=> 'Le mot de passe que vous avez spécifié est incorrect.',

	'WRONG_DATA_COLOUR'			=> 'La valeur de couleur que vous avez spécifiée est incorrecte.',
	'WRONG_DATA_ICQ'			=> 'Le numéro ICQ que vous avez spécifié est incorrect.',
	'WRONG_DATA_JABBER'			=> 'Le nom du compte Jabber que vous avez spécifié est incorrect.',
	'WRONG_DATA_LANG'			=> 'La langue que vous avez spécifiée est incorrecte.',
	'WRONG_DATA_WEBSITE'		=> 'L’adresse du site internet doit être exacte, comportant le protocole. Par exemple, http://www.exemple.com/.',
	'WROTE'						=> 'a écrit',

	'YEAR'				=> 'Année',
	'YEAR_MONTH_DAY'	=> '(AAAA-MM-JJ)',
	'YES'				=> 'Oui',
	'YIM'				=> 'YIM',
	'YOU_LAST_VISIT'	=> 'Dernière visite : %s',
	'YOU_NEW_PM'		=> 'Vous avez un nouveau message privé dans votre boîte de réception.',
	'YOU_NEW_PMS'		=> 'Vous avez de nouveaux messages privés dans votre boîte de réception.',
	'YOU_NO_NEW_PM'		=> 'Vous n’avez aucun nouveau message privé dans votre boîte de réception.',

	'datetime'			=> array(
		'TODAY'		=> 'Aujourd’hui',
		'TOMORROW'	=> 'Demain',
		'YESTERDAY'	=> 'Hier',
		'AGO'		=> array(
			0		=> 'il y a moins d’une minute',
			1		=> 'il y a %d minute',
			2		=> 'il y a %d minutes',
			60		=> 'il y a 1 heure',
		),

		'Sunday'	=> 'Dimanche',
		'Monday'	=> 'Lundi',
		'Tuesday'	=> 'Mardi',
		'Wednesday'	=> 'Mercredi',
		'Thursday'	=> 'Jeudi',
		'Friday'	=> 'Vendredi',
		'Saturday'	=> 'Samedi',

		'Sun'		=> 'Dim',
		'Mon'		=> 'Lun',
		'Tue'		=> 'Mar',
		'Wed'		=> 'Mer',
		'Thu'		=> 'Jeu',
		'Fri'		=> 'Ven',
		'Sat'		=> 'Sam',

		'January'	=> 'Janvier',
		'February'	=> 'Février',
		'March'		=> 'Mars',
		'April'		=> 'Avril',
		'May'		=> 'Mai',
		'June'		=> 'Juin',
		'July'		=> 'Juillet',
		'August'	=> 'Août',
		'September' => 'Septembre',
		'October'	=> 'Octobre',
		'November'	=> 'Novembre',
		'December'	=> 'Décembre',

		'Jan'		=> 'Jan',
		'Feb'		=> 'Fév',
		'Mar'		=> 'Mars',
		'Apr'		=> 'Avr',
		'May_short'	=> 'Mai',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'Juin',
		'Jul'		=> 'Juil',
		'Aug'		=> 'Août',
		'Sep'		=> 'Sep',
		'Oct'		=> 'Oct',
		'Nov'		=> 'Nov',
		'Dec'		=> 'Déc',
	),

	'tz'				=> array(
		'-12'	=> 'UTC-12 heures',
		'-11'	=> 'UTC-11 heures',
		'-10'	=> 'UTC-10 heures',
		'-9.5'	=> 'UTC-9:30 heures',
		'-9'	=> 'UTC-9 heures',
		'-8'	=> 'UTC-8 heures',
		'-7'	=> 'UTC-7 heures',
		'-6'	=> 'UTC-6 heures',
		'-5'	=> 'UTC-5 heures',
		'-4.5'	=> 'UTC-4:30 heures',
		'-4'	=> 'UTC-4 heures',
		'-3.5'	=> 'UTC-3:30 heures',
		'-3'	=> 'UTC-3 heures',
		'-2'	=> 'UTC-2 heures',
		'-1'	=> 'UTC-1 heure',
		'0'		=> 'UTC',
		'1'		=> 'UTC+1 heure',
		'2'		=> 'UTC+2 heures',
		'3'		=> 'UTC+3 heures',
		'3.5'	=> 'UTC+3:30 heures',
		'4'		=> 'UTC+4 heures',
		'4.5'	=> 'UTC+4:30 heures',
		'5'		=> 'UTC+5 heures',
		'5.5'	=> 'UTC+5:30 heures',
		'5.75'	=> 'UTC+5:45 heures',
		'6'		=> 'UTC+6 heures',
		'6.5'	=> 'UTC+6:30 heures',
		'7'		=> 'UTC+7 heures',
		'8'		=> 'UTC+8 heures',
		'8.75'	=> 'UTC+8:45 heures',
		'9'		=> 'UTC+9 heures',
		'9.5'	=> 'UTC+9:30 heures',
		'10'	=> 'UTC+10 heures',
		'10.5'	=> 'UTC+10:30 heures',
		'11'	=> 'UTC+11 heures',
		'11.5'	=> 'UTC+11:30 heures',
		'12'	=> 'UTC+12 heures',
		'12.75'	=> 'UTC+12:45 heures',
		'13'	=> 'UTC+13 heures',
		'14'	=> 'UTC+14 heures',
		'dst'	=> '[Heure d’été]',
	),

	'tz_zones'	=> array(
		'-12'	=> '[UTC-12] Île Baker',
		'-11'	=> '[UTC-11] Niue, Samoa',
		'-10'	=> '[UTC-10] Hawaii-Aleutian, Île Cook',
		'-9.5'	=> '[UTC-9:30] Îles Marquises',
		'-9'	=> '[UTC-9] Alaska, Île Gambier',
		'-8'	=> '[UTC-8] Pacifique',
		'-7'	=> '[UTC-7] Montagnes Rocheuses',
		'-6'	=> '[UTC-6] Centre',
		'-5'	=> '[UTC-5] Est',
		'-4.5'	=> '[UTC-4:30] Venezuela',
		'-4'	=> '[UTC-4] Atlantique',
		'-3.5'	=> '[UTC-3:30] Terre-Neuve',
		'-3'	=> '[UTC-3] Amazonie, Groenland central',
		'-2'	=> '[UTC-2] Fernando de Noronha, Géorgie du sud &amp; les Îles Sandwich du sud',
		'-1'	=> '[UTC-1] Açores, Cap-Vert, Groenland de l’est',
		'0'		=> '[UTC] Europe de l’ouest, Méridien de Greenwich',
		'1'		=> '[UTC+1] Europe centrale, Afrique de l’ouest',
		'2'		=> '[UTC+2] Europe de l’est, Afrique centrale',
		'3'		=> '[UTC+3] Moscou, Afrique de l’est',
		'3.5'	=> '[UTC+3:30] Iran',
		'4'		=> '[UTC+4] Gulf, Samara',
		'4.5'	=> '[UTC+4:30] Afghanistan',
		'5'		=> '[UTC+5] Pakistan, Iekaterinbourg',
		'5.5'	=> '[UTC+5:30] Inde, Sri Lanka',
		'5.75'	=> '[UTC+5:45] Népal',
		'6'		=> '[UTC+6] Bangladesh, Bhoutan, Novosibirsk',
		'6.5'	=> '[UTC+6:30] Îles Cocos, Myanmar',
		'7'		=> '[UTC+7] Indochine, Krasnoyarsk',
		'8'		=> '[UTC+8] Chine, Australie de l’ouest, Irkutsk',
		'8.75'	=> '[UTC+8:45] Australie du sud-est',
		'9'		=> '[UTC+9] Japon, Corée, Chita',
		'9.5'	=> '[UTC+9:30] Australie centrale',
		'10'	=> '[UTC+10] Australie de l’est, Vladivostok',
		'10.5'	=> '[UTC+10:30] Lord Howe',
		'11'	=> '[UTC+11] Île Solomon, Magadan',
		'11.5'	=> '[UTC+11:30] Île Norfolk',
		'12'	=> '[UTC+12] Nouvelle Zélande, Fiji, Kamchatka',
		'12.75'	=> '[UTC+12:45] Îles Chatham',
		'13'	=> '[UTC+13] Tongo, Îles Phoenix',
		'14'	=> '[UTC+14] Île de Wight',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '01 Jan 2007, 13:37',
		'd M Y H:i'				=> '01 Jan 2007 13:37',
		'M jS, \'y, H:i'		=> 'Jan 1st, ’07, 13:37',
		'D M d, Y g:i a'		=> 'Lun Jan 01, 2007 1:37 pm',
		'F jS, Y, g:i a'		=> 'Janvier 1st, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> 'Aujourd’hui, 13:37 / 01 Jan 2007, 13:37',
		'|F jS, Y|, g:i a'		=> 'Aujourd’hui, 1:37 pm / Janvier 1st, 2007, 1:37 pm',
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'd F Y, H:i', // 01 January 2007, 13:37

));

?>