/*
 * The MIT License
 *
 * Copyright (c) 2018 The Broad Institute
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package picard.sam.SamErrorMetric;

import htsjdk.samtools.reference.SamLocusAndReferenceIterator;
import htsjdk.samtools.util.SamLocusIterator;

/**
 * An interface that can take a collection of bases (provided as {@link htsjdk.samtools.util.SamLocusIterator.RecordAndOffset RecordAndOffset}
 * and {@link SamLocusAndReferenceIterator.SAMLocusAndReference SAMLocusAndReference}) and generates a
 * {@link ErrorMetric} from them.
 * <p>
 * The Calculator has a suffix which will be used to generate the metric file suffixes.
 */
public interface BaseCalculator {

    /**
     * The suffix that pertains to the implementation of aggregation
     **/
    String getSuffix();

    /**
     * Returns the metric generated by the observed loci
     **/
    ErrorMetric getMetric();

    /**
     * the function by which new loci are "shown" to the calculator
     **/
    void addBase(final SamLocusIterator.RecordAndOffset recordAndOffset,
                 final SamLocusAndReferenceIterator.SAMLocusAndReference locusInfo);
}