# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import WebSiteManagementClientConfiguration
from .operations import AppServiceEnvironmentsOperations
from .operations import AppServicePlansOperations
from . import models


class WebSiteManagementClient(SDKClient):
    """WebSite Management Client

    :ivar config: Configuration for client.
    :vartype config: WebSiteManagementClientConfiguration

    :ivar app_service_environments: AppServiceEnvironments operations
    :vartype app_service_environments: azure.mgmt.web.v2016_09_01.operations.AppServiceEnvironmentsOperations
    :ivar app_service_plans: AppServicePlans operations
    :vartype app_service_plans: azure.mgmt.web.v2016_09_01.operations.AppServicePlansOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Your Azure subscription ID. This is a
     GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = WebSiteManagementClientConfiguration(credentials, subscription_id, base_url)
        super(WebSiteManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2016-09-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.app_service_environments = AppServiceEnvironmentsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.app_service_plans = AppServicePlansOperations(
            self._client, self.config, self._serialize, self._deserialize)
