# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .dataset_compression import DatasetCompression


class DatasetDeflateCompression(DatasetCompression):
    """The Deflate compression method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param type: Required. Constant filled by server.
    :type type: str
    :param level: The Deflate compression level.
    :type level: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'level': {'key': 'level', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(DatasetDeflateCompression, self).__init__(**kwargs)
        self.level = kwargs.get('level', None)
        self.type = 'Deflate'
