# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient
from azure.mgmt.core.policies import ARMAutoResourceProviderRegistrationPolicy

from . import models as _models
from ._configuration import MicrosoftElasticConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    AllTrafficFiltersOperations,
    AssociateTrafficFilterOperations,
    BillingInfoOperations,
    ConnectedPartnerResourcesOperations,
    CreateAndAssociateIPFilterOperations,
    CreateAndAssociatePLFilterOperations,
    DeploymentInfoOperations,
    DetachAndDeleteTrafficFilterOperations,
    DetachTrafficFilterOperations,
    ElasticVersionsOperations,
    ExternalUserOperations,
    ListAssociatedTrafficFiltersOperations,
    MonitorOperations,
    MonitoredResourcesOperations,
    MonitoredSubscriptionsOperations,
    MonitorsOperations,
    OpenAIOperations,
    Operations,
    OrganizationsOperations,
    TagRulesOperations,
    TrafficFiltersOperations,
    UpgradableVersionsOperations,
    VMCollectionOperations,
    VMHostOperations,
    VMIngestionOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential


class MicrosoftElastic:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """MicrosoftElastic.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.elastic.operations.Operations
    :ivar monitors: MonitorsOperations operations
    :vartype monitors: azure.mgmt.elastic.operations.MonitorsOperations
    :ivar elastic_versions: ElasticVersionsOperations operations
    :vartype elastic_versions: azure.mgmt.elastic.operations.ElasticVersionsOperations
    :ivar monitored_subscriptions: MonitoredSubscriptionsOperations operations
    :vartype monitored_subscriptions:
     azure.mgmt.elastic.operations.MonitoredSubscriptionsOperations
    :ivar monitored_resources: MonitoredResourcesOperations operations
    :vartype monitored_resources: azure.mgmt.elastic.operations.MonitoredResourcesOperations
    :ivar deployment_info: DeploymentInfoOperations operations
    :vartype deployment_info: azure.mgmt.elastic.operations.DeploymentInfoOperations
    :ivar external_user: ExternalUserOperations operations
    :vartype external_user: azure.mgmt.elastic.operations.ExternalUserOperations
    :ivar billing_info: BillingInfoOperations operations
    :vartype billing_info: azure.mgmt.elastic.operations.BillingInfoOperations
    :ivar connected_partner_resources: ConnectedPartnerResourcesOperations operations
    :vartype connected_partner_resources:
     azure.mgmt.elastic.operations.ConnectedPartnerResourcesOperations
    :ivar open_ai: OpenAIOperations operations
    :vartype open_ai: azure.mgmt.elastic.operations.OpenAIOperations
    :ivar tag_rules: TagRulesOperations operations
    :vartype tag_rules: azure.mgmt.elastic.operations.TagRulesOperations
    :ivar vm_host: VMHostOperations operations
    :vartype vm_host: azure.mgmt.elastic.operations.VMHostOperations
    :ivar vm_ingestion: VMIngestionOperations operations
    :vartype vm_ingestion: azure.mgmt.elastic.operations.VMIngestionOperations
    :ivar vm_collection: VMCollectionOperations operations
    :vartype vm_collection: azure.mgmt.elastic.operations.VMCollectionOperations
    :ivar upgradable_versions: UpgradableVersionsOperations operations
    :vartype upgradable_versions: azure.mgmt.elastic.operations.UpgradableVersionsOperations
    :ivar monitor: MonitorOperations operations
    :vartype monitor: azure.mgmt.elastic.operations.MonitorOperations
    :ivar all_traffic_filters: AllTrafficFiltersOperations operations
    :vartype all_traffic_filters: azure.mgmt.elastic.operations.AllTrafficFiltersOperations
    :ivar list_associated_traffic_filters: ListAssociatedTrafficFiltersOperations operations
    :vartype list_associated_traffic_filters:
     azure.mgmt.elastic.operations.ListAssociatedTrafficFiltersOperations
    :ivar create_and_associate_ip_filter: CreateAndAssociateIPFilterOperations operations
    :vartype create_and_associate_ip_filter:
     azure.mgmt.elastic.operations.CreateAndAssociateIPFilterOperations
    :ivar create_and_associate_pl_filter: CreateAndAssociatePLFilterOperations operations
    :vartype create_and_associate_pl_filter:
     azure.mgmt.elastic.operations.CreateAndAssociatePLFilterOperations
    :ivar associate_traffic_filter: AssociateTrafficFilterOperations operations
    :vartype associate_traffic_filter:
     azure.mgmt.elastic.operations.AssociateTrafficFilterOperations
    :ivar detach_and_delete_traffic_filter: DetachAndDeleteTrafficFilterOperations operations
    :vartype detach_and_delete_traffic_filter:
     azure.mgmt.elastic.operations.DetachAndDeleteTrafficFilterOperations
    :ivar detach_traffic_filter: DetachTrafficFilterOperations operations
    :vartype detach_traffic_filter: azure.mgmt.elastic.operations.DetachTrafficFilterOperations
    :ivar traffic_filters: TrafficFiltersOperations operations
    :vartype traffic_filters: azure.mgmt.elastic.operations.TrafficFiltersOperations
    :ivar organizations: OrganizationsOperations operations
    :vartype organizations: azure.mgmt.elastic.operations.OrganizationsOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription. The value must be an UUID. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2024-06-15-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = MicrosoftElasticConfiguration(credential=credential, subscription_id=subscription_id, **kwargs)
        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                ARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: ARMPipelineClient = ARMPipelineClient(base_url=base_url, policies=_policies, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.monitors = MonitorsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.elastic_versions = ElasticVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.monitored_subscriptions = MonitoredSubscriptionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.monitored_resources = MonitoredResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.deployment_info = DeploymentInfoOperations(self._client, self._config, self._serialize, self._deserialize)
        self.external_user = ExternalUserOperations(self._client, self._config, self._serialize, self._deserialize)
        self.billing_info = BillingInfoOperations(self._client, self._config, self._serialize, self._deserialize)
        self.connected_partner_resources = ConnectedPartnerResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.open_ai = OpenAIOperations(self._client, self._config, self._serialize, self._deserialize)
        self.tag_rules = TagRulesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.vm_host = VMHostOperations(self._client, self._config, self._serialize, self._deserialize)
        self.vm_ingestion = VMIngestionOperations(self._client, self._config, self._serialize, self._deserialize)
        self.vm_collection = VMCollectionOperations(self._client, self._config, self._serialize, self._deserialize)
        self.upgradable_versions = UpgradableVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.monitor = MonitorOperations(self._client, self._config, self._serialize, self._deserialize)
        self.all_traffic_filters = AllTrafficFiltersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.list_associated_traffic_filters = ListAssociatedTrafficFiltersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.create_and_associate_ip_filter = CreateAndAssociateIPFilterOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.create_and_associate_pl_filter = CreateAndAssociatePLFilterOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.associate_traffic_filter = AssociateTrafficFilterOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.detach_and_delete_traffic_filter = DetachAndDeleteTrafficFilterOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.detach_traffic_filter = DetachTrafficFilterOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.traffic_filters = TrafficFiltersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.organizations = OrganizationsOperations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, request: HttpRequest, *, stream: bool = False, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> Self:
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
