/*
Qxw is a program to help construct and publish crosswords.

Copyright 2011-2020 Mark Owen; Windows port by Peter Flippant
http://www.quinapalus.com
E-mail: qxw@quinapalus.com

This file is part of Qxw.

Qxw is free software: you can redistribute it and/or modify
it under the terms of version 2 of the GNU General Public License
as published by the Free Software Foundation.

Qxw is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Qxw.  If not, see <http://www.gnu.org/licenses/> or
write to the Free Software Foundation, Inc., 51 Franklin Street,
Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include "common.h"
#include "alphabets.h"

const char*alphaname[NALPHAINIT][NALPHACODES+1]={
  {"Roman A-Z",                  "Roman","AZ",""},
  {"Digits only 0-9",            "Digits","09",""},
  {"Roman plus digits A-Z 0-9",  "RomanDigits","AZ09",""},
  {"Czech",                      "Czech","CZ",""},
  {"Danish and Norwegian",       "Danish","Norwegian","DA","NO",""},
//  {"Devanagari",                 "Devanagari","DV",""},
  {"Dutch",                      "Dutch","NL",""},
  {"Estonian",                   "Estonian","EE",""},
  {"Finnish",                    "Finnish","FI",""},
  {"French and Italian",         "French","Italian","FR","IT",""},
  {"German",                     "German","DE",""},
  {"Ancient Greek (polytonic)",  "AncientGreek","AG",""},
  {"Modern Greek (monotonic)",   "ModernGreek","MG","EL",""},
  {"Hungarian",                  "Hungarian","HU",""},
  {"Polish",                     "Polish","PL",""},
  {"Romanian",                   "Romanian","RO",""},
  {"Russian",                    "Russian","RU",""},
  {"Slovenian",                  "Slovenian","SI",""},
  {"Spanish",                    "Spanish","SP","ES",""},
  {"Swedish",                    "Swedish","SE",""},
  {"Empty",                      "Empty","Null",""},
  };

//  {"Japanese (katakana)",        "Katakana","JPK",""},
//  {"Japanese (hiragana)",        "Hiragana","JPH",""},

struct alphaentry alphainitdata[NALPHAINIT][MAXICC]={

{

// Roman A-Z

{ 0 ,""               ,0,0,0},  //  0 always unused
{"A","aÀáÁàâÂåÅäÄãÃ"  ,1,0,1},
{"B","b"              ,0,1,1},
{"C","cçÇ"            ,0,1,1},
{"D","d"              ,0,1,1},
{"E","eæÆœŒéÉèÈêÊëË"  ,1,0,1},
{"F","f"              ,0,1,1},
{"G","g"              ,0,1,1},
{"H","h"              ,0,1,1},
{"I","iíÍìÌîÎïÏ"      ,1,0,1},
{"J","j"              ,0,1,1},
{"K","k"              ,0,1,1},
{"L","l"              ,0,1,1},
{"M","m"              ,0,1,1},
{"N","nñÑ"            ,0,1,1},
{"O","oóÓòÒôÔöÖõÕøØ"  ,1,0,1},
{"P","p"              ,0,1,1},
{"Q","q"              ,0,1,1},
{"R","r"              ,0,1,1},
{"S","s"              ,0,1,1},
{"T","t"              ,0,1,1},
{"U","uúÚùÙûÛüÜ"      ,1,0,1},
{"V","v"              ,0,1,1},
{"W","w"              ,0,1,1},
{"X","x"              ,0,1,1},
{"Y","yýÝÿ"           ,0,1,1},
{"Z","z"              ,0,1,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},

},{

// Digits only 0-9

{ 0 ,""               ,0,0,0},  //  0 always unused
{"0",""               ,0,0,1},
{"1",""               ,0,0,1},
{"2",""               ,0,0,1},
{"3",""               ,0,0,1},
{"4",""               ,0,0,1},
{"5",""               ,0,0,1},
{"6",""               ,0,0,1},
{"7",""               ,0,0,1},
{"8",""               ,0,0,1},
{"9",""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},

},{

// Roman plus digits A-Z 0-9

{ 0 ,""               ,0,0,0},  //  0 always unused
{"A","aÀáÁàâÂåÅäÄãÃ"  ,1,0,1},
{"B","b"              ,0,1,1},
{"C","cçÇ"            ,0,1,1},
{"D","d"              ,0,1,1},
{"E","eæÆœŒéÉèÈêÊëË"  ,1,0,1},
{"F","f"              ,0,1,1},
{"G","g"              ,0,1,1},
{"H","h"              ,0,1,1},
{"I","iíÍìÌîÎïÏ"      ,1,0,1},
{"J","j"              ,0,1,1},
{"K","k"              ,0,1,1},
{"L","l"              ,0,1,1},
{"M","m"              ,0,1,1},
{"N","nñÑ"            ,0,1,1},
{"O","oóÓòÒôÔöÖõÕøØ"  ,1,0,1},
{"P","p"              ,0,1,1},
{"Q","q"              ,0,1,1},
{"R","r"              ,0,1,1},
{"S","s"              ,0,1,1},
{"T","t"              ,0,1,1},
{"U","uúÚùÙûÛüÜ"      ,1,0,1},
{"V","v"              ,0,1,1},
{"W","w"              ,0,1,1},
{"X","x"              ,0,1,1},
{"Y","yýÝÿ"           ,0,1,1},
{"Z","z"              ,0,1,0},
{"0",""               ,0,0,1},
{"1",""               ,0,0,1},
{"2",""               ,0,0,1},
{"3",""               ,0,0,1},
{"4",""               ,0,0,1},
{"5",""               ,0,0,1},
{"6",""               ,0,0,1},
{"7",""               ,0,0,1},
{"8",""               ,0,0,1},
{"9",""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},

},{

// Czech

{ 0 ,""               ,0,0,0},  //  0 always unused
{"A","aÀàâÂåÅäÄãÃ"    ,1,0,0},
{"Á","á"              ,1,0,0},
{"B","b"              ,0,1,1},
{"C","cçÇ"            ,0,1,1},
{"Č","č"              ,0,1,1},
{"D","d"              ,0,1,1},
{"Ď","ď"              ,0,1,0},
{"E","eæÆœŒèÈêÊëË"    ,1,0,0},
{"É","é"              ,1,0,0},
{"Ě","ě"              ,1,0,0},
{"F","f"              ,0,1,1},
{"G","g"              ,0,1,1},
{"H","h"              ,0,1,1},
{"$",""               ,0,1,0},
{"I","iìÌîÎïÏ"        ,1,0,0},
{"Í","í"              ,1,0,0},
{"J","j"              ,0,1,1},
{"K","k"              ,0,1,1},
{"L","l"              ,0,1,1},
{"M","m"              ,0,1,1},
{"N","nñÑ"            ,0,1,1},
{"Ň","ň"              ,0,1,0},
{"O","oòÒôÔöÖõÕøØ"    ,1,0,0},
{"Ó","ó"              ,1,0,0},
{"P","p"              ,0,1,1},
{"Q","q"              ,0,1,1},
{"R","r"              ,0,1,1},
{"Ř","ř"              ,0,1,1},
{"S","s"              ,0,1,1},
{"Š","š"              ,0,1,1},
{"T","t"              ,0,1,1},
{"Ť","ť"              ,0,1,0},
{"U","uùÙûÛüÜ"        ,1,0,0},
{"Ú","ú"              ,1,0,0},
{"Ů","ů"              ,1,0,0},
{"V","v"              ,0,1,1},
{"W","w"              ,0,1,1},
{"X","x"              ,0,1,0},
{"Y","yÿ"             ,1,0,0},
{"Ý","ý"              ,1,0,0},
{"Z","z"              ,0,1,1},
{"Ž","ž"              ,0,1,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},

},{

// Danish and Norwegian

{ 0 ,""               ,0,0,0},  //  0 always unused
{"A","aÀáÁàâÂãÃ"      ,1,0,1},
{"B","b"              ,0,1,1},
{"C","cçÇ"            ,0,1,1},
{"D","d"              ,0,1,1},
{"E","eœŒéÉèÈêÊëË"    ,1,0,1},
{"F","f"              ,0,1,1},
{"G","g"              ,0,1,1},
{"H","h"              ,0,1,1},
{"I","iíÍìÌîÎïÏ"      ,1,0,1},
{"J","j"              ,0,1,1},
{"K","k"              ,0,1,1},
{"L","l"              ,0,1,1},
{"M","m"              ,0,1,1},
{"N","nñÑ"            ,0,1,1},
{"O","oóÓòÒôÔöÖõÕ"    ,1,0,1},
{"P","p"              ,0,1,1},
{"Q","q"              ,0,1,1},
{"R","r"              ,0,1,1},
{"S","s"              ,0,1,1},
{"T","t"              ,0,1,1},
{"U","uúÚùÙûÛ"        ,1,0,1},
{"V","v"              ,0,1,1},
{"W","w"              ,0,1,1},
{"X","x"              ,0,1,1},
{"Y","yýÝÿüÜ"         ,1,0,1},
{"Z","z"              ,0,1,1},
{"Æ","æ"              ,1,0,1},
{"Ø","ø"              ,1,0,1},
{"Å","å"              ,1,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},

},{

// // Devanagari (testing)
// 
// { 0 ,""               ,0,0,0},  //  0 always unused
// {"ऄ","",1,0,1},
// {"अ","",1,0,1},
// {"आ","",1,0,1},
// {"इ","",1,0,1},
// {"ई","",1,0,1},
// {"उ","",1,0,1},
// {"ऊ","",1,0,0},
// {"ऋ","",1,0,0},
// {"ऌ","",1,0,0},
// {"ऎ","",1,0,1},
// {"ए","ऍ",1,0,1},
// {"ऐ","",1,0,1},
// {"ऒ","",1,0,1},
// {"ओ","ऑ",1,0,1},
// {"औ","",1,0,0},
// {"क","क़",0,1,1},
// {"ख","ख़",0,1,1},
// {"ग","ग़",0,1,1},
// {"घ","",0,1,1},
// {"ङ","",0,1,0},
// {"च","",0,1,1},
// {"छ","",0,1,1},
// {"ज","ज़",0,1,1},
// {"झ","",0,1,1},
// {"ञ","",0,1,0},
// {"ट","",0,1,1},
// {"ठ","",0,1,1},
// {"ड","",0,1,1},
// {"ड़","",0,1,0},
// {"ढ","",0,1,0},
// {"ढ़","",0,1,0},
// {"ण","",0,1,0},
// {"त","",0,1,1},
// {"थ","",0,1,1},
// {"द","",0,1,1},
// {"ध","",0,1,1},
// {"न","",0,1,0},
// {"ऩ","",0,1,0},
// {"प","",0,1,1},
// {"फ","फ़",0,1,1},
// {"ब","",0,1,1},
// {"भ","",0,1,1},
// {"म","",0,1,0},
// {"य","य़",0,1,1},
// {"र","",0,1,1},
// {"ऱ","",0,1,1},
// {"ल","",0,1,0},
// {"ळ","",0,1,0},
// {"ऴ","",0,1,0},
// {"व","",0,1,1},
// {"श","",0,1,0},
// {"ष","",0,1,1},
// {"स","",0,1,1},
// {"ह","",0,1,1},
// {"ॐ","",0,1,0},
// {"ॠ","",1,0,0},
// {"ॡ","",1,0,0},
// { 0 ,"",0,0,0},
// { 0 ,"",0,0,0},
// { 0 ,"",0,0,0},
// 
// },{

// Dutch

{ 0 ,""               ,0,0,0},  //  0 always unused
{"A","aÀáÁàâÂåÅäÄãÃ"  ,1,0,1},
{"B","b"              ,0,1,1},
{"C","cçÇ"            ,0,1,1},
{"D","d"              ,0,1,1},
{"E","eæÆœŒéÉèÈêÊëË"  ,1,0,1},
{"F","f"              ,0,1,1},
{"G","g"              ,0,1,1},
{"H","h"              ,0,1,1},
{"I","iíÍìÌîÎïÏ"      ,1,0,1},
{"J","j"              ,0,1,1},
{"K","k"              ,0,1,1},
{"L","l"              ,0,1,1},
{"M","m"              ,0,1,1},
{"N","nñÑ"            ,0,1,1},
{"O","oóÓòÒôÔöÖõÕøØ"  ,1,0,1},
{"P","p"              ,0,1,1},
{"Q","q"              ,0,1,1},
{"R","r"              ,0,1,1},
{"S","s"              ,0,1,1},
{"T","t"              ,0,1,1},
{"U","uúÚùÙûÛüÜ"      ,1,0,1},
{"V","v"              ,0,1,1},
{"W","w"              ,0,1,1},
{"X","x"              ,0,1,1},
{"Y","yýÝ"            ,0,1,1},
{"Z","z"              ,0,1,0},
{"Ĳ","ĳÿ"             ,1,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},

},{

// Estonian

{ 0 ,""               ,0,0,0},  //  0 always unused
{"A","aÀáÁàâÂãÃ"      ,1,0,1},
{"B","b"              ,0,1,1},
{"C","cçÇ"            ,0,1,1},
{"D","d"              ,0,1,1},
{"E","eæÆœŒéÉèÈêÊëË"  ,1,0,1},
{"F","f"              ,0,1,1},
{"G","g"              ,0,1,1},
{"H","h"              ,0,1,1},
{"I","iíÍìÌîÎïÏ"      ,1,0,1},
{"J","j"              ,0,1,1},
{"K","k"              ,0,1,1},
{"L","l"              ,0,1,1},
{"M","m"              ,0,1,1},
{"N","nñÑ"            ,0,1,1},
{"O","oóÓòÒôÔ"        ,1,0,1},
{"P","p"              ,0,1,1},
{"Q","q"              ,0,1,1},
{"R","r"              ,0,1,1},
{"S","s"              ,0,1,1},
{"Š","š"              ,0,1,1},
{"Z","z"              ,0,1,1},
{"Ž","ž"              ,0,1,1},
{"T","t"              ,0,1,1},
{"U","uúÚùÙûÛ"        ,1,0,1},
{"V","v"              ,0,1,1},
{"W","w"              ,0,1,1},
{"Õ","õ"              ,1,0,1},
{"Ä","ä"              ,1,0,1},
{"Ö","öøØ"            ,1,0,1},
{"Ü","ü"              ,1,0,1},
{"X","x"              ,0,1,1},
{"Y","yýÝÿ"           ,1,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},

},{

// Finnish

{ 0 ,""               ,0,0,0},  //  0 always unused
{"A","aÀáÁàâÂãÃ"      ,1,0,1},
{"B","b"              ,0,1,1},
{"C","cçÇ"            ,0,1,1},
{"D","d"              ,0,1,1},
{"E","eæÆœŒéÉèÈêÊëË"  ,1,0,1},
{"F","f"              ,0,1,1},
{"G","g"              ,0,1,1},
{"H","h"              ,0,1,1},
{"I","iíÍìÌîÎïÏ"      ,1,0,1},
{"J","j"              ,0,1,1},
{"K","k"              ,0,1,1},
{"L","l"              ,0,1,1},
{"M","m"              ,0,1,1},
{"N","nñÑ"            ,0,1,1},
{"O","oóÓòÒôÔ"        ,1,0,1},
{"P","p"              ,0,1,1},
{"Q","q"              ,0,1,1},
{"R","r"              ,0,1,1},
{"S","s"              ,0,1,1},
{"T","t"              ,0,1,1},
{"U","uúÚùÙûÛ"        ,1,0,1},
{"V","v"              ,0,1,1},
{"W","w"              ,0,1,1},
{"X","x"              ,0,1,1},
{"Y","yýÝÿüÜ"         ,1,1,1},
{"Z","z"              ,0,1,1},
{"Å","å"              ,1,0,1},
{"Ä","ä"              ,1,0,1},
{"Ö","öøØõÕ"          ,1,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},

},{

// French

{ 0 ,""               ,0,0,0},  //  0 always unused
{"A","aÀáÁàâÂåÅäÄãÃ"  ,1,0,1},
{"B","b"              ,0,1,1},
{"C","cçÇ"            ,0,1,1},
{"D","d"              ,0,1,1},
{"E","eæÆœŒéÉèÈêÊëË"  ,1,0,1},
{"F","f"              ,0,1,1},
{"G","g"              ,0,1,1},
{"H","h"              ,0,1,1},
{"I","iíÍìÌîÎïÏ"      ,1,0,1},
{"J","j"              ,0,1,1},
{"K","k"              ,0,1,1},
{"L","l"              ,0,1,1},
{"M","m"              ,0,1,1},
{"N","nñÑ"            ,0,1,1},
{"O","oóÓòÒôÔöÖõÕøØ"  ,1,0,1},
{"P","p"              ,0,1,1},
{"Q","q"              ,0,1,1},
{"R","r"              ,0,1,1},
{"S","s"              ,0,1,1},
{"T","t"              ,0,1,1},
{"U","uúÚùÙûÛüÜ"      ,1,0,1},
{"V","v"              ,0,1,1},
{"W","w"              ,0,1,1},
{"X","x"              ,0,1,1},
{"Y","yýÝÿ"           ,1,0,1},
{"Z","z"              ,0,1,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},

},{

// German

{ 0 ,""               ,0,0,0},  //  0 always unused
{"A","aÀáÁàâÂåÅãÃ"    ,1,0,1},
{"B","b"              ,0,1,1},
{"C","cçÇ"            ,0,1,1},
{"D","d"              ,0,1,1},
{"E","eæÆœŒéÉèÈêÊëË"  ,1,0,1},
{"F","f"              ,0,1,1},
{"G","g"              ,0,1,1},
{"H","h"              ,0,1,1},
{"I","iíÍìÌîÎïÏ"      ,1,0,1},
{"J","j"              ,0,1,1},
{"K","k"              ,0,1,1},
{"L","l"              ,0,1,1},
{"M","m"              ,0,1,1},
{"N","nñÑ"            ,0,1,1},
{"O","oóÓòÒôÔõÕøØ"    ,1,0,1},
{"P","p"              ,0,1,1},
{"Q","q"              ,0,1,1},
{"R","r"              ,0,1,1},
{"S","s"              ,0,1,1},
{"T","t"              ,0,1,1},
{"U","uúÚùÙûÛ"        ,1,0,1},
{"V","v"              ,0,1,1},
{"W","w"              ,0,1,1},
{"X","x"              ,0,1,1},
{"Y","yýÝ"            ,0,1,1},
{"Z","z"              ,0,1,0},
{"AE","Ää"            ,0,0,0},
{"OE","Öö"            ,0,0,0},
{"UE","Üü"            ,0,0,0},
{"SS","ẞß"            ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},

},{

// Ancient Greek

{ 0 ,""                                                       ,0,0,0},  //  0 always unused
{"Α","αάΆἀἁἂἃἄἅἆἇἈἉἊἋἌἍἎἏὰάᾰᾱᾶᾸᾹᾺΆ"                           ,1,0,1},
{"Β","βϐ"                                                     ,0,1,1},
{"Γ","γ"                                                      ,0,1,1},
{"Δ","δ"                                                      ,0,1,1},
{"Ε","εέΈἐἑἒἓἔἕἘἙἚἛἜἝὲέῈΈϵ"                                   ,1,0,1},
{"Ζ","ζ"                                                      ,0,1,1},
{"Η","ηήΉἠἡἢἣἤἥἦἧἨἩἪἫἬἭἮἯὴήῆῊΉ"                               ,1,0,1},
{"Θ","θϑϴ"                                                    ,0,1,1},
{"Ι","ιίϊΐΊΪἰἱἲἳἴἵἶἷἸἹἺἻἼἽἾἿὶίῐῑῒΐῖῗῘῙῚΊ"                     ,1,0,1},
{"Κ","κϰ"                                                     ,0,1,1},
{"Λ","λ"                                                      ,0,1,1},
{"Μ","μ"                                                      ,0,1,1},
{"Ν","ν"                                                      ,0,1,1},
{"Ξ","ξ"                                                      ,0,1,1},
{"Ο","οόΌὀὁὂὃὄὅὈὉὊὋὌὍὸόῸΌ"                                    ,1,0,1},
{"Π","πϖ"                                                     ,0,1,1},
{"Ρ","ρῤῥῬϱϼ"                                                 ,0,1,1},
{"Σ","σςϲϹ"                                                   ,0,1,1},
{"Τ","τ"                                                      ,0,1,1},
{"Υ","υύϋΰΎΫὐὑὒὓὔὕὖὗὙὛὝὟὺύῠῡῢΰῦῧῨῩῪΎϒϓϔ"                      ,1,0,1},
{"Φ","φϕ"                                                     ,0,1,1},
{"Χ","χ"                                                      ,0,1,1},
{"Ψ","ψ"                                                      ,0,1,1},
{"Ω","ωώΏὠὡὢὣὤὥὦὧὼώὨὩὪὫὬὭὮὯῶῺΏ"                               ,1,0,0},
{"Ϙ","Ϙϙ"                                                     ,0,1,0},
{"Ϛ","Ϛϛ"                                                     ,0,1,0},
{"Ϝ","Ϝϝ"                                                     ,0,1,0},
{"Ϟ","Ϟϟ"                                                     ,0,1,0},
{"Ϡ","Ϡϡ"                                                     ,0,1,0},
{"Ͱ","Ͱͱ"                                                     ,0,1,0},
{"Ͳ","Ͳͳ"                                                     ,0,1,0},
{"Ͷ","Ͷͷ"                                                     ,0,1,0},
{"Ϻ","Ϻϻ"                                                     ,0,1,0},
{"ΑΙ","ᾀᾁᾂᾃᾄᾅᾆᾇᾈᾉᾊᾋᾌᾍᾎᾏᾲᾳᾴᾷᾼ"                                 ,0,0,0},
{"ΗΙ","ᾐᾑᾒᾓᾔᾕᾖᾗᾘᾙᾚᾛᾜᾝᾞᾟῂῃῄῇῌ"                                 ,0,0,0},
{"ΩΙ","ᾠᾡᾢᾣᾤᾥᾦᾧᾨᾩᾪᾫᾬᾭᾮᾯῲῳῴῷῼ"                                 ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},
{ 0 ,""                                                       ,0,0,0},

},{

// Modern Greek

{ 0 ,""               ,0,0,0},  //  0 always unused
{"Α","αάΆ"            ,1,0,1},
{"Β","β"              ,0,1,1},
{"Γ","γ"              ,0,1,1},
{"Δ","δ"              ,0,1,1},
{"Ε","εέΈ"            ,1,0,1},
{"Ζ","ζ"              ,0,1,1},
{"Η","ηήΉ"            ,1,0,1},
{"Θ","θ"              ,0,1,1},
{"Ι","ιίϊΐΊΪ"         ,1,0,1},
{"Κ","κ"              ,0,1,1},
{"Λ","λ"              ,0,1,1},
{"Μ","μ"              ,0,1,1},
{"Ν","ν"              ,0,1,1},
{"Ξ","ξ"              ,0,1,1},
{"Ο","οόΌ"            ,1,0,1},
{"Π","π"              ,0,1,1},
{"Ρ","ρ"              ,0,1,1},
{"Σ","σς"             ,0,1,1},
{"Τ","τ"              ,0,1,1},
{"Υ","υύϋΰΎΫ"         ,1,0,1},
{"Φ","φ"              ,0,1,1},
{"Χ","χ"              ,0,1,1},
{"Ψ","ψ"              ,0,1,1},
{"Ω","ωώΏ"            ,1,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},

},{

// Hungarian

{ 0 ,""               ,0,0,0},  //  0 always unused
{"A","aàÀâÂåÅäÄãÃ"    ,1,0,0},
{"Á","á"              ,1,0,0},
{"B","b"              ,0,1,1},
{"C","cçÇ"            ,0,1,1},
{"D","d"              ,0,1,0},
{"E","eæÆœŒèÈêÊëË"    ,1,0,0},
{"É","é"              ,1,0,0},
{"F","f"              ,0,1,1},
{"G","g"              ,0,1,1},
{"H","h"              ,0,1,1},
{"I","iíÍìÌîÎïÏ"      ,1,0,1},
{"J","j"              ,0,1,1},
{"K","k"              ,0,1,1},
{"L","l"              ,0,1,1},
{"M","m"              ,0,1,1},
{"N","nñÑ"            ,0,1,0},
{"O","oóÓòÒôÔõÕøØ"    ,1,0,0},
{"Ö","öőŐ"            ,1,0,0},
{"P","p"              ,0,1,1},
{"Q","q"              ,0,1,1},
{"R","r"              ,0,1,1},
{"S","s"              ,0,1,1},
{"T","t"              ,0,1,0},
{"U","uúÚùÙûÛ"        ,1,0,0},
{"Ü","üűŰ"            ,1,0,0},
{"V","v"              ,0,1,1},
{"W","w"              ,0,1,1},
{"X","x"              ,0,1,1},
{"Y","yýÝÿ"           ,0,1,1},
{"Z","z"              ,0,1,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},

},{

// // Japanese (katakana)
// 
// { 0 ,""               ,0,0,0},
// {"ア","ァｧｱ"          ,1,0,0},
// {"イ","ィｨｲ"          ,1,0,0},
// {"ウ","ゥｩｳヴ"        ,1,0,0},
// {"エ","ェｪｴ"          ,1,0,0},
// {"オ","ォｫｵ"          ,1,0,0},
// {"カ","ヵｶガ"         ,0,1,0},
// {"キ","ｷギ"           ,0,1,0},
// {"ク","ㇰｸグ"         ,0,1,0},
// {"ケ","ヶｹゲ"         ,0,1,0},
// {"コ","ｺゴ"           ,0,1,0},
// {"サ","ｻザ"           ,0,1,0},
// {"シ","ㇱｼジ"         ,0,1,0},
// {"ス","ㇲｽズ"         ,0,1,0},
// {"セ","ｾゼ"           ,0,1,0},
// {"ソ","ｿゾ"           ,0,1,0},
// {"タ","ﾀダ"           ,0,1,0},
// {"チ","ﾁヂ"           ,0,1,0},
// {"ツ","ッｯﾂヅ"        ,0,1,0},
// {"テ","ﾃデ"           ,0,1,0},
// {"ト","ㇳﾄド"         ,0,1,0},
// {"ナ","ﾅ"             ,0,1,0},
// {"ニ","ﾆ"             ,0,1,0},
// {"ヌ","ㇴﾇ"           ,0,1,0},
// {"ネ","ﾈ"             ,0,1,0},
// {"ノ","ﾉ"             ,0,1,0},
// {"ハ","ㇵﾊバパ"       ,0,1,0},
// {"ヒ","ㇶﾋビピ"       ,0,1,0},
// {"フ","ㇷﾌブプ"       ,0,1,0},
// {"ヘ","ㇸﾍベペ"       ,0,1,0},
// {"ホ","ㇹﾎボポ"       ,0,1,0},
// {"マ","ﾏ"             ,0,1,0},
// {"ミ","ﾐ"             ,0,1,0},
// {"ム","ㇺﾑ"           ,0,1,0},
// {"メ","ﾒ"             ,0,1,0},
// {"モ","ﾓ"             ,0,1,0},
// {"ヤ","ャｬﾔ"          ,0,1,0},
// {"ユ","ュｭﾕ"          ,0,1,0},
// {"ヨ","ョｮﾖ"          ,0,1,0},
// {"ラ","ㇻﾗ"           ,0,1,0},
// {"リ","ㇼﾘ"           ,0,1,0},
// {"ル","ㇽﾙ"           ,0,1,0},
// {"レ","ㇾﾚ"           ,0,1,0},
// {"ロ","ㇿﾛ"           ,0,1,0},
// {"ワ","ヮﾜヷ"         ,0,1,0},
// {"ヰ","ヸ"            ,0,1,0},
// {"ヱ","ヹ"            ,0,1,0},
// {"ヲ","ｦヺ"           ,0,1,0},
// {"ン","ﾝ"             ,0,1,0},
// {"ー","ｰ"             ,0,0,0},
// { 0 ,""               ,0,0,0},
// { 0 ,""               ,0,0,0},
// { 0 ,""               ,0,0,0},
// { 0 ,""               ,0,0,0},
// { 0 ,""               ,0,0,0},
// { 0 ,""               ,0,0,0},
// { 0 ,""               ,0,0,0},
// { 0 ,""               ,0,0,0},
// { 0 ,""               ,0,0,0},
// { 0 ,""               ,0,0,0},
// { 0 ,""               ,0,0,0},
// 
// },{
// 
// // Japanese (hiragana)
// 
// { 0 ,""               ,0,0,0},
// {"あ","ぁ"            ,1,0,0},
// {"い","ぃ"            ,1,0,0},
// {"う","ぅゔ"          ,1,0,0},
// {"え","ぇ"            ,1,0,0},
// {"お","ぉ"            ,1,0,0},
// {"か","ゕが"          ,0,1,0},
// {"き","ぎ"            ,0,1,0},
// {"く","ぐ"            ,0,1,0},
// {"け","ゖげ"          ,0,1,0},
// {"こ","ご"            ,0,1,0},
// {"さ","ざ"            ,0,1,0},
// {"し","じ"            ,0,1,0},
// {"す","ず"            ,0,1,0},
// {"せ","ぜ"            ,0,1,0},
// {"そ","ぞ"            ,0,1,0},
// {"た","だ"            ,0,1,0},
// {"ち","ぢ"            ,0,1,0},
// {"つ","っづ"          ,0,1,0},
// {"て","で"            ,0,1,0},
// {"と","ど"            ,0,1,0},
// {"な",""              ,0,1,0},
// {"に",""              ,0,1,0},
// {"ぬ",""              ,0,1,0},
// {"ね",""              ,0,1,0},
// {"の",""              ,0,1,0},
// {"は","ばぱ"          ,0,1,0},
// {"ひ","びぴ"          ,0,1,0},
// {"ふ","ぶぷ"          ,0,1,0},
// {"へ","べぺ"          ,0,1,0},
// {"ほ","ぼぽ"          ,0,1,0},
// {"ま",""              ,0,1,0},
// {"み",""              ,0,1,0},
// {"む",""              ,0,1,0},
// {"め",""              ,0,1,0},
// {"も",""              ,0,1,0},
// {"や","ゃ"            ,0,1,0},
// {"ゆ","ゅ"            ,0,1,0},
// {"よ","ょ"            ,0,1,0},
// {"ら",""              ,0,1,0},
// {"り",""              ,0,1,0},
// {"る",""              ,0,1,0},
// {"れ",""              ,0,1,0},
// {"ろ",""              ,0,1,0},
// {"わ","ゎ"            ,0,1,0},
// {"ゐ",""              ,0,1,0},
// {"ゑ",""              ,0,1,0},
// {"を",""              ,0,1,0},
// {"ん",""              ,0,1,0},
// {"ー","ｰ"             ,0,0,0},
// { 0 ,""               ,0,0,0},
// { 0 ,""               ,0,0,0},
// { 0 ,""               ,0,0,0},
// { 0 ,""               ,0,0,0},
// { 0 ,""               ,0,0,0},
// { 0 ,""               ,0,0,0},
// { 0 ,""               ,0,0,0},
// { 0 ,""               ,0,0,0},
// { 0 ,""               ,0,0,0},
// { 0 ,""               ,0,0,0},
// { 0 ,""               ,0,0,0},
// 
// },{

// Polish

{ 0 ,""               ,0,0,0},  //  0 always unused
{"A","aÀáÁàâÂåÅäÄãÃ"  ,1,0,1},
{"Ą","ą"              ,1,0,1},
{"B","b"              ,0,1,1},
{"C","cçÇ"            ,0,1,1},
{"Ć","ć"              ,0,1,1},
{"D","d"              ,0,1,1},
{"E","eæÆœŒéÉèÈêÊëË"  ,1,0,1},
{"Ę","ę"              ,1,0,1},
{"F","f"              ,0,1,1},
{"G","g"              ,0,1,1},
{"H","h"              ,0,1,1},
{"I","iíÍìÌîÎïÏ"      ,1,0,1},
{"J","j"              ,0,1,1},
{"K","k"              ,0,1,1},
{"L","l"              ,0,1,1},
{"Ł","ł"              ,0,1,1},
{"M","m"              ,0,1,1},
{"N","nñÑ"            ,0,1,1},
{"Ń","ń"              ,0,1,1},
{"O","oòÒôÔöÖõÕøØ"    ,1,0,1},
{"Ó","ó"              ,1,0,1},
{"P","p"              ,0,1,1},
{"Q","q"              ,0,1,1},
{"R","r"              ,0,1,1},
{"S","s"              ,0,1,1},
{"Ś","ś"              ,0,1,1},
{"T","t"              ,0,1,1},
{"U","uúÚùÙûÛüÜ"      ,1,0,1},
{"V","v"              ,0,1,1},
{"W","w"              ,0,1,1},
{"X","x"              ,0,1,1},
{"Y","yýÝÿ"           ,1,0,1},
{"Z","z"              ,0,1,1},
{"Ź","ź"              ,0,1,1},
{"Ż","ż"              ,0,1,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},

},{

// Romanian

{ 0 ,""               ,0,0,0},  //  0 always unused
{"A","aÀáÁàâÂåÅäÄãÃĂă",1,0,1},
{"B","b"              ,0,1,1},
{"C","cçÇ"            ,0,1,1},
{"D","d"              ,0,1,1},
{"E","eæÆœŒéÉèÈêÊëË"  ,1,0,1},
{"F","f"              ,0,1,1},
{"G","g"              ,0,1,1},
{"H","h"              ,0,1,1},
{"I","iíÍìÌîÎïÏ"      ,1,0,1},
{"J","j"              ,0,1,1},
{"K","k"              ,0,1,1},
{"L","l"              ,0,1,1},
{"M","m"              ,0,1,1},
{"N","nñÑ"            ,0,1,1},
{"O","oóÓòÒôÔöÖõÕøØ"  ,1,0,1},
{"P","p"              ,0,1,1},
{"Q","q"              ,0,1,1},
{"R","r"              ,0,1,1},
{"S","sȘŞșş"          ,0,1,1},
{"T","tȚŢțţ"          ,0,1,1},
{"U","uúÚùÙûÛüÜ"      ,1,0,1},
{"V","v"              ,0,1,1},
{"W","w"              ,0,1,1},
{"X","x"              ,0,1,1},
{"Y","yýÝÿ"           ,0,1,1},
{"Z","z"              ,0,1,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},

},{

// Russian

{ 0 ,""               ,0,0,0},  //  0 always unused
{"А","а"              ,1,0,1},
{"Б","б"              ,0,1,1},
{"В","в"              ,0,1,1},
{"Г","г"              ,0,1,1},
{"Д","д"              ,0,1,1},
{"Е","еЁё"            ,1,0,1},
{"Ж","ж"              ,0,1,1},
{"З","з"              ,0,1,1},
{"И","и"              ,1,0,1},
{"Й","й"              ,1,0,1},
{"К","к"              ,0,1,1},
{"Л","л"              ,0,1,1},
{"М","м"              ,0,1,1},
{"Н","н"              ,0,1,1},
{"О","о"              ,1,0,1},
{"П","п"              ,0,1,1},
{"Р","р"              ,0,1,1},
{"С","с"              ,0,1,1},
{"Т","т"              ,0,1,1},
{"У","у"              ,1,0,1},
{"Ф","ф"              ,0,1,1},
{"Х","х"              ,0,1,1},
{"Ц","ц"              ,0,1,1},
{"Ч","ч"              ,0,1,1},
{"Ш","ш"              ,0,1,1},
{"Щ","щ"              ,0,1,1},
{"Ъ","ъ"              ,0,1,1},
{"Ы","ы"              ,1,0,1},
{"Ь","ь"              ,0,1,1},
{"Э","э"              ,1,0,1},
{"Ю","ю"              ,1,0,1},
{"Я","я"              ,1,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},

},{

// Slovenian

{ 0 ,""               ,0,0,0},  //  0 always unused
{"A","aÀáÁàâÂåÅãÃ"    ,1,0,1},
{"B","b"              ,0,1,1},
{"C","cçÇ"            ,0,1,1},
{"Č","č"              ,0,1,1},
{"D","d"              ,0,1,1},
{"E","eæÆœŒéÉèÈêÊ"    ,1,0,1},
{"F","f"              ,0,1,1},
{"G","g"              ,0,1,1},
{"H","h"              ,0,1,1},
{"I","iíÍìÌîÎïÏ"      ,1,0,1},
{"J","j"              ,0,1,1},
{"K","k"              ,0,1,1},
{"L","l"              ,0,1,1},
{"M","m"              ,0,1,1},
{"N","nñÑ"            ,0,1,1},
{"O","oóÓòÒôÔõÕøØ"    ,1,0,1},
{"P","p"              ,0,1,1},
{"Q","q"              ,0,1,1},
{"R","r"              ,0,1,1},
{"S","s"              ,0,1,1},
{"Š","š"              ,0,1,1},
{"T","t"              ,0,1,1},
{"U","uúÚùÙûÛ"        ,1,0,1},
{"V","v"              ,0,1,1},
{"W","w"              ,0,1,1},
{"X","x"              ,0,1,1},
{"Y","yýÝÿ"           ,0,1,1},
{"Z","z"              ,0,1,1},
{"Ž","ž"              ,0,1,0},
{"Ä","ä"              ,1,0,0},
{"Ć","ć"              ,0,1,0},
{"Đ","đ"              ,0,1,0},
{"Ë","ë"              ,1,0,0},
{"Ö","ö"              ,1,0,0},
{"Ü","ü"              ,1,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},

},{

// Spanish

{ 0 ,""               ,0,0,0},  //  0 always unused
{"A","aÀáÁàâÂåÅäÄãÃ"  ,1,0,1},
{"B","b"              ,0,1,1},
{"C","cçÇ"            ,0,1,1},
{"D","d"              ,0,1,1},
{"E","eæÆœŒéÉèÈêÊëË"  ,1,0,1},
{"F","f"              ,0,1,1},
{"G","g"              ,0,1,1},
{"H","h"              ,0,1,1},
{"I","iíÍìÌîÎïÏ"      ,1,0,1},
{"J","j"              ,0,1,1},
{"K","k"              ,0,1,1},
{"L","l"              ,0,1,1},
{"M","m"              ,0,1,1},
{"N","n"              ,0,1,1},
{"Ñ","ñ"              ,0,1,1},
{"O","oóÓòÒôÔöÖõÕøØ"  ,1,0,1},
{"P","p"              ,0,1,1},
{"Q","q"              ,0,1,1},
{"R","r"              ,0,1,1},
{"S","s"              ,0,1,1},
{"T","t"              ,0,1,1},
{"U","uúÚùÙûÛüÜ"      ,1,0,1},
{"V","v"              ,0,1,1},
{"W","w"              ,0,1,1},
{"X","x"              ,0,1,1},
{"Y","yýÝ"            ,0,1,1},
{"Z","z"              ,0,1,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},

},{

// Swedish

{ 0 ,""               ,0,0,0},  //  0 always unused
{"A","aÀáÁàâÂãÃ"      ,1,0,1},
{"B","b"              ,0,1,1},
{"C","cçÇ"            ,0,1,1},
{"D","d"              ,0,1,1},
{"E","eæÆœŒéÉèÈêÊëË"  ,1,0,1},
{"F","f"              ,0,1,1},
{"G","g"              ,0,1,1},
{"H","h"              ,0,1,1},
{"I","iíÍìÌîÎïÏ"      ,1,0,1},
{"J","j"              ,0,1,1},
{"K","k"              ,0,1,1},
{"L","l"              ,0,1,1},
{"M","m"              ,0,1,1},
{"N","nñÑ"            ,0,1,1},
{"O","oóÓòÒôÔõÕøØ"    ,1,0,1},
{"P","p"              ,0,1,1},
{"Q","q"              ,0,1,1},
{"R","r"              ,0,1,1},
{"S","s"              ,0,1,1},
{"T","t"              ,0,1,1},
{"U","uúÚùÙûÛ"        ,1,0,1},
{"V","v"              ,0,1,1},
{"W","w"              ,0,1,1},
{"X","x"              ,0,1,1},
{"Y","yýÝÿüÜ"         ,1,0,1},
{"Z","z"              ,0,1,1},
{"Å","å"              ,1,0,1},
{"Ä","ä"              ,1,0,1},
{"Ö","ö"              ,1,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},

},{















// Empty

{ 0 ,""               ,0,0,0},  //  0 always unused
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},
{ 0 ,""               ,0,0,0},

}};
