% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mstl.R
\name{stlm}
\alias{stlm}
\title{Forecasting model using STL with a generative time series model}
\usage{
stlm(
  y,
  s.window = 7 + 4 * seq(6),
  t.window = NULL,
  robust = FALSE,
  method = c("ets", "arima"),
  modelfunction = NULL,
  model = NULL,
  etsmodel = "ZZN",
  lambda = NULL,
  biasadj = FALSE,
  xreg = NULL,
  allow.multiplicative.trend = FALSE,
  x = y,
  ...
)
}
\arguments{
\item{y}{a numeric vector or univariate time series of class \code{ts}}

\item{s.window}{Either the character string \code{"periodic"} or the span (in
lags) of the loess window for seasonal extraction.}

\item{t.window}{A number to control the smoothness of the trend. See
\code{\link[stats:stl]{stats::stl()}} for details.}

\item{robust}{If \code{TRUE}, robust fitting will used in the loess
procedure within \code{\link[stats:stl]{stats::stl()}}.}

\item{method}{Method to use for forecasting the seasonally adjusted series.}

\item{modelfunction}{An alternative way of specifying the function for
modelling the seasonally adjusted series. If \code{modelfunction} is not
\code{NULL}, then \code{method} is ignored. Otherwise \code{method} is used
to specify the time series model to be used.}

\item{model}{Output from a previous call to \code{stlm}. If a \code{stlm}
model is passed, this same model is fitted to y without re-estimating any
parameters.}

\item{etsmodel}{The ets model specification passed to
\code{\link[=ets]{ets()}}. By default it allows any non-seasonal model. If
\code{method != "ets"}, this argument is ignored.}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda = "auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}

\item{biasadj}{Use adjusted back-transformed mean for Box-Cox
transformations. If transformed data is used to produce forecasts and fitted
values, a regular back transformation will result in median forecasts. If
biasadj is \code{TRUE}, an adjustment will be made to produce mean forecasts
and fitted values.}

\item{xreg}{Historical regressors to be used in
\code{\link[=auto.arima]{auto.arima()}} when \code{method = "arima"}.}

\item{allow.multiplicative.trend}{If \code{TRUE}, then ETS models with
multiplicative trends are allowed. Otherwise, only additive or no trend ETS
models are permitted.}

\item{x}{Deprecated. Included for backwards compatibility.}

\item{...}{Other arguments passed to \code{modelfunction}.}
}
\value{
An object of class \code{stlm}.
}
\description{
Forecasts of STL objects are obtained by applying a non-seasonal forecasting
model to the seasonally adjusted data and re-seasonalizing using the last
year of the seasonal component. \code{stlm} takes a time series \code{y}, applies an STL decomposition, and
models the seasonally adjusted data using the model passed as
\code{modelfunction} or specified using \code{method}. It returns an object
that includes the original STL decomposition and a time series model fitted
to the seasonally adjusted data. This object can be passed to the
\code{forecast.stlm} for forecasting.
}
\details{
The time series model for the seasonally adjusted data can be specified in
\code{stlm} using either \code{method} or \code{modelfunction}. The
\code{method} argument provides a shorthand way of specifying
\code{modelfunction} for a few special cases. More generally,
\code{modelfunction} can be any function with first argument a \code{ts}
object, that returns an object that can be passed to \code{\link[=forecast]{forecast()}}.
For example, \code{modelfunction = ar} uses the \code{\link[=ar]{ar()}} function
for modelling the seasonally adjusted series.
}
\examples{

tsmod <- stlm(USAccDeaths, modelfunction = ar)
forecast(tsmod, h = 36) |> autoplot()

decomp <- stl(USAccDeaths, s.window = "periodic")
forecast(decomp) |> autoplot()
}
\seealso{
\code{\link[stats:stl]{stats::stl()}}, \code{\link[=ets]{ets()}}, \code{\link[=Arima]{Arima()}}.
}
\author{
Rob J Hyndman
}
\keyword{ts}
