
<!-- README.md is generated from README.Rmd. Please edit that file -->

# gh

<!-- badges: start -->

[![R-CMD-check](https://github.com/r-lib/gh/workflows/R-CMD-check/badge.svg)](https://github.com/r-lib/gh/actions)
[![](https://www.r-pkg.org/badges/version/gh)](https://www.r-pkg.org/pkg/gh)
[![CRAN Posit mirror
downloads](https://cranlogs.r-pkg.org/badges/gh)](https://www.r-pkg.org/pkg/gh)
[![R-CMD-check](https://github.com/r-lib/gh/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/r-lib/gh/actions/workflows/R-CMD-check.yaml)
[![Codecov test
coverage](https://codecov.io/gh/r-lib/gh/graph/badge.svg)](https://app.codecov.io/gh/r-lib/gh)
<!-- badges: end -->

Minimalistic client to access GitHub’s
[REST](https://docs.github.com/rest) and
[GraphQL](https://docs.github.com/graphql) APIs.

## Installation and setup

Install the package from CRAN as usual:

``` r
install.packages("gh")
```

Install the development version from GitHub:

``` r
pak::pak("r-lib/gh")
```

### Authentication

The value returned by `gh::gh_token()` is used as Personal Access Token
(PAT). A token is needed for some requests, and to help with rate
limiting. gh can use your regular git credentials in the git credential
store, via the gitcreds package. Use `gitcreds::gitcreds_set()` to put a
PAT into the git credential store. If you cannot use the credential
store, set the `GITHUB_PAT` environment variable to your PAT. See the
details in the `?gh::gh_token` manual page and the manual of the
gitcreds package.

### API URL

-   The `GITHUB_API_URL` environment variable, if set, is used for the
    default github api url.

## Usage

``` r
library(gh)
```

Use the `gh()` function to access all API endpoints. The endpoints are
listed in the [documentation](https://docs.github.com/rest).

The first argument of `gh()` is the endpoint. You can just copy and
paste the API endpoints from the documentation. Note that the leading
slash must be included as well.

From
<https://docs.github.com/rest/reference/repos#list-repositories-for-a-user>
you can copy and paste `GET /users/{username}/repos` into your `gh()`
call. E.g.

``` r
my_repos <- gh("GET /users/{username}/repos", username = "gaborcsardi")
vapply(my_repos, "[[", "", "name")
#>  [1] "after"                "alda"                 "alexr"               
#>  [4] "all.primer.tutorials" "altlist"              "anticlust"           
#>  [7] "argufy"               "ask"                  "async"               
#> [10] "autobrew-bundler"     "available-work"       "baguette"            
#> [13] "BCEA"                 "BH"                   "bigrquerystorage"    
#> [16] "brew-big-sur"         "brokenPackage"        "brulee"              
#> [19] "build-r-app"          "butcher"              "censored"            
#> [22] "cf-tunnel"            "checkinstall"         "cli"                 
#> [25] "clock"                "comments"             "covr"                
#> [28] "covrlabs"             "cran-metadata"        "csg"
```

The JSON result sent by the API is converted to an R object.

Parameters can be passed as extra arguments. E.g.

``` r
my_repos <- gh(
  "/users/{username}/repos",
  username = "gaborcsardi",
  sort = "created")
vapply(my_repos, "[[", "", "name")
#>  [1] "phantomjs"       "FSA"             "greta"           "webdriver"      
#>  [5] "clock"           "testthat"        "jsonlite"        "duckdb"         
#>  [9] "duckdb-r"        "httpuv"          "unwind"          "httr2"          
#> [13] "pins-r"          "install-figlet"  "weird-package"   "anticlust"      
#> [17] "nanoparquet-cli" "cf-tunnel"       "myweek"          "figlet"         
#> [21] "evercran"        "available-work"  "r-shell"         "Rcpp"           
#> [25] "openssl"         "openbsd-vm"      "cran-metadata"   "run-r-app"      
#> [29] "build-r-app"     "comments"
```

### POST, PATCH, PUT and DELETE requests

POST, PATCH, PUT, and DELETE requests can be sent by including the HTTP
verb before the endpoint, in the first argument. E.g. to create a
repository:

``` r
new_repo <- gh("POST /user/repos", name = "my-new-repo-for-gh-testing")
```

and then delete it:

``` r
gh("DELETE /repos/{owner}/{repo}", owner = "gaborcsardi",
   repo = "my-new-repo-for-gh-testing")
```

### Tokens

By default the `GITHUB_PAT` environment variable is used. Alternatively,
one can set the `.token` argument of `gh()`.

### Pagination

Supply the `page` parameter to get subsequent pages:

``` r
my_repos2 <- gh("GET /orgs/{org}/repos", org = "r-lib", page = 2)
vapply(my_repos2, "[[", "", "name")
#>  [1] "desc"        "profvis"     "sodium"      "gargle"      "remotes"    
#>  [6] "jose"        "backports"   "rcmdcheck"   "vdiffr"      "callr"      
#> [11] "mockery"     "here"        "revdepcheck" "processx"    "vctrs"      
#> [16] "debugme"     "usethis"     "rlang"       "pkgload"     "httrmock"   
#> [21] "pkgbuild"    "prettycode"  "roxygen2md"  "pkgapi"      "zeallot"    
#> [26] "liteq"       "keyring"     "sloop"       "styler"      "ansistrings"
```

## Environment Variables

-   The `GITHUB_API_URL` environment variable is used for the default
    github api url.
-   The `GITHUB_PAT` and `GITHUB_TOKEN` environment variables are used,
    if set, in this order, as default token. Consider using the git
    credential store instead, see `?gh::gh_token`.

## Code of Conduct

Please note that the gh project is released with a [Contributor Code of
Conduct](https://gh.r-lib.org/CODE_OF_CONDUCT.html). By contributing to
this project, you agree to abide by its terms.

## License

MIT © Gábor Csárdi, Jennifer Bryan, Hadley Wickham
