//
// Copyright 2022 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//go:build e2e

package main

import (
	"testing"

	e2eutil "github.com/sigstore/rekor/pkg/util/e2eutil"
)

func TestVerifyNonExistentIndex(t *testing.T) {
	// this index is extremely likely to not exist
	out := e2eutil.RunCliErr(t, "verify", "--log-index", "100000000")
	e2eutil.OutputContains(t, out, "entry in log cannot be located")
}
