/*
 * $Header: /home/harald/repos/remotetea.sf.net/remotetea/src/tests/org/acplt/oncrpc/BroadcastClientTest.java,v 1.2 2003/08/14 08:16:10 haraldalbrecht Exp $
 *
 * Copyright (c) 1999, 2000
 * Lehrstuhl fuer Prozessleittechnik (PLT), RWTH Aachen
 * D-52064 Aachen, Germany.
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program (see the file LICENSE.txt for more
 * details); if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 */

package tests.org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;

import org.acplt.oncrpc.OncRpcBroadcastEvent;
import org.acplt.oncrpc.OncRpcBroadcastListener;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcUdpClient;
import org.acplt.oncrpc.XdrVoid;

public class BroadcastClientTest implements OncRpcBroadcastListener {

    //
    // List of addresses of portmappers that replied to our call...
    //
    List<InetAddress> portmappers = new LinkedList<InetAddress>();

    //
    // Remember addresses of replies for later processing. Please note
    // that you should not do any lengthy things (like DNS name lookups)
    // in this event handler, as you will otherwise miss some incomming
    // replies because the OS will drop them.
    //
    public void replyReceived(OncRpcBroadcastEvent evt) {
	/*
	 * Let's just add the reply address to the list of
	 * portmappers.
	 */
        this.portmappers.add(evt.getReplyAddress());
    }

    public void testBroadcastCall() {

        //
        // Create a portmap client object, which can then be used to contact
        // the local ONC/RPC ServerTest test server.
        //
        OncRpcUdpClient client = null;
        
	try {
	    client = new OncRpcUdpClient(InetAddress.getByName("255.255.255.255"),
                                100000, 2, 111);
    
	    //
	    // Ping all portmappers in this subnet...
	    //
	    System.out.print("pinging portmappers in subnet: ");

	    /*
	     * For test reasons the timeout is set to one second.
	     * Within a test scenario it is expected that availble
	     * portmappers will respond within a time frame less
	     * than one second.
	     */
	    client.setTimeout(1000);
	    try {
		client.broadcastCall(0,
			XdrVoid.XDR_VOID, XdrVoid.XDR_VOID,
			this);
		System.out.println("done.");
	    } catch ( OncRpcException e ) {
		System.out.format("broadcast call failed (%s):%n", e.getMessage());
		System.out.println(e);
		return;
	    }

	    /*
	     * Is there at least one portmapper
	     * in the list?
	     */
	    if (this.portmappers.size() > 0) {
		/*
		 * Let's print a list of the portmappers
		 * that gave a respond to the call.
		 */
		for (InetAddress portmapper : portmappers) {
		    System.out.format("Found: %s (%s)%n",
			    portmapper.getHostName(),
			    portmapper.getHostAddress());
		}
	    } else {
		System.out.println("No portmapper responded within the time frame of a second.");
	    }

	} catch (UnknownHostException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace(System.out);
	} catch (OncRpcException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace(System.out);
	} catch (IOException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace(System.out);
	} finally {
            //
            // Release resources bound by portmap client object as soon as possible
            // so might help the garbage wo/man. Yeah, this is now a political
            // correct comment.
            //
	    if (client != null) {
		try {
		    client.close();
		} catch (OncRpcException e) {
		    e.printStackTrace(System.out);
		}
		
		client = null;
	    }
	}
    }
    
}

// End of BroadcastClientTest.java