//! DO NOT EDIT! This file is generated by `xtask`.
//! Contains tests for the `event!` macro.
#![deny(warnings)]
#![no_implicit_prelude]

extern crate tracing;

// We call all macros in this module with `no_implicit_prelude` to ensure they do not depend on the standard prelude.
#[cfg(target_arch = "wasm32")]
extern crate wasm_bindgen_test;

struct Disp {
    val: u64,
}

impl ::std::fmt::Display for Disp {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::std::write!(f, "Disp.val={val}", val = self.val)
    }
}

struct Deb {
    val: u64,
}

/// Manual implementation because otherwise `val` is unused.
impl ::std::fmt::Debug for Deb {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        f.debug_struct("Deb").field("val", &self.val).finish()
    }
}

struct Sub {
    field: u64,
}
#[cfg_attr(target_arch = "wasm32", wasm_bindgen_test::wasm_bindgen_test)]
#[test]
fn event() {
    const CONST_VAR: &str = "const-field";

    let var = true;
    let sub = Sub { field: 4, };
    let disp = Disp { val: 61, };
    let deb = Deb { val: 102, };

    tracing::event!(target: "my::module", tracing::Level::INFO, ident = 3); // DEBUG:event,t,-,-,-,"ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = 3); // DEBUG:event,t,-,p,-,"ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = 3, qux = 3); // DEBUG:event,t,-,f,-,"ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = 3, qux = 3); // DEBUG:event,t,-,pf,-,"ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = 3, "msg without args"); // DEBUG:event,t,-,-,m,"ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = 3, "msg without args"); // DEBUG:event,t,-,p,m,"ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = 3, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = 3, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = 3 }, "msg without args"); // DEBUG:event,t,{},-,m,"ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = 3 }, "msg without args"); // DEBUG:event,t,{},p,m,"ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = false); // DEBUG:event,t,-,-,-,"ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = false); // DEBUG:event,t,-,p,-,"ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = false, qux = 3); // DEBUG:event,t,-,f,-,"ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = false, qux = 3); // DEBUG:event,t,-,pf,-,"ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = false, "msg without args"); // DEBUG:event,t,-,-,m,"ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = false, "msg without args"); // DEBUG:event,t,-,p,m,"ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = false, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = false, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = false }, "msg without args"); // DEBUG:event,t,{},-,m,"ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = false }, "msg without args"); // DEBUG:event,t,{},p,m,"ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = false, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = false, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = false, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = false, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = ?3); // DEBUG:event,t,-,-,-,"ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = ?3); // DEBUG:event,t,-,p,-,"ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = ?3, qux = 3); // DEBUG:event,t,-,f,-,"ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = ?3, qux = 3); // DEBUG:event,t,-,pf,-,"ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = ?3, "msg without args"); // DEBUG:event,t,-,-,m,"ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = ?3, "msg without args"); // DEBUG:event,t,-,p,m,"ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = ?3, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = ?3, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = ?3 }, "msg without args"); // DEBUG:event,t,{},-,m,"ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = ?3 }, "msg without args"); // DEBUG:event,t,{},p,m,"ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = %3); // DEBUG:event,t,-,-,-,"ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = %3); // DEBUG:event,t,-,p,-,"ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = %3, qux = 3); // DEBUG:event,t,-,f,-,"ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = %3, qux = 3); // DEBUG:event,t,-,pf,-,"ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = %3, "msg without args"); // DEBUG:event,t,-,-,m,"ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = %3, "msg without args"); // DEBUG:event,t,-,p,m,"ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = %3, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = %3, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = %3 }, "msg without args"); // DEBUG:event,t,{},-,m,"ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = %3 }, "msg without args"); // DEBUG:event,t,{},p,m,"ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = ?deb); // DEBUG:event,t,-,-,-,"ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = ?deb); // DEBUG:event,t,-,p,-,"ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = ?deb, qux = 3); // DEBUG:event,t,-,f,-,"ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = ?deb, qux = 3); // DEBUG:event,t,-,pf,-,"ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = ?deb, "msg without args"); // DEBUG:event,t,-,-,m,"ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = ?deb, "msg without args"); // DEBUG:event,t,-,p,m,"ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = ?deb }, "msg without args"); // DEBUG:event,t,{},-,m,"ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = ?deb }, "msg without args"); // DEBUG:event,t,{},p,m,"ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = %disp); // DEBUG:event,t,-,-,-,"ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = %disp); // DEBUG:event,t,-,p,-,"ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = %disp, qux = 3); // DEBUG:event,t,-,f,-,"ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = %disp, qux = 3); // DEBUG:event,t,-,pf,-,"ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = %disp, "msg without args"); // DEBUG:event,t,-,-,m,"ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = %disp, "msg without args"); // DEBUG:event,t,-,p,m,"ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = %disp, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = %disp, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = %disp }, "msg without args"); // DEBUG:event,t,{},-,m,"ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = %disp }, "msg without args"); // DEBUG:event,t,{},p,m,"ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = ?sub.field); // DEBUG:event,t,-,-,-,"ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = ?sub.field); // DEBUG:event,t,-,p,-,"ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = ?sub.field, qux = 3); // DEBUG:event,t,-,f,-,"ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3); // DEBUG:event,t,-,pf,-,"ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = ?sub.field, "msg without args"); // DEBUG:event,t,-,-,m,"ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = ?sub.field, "msg without args"); // DEBUG:event,t,-,p,m,"ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = ?sub.field }, "msg without args"); // DEBUG:event,t,{},-,m,"ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = ?sub.field }, "msg without args"); // DEBUG:event,t,{},p,m,"ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = %sub.field); // DEBUG:event,t,-,-,-,"ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = %sub.field); // DEBUG:event,t,-,p,-,"ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = %sub.field, qux = 3); // DEBUG:event,t,-,f,-,"ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3); // DEBUG:event,t,-,pf,-,"ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = %sub.field, "msg without args"); // DEBUG:event,t,-,-,m,"ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = %sub.field, "msg without args"); // DEBUG:event,t,-,p,m,"ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = %sub.field }, "msg without args"); // DEBUG:event,t,{},-,m,"ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = %sub.field }, "msg without args"); // DEBUG:event,t,{},p,m,"ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = debug(&deb)); // DEBUG:event,t,-,-,-,"ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = debug(&deb)); // DEBUG:event,t,-,p,-,"ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = debug(&deb), qux = 3); // DEBUG:event,t,-,f,-,"ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3); // DEBUG:event,t,-,pf,-,"ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = debug(&deb), "msg without args"); // DEBUG:event,t,-,-,m,"ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = debug(&deb), "msg without args"); // DEBUG:event,t,-,p,m,"ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = debug(&deb) }, "msg without args"); // DEBUG:event,t,{},-,m,"ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = debug(&deb) }, "msg without args"); // DEBUG:event,t,{},p,m,"ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = display(&disp)); // DEBUG:event,t,-,-,-,"ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = display(&disp)); // DEBUG:event,t,-,p,-,"ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = display(&disp), qux = 3); // DEBUG:event,t,-,f,-,"ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3); // DEBUG:event,t,-,pf,-,"ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = display(&disp), "msg without args"); // DEBUG:event,t,-,-,m,"ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = display(&disp), "msg without args"); // DEBUG:event,t,-,p,m,"ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = display(&disp) }, "msg without args"); // DEBUG:event,t,{},-,m,"ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = display(&disp) }, "msg without args"); // DEBUG:event,t,{},p,m,"ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = tracing::field::Empty); // DEBUG:event,t,-,-,-,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = tracing::field::Empty); // DEBUG:event,t,-,p,-,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = tracing::field::Empty, qux = 3); // DEBUG:event,t,-,f,-,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3); // DEBUG:event,t,-,pf,-,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = tracing::field::Empty, "msg without args"); // DEBUG:event,t,-,-,m,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = tracing::field::Empty, "msg without args"); // DEBUG:event,t,-,p,m,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,t,{},-,m,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,t,{},p,m,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = 3); // DEBUG:event,t,-,-,-,"dotted.ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = 3); // DEBUG:event,t,-,p,-,"dotted.ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = 3, qux = 3); // DEBUG:event,t,-,f,-,"dotted.ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3); // DEBUG:event,t,-,pf,-,"dotted.ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = 3, "msg without args"); // DEBUG:event,t,-,-,m,"dotted.ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = 3, "msg without args"); // DEBUG:event,t,-,p,m,"dotted.ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"dotted.ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"dotted.ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = 3 }, "msg without args"); // DEBUG:event,t,{},-,m,"dotted.ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = 3 }, "msg without args"); // DEBUG:event,t,{},p,m,"dotted.ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"dotted.ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"dotted.ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"dotted.ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"dotted.ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"dotted.ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"dotted.ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"dotted.ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"dotted.ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"dotted.ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"dotted.ident","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = false); // DEBUG:event,t,-,-,-,"dotted.ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = false); // DEBUG:event,t,-,p,-,"dotted.ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = false, qux = 3); // DEBUG:event,t,-,f,-,"dotted.ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3); // DEBUG:event,t,-,pf,-,"dotted.ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = false, "msg without args"); // DEBUG:event,t,-,-,m,"dotted.ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = false, "msg without args"); // DEBUG:event,t,-,p,m,"dotted.ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"dotted.ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"dotted.ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = false }, "msg without args"); // DEBUG:event,t,{},-,m,"dotted.ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = false }, "msg without args"); // DEBUG:event,t,{},p,m,"dotted.ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"dotted.ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"dotted.ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"dotted.ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"dotted.ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"dotted.ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"dotted.ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"dotted.ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"dotted.ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"dotted.ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"dotted.ident","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = ?3); // DEBUG:event,t,-,-,-,"dotted.ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?3); // DEBUG:event,t,-,p,-,"dotted.ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = ?3, qux = 3); // DEBUG:event,t,-,f,-,"dotted.ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3); // DEBUG:event,t,-,pf,-,"dotted.ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = ?3, "msg without args"); // DEBUG:event,t,-,-,m,"dotted.ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?3, "msg without args"); // DEBUG:event,t,-,p,m,"dotted.ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"dotted.ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"dotted.ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = ?3 }, "msg without args"); // DEBUG:event,t,{},-,m,"dotted.ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?3 }, "msg without args"); // DEBUG:event,t,{},p,m,"dotted.ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"dotted.ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"dotted.ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"dotted.ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"dotted.ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"dotted.ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"dotted.ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"dotted.ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"dotted.ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"dotted.ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"dotted.ident","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = %3); // DEBUG:event,t,-,-,-,"dotted.ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %3); // DEBUG:event,t,-,p,-,"dotted.ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = %3, qux = 3); // DEBUG:event,t,-,f,-,"dotted.ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3); // DEBUG:event,t,-,pf,-,"dotted.ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = %3, "msg without args"); // DEBUG:event,t,-,-,m,"dotted.ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %3, "msg without args"); // DEBUG:event,t,-,p,m,"dotted.ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"dotted.ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"dotted.ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = %3 }, "msg without args"); // DEBUG:event,t,{},-,m,"dotted.ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %3 }, "msg without args"); // DEBUG:event,t,{},p,m,"dotted.ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"dotted.ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"dotted.ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"dotted.ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"dotted.ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"dotted.ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"dotted.ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"dotted.ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"dotted.ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"dotted.ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"dotted.ident","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = ?deb); // DEBUG:event,t,-,-,-,"dotted.ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?deb); // DEBUG:event,t,-,p,-,"dotted.ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = ?deb, qux = 3); // DEBUG:event,t,-,f,-,"dotted.ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3); // DEBUG:event,t,-,pf,-,"dotted.ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = ?deb, "msg without args"); // DEBUG:event,t,-,-,m,"dotted.ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?deb, "msg without args"); // DEBUG:event,t,-,p,m,"dotted.ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"dotted.ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"dotted.ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = ?deb }, "msg without args"); // DEBUG:event,t,{},-,m,"dotted.ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?deb }, "msg without args"); // DEBUG:event,t,{},p,m,"dotted.ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"dotted.ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"dotted.ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"dotted.ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"dotted.ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"dotted.ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"dotted.ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"dotted.ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"dotted.ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"dotted.ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"dotted.ident","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = %disp); // DEBUG:event,t,-,-,-,"dotted.ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %disp); // DEBUG:event,t,-,p,-,"dotted.ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = %disp, qux = 3); // DEBUG:event,t,-,f,-,"dotted.ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3); // DEBUG:event,t,-,pf,-,"dotted.ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = %disp, "msg without args"); // DEBUG:event,t,-,-,m,"dotted.ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %disp, "msg without args"); // DEBUG:event,t,-,p,m,"dotted.ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"dotted.ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"dotted.ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = %disp }, "msg without args"); // DEBUG:event,t,{},-,m,"dotted.ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %disp }, "msg without args"); // DEBUG:event,t,{},p,m,"dotted.ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"dotted.ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"dotted.ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"dotted.ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"dotted.ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"dotted.ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"dotted.ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"dotted.ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"dotted.ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"dotted.ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"dotted.ident","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = ?sub.field); // DEBUG:event,t,-,-,-,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?sub.field); // DEBUG:event,t,-,p,-,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3); // DEBUG:event,t,-,f,-,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3); // DEBUG:event,t,-,pf,-,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = ?sub.field, "msg without args"); // DEBUG:event,t,-,-,m,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, "msg without args"); // DEBUG:event,t,-,p,m,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = ?sub.field }, "msg without args"); // DEBUG:event,t,{},-,m,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field }, "msg without args"); // DEBUG:event,t,{},p,m,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"dotted.ident","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = %sub.field); // DEBUG:event,t,-,-,-,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %sub.field); // DEBUG:event,t,-,p,-,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = %sub.field, qux = 3); // DEBUG:event,t,-,f,-,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3); // DEBUG:event,t,-,pf,-,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = %sub.field, "msg without args"); // DEBUG:event,t,-,-,m,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %sub.field, "msg without args"); // DEBUG:event,t,-,p,m,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = %sub.field }, "msg without args"); // DEBUG:event,t,{},-,m,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %sub.field }, "msg without args"); // DEBUG:event,t,{},p,m,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"dotted.ident","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = debug(&deb)); // DEBUG:event,t,-,-,-,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = debug(&deb)); // DEBUG:event,t,-,p,-,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3); // DEBUG:event,t,-,f,-,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3); // DEBUG:event,t,-,pf,-,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = debug(&deb), "msg without args"); // DEBUG:event,t,-,-,m,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), "msg without args"); // DEBUG:event,t,-,p,m,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:event,t,{},-,m,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:event,t,{},p,m,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"dotted.ident","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = display(&disp)); // DEBUG:event,t,-,-,-,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = display(&disp)); // DEBUG:event,t,-,p,-,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = display(&disp), qux = 3); // DEBUG:event,t,-,f,-,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3); // DEBUG:event,t,-,pf,-,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = display(&disp), "msg without args"); // DEBUG:event,t,-,-,m,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = display(&disp), "msg without args"); // DEBUG:event,t,-,p,m,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = display(&disp) }, "msg without args"); // DEBUG:event,t,{},-,m,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = display(&disp) }, "msg without args"); // DEBUG:event,t,{},p,m,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"dotted.ident","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = tracing::field::Empty); // DEBUG:event,t,-,-,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty); // DEBUG:event,t,-,p,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:event,t,-,f,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:event,t,-,pf,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:event,t,-,-,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:event,t,-,p,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,t,{},-,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,t,{},p,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = 3); // DEBUG:event,t,-,-,-,"\"literal\"","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = 3); // DEBUG:event,t,-,p,-,"\"literal\"","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = 3, qux = 3); // DEBUG:event,t,-,f,-,"\"literal\"","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = 3, qux = 3); // DEBUG:event,t,-,pf,-,"\"literal\"","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = 3, "msg without args"); // DEBUG:event,t,-,-,m,"\"literal\"","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = 3, "msg without args"); // DEBUG:event,t,-,p,m,"\"literal\"","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = 3, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"\"literal\"","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = 3, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"\"literal\"","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = 3 }, "msg without args"); // DEBUG:event,t,{},-,m,"\"literal\"","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = 3 }, "msg without args"); // DEBUG:event,t,{},p,m,"\"literal\"","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"\"literal\"","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"\"literal\"","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"\"literal\"","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"\"literal\"","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"\"literal\"","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"\"literal\"","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"\"literal\"","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"\"literal\"","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"\"literal\"","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"\"literal\"","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = false); // DEBUG:event,t,-,-,-,"\"literal\"","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = false); // DEBUG:event,t,-,p,-,"\"literal\"","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = false, qux = 3); // DEBUG:event,t,-,f,-,"\"literal\"","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = false, qux = 3); // DEBUG:event,t,-,pf,-,"\"literal\"","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = false, "msg without args"); // DEBUG:event,t,-,-,m,"\"literal\"","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = false, "msg without args"); // DEBUG:event,t,-,p,m,"\"literal\"","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = false, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"\"literal\"","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = false, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"\"literal\"","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = false }, "msg without args"); // DEBUG:event,t,{},-,m,"\"literal\"","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = false }, "msg without args"); // DEBUG:event,t,{},p,m,"\"literal\"","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = false, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"\"literal\"","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = false, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"\"literal\"","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"\"literal\"","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"\"literal\"","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"\"literal\"","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"\"literal\"","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"\"literal\"","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"\"literal\"","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"\"literal\"","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"\"literal\"","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = ?3); // DEBUG:event,t,-,-,-,"\"literal\"","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?3); // DEBUG:event,t,-,p,-,"\"literal\"","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = ?3, qux = 3); // DEBUG:event,t,-,f,-,"\"literal\"","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3); // DEBUG:event,t,-,pf,-,"\"literal\"","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = ?3, "msg without args"); // DEBUG:event,t,-,-,m,"\"literal\"","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?3, "msg without args"); // DEBUG:event,t,-,p,m,"\"literal\"","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"\"literal\"","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"\"literal\"","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = ?3 }, "msg without args"); // DEBUG:event,t,{},-,m,"\"literal\"","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?3 }, "msg without args"); // DEBUG:event,t,{},p,m,"\"literal\"","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"\"literal\"","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"\"literal\"","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"\"literal\"","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"\"literal\"","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"\"literal\"","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"\"literal\"","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"\"literal\"","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"\"literal\"","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"\"literal\"","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"\"literal\"","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = %3); // DEBUG:event,t,-,-,-,"\"literal\"","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = %3); // DEBUG:event,t,-,p,-,"\"literal\"","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = %3, qux = 3); // DEBUG:event,t,-,f,-,"\"literal\"","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = %3, qux = 3); // DEBUG:event,t,-,pf,-,"\"literal\"","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = %3, "msg without args"); // DEBUG:event,t,-,-,m,"\"literal\"","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = %3, "msg without args"); // DEBUG:event,t,-,p,m,"\"literal\"","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = %3, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"\"literal\"","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = %3, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"\"literal\"","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = %3 }, "msg without args"); // DEBUG:event,t,{},-,m,"\"literal\"","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %3 }, "msg without args"); // DEBUG:event,t,{},p,m,"\"literal\"","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"\"literal\"","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"\"literal\"","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"\"literal\"","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"\"literal\"","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"\"literal\"","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"\"literal\"","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"\"literal\"","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"\"literal\"","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"\"literal\"","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"\"literal\"","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = ?deb); // DEBUG:event,t,-,-,-,"\"literal\"","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?deb); // DEBUG:event,t,-,p,-,"\"literal\"","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = ?deb, qux = 3); // DEBUG:event,t,-,f,-,"\"literal\"","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3); // DEBUG:event,t,-,pf,-,"\"literal\"","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = ?deb, "msg without args"); // DEBUG:event,t,-,-,m,"\"literal\"","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?deb, "msg without args"); // DEBUG:event,t,-,p,m,"\"literal\"","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"\"literal\"","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"\"literal\"","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = ?deb }, "msg without args"); // DEBUG:event,t,{},-,m,"\"literal\"","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?deb }, "msg without args"); // DEBUG:event,t,{},p,m,"\"literal\"","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"\"literal\"","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"\"literal\"","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"\"literal\"","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"\"literal\"","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"\"literal\"","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"\"literal\"","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"\"literal\"","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"\"literal\"","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"\"literal\"","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"\"literal\"","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = %disp); // DEBUG:event,t,-,-,-,"\"literal\"","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = %disp); // DEBUG:event,t,-,p,-,"\"literal\"","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = %disp, qux = 3); // DEBUG:event,t,-,f,-,"\"literal\"","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3); // DEBUG:event,t,-,pf,-,"\"literal\"","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = %disp, "msg without args"); // DEBUG:event,t,-,-,m,"\"literal\"","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = %disp, "msg without args"); // DEBUG:event,t,-,p,m,"\"literal\"","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"\"literal\"","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"\"literal\"","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = %disp }, "msg without args"); // DEBUG:event,t,{},-,m,"\"literal\"","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %disp }, "msg without args"); // DEBUG:event,t,{},p,m,"\"literal\"","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"\"literal\"","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"\"literal\"","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"\"literal\"","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"\"literal\"","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"\"literal\"","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"\"literal\"","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"\"literal\"","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"\"literal\"","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"\"literal\"","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"\"literal\"","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = ?sub.field); // DEBUG:event,t,-,-,-,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?sub.field); // DEBUG:event,t,-,p,-,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = ?sub.field, qux = 3); // DEBUG:event,t,-,f,-,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3); // DEBUG:event,t,-,pf,-,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = ?sub.field, "msg without args"); // DEBUG:event,t,-,-,m,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?sub.field, "msg without args"); // DEBUG:event,t,-,p,m,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = ?sub.field }, "msg without args"); // DEBUG:event,t,{},-,m,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?sub.field }, "msg without args"); // DEBUG:event,t,{},p,m,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"\"literal\"","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = %sub.field); // DEBUG:event,t,-,-,-,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = %sub.field); // DEBUG:event,t,-,p,-,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = %sub.field, qux = 3); // DEBUG:event,t,-,f,-,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3); // DEBUG:event,t,-,pf,-,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = %sub.field, "msg without args"); // DEBUG:event,t,-,-,m,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = %sub.field, "msg without args"); // DEBUG:event,t,-,p,m,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = %sub.field }, "msg without args"); // DEBUG:event,t,{},-,m,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %sub.field }, "msg without args"); // DEBUG:event,t,{},p,m,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"\"literal\"","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = debug(&deb)); // DEBUG:event,t,-,-,-,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = debug(&deb)); // DEBUG:event,t,-,p,-,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = debug(&deb), qux = 3); // DEBUG:event,t,-,f,-,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3); // DEBUG:event,t,-,pf,-,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = debug(&deb), "msg without args"); // DEBUG:event,t,-,-,m,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = debug(&deb), "msg without args"); // DEBUG:event,t,-,p,m,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = debug(&deb) }, "msg without args"); // DEBUG:event,t,{},-,m,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = debug(&deb) }, "msg without args"); // DEBUG:event,t,{},p,m,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"\"literal\"","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = display(&disp)); // DEBUG:event,t,-,-,-,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = display(&disp)); // DEBUG:event,t,-,p,-,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = display(&disp), qux = 3); // DEBUG:event,t,-,f,-,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3); // DEBUG:event,t,-,pf,-,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = display(&disp), "msg without args"); // DEBUG:event,t,-,-,m,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = display(&disp), "msg without args"); // DEBUG:event,t,-,p,m,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = display(&disp) }, "msg without args"); // DEBUG:event,t,{},-,m,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = display(&disp) }, "msg without args"); // DEBUG:event,t,{},p,m,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"\"literal\"","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = tracing::field::Empty); // DEBUG:event,t,-,-,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty); // DEBUG:event,t,-,p,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3); // DEBUG:event,t,-,f,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3); // DEBUG:event,t,-,pf,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:event,t,-,-,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:event,t,-,p,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:event,t,{},-,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:event,t,{},p,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = 3); // DEBUG:event,t,-,-,-,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = 3); // DEBUG:event,t,-,p,-,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = 3, qux = 3); // DEBUG:event,t,-,f,-,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3); // DEBUG:event,t,-,pf,-,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = 3, "msg without args"); // DEBUG:event,t,-,-,m,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = 3, "msg without args"); // DEBUG:event,t,-,p,m,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = 3 }, "msg without args"); // DEBUG:event,t,{},-,m,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = 3 }, "msg without args"); // DEBUG:event,t,{},p,m,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"{ CONST_VAR }","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = false); // DEBUG:event,t,-,-,-,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = false); // DEBUG:event,t,-,p,-,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = false, qux = 3); // DEBUG:event,t,-,f,-,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3); // DEBUG:event,t,-,pf,-,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = false, "msg without args"); // DEBUG:event,t,-,-,m,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = false, "msg without args"); // DEBUG:event,t,-,p,m,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = false }, "msg without args"); // DEBUG:event,t,{},-,m,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = false }, "msg without args"); // DEBUG:event,t,{},p,m,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"{ CONST_VAR }","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?3); // DEBUG:event,t,-,-,-,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?3); // DEBUG:event,t,-,p,-,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3); // DEBUG:event,t,-,f,-,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3); // DEBUG:event,t,-,pf,-,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?3, "msg without args"); // DEBUG:event,t,-,-,m,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, "msg without args"); // DEBUG:event,t,-,p,m,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:event,t,{},-,m,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:event,t,{},p,m,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"{ CONST_VAR }","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = %3); // DEBUG:event,t,-,-,-,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %3); // DEBUG:event,t,-,p,-,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = %3, qux = 3); // DEBUG:event,t,-,f,-,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3); // DEBUG:event,t,-,pf,-,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = %3, "msg without args"); // DEBUG:event,t,-,-,m,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %3, "msg without args"); // DEBUG:event,t,-,p,m,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %3 }, "msg without args"); // DEBUG:event,t,{},-,m,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %3 }, "msg without args"); // DEBUG:event,t,{},p,m,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"{ CONST_VAR }","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?deb); // DEBUG:event,t,-,-,-,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb); // DEBUG:event,t,-,p,-,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3); // DEBUG:event,t,-,f,-,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3); // DEBUG:event,t,-,pf,-,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:event,t,-,-,m,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:event,t,-,p,m,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:event,t,{},-,m,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:event,t,{},p,m,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"{ CONST_VAR }","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = %disp); // DEBUG:event,t,-,-,-,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %disp); // DEBUG:event,t,-,p,-,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3); // DEBUG:event,t,-,f,-,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3); // DEBUG:event,t,-,pf,-,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = %disp, "msg without args"); // DEBUG:event,t,-,-,m,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, "msg without args"); // DEBUG:event,t,-,p,m,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %disp }, "msg without args"); // DEBUG:event,t,{},-,m,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp }, "msg without args"); // DEBUG:event,t,{},p,m,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"{ CONST_VAR }","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?sub.field); // DEBUG:event,t,-,-,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field); // DEBUG:event,t,-,p,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:event,t,-,f,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:event,t,-,pf,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:event,t,-,-,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:event,t,-,p,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:event,t,{},-,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:event,t,{},p,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = %sub.field); // DEBUG:event,t,-,-,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field); // DEBUG:event,t,-,p,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:event,t,-,f,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:event,t,-,pf,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:event,t,-,-,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:event,t,-,p,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:event,t,{},-,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:event,t,{},p,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = debug(&deb)); // DEBUG:event,t,-,-,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb)); // DEBUG:event,t,-,p,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:event,t,-,f,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:event,t,-,pf,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:event,t,-,-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:event,t,-,p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:event,t,{},-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:event,t,{},p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = display(&disp)); // DEBUG:event,t,-,-,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp)); // DEBUG:event,t,-,p,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:event,t,-,f,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:event,t,-,pf,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:event,t,-,-,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:event,t,-,p,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:event,t,{},-,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:event,t,{},p,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty); // DEBUG:event,t,-,-,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty); // DEBUG:event,t,-,p,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:event,t,-,f,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:event,t,-,pf,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:event,t,-,-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:event,t,-,p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:event,t,{},-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:event,t,{},p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = 3); // DEBUG:event,t,-,-,-,"r#type","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = 3); // DEBUG:event,t,-,p,-,"r#type","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = 3, qux = 3); // DEBUG:event,t,-,f,-,"r#type","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = 3, qux = 3); // DEBUG:event,t,-,pf,-,"r#type","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = 3, "msg without args"); // DEBUG:event,t,-,-,m,"r#type","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = 3, "msg without args"); // DEBUG:event,t,-,p,m,"r#type","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = 3, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"r#type","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = 3, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"r#type","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = 3 }, "msg without args"); // DEBUG:event,t,{},-,m,"r#type","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = 3 }, "msg without args"); // DEBUG:event,t,{},p,m,"r#type","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = 3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"r#type","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = 3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"r#type","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"r#type","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"r#type","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"r#type","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"r#type","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"r#type","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"r#type","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"r#type","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"r#type","3"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = false); // DEBUG:event,t,-,-,-,"r#type","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = false); // DEBUG:event,t,-,p,-,"r#type","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = false, qux = 3); // DEBUG:event,t,-,f,-,"r#type","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = false, qux = 3); // DEBUG:event,t,-,pf,-,"r#type","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = false, "msg without args"); // DEBUG:event,t,-,-,m,"r#type","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = false, "msg without args"); // DEBUG:event,t,-,p,m,"r#type","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = false, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"r#type","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = false, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"r#type","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = false }, "msg without args"); // DEBUG:event,t,{},-,m,"r#type","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = false }, "msg without args"); // DEBUG:event,t,{},p,m,"r#type","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = false, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"r#type","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = false, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"r#type","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = false, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"r#type","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = false, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"r#type","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"r#type","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"r#type","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = false }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"r#type","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = false }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"r#type","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"r#type","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"r#type","false"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = ?3); // DEBUG:event,t,-,-,-,"r#type","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = ?3); // DEBUG:event,t,-,p,-,"r#type","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = ?3, qux = 3); // DEBUG:event,t,-,f,-,"r#type","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = ?3, qux = 3); // DEBUG:event,t,-,pf,-,"r#type","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = ?3, "msg without args"); // DEBUG:event,t,-,-,m,"r#type","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = ?3, "msg without args"); // DEBUG:event,t,-,p,m,"r#type","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = ?3, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"r#type","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = ?3, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"r#type","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = ?3 }, "msg without args"); // DEBUG:event,t,{},-,m,"r#type","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?3 }, "msg without args"); // DEBUG:event,t,{},p,m,"r#type","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"r#type","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"r#type","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"r#type","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"r#type","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"r#type","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"r#type","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"r#type","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"r#type","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"r#type","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"r#type","?3"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = %3); // DEBUG:event,t,-,-,-,"r#type","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = %3); // DEBUG:event,t,-,p,-,"r#type","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = %3, qux = 3); // DEBUG:event,t,-,f,-,"r#type","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = %3, qux = 3); // DEBUG:event,t,-,pf,-,"r#type","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = %3, "msg without args"); // DEBUG:event,t,-,-,m,"r#type","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = %3, "msg without args"); // DEBUG:event,t,-,p,m,"r#type","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = %3, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"r#type","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = %3, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"r#type","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = %3 }, "msg without args"); // DEBUG:event,t,{},-,m,"r#type","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = %3 }, "msg without args"); // DEBUG:event,t,{},p,m,"r#type","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = %3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"r#type","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = %3, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"r#type","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"r#type","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"r#type","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"r#type","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"r#type","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"r#type","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"r#type","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"r#type","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"r#type","%3"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = ?deb); // DEBUG:event,t,-,-,-,"r#type","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = ?deb); // DEBUG:event,t,-,p,-,"r#type","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = ?deb, qux = 3); // DEBUG:event,t,-,f,-,"r#type","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3); // DEBUG:event,t,-,pf,-,"r#type","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = ?deb, "msg without args"); // DEBUG:event,t,-,-,m,"r#type","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = ?deb, "msg without args"); // DEBUG:event,t,-,p,m,"r#type","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"r#type","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"r#type","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = ?deb }, "msg without args"); // DEBUG:event,t,{},-,m,"r#type","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?deb }, "msg without args"); // DEBUG:event,t,{},p,m,"r#type","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"r#type","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"r#type","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"r#type","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"r#type","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"r#type","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"r#type","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"r#type","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"r#type","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"r#type","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"r#type","?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = %disp); // DEBUG:event,t,-,-,-,"r#type","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = %disp); // DEBUG:event,t,-,p,-,"r#type","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = %disp, qux = 3); // DEBUG:event,t,-,f,-,"r#type","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = %disp, qux = 3); // DEBUG:event,t,-,pf,-,"r#type","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = %disp, "msg without args"); // DEBUG:event,t,-,-,m,"r#type","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = %disp, "msg without args"); // DEBUG:event,t,-,p,m,"r#type","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = %disp, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"r#type","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = %disp, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"r#type","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = %disp }, "msg without args"); // DEBUG:event,t,{},-,m,"r#type","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = %disp }, "msg without args"); // DEBUG:event,t,{},p,m,"r#type","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"r#type","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"r#type","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"r#type","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"r#type","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"r#type","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"r#type","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"r#type","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"r#type","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"r#type","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"r#type","%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = ?sub.field); // DEBUG:event,t,-,-,-,"r#type","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = ?sub.field); // DEBUG:event,t,-,p,-,"r#type","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = ?sub.field, qux = 3); // DEBUG:event,t,-,f,-,"r#type","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3); // DEBUG:event,t,-,pf,-,"r#type","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = ?sub.field, "msg without args"); // DEBUG:event,t,-,-,m,"r#type","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = ?sub.field, "msg without args"); // DEBUG:event,t,-,p,m,"r#type","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"r#type","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"r#type","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = ?sub.field }, "msg without args"); // DEBUG:event,t,{},-,m,"r#type","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?sub.field }, "msg without args"); // DEBUG:event,t,{},p,m,"r#type","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"r#type","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"r#type","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"r#type","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"r#type","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"r#type","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"r#type","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"r#type","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"r#type","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"r#type","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"r#type","?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = %sub.field); // DEBUG:event,t,-,-,-,"r#type","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = %sub.field); // DEBUG:event,t,-,p,-,"r#type","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = %sub.field, qux = 3); // DEBUG:event,t,-,f,-,"r#type","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3); // DEBUG:event,t,-,pf,-,"r#type","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = %sub.field, "msg without args"); // DEBUG:event,t,-,-,m,"r#type","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = %sub.field, "msg without args"); // DEBUG:event,t,-,p,m,"r#type","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"r#type","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"r#type","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = %sub.field }, "msg without args"); // DEBUG:event,t,{},-,m,"r#type","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = %sub.field }, "msg without args"); // DEBUG:event,t,{},p,m,"r#type","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"r#type","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"r#type","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"r#type","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"r#type","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"r#type","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"r#type","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"r#type","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"r#type","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"r#type","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"r#type","%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = debug(&deb)); // DEBUG:event,t,-,-,-,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = debug(&deb)); // DEBUG:event,t,-,p,-,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = debug(&deb), qux = 3); // DEBUG:event,t,-,f,-,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3); // DEBUG:event,t,-,pf,-,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = debug(&deb), "msg without args"); // DEBUG:event,t,-,-,m,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = debug(&deb), "msg without args"); // DEBUG:event,t,-,p,m,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = debug(&deb) }, "msg without args"); // DEBUG:event,t,{},-,m,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = debug(&deb) }, "msg without args"); // DEBUG:event,t,{},p,m,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"r#type","debug(&deb)"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = display(&disp)); // DEBUG:event,t,-,-,-,"r#type","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = display(&disp)); // DEBUG:event,t,-,p,-,"r#type","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = display(&disp), qux = 3); // DEBUG:event,t,-,f,-,"r#type","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3); // DEBUG:event,t,-,pf,-,"r#type","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = display(&disp), "msg without args"); // DEBUG:event,t,-,-,m,"r#type","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = display(&disp), "msg without args"); // DEBUG:event,t,-,p,m,"r#type","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"r#type","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"r#type","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = display(&disp) }, "msg without args"); // DEBUG:event,t,{},-,m,"r#type","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = display(&disp) }, "msg without args"); // DEBUG:event,t,{},p,m,"r#type","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"r#type","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"r#type","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"r#type","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"r#type","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"r#type","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"r#type","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"r#type","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"r#type","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"r#type","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"r#type","display(&disp)"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = tracing::field::Empty); // DEBUG:event,t,-,-,-,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = tracing::field::Empty); // DEBUG:event,t,-,p,-,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3); // DEBUG:event,t,-,f,-,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3); // DEBUG:event,t,-,pf,-,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = tracing::field::Empty, "msg without args"); // DEBUG:event,t,-,-,m,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, "msg without args"); // DEBUG:event,t,-,p,m,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = tracing::field::Empty }, "msg without args"); // DEBUG:event,t,{},-,m,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty }, "msg without args"); // DEBUG:event,t,{},p,m,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,"r#type","tracing::field::Empty"
    tracing::event!(target: "my::module", tracing::Level::INFO, var); // DEBUG:event,t,-,-,-,-,"var"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, var); // DEBUG:event,t,-,p,-,-,"var"
    tracing::event!(target: "my::module", tracing::Level::INFO, var, qux = 3); // DEBUG:event,t,-,f,-,-,"var"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, var, qux = 3); // DEBUG:event,t,-,pf,-,-,"var"
    tracing::event!(target: "my::module", tracing::Level::INFO, var, "msg without args"); // DEBUG:event,t,-,-,m,-,"var"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, var, "msg without args"); // DEBUG:event,t,-,p,m,-,"var"
    tracing::event!(target: "my::module", tracing::Level::INFO, var, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,-,"var"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, var, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,-,"var"
    tracing::event!(target: "my::module", tracing::Level::INFO, { var }, "msg without args"); // DEBUG:event,t,{},-,m,-,"var"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, var }, "msg without args"); // DEBUG:event,t,{},p,m,-,"var"
    tracing::event!(target: "my::module", tracing::Level::INFO, { var, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,-,"var"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, var, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,-,"var"
    tracing::event!(target: "my::module", tracing::Level::INFO, var, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,-,"var"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, var, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,-,"var"
    tracing::event!(target: "my::module", tracing::Level::INFO, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,-,"var"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,-,"var"
    tracing::event!(target: "my::module", tracing::Level::INFO, { var }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,-,"var"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, var }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,-,"var"
    tracing::event!(target: "my::module", tracing::Level::INFO, { var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,-,"var"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,-,"var"
    tracing::event!(target: "my::module", tracing::Level::INFO, sub.field); // DEBUG:event,t,-,-,-,-,"sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, sub.field); // DEBUG:event,t,-,p,-,-,"sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, sub.field, qux = 3); // DEBUG:event,t,-,f,-,-,"sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, sub.field, qux = 3); // DEBUG:event,t,-,pf,-,-,"sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, sub.field, "msg without args"); // DEBUG:event,t,-,-,m,-,"sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, sub.field, "msg without args"); // DEBUG:event,t,-,p,m,-,"sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,-,"sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,-,"sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { sub.field }, "msg without args"); // DEBUG:event,t,{},-,m,-,"sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, sub.field }, "msg without args"); // DEBUG:event,t,{},p,m,-,"sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,-,"sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,-,"sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,-,"sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,-,"sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,-,"sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,-,"sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,-,"sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,-,"sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,-,"sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,-,"sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, %disp); // DEBUG:event,t,-,-,-,-,"%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, %disp); // DEBUG:event,t,-,p,-,-,"%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, %disp, qux = 3); // DEBUG:event,t,-,f,-,-,"%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, %disp, qux = 3); // DEBUG:event,t,-,pf,-,-,"%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, %disp, "msg without args"); // DEBUG:event,t,-,-,m,-,"%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, %disp, "msg without args"); // DEBUG:event,t,-,p,m,-,"%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, %disp, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,-,"%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, %disp, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,-,"%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { %disp }, "msg without args"); // DEBUG:event,t,{},-,m,-,"%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, %disp }, "msg without args"); // DEBUG:event,t,{},p,m,-,"%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { %disp, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,-,"%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, %disp, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,-,"%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, %disp, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,-,"%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, %disp, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,-,"%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,-,"%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,-,"%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { %disp }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,-,"%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, %disp }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,-,"%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,-,"%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,-,"%disp"
    tracing::event!(target: "my::module", tracing::Level::INFO, ?deb); // DEBUG:event,t,-,-,-,-,"?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ?deb); // DEBUG:event,t,-,p,-,-,"?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, ?deb, qux = 3); // DEBUG:event,t,-,f,-,-,"?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ?deb, qux = 3); // DEBUG:event,t,-,pf,-,-,"?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, ?deb, "msg without args"); // DEBUG:event,t,-,-,m,-,"?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ?deb, "msg without args"); // DEBUG:event,t,-,p,m,-,"?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, ?deb, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,-,"?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ?deb, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,-,"?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ?deb }, "msg without args"); // DEBUG:event,t,{},-,m,-,"?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ?deb }, "msg without args"); // DEBUG:event,t,{},p,m,-,"?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ?deb, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,-,"?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ?deb, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,-,"?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, ?deb, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,-,"?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ?deb, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,-,"?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,-,"?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,-,"?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,-,"?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,-,"?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,-,"?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,-,"?deb"
    tracing::event!(target: "my::module", tracing::Level::INFO, %sub.field); // DEBUG:event,t,-,-,-,-,"%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, %sub.field); // DEBUG:event,t,-,p,-,-,"%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, %sub.field, qux = 3); // DEBUG:event,t,-,f,-,-,"%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, %sub.field, qux = 3); // DEBUG:event,t,-,pf,-,-,"%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, %sub.field, "msg without args"); // DEBUG:event,t,-,-,m,-,"%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, %sub.field, "msg without args"); // DEBUG:event,t,-,p,m,-,"%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, %sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,-,"%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, %sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,-,"%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { %sub.field }, "msg without args"); // DEBUG:event,t,{},-,m,-,"%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, %sub.field }, "msg without args"); // DEBUG:event,t,{},p,m,-,"%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,-,"%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,-,"%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,-,"%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,-,"%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,-,"%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,-,"%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,-,"%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,-,"%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,-,"%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,-,"%sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, ?sub.field); // DEBUG:event,t,-,-,-,-,"?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ?sub.field); // DEBUG:event,t,-,p,-,-,"?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, ?sub.field, qux = 3); // DEBUG:event,t,-,f,-,-,"?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ?sub.field, qux = 3); // DEBUG:event,t,-,pf,-,-,"?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, ?sub.field, "msg without args"); // DEBUG:event,t,-,-,m,-,"?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ?sub.field, "msg without args"); // DEBUG:event,t,-,p,m,-,"?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, ?sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,f,m,-,"?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ?sub.field, qux = 3, "msg without args"); // DEBUG:event,t,-,pf,m,-,"?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ?sub.field }, "msg without args"); // DEBUG:event,t,{},-,m,-,"?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ?sub.field }, "msg without args"); // DEBUG:event,t,{},p,m,-,"?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},f,m,-,"?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,t,{},pf,m,-,"?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,-,ma,-,"?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,t,-,p,ma,-,"?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,f,ma,-,"?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, foo = true, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,t,-,pf,ma,-,"?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},-,ma,-,"?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},p,ma,-,"?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},f,ma,-,"?sub.field"
    tracing::event!(target: "my::module", tracing::Level::INFO, { foo = true, ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,t,{},pf,ma,-,"?sub.field"
}
