#!/bin/bash
# bbou@ac-toulouse.fr
# 2004-09-26 18:28:27  
# precheck.sh

### P A R A M S

MYVERBOSE=
if [ "$1" == "-v" ];then
	export MYVERBOSE="-v"
	shift
fi

### I N C L U D E

. ./_include.sh

### S T A R T

echo "--------------------------------------------------------------------------------"
echo "PRECHECK"
echo "--------------------------------------------------------------------------------"

echo "+SYSTEM"
echo "${DISTRIBUTIONRELEASEINFO}"
echo distribution is ${DISTRIBUTION}
echo distribution tag is ${DISTRIBUTIONTAG}
echo "+CLIB"
echo C library is ${LIBC_VERSMAJ}

# P R I V I L E G E
echo "+PRIVILEGE"
echo User is $(whoami)
if [ ! $(whoami) = "root" ]; then
	echo "SADMS must be run as root"
	exit
fi

# S A M B A  L I B R A R I E S   A  N D   P A C K A G E S
./_check-samba.sh ${MYVERBOSE}
if [ ! $? = 0 ]; then
	echo "[FAIL] samba check failed" >&2
fi

# K E R B E R O S   L I B R A R I E S   A  N D   P A C K A G E S
./_check-kerberos.sh ${MYVERBOSE}
if [ ! $? = 0 ]; then
	echo "[FAIL] kerberos check failed" >&2
fi

# P A M _ M O U N T   L I B R A R I E S   A  N D   P A C K A G E S
./_check-pam_mount.sh ${MYVERBOSE}
if [ ! $? = 0 ]; then
	echo "[FAIL-PAM ONLY] pam_mount check failed"
fi

# R U N T I M E  D E P E N D E N C I E S
echo "+RUNTIME"
./sadms-deps.py
