#!/bin/bash
# bbou@ac-toulouse.fr
# 2006-04-15 08:52:24     
# conf/config-bugfix-pam.sh

### P A R A M S
# none

### I N C L U D E S
. ./_include.sh

### M O D I F I E D   F I L E S ...
logindefs=login.defs

### ... W I T H   A C C E S S
INST_UID=root
INST_GID=root
INST_MOD=644

### S T A R T

# D E B I A N : F I X   E X I S T I N G   L O G I N . D E F S
function fixDebian163635()
{
echo 'fix debian 163635'
grep '^CLOSE_SESSIONS[[:space:]]yes' ${ETCDIR}/${logindefs}
if [ "$?" != "0" ] ; then
echo "${ETCDIR}/${logindefs} must have CLOSE_SESSION yes"
awk 'BEGIN {
	FS=" ";
	}
	{
	if(match($0,"^CLOSE_SESSIONS"))
		print "CLOSE_SESSIONS yes"
	else
		print
	}' ${ETCDIR}/${logindefs} > ${TMPDIR}/${logindefs}
#cat ${TMPDIR}/${logindefs} | grep -v "^#" | grep -v "^$"

# I N S T A L L
echo install modified ${logindefs} to ${ETCDIR}
${INSTALL} -o ${INST_UID} -g ${INST_GID} -m ${INST_MOD} ${TMPDIR}/${logindefs} ${ETCDIR} > /dev/null

# C L E A N U P
rm -f ${TMPDIR}/${logindefs}
fi
}

function fixDebianFam()
{
	famservice=fam

	# service
	echo "${famservice}, the File Alteration Monitor, has to be stopped."
	echo "${famservice}, by keeping monitored files open, stops proper share unmounting on session exit."
	echo "+stop ${famservice}"
	if ${SERVICESTATUS} ${famservice} > /dev/null; then
		${SERVICE} ${famservice} stop > /dev/null
	fi

	# service autostart
	echo "+disable ${famservice} automatic startup"
	${SERVICEREMOVE} ${famservice} > /dev/null 2> /dev/null
}

# M A I N
echo "+fix bugs"

#  D I S T R I B U T I O N
case ${DISTRIBUTION} in
	Redhat)
		exit 0
		;;
	Fedora)
		exit 0
		;;
	Mandriva)
		exit 0
		;;
	Debian)
		fixDebian163635
		fixDebianFam
		exit 0
		;;
	Ubuntu)
		exit 0
		;;
	*)
		;;
esac
