/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_Undo.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2007/11/08
 * ====================================================================
 */
#ifndef __LIST_UNDO_H__
#define __LIST_UNDO_H__

//#include <>
#include "types.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */

#define CAD_DATA		1
#define DIMENSION_DATA	1
#define POLYLINE_DATA	1
#define BLOCK_DATA		1

#define CAD_NEW			11
#define CAD_DEL			12
#define CAD_EDIT		13
#define DIMENSION_NEW	21
#define DIMENSION_DEL	22
#define DIMENSION_EDIT	23
#define POLYLINE_NEW	31
#define POLYLINE_DEL	32
#define POLYLINE_EDIT	33
#define ELLIPSE_NEW		41
#define ELLIPSE_DEL		42
#define ELLIPSE_EDIT	43
#define INSERT_NEW		51
#define INSERT_DEL		52
#define INSERT_EDIT		53
#define BLOCK_NEW		61
#define BLOCK_DEL		62
#define BLOCK_EDIT		63



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef    _LIST_UNDO_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL	long	  Undo_index	GLOBAL_VAL(0);
	GLOBAL	long	  Undo_Now		GLOBAL_VAL(1);

	GLOBAL	UNDO_LIST *p_undo_list;
	GLOBAL	UNDO_LIST_INFO undo_list_info;
	GLOBAL	int *p_undo_list_type;
	GLOBAL	long *p_undo_list_index;


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef  _LIST_UNDO_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
/* Undo_index をインクリメントする */
void undo_index_plus(void);

/* Undo Data をリストの最初に追加 */
int undo_list_add_first(int type, LPDIAGRAM diagram_point, DIAGRAM diagram);
/* Redo を削除する */
void Redo_Delete(void);
/* 引数 index と同じ最初の Undo_index を探し,その Undo Buffer のポインタを返す */
UNDO_LIST *search_list_undo_start(long index);
/* 引数 index と同じ最後の Undo_index を探し,その Undo Buffer のポインタを返す */
UNDO_LIST *search_list_undo_end(long index);
/* Undo */
int Undo(void);
/* Redo */
int Redo(void);
void UndoRedo(UNDO_LIST *undo);

/* Undo Data をリストから削除 */
int undo_list_free(UNDO_LIST *del_List);
/* 全リストを削除 */
void undo_list_all_free(void);
/* Undo Data をリストの最後に追加 */
int undo_list_add_last(int type, CAD_LIST *add_cad, DIMENSION_LIST *add_dimension);

/* UNDO_LIST のデータ表示 */
void undo_list_log(void);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LIST_UNDO_H__ */



/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : List_Undo.h
 * ====================================================================
 */
