# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v6/odf_format.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: opendocument formatting, default opendocument template

=end
module SiSU_XML_ODF_ODT_Format
  require_relative 'param'                              # param.rb
    include SiSU_Param
  include SiSU_Viz
  class ParagraphNumber
    def initialize(make,paranum)
      @make=make
      @paranum=/(\d+)/m.match(paranum.to_s)[1]
    end
    def set_ref_and_display
      set_ref=@paranum.gsub(/(\d+)/,
        ' <text:span text:style-name="Span_subscript"><text:reference-mark-start text:name="\1"/><text:reference-mark-end text:name="\1"/></text:span>')
      disp=@paranum.gsub(/(\d+)/,
        (@make.build.odt_ocn?) \
        ? %{ <text:span text:style-name="Span_subscript">#{Dx[:ocn_o]}\\1#{Dx[:ocn_c]}</text:span>}
        : '')
      { display: disp, set_ref: set_ref }
    end
    def set_bookmark_and_display
      set_ref=@paranum.gsub(/(\d+)/,
        ' <text:span text:style-name="Span_subscript"><text:bookmark-start text:name="\1"/><text:bookmark-end text:name="\1"/></text:span>')
      disp=@paranum.gsub(/(\d+)/,
        (@make.build.odt_ocn?) \
        ? %{ <text:span text:style-name="Span_subscript">#{Dx[:ocn_o]}\\1#{Dx[:ocn_c]}</text:span>}
        : '')
      { display: disp, set_ref: set_ref }
    end
    def name
      @paranum.gsub(/(\d+)/,'<a name="\1"></a>')
    end
    def goto
      @paranum.gsub(/(\d+)/,'<a href="#\1">')
    end
  end
  class FormatBookIndex
    def initialize(idx_str)
      @idx_str=idx_str
    end
    def book_idx_bookmark
      map_nametags=SiSU_Particulars::CombinedSingleton.instance.get_map_nametags(@md).nametags_map #p map_nametags
      rgx_bookmark=/#{Mx[:lnk_o]}.+?#{Mx[:lnk_c]}#{Mx[:rel_o]}#?\S+?#{Mx[:rel_c]}/m
      while @idx_str =~/#{Mx[:lnk_o]}([^#{Mx[:lnk_o]}#{Mx[:lnk_c]}]+)#{Mx[:lnk_c]}#{Mx[:rel_o]}#?(\S+?)#{Mx[:rel_c]}/m
        link,url=$1,$2
        link,url=link.strip,url.strip
        @idx_str=@idx_str.gsub(/&/m,"&amp;")
        ocn_lnk=if map_nametags[url] \
        and map_nametags[url][:ocn]
          map_nametags[url][:ocn]
        else nil
        end
        ocn_lnk=(url=~/^\d+$/ ? url : ocn_lnk)
        if ocn_lnk and not ocn_lnk.empty?
          @idx_str=@idx_str.sub(/#{Mx[:fa_bold_o]}(.+?)#{Mx[:fa_bold_c]}/,
              '<text:span text:style-name="Span_bold">\1</text:span>').
            sub(rgx_bookmark,
              %{<text:bookmark-ref text:reference-format="text" text:ref-name="#{url}">#{link.strip}</text:bookmark-ref>})
        else
          puts %{name tag: "#{url}" not found}
          @idx_str.sub!(rgx_bookmark,"#{link}")
        end
      end
      @idx_str=@idx_str.gsub(/#{Xx[:protect]}/m,'').
        sub(/,\s*$/m,'').
        gsub(/\n/,'')
      @idx_str='<text:p text:style-name="P_normal">' + @idx_str + '</text:p>'
    end
  end
  class Tags
    def set_bookmark_tag(dob)
      tags=''
      if dob.tags.length > 0
        dob.tags.each do |tag|
          tags +=%{ <text:span text:style-name="Span_subscript"><text:bookmark-start text:name="#{tag}"/><text:bookmark-end text:name="#{tag}"/></text:span>}
        end
      end
      tags
    end
  end
  class FormatTextObject
    def initialize(md,t_o)
      @md,@t_o=md,t_o
      if t_o.is_a?(Hash)
        @txt =t_o[:txt]            || nil
      else
        p t_o.class
        p caller
      end
      rgx=/#{Mx[:en_a_o]}\d+\s+(.+?)#{Mx[:en_a_c]}/
      @txt=@txt.gsub(rgx,'\1') if @txt =~rgx
      @vz=SiSU_Viz::Defaults.new
    end
    def scr_endnote_body
      "<endnote>#{@txt}</endnote> "
    end
    def heading_body1
    end
    def heading_body2
    end
    def heading_body3
    end
    def heading_body4
    end
    def heading_body5
    end
    def heading_body6
    end
  end
  class Table
    @@tablehead,@@table_counter=0,0 #reinitialise on new file
    @@tablefoot=[] #watch
    @@fns=''
    def initialize(md,dob,p_num)
      @md,@dob,@p_num=md,dob,p_num
      @txt=dob.obj
      @vz=SiSU_Viz::Defaults.new
      if @md.fns != @@fns
        @@table_counter=0
        @@fns=@md.fns
      end
    end
    def break_line
      (@md.opt.act[:maintenance][:set]==:on) \
      ? "\n" : ''
    end
    def table_head_open(count)
      type=(@dob.head_) \
      ? 1
      : 2
      alpha=case @dob.cols
      when  1 then 'A'
      when  2 then 'B'
      when  3 then 'C'
      when  4 then 'D'
      when  5 then 'E'
      when  6 then 'F'
      when  7 then 'G'
      when  8 then 'H'
      when  9 then 'I'
      when 10 then 'J'
      when 11 then 'K'
      when 12 then 'L'
      when 13 then 'M'
      when 14 then 'N'
      else         'D'
      end
      tag=SiSU_XML_ODF_ODT_Format::Tags.new.set_bookmark_tag(@dob)
      %{<table:table table:name="Table#{count}" table:style-name="Table#{type}">#{@p_num[:set_ref]}#{tag}#{break_line}} +
      %{<table:table-column table:style-name="Table#{type}.#{alpha}" table:number-columns-repeated="#{@dob.cols}"/>#{break_line}}
    end
    def table_close(tablefoot='')
      '</table:table>' \
      + %{<text:p text:style-name="P_group">#{@p_num[:display]}</text:p>}
    end
    def table_tag_cell(str,i)
      txt_name_cell=if i==0 \
      and @dob.head_
        'Table_Heading'
      else 'P_table_cell'
      end
      str=str.gsub(/^~$/,'') # tilde / empty cell
      %{<table:table-cell office:value-type="string">#{break_line}} +
      %{<text:p text:style-name="#{txt_name_cell}">#{break_line}} +
      %{#{str}} +
      %{</text:p>#{break_line}} +
      %{</table:table-cell>#{break_line}}
    end
    def table_tag_row(str,i)
      %{<table:table-row>#{break_line}} +
      %{#{str}} +
      %{</table:table-row>#{break_line}}
    end
    def table_tag_row_dump(str,i)
      txt_name_row=if i==0 \
      and @dob.head_
        'Table_Heading'
      else 'P_table_cell'
      end
      %{<table:table-row>#{break_line}} +
      %{<table:table-cell office:value-type="string">#{break_line}} +
      %{<text:p text:style-name="#{txt_name_row}">#{break_line}} +
      %{#{str}} +
      %{</text:p>#{break_line}} +
      %{</table:table-cell>#{break_line}} +
      %{</table:table-row>#{break_line}}
    end
    def table_row(row,i)
      row='' if row =~/^<!$/
      m=row[/<!f(.+?)!>/,1]
      @@tablefoot << m if m
      row=row.gsub(/<!f.+?!>/,'')
      @cells=[]
      row.split(/\s*#{Mx[:tc_p]}/).each do |cell|
        @cells << table_tag_cell(cell,i)
      end
      row=@cells.join
      row=table_tag_row(row,i)
      row
    end
    def table
      @@table_counter+=1
      table_head_open(@@table_counter)
      @table=[]
      @dob.obj.split(/\s*#{Mx[:tc_c]}/).each_with_index do |r,i|
        @table << table_row(r,i)
      end
      @dob.obj= table_head_open(@@table_counter) + @table.join + table_close
      @dob
    end
  end
  class ODT_Head_1_2
    def initialize(md)
      @md=md
      @generator="#{@md.sisu_version[:project]} #{@md.sisu_version[:version]} #{@md.sisu_version[:date_stamp]} (#{@md.sisu_version[:date]})"
    end
    def manifest_rdf
      x=<<WOK
<?xml version="1.0" encoding="utf-8"?>
<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <rdf:Description rdf:about="styles.xml">
    <rdf:type rdf:resource="http://docs.oasis-open.org/ns/office/1.2/meta/odf#StylesFile"/>
  </rdf:Description>
  <rdf:Description rdf:about="">
    <ns0:hasPart xmlns:ns0="http://docs.oasis-open.org/ns/office/1.2/meta/pkg#" rdf:resource="styles.xml"/>
  </rdf:Description>
  <rdf:Description rdf:about="content.xml">
    <rdf:type rdf:resource="http://docs.oasis-open.org/ns/office/1.2/meta/odf#ContentFile"/>
  </rdf:Description>
  <rdf:Description rdf:about="">
    <ns0:hasPart xmlns:ns0="http://docs.oasis-open.org/ns/office/1.2/meta/pkg#" rdf:resource="content.xml"/>
  </rdf:Description>
  <rdf:Description rdf:about="">
    <rdf:type rdf:resource="http://docs.oasis-open.org/ns/office/1.2/meta/pkg#Document"/>
  </rdf:Description>
</rdf:RDF>
WOK
      x=x.strip
      x=x.gsub(/\n+/m,'') unless @md.opt.act[:maintenance][:set]==:on
      x
    end
    def meta_inf_manifest_xml(md)
      images=['  <manifest:file-entry manifest:media-type="" manifest:full-path="Pictures/bullet_09.png"/>']
      if md.ec[:image].length > 0
        md.ec[:image].each do |i|
          images<<<<WOK
  <manifest:file-entry manifest:media-type="" manifest:full-path="Pictures/#{i}"/>
WOK
        end
      end
      images=images.join('')
      x=<<WOK
<?xml version="1.0" encoding="UTF-8"?>
<manifest:manifest xmlns:manifest="urn:oasis:names:tc:opendocument:xmlns:manifest:1.0" manifest:version="1.2">
  <manifest:file-entry manifest:media-type="application/vnd.oasis.opendocument.text" manifest:version="1.2" manifest:full-path="/"/>
  <manifest:file-entry manifest:media-type="text/xml" manifest:full-path="styles.xml"/>
  <manifest:file-entry manifest:media-type="text/xml" manifest:full-path="content.xml"/>
  #{images}
  <manifest:file-entry manifest:media-type="text/xml" manifest:full-path="meta.xml"/>
  <manifest:file-entry manifest:media-type="application/rdf+xml" manifest:full-path="manifest.rdf"/>
  <manifest:file-entry manifest:media-type="image/png" manifest:full-path="Thumbnails/thumbnail.png"/>
  <manifest:file-entry manifest:media-type="application/binary" manifest:full-path="layout-cache"/>
  <manifest:file-entry manifest:media-type="text/xml" manifest:full-path="settings.xml"/>
  <manifest:file-entry manifest:media-type="" manifest:full-path="Configurations2/accelerator/current.xml"/>
  <manifest:file-entry manifest:media-type="application/vnd.sun.xml.ui.configuration" manifest:full-path="Configurations2/"/>
</manifest:manifest>
WOK
      x=x.strip
      x=x.gsub(/\n+/m,'') unless @md.opt.act[:maintenance][:set]==:on
      x
    end
    def meta_xml
      x=<<WOK
<?xml version="1.0" encoding="UTF-8"?>
<office:document-meta xmlns:office="urn:oasis:names:tc:opendocument:xmlns:office:1.0" xmlns:xl="http://www.w3.org/1999/xlink" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:meta="urn:oasis:names:tc:opendocument:xmlns:meta:1.0" xmlns:ooo="http://openoffice.org/2004/office" xmlns:grddl="http://www.w3.org/2003/g/data-view#" office:version="1.2">
  <office:meta>
    <meta:generator>#{@generator}</meta:generator>
    <meta:creation-date>#{@md.generated}</meta:creation-date>
    <dc:date>#{@md.generated}</dc:date>
    <dc:language>en-US</dc:language>
  </office:meta>
</office:document-meta>
WOK
      x=x.strip
      x=x.gsub(/\n+/m,'') unless @md.opt.act[:maintenance][:set]==:on
      x
    end
    def settings_xml
      x=<<WOK
<?xml version="1.0" encoding="UTF-8"?>
<office:document-settings xmlns:office="urn:oasis:names:tc:opendocument:xmlns:office:1.0" xmlns:xl="http://www.w3.org/1999/xlink" xmlns:config="urn:oasis:names:tc:opendocument:xmlns:config:1.0" xmlns:ooo="http://openoffice.org/2004/office" office:version="1.2">
  <office:settings>
    <config:config-item-set config:name="ooo:view-settings">
      <config:config-item config:name="ViewAreaTop" config:type="int">0</config:config-item>
      <config:config-item config:name="ViewAreaLeft" config:type="int">0</config:config-item>
      <config:config-item config:name="ViewAreaWidth" config:type="int">0</config:config-item>
      <config:config-item config:name="ViewAreaHeight" config:type="int">0</config:config-item>
      <config:config-item config:name="ShowRedlineChanges" config:type="boolean">true</config:config-item>
      <config:config-item config:name="InBrowseMode" config:type="boolean">false</config:config-item>
      <config:config-item-map-indexed config:name="Views">
        <config:config-item-map-entry>
          <config:config-item config:name="ViewId" config:type="string">view2</config:config-item>
          <config:config-item config:name="ViewLeft" config:type="int">0</config:config-item>
          <config:config-item config:name="ViewTop" config:type="int">0</config:config-item>
          <config:config-item config:name="VisibleLeft" config:type="int">0</config:config-item>
          <config:config-item config:name="VisibleTop" config:type="int">0</config:config-item>
          <config:config-item config:name="VisibleRight" config:type="int">0</config:config-item>
          <config:config-item config:name="VisibleBottom" config:type="int">0</config:config-item>
          <config:config-item config:name="ZoomType" config:type="short">0</config:config-item>
          <config:config-item config:name="ViewLayoutColumns" config:type="short">2</config:config-item>
          <config:config-item config:name="ViewLayoutBookMode" config:type="boolean">true</config:config-item>
          <config:config-item config:name="ZoomFactor" config:type="short">100</config:config-item>
          <config:config-item config:name="IsSelectedFrame" config:type="boolean">false</config:config-item>
        </config:config-item-map-entry>
      </config:config-item-map-indexed>
    </config:config-item-set>
    <config:config-item-set config:name="ooo:configuration-settings">
      <config:config-item config:name="ChartAutoUpdate" config:type="boolean">true</config:config-item>
      <config:config-item config:name="IsLabelDocument" config:type="boolean">false</config:config-item>
      <config:config-item config:name="MathBaselineAlignment" config:type="boolean">false</config:config-item>
      <config:config-item config:name="OutlineLevelYieldsNumbering" config:type="boolean">true</config:config-item>
      <config:config-item config:name="PrintLeftPages" config:type="boolean">true</config:config-item>
      <config:config-item config:name="DoNotJustifyLinesWithManualBreak" config:type="boolean">false</config:config-item>
      <config:config-item config:name="AlignTabStopPosition" config:type="boolean">true</config:config-item>
      <config:config-item config:name="PrintTextPlaceholder" config:type="boolean">false</config:config-item>
      <config:config-item config:name="UseOldNumbering" config:type="boolean">false</config:config-item>
      <config:config-item config:name="CurrentDatabaseCommand" config:type="string"/>
      <config:config-item config:name="ProtectForm" config:type="boolean">false</config:config-item>
      <config:config-item config:name="PrintBlackFonts" config:type="boolean">false</config:config-item>
      <config:config-item config:name="PrintProspectRTL" config:type="boolean">false</config:config-item>
      <config:config-item config:name="SmallCapsPercentage66" config:type="boolean">true</config:config-item>
      <config:config-item config:name="PrintControls" config:type="boolean">true</config:config-item>
      <config:config-item config:name="CharacterCompressionType" config:type="short">0</config:config-item>
      <config:config-item config:name="PrintHiddenText" config:type="boolean">false</config:config-item>
      <config:config-item config:name="UseFormerTextWrapping" config:type="boolean">false</config:config-item>
      <config:config-item config:name="IsKernAsianPunctuation" config:type="boolean">false</config:config-item>
      <config:config-item config:name="PrintProspect" config:type="boolean">false</config:config-item>
      <config:config-item config:name="PrintEmptyPages" config:type="boolean">true</config:config-item>
      <config:config-item config:name="UseFormerObjectPositioning" config:type="boolean">false</config:config-item>
      <config:config-item config:name="ConsiderTextWrapOnObjPos" config:type="boolean">false</config:config-item>
      <config:config-item config:name="TableRowKeep" config:type="boolean">false</config:config-item>
      <config:config-item config:name="PrintReversed" config:type="boolean">false</config:config-item>
      <config:config-item config:name="TabsRelativeToIndent" config:type="boolean">true</config:config-item>
      <config:config-item config:name="PrintRightPages" config:type="boolean">true</config:config-item>
      <config:config-item config:name="PrintPaperFromSetup" config:type="boolean">false</config:config-item>
      <config:config-item config:name="AddFrameOffsets" config:type="boolean">false</config:config-item>
      <config:config-item config:name="AddParaSpacingToTableCells" config:type="boolean">true</config:config-item>
      <config:config-item config:name="UpdateFromTemplate" config:type="boolean">false</config:config-item>
      <config:config-item config:name="AddExternalLeading" config:type="boolean">true</config:config-item>
      <config:config-item config:name="PrintSingleJobs" config:type="boolean">false</config:config-item>
      <config:config-item config:name="PrinterIndependentLayout" config:type="string">high-resolution</config:config-item>
      <config:config-item config:name="LinkUpdateMode" config:type="short">1</config:config-item>
      <config:config-item config:name="PrintAnnotationMode" config:type="short">0</config:config-item>
      <config:config-item config:name="UseOldPrinterMetrics" config:type="boolean">true</config:config-item>
      <config:config-item config:name="RedlineProtectionKey" config:type="base64Binary"/>
      <config:config-item config:name="PrinterSetup" config:type="base64Binary"/>
      <config:config-item config:name="IgnoreFirstLineIndentInNumbering" config:type="boolean">false</config:config-item>
      <config:config-item config:name="CollapseEmptyCellPara" config:type="boolean">true</config:config-item>
      <config:config-item config:name="PrinterName" config:type="string"/>
      <config:config-item config:name="InvertBorderSpacing" config:type="boolean">false</config:config-item>
      <config:config-item config:name="PrintPageBackground" config:type="boolean">true</config:config-item>
      <config:config-item config:name="DoNotCaptureDrawObjsOnPage" config:type="boolean">false</config:config-item>
      <config:config-item config:name="ApplyUserData" config:type="boolean">true</config:config-item>
      <config:config-item config:name="TabAtLeftIndentForParagraphsInList" config:type="boolean">false</config:config-item>
      <config:config-item config:name="UnxForceZeroExtLeading" config:type="boolean">true</config:config-item>
      <config:config-item config:name="SaveVersionOnClose" config:type="boolean">false</config:config-item>
      <config:config-item config:name="PrintFaxName" config:type="string"/>
      <config:config-item config:name="AddParaTableSpacing" config:type="boolean">true</config:config-item>
      <config:config-item config:name="PrintDrawings" config:type="boolean">true</config:config-item>
      <config:config-item config:name="LoadReadonly" config:type="boolean">false</config:config-item>
      <config:config-item config:name="PrintGraphics" config:type="boolean">true</config:config-item>
      <config:config-item config:name="FieldAutoUpdate" config:type="boolean">true</config:config-item>
      <config:config-item config:name="AllowPrintJobCancel" config:type="boolean">true</config:config-item>
      <config:config-item config:name="UseFormerLineSpacing" config:type="boolean">false</config:config-item>
      <config:config-item config:name="SaveGlobalDocumentLinks" config:type="boolean">false</config:config-item>
      <config:config-item config:name="CurrentDatabaseDataSource" config:type="string"/>
      <config:config-item config:name="IgnoreTabsAndBlanksForLineCalculation" config:type="boolean">false</config:config-item>
      <config:config-item config:name="CurrentDatabaseCommandType" config:type="int">0</config:config-item>
      <config:config-item config:name="DoNotResetParaAttrsForNumFont" config:type="boolean">false</config:config-item>
      <config:config-item config:name="ClipAsCharacterAnchoredWriterFlyFrames" config:type="boolean">false</config:config-item>
      <config:config-item config:name="PrintTables" config:type="boolean">true</config:config-item>
      <config:config-item config:name="AddParaTableSpacingAtStart" config:type="boolean">true</config:config-item>
    </config:config-item-set>
  </office:settings>
</office:document-settings>
WOK
      x=x.strip
      x=x.gsub(/\n+/m,'') unless @md.opt.act[:maintenance][:set]==:on
      x
    end
    def styles_xml
      x=<<WOK
<?xml version="1.0" encoding="UTF-8"?>
<office:document-styles xmlns:office="urn:oasis:names:tc:opendocument:xmlns:office:1.0" xmlns:style="urn:oasis:names:tc:opendocument:xmlns:style:1.0" xmlns:text="urn:oasis:names:tc:opendocument:xmlns:text:1.0" xmlns:table="urn:oasis:names:tc:opendocument:xmlns:table:1.0" xmlns:draw="urn:oasis:names:tc:opendocument:xmlns:drawing:1.0" xmlns:fo="urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0" xmlns:xl="http://www.w3.org/1999/xlink" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:meta="urn:oasis:names:tc:opendocument:xmlns:meta:1.0" xmlns:number="urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0" xmlns:svg="urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0" xmlns:chart="urn:oasis:names:tc:opendocument:xmlns:chart:1.0" xmlns:dr3d="urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0" xmlns:math="http://www.w3.org/1998/Math/MathML" xmlns:form="urn:oasis:names:tc:opendocument:xmlns:form:1.0" xmlns:script="urn:oasis:names:tc:opendocument:xmlns:script:1.0" xmlns:ooo="http://openoffice.org/2004/office" xmlns:ooow="http://openoffice.org/2004/writer" xmlns:oooc="http://openoffice.org/2004/calc" xmlns:dom="http://www.w3.org/2001/xml-events" xmlns:rpt="http://openoffice.org/2005/report" xmlns:of="urn:oasis:names:tc:opendocument:xmlns:of:1.2" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:grddl="http://www.w3.org/2003/g/data-view#" xmlns:tableooo="http://openoffice.org/2009/table" xmlns:css3t="http://www.w3.org/TR/css3-text/" office:version="1.2">
  <office:font-face-decls>
    <style:font-face style:name="DejaVu Sans Mono" svg:font-family="'DejaVu Sans Mono'" style:font-adornments="Book" style:font-family-generic="modern" style:font-pitch="fixed"/>
    <style:font-face style:name="Nimbus Sans L" svg:font-family="'Nimbus Sans L'" style:font-pitch="variable"/>
    <style:font-face style:name="Tahoma" svg:font-family="Tahoma, Lucidasans, 'Lucida Sans', 'Arial Unicode MS'" style:font-pitch="variable"/>
    <style:font-face style:name="Nimbus Roman No9 L" svg:font-family="'Nimbus Roman No9 L'" style:font-family-generic="roman" style:font-pitch="variable"/>
    <style:font-face style:name="Bitstream Vera Sans" svg:font-family="'Bitstream Vera Sans'" style:font-family-generic="swiss" style:font-pitch="variable"/>
  </office:font-face-decls>
  <office:styles>
    <style:default-style style:family="graphic">
      <style:graphic-properties fo:wrap-option="wrap" draw:shadow-offset-x="0.3cm" draw:shadow-offset-y="0.3cm" draw:start-line-spacing-horizontal="0.283cm" draw:start-line-spacing-vertical="0.283cm" draw:end-line-spacing-horizontal="0.283cm" draw:end-line-spacing-vertical="0.283cm" style:flow-with-text="false"/>
      <style:paragraph-properties style:text-autospace="ideograph-alpha" style:line-break="strict" style:writing-mode="lr-tb" style:font-independent-line-spacing="false">
        <style:tab-stops/>
      </style:paragraph-properties>
      <style:text-properties style:use-window-font-color="true" fo:font-size="12pt" fo:language="en" fo:country="US" style:font-size-asian="12pt" style:language-asian="zxx" style:country-asian="none" style:font-size-complex="12pt" style:language-complex="zxx" style:country-complex="none"/>
    </style:default-style>
    <style:default-style style:family="paragraph">
      <style:paragraph-properties fo:hyphenation-ladder-count="no-limit" style:text-autospace="ideograph-alpha" style:punctuation-wrap="hanging" style:line-break="strict" style:tab-stop-distance="1.251cm" style:writing-mode="page"/>
      <style:text-properties style:use-window-font-color="true" style:font-name="Nimbus Roman No9 L" fo:font-size="12pt" fo:language="en" fo:country="US" style:font-name-asian="Nimbus Sans L" style:font-size-asian="12pt" style:language-asian="zxx" style:country-asian="none" style:font-name-complex="Nimbus Sans L" style:font-size-complex="12pt" style:language-complex="zxx" style:country-complex="none" fo:hyphenate="false" fo:hyphenation-remain-char-count="2" fo:hyphenation-push-char-count="2"/>
    </style:default-style>
    <style:default-style style:family="table">
      <style:table-properties table:border-model="collapsing"/>
    </style:default-style>
    <style:default-style style:family="table-row">
      <style:table-row-properties fo:keep-together="auto"/>
    </style:default-style>
    <style:style style:name="Standard" style:family="paragraph" style:class="text"/>
    <style:style style:name="Text_body" style:display-name="Text body" style:family="paragraph" style:class="text"><style:paragraph-properties fo:margin-top="0cm" fo:margin-bottom="0.212cm"/></style:style>
    <style:style style:name="P_page_break" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties fo:break-before="page"/></style:style>
    <style:style style:name="P_normal" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:text-align="justify" style:justify-single-word="false"/></style:style>
    <style:style style:name="P_normal_page_new" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties fo:break-after="page"/></style:style>
    <style:style style:name="P_indent_0" style:display-name="Paragraph indent 0" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:text-align="justify" style:justify-single-word="false"/></style:style>
    <style:style style:name="P_indent_1" style:display-name="Paragraph indent 1" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:margin-left="1cm" fo:margin-right="0cm" fo:text-align="justify" style:justify-single-word="false" fo:text-indent="0cm" style:auto-text-indent="false"/></style:style>
    <style:style style:name="P_indent_2" style:display-name="Paragraph indent 2" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:margin-left="2cm" fo:margin-right="0cm" fo:text-align="justify" style:justify-single-word="false" fo:text-indent="0cm" style:auto-text-indent="false"/></style:style>
    <style:style style:name="P_indent_3" style:display-name="Paragraph indent 3" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:margin-left="3cm" fo:margin-right="0cm" fo:text-align="justify" style:justify-single-word="false" fo:text-indent="0cm" style:auto-text-indent="false"/></style:style>
    <style:style style:name="P_indent_4" style:display-name="Paragraph indent 4" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:margin-left="4cm" fo:margin-right="0cm" fo:text-align="justify" style:justify-single-word="false" fo:text-indent="0cm" style:auto-text-indent="false"/></style:style>
    <style:style style:name="P_indent_5" style:display-name="Paragraph indent 5" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:margin-left="5cm" fo:margin-right="0cm" fo:text-align="justify" style:justify-single-word="false" fo:text-indent="0cm" style:auto-text-indent="false"/></style:style>
    <style:style style:name="P_indent_6" style:display-name="Paragraph indent 6" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:margin-left="6cm" fo:margin-right="0cm" fo:text-align="justify" style:justify-single-word="false" fo:text-indent="0cm" style:auto-text-indent="false"/></style:style>
    <style:style style:name="P_indent_7" style:display-name="Paragraph indent 7" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:margin-left="7cm" fo:margin-right="0cm" fo:text-align="justify" style:justify-single-word="false" fo:text-indent="0cm" style:auto-text-indent="false"/></style:style>
    <style:style style:name="P_indent_8" style:display-name="Paragraph indent 8" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:margin-left="8cm" fo:margin-right="0cm" fo:text-align="justify" style:justify-single-word="false" fo:text-indent="0cm" style:auto-text-indent="false"/></style:style>
    <style:style style:name="P_indent_9" style:display-name="Paragraph indent 9" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties  fo:margin-top="0.199cm" fo:margin-bottom="0.199cm" fo:line-height="150%" fo:margin-left="9cm" fo:margin-right="0cm" fo:text-align="justify" style:justify-single-word="false" fo:text-indent="0cm" style:auto-text-indent="false"/></style:style>
    <style:style style:name="P_h0_i0" style:display-name="Hang 0 Indent 0" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="0cm" fo:margin-right="0cm" fo:text-indent="0cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h0_i1" style:display-name="Hang 0 Indent 1" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="1cm" fo:margin-right="0cm" fo:text-indent="-1cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h0_i2" style:display-name="Hang 0 Indent 2" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="2cm" fo:margin-right="0cm" fo:text-indent="-2cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h0_i3" style:display-name="Hang 0 Indent 3" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="3cm" fo:margin-right="0cm" fo:text-indent="-3cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h0_i4" style:display-name="Hang 0 Indent 4" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="4cm" fo:margin-right="0cm" fo:text-indent="-4cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h0_i5" style:display-name="Hang 0 Indent 5" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="5cm" fo:margin-right="0cm" fo:text-indent="-5cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h0_i6" style:display-name="Hang 0 Indent 6" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="6cm" fo:margin-right="0cm" fo:text-indent="-6cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h0_i7" style:display-name="Hang 0 Indent 7" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="7cm" fo:margin-right="0cm" fo:text-indent="-7cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h0_i8" style:display-name="Hang 0 Indent 8" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="8cm" fo:margin-right="0cm" fo:text-indent="-8cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h0_i9" style:display-name="Hang 0 Indent 9" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="9cm" fo:margin-right="0cm" fo:text-indent="-9cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h1_i0" style:display-name="Hang 1 Indent 0" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="0cm" fo:margin-right="0cm" fo:text-indent="1cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h1_i1" style:display-name="Hang 1 Indent 1" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="1cm" fo:margin-right="0cm" fo:text-indent="0cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h1_i2" style:display-name="Hang 1 Indent 2" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="2cm" fo:margin-right="0cm" fo:text-indent="-1cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h1_i3" style:display-name="Hang 1 Indent 3" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="3cm" fo:margin-right="0cm" fo:text-indent="-2cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h1_i4" style:display-name="Hang 1 Indent 4" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="4cm" fo:margin-right="0cm" fo:text-indent="-3cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h1_i5" style:display-name="Hang 1 Indent 5" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="5cm" fo:margin-right="0cm" fo:text-indent="-4cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h1_i6" style:display-name="Hang 1 Indent 6" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="6cm" fo:margin-right="0cm" fo:text-indent="-5cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h1_i7" style:display-name="Hang 1 Indent 7" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="7cm" fo:margin-right="0cm" fo:text-indent="-6cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h1_i8" style:display-name="Hang 1 Indent 8" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="8cm" fo:margin-right="0cm" fo:text-indent="-7cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h1_i9" style:display-name="Hang 1 Indent 9" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="9cm" fo:margin-right="0cm" fo:text-indent="-8cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h2_i0" style:display-name="Hang 2 Indent 0" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="0cm" fo:margin-right="0cm" fo:text-indent="2cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h2_i1" style:display-name="Hang 2 Indent 1" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="1cm" fo:margin-right="0cm" fo:text-indent="1cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h2_i2" style:display-name="Hang 2 Indent 2" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="2cm" fo:margin-right="0cm" fo:text-indent="0cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h2_i3" style:display-name="Hang 2 Indent 3" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="3cm" fo:margin-right="0cm" fo:text-indent="-1cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h2_i4" style:display-name="Hang 2 Indent 4" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="4cm" fo:margin-right="0cm" fo:text-indent="-2cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h2_i5" style:display-name="Hang 2 Indent 5" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="5cm" fo:margin-right="0cm" fo:text-indent="-3cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h2_i6" style:display-name="Hang 2 Indent 6" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="6cm" fo:margin-right="0cm" fo:text-indent="-4cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h2_i7" style:display-name="Hang 2 Indent 7" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="7cm" fo:margin-right="0cm" fo:text-indent="-5cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h2_i8" style:display-name="Hang 2 Indent 8" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="8cm" fo:margin-right="0cm" fo:text-indent="-6cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h2_i9" style:display-name="Hang 2 Indent 9" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="9cm" fo:margin-right="0cm" fo:text-indent="-7cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h3_i0" style:display-name="Hang 3 Indent 0" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="0cm" fo:margin-right="0cm" fo:text-indent="3cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h3_i1" style:display-name="Hang 3 Indent 1" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="1cm" fo:margin-right="0cm" fo:text-indent="2cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h3_i2" style:display-name="Hang 3 Indent 2" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="2cm" fo:margin-right="0cm" fo:text-indent="1cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h3_i3" style:display-name="Hang 3 Indent 3" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="3cm" fo:margin-right="0cm" fo:text-indent="0cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h3_i4" style:display-name="Hang 3 Indent 4" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="4cm" fo:margin-right="0cm" fo:text-indent="-1cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h3_i5" style:display-name="Hang 3 Indent 5" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="5cm" fo:margin-right="0cm" fo:text-indent="-2cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h3_i6" style:display-name="Hang 3 Indent 6" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="6cm" fo:margin-right="0cm" fo:text-indent="-3cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h3_i7" style:display-name="Hang 3 Indent 7" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="7cm" fo:margin-right="0cm" fo:text-indent="-4cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h3_i8" style:display-name="Hang 3 Indent 8" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="8cm" fo:margin-right="0cm" fo:text-indent="-5cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h3_i9" style:display-name="Hang 3 Indent 9" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="9cm" fo:margin-right="0cm" fo:text-indent="-6cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h4_i0" style:display-name="Hang 4 Indent 0" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="0cm" fo:margin-right="0cm" fo:text-indent="4cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h4_i1" style:display-name="Hang 4 Indent 1" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="1cm" fo:margin-right="0cm" fo:text-indent="3cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h4_i2" style:display-name="Hang 4 Indent 2" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="2cm" fo:margin-right="0cm" fo:text-indent="2cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h4_i3" style:display-name="Hang 4 Indent 3" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="3cm" fo:margin-right="0cm" fo:text-indent="1cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h4_i4" style:display-name="Hang 4 Indent 4" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="4cm" fo:margin-right="0cm" fo:text-indent="0cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h4_i5" style:display-name="Hang 4 Indent 5" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="5cm" fo:margin-right="0cm" fo:text-indent="-1cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h4_i6" style:display-name="Hang 4 Indent 6" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="6cm" fo:margin-right="0cm" fo:text-indent="-2cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h4_i7" style:display-name="Hang 4 Indent 7" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="7cm" fo:margin-right="0cm" fo:text-indent="-3cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h4_i8" style:display-name="Hang 4 Indent 8" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="8cm" fo:margin-right="0cm" fo:text-indent="-4cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h4_i9" style:display-name="Hang 4 Indent 9" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="9cm" fo:margin-right="0cm" fo:text-indent="-5cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h5_i0" style:display-name="Hang 5 Indent 0" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="0cm" fo:margin-right="0cm" fo:text-indent="5cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h5_i1" style:display-name="Hang 5 Indent 1" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="1cm" fo:margin-right="0cm" fo:text-indent="4cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h5_i2" style:display-name="Hang 5 Indent 2" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="2cm" fo:margin-right="0cm" fo:text-indent="3cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h5_i3" style:display-name="Hang 5 Indent 3" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="3cm" fo:margin-right="0cm" fo:text-indent="2cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h5_i4" style:display-name="Hang 5 Indent 4" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="4cm" fo:margin-right="0cm" fo:text-indent="1cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h5_i5" style:display-name="Hang 5 Indent 5" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="5cm" fo:margin-right="0cm" fo:text-indent="0cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h5_i6" style:display-name="Hang 5 Indent 6" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="6cm" fo:margin-right="0cm" fo:text-indent="-1cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h5_i7" style:display-name="Hang 5 Indent 7" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="7cm" fo:margin-right="0cm" fo:text-indent="-2cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h5_i8" style:display-name="Hang 5 Indent 8" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="8cm" fo:margin-right="0cm" fo:text-indent="-3cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h5_i9" style:display-name="Hang 5 Indent 9" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="9cm" fo:margin-right="0cm" fo:text-indent="-4cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h6_i0" style:display-name="Hang 6 Indent 0" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="0cm" fo:margin-right="0cm" fo:text-indent="6cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h6_i1" style:display-name="Hang 6 Indent 1" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="1cm" fo:margin-right="0cm" fo:text-indent="5cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h6_i2" style:display-name="Hang 6 Indent 2" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="2cm" fo:margin-right="0cm" fo:text-indent="4cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h6_i3" style:display-name="Hang 6 Indent 3" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="3cm" fo:margin-right="0cm" fo:text-indent="3cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h6_i4" style:display-name="Hang 6 Indent 4" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="4cm" fo:margin-right="0cm" fo:text-indent="2cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h6_i5" style:display-name="Hang 6 Indent 5" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="5cm" fo:margin-right="0cm" fo:text-indent="1cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h6_i6" style:display-name="Hang 6 Indent 6" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="6cm" fo:margin-right="0cm" fo:text-indent="0cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h6_i7" style:display-name="Hang 6 Indent 7" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="7cm" fo:margin-right="0cm" fo:text-indent="-1cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h6_i8" style:display-name="Hang 6 Indent 8" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="8cm" fo:margin-right="0cm" fo:text-indent="-2cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h6_i9" style:display-name="Hang 6 Indent 9" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="9cm" fo:margin-right="0cm" fo:text-indent="-3cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h7_i0" style:display-name="Hang 7 Indent 0" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="0cm" fo:margin-right="0cm" fo:text-indent="7cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h7_i1" style:display-name="Hang 7 Indent 1" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="1cm" fo:margin-right="0cm" fo:text-indent="6cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h7_i2" style:display-name="Hang 7 Indent 2" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="2cm" fo:margin-right="0cm" fo:text-indent="5cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h7_i3" style:display-name="Hang 7 Indent 3" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="3cm" fo:margin-right="0cm" fo:text-indent="4cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h7_i4" style:display-name="Hang 7 Indent 4" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="4cm" fo:margin-right="0cm" fo:text-indent="3cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h7_i5" style:display-name="Hang 7 Indent 5" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="5cm" fo:margin-right="0cm" fo:text-indent="2cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h7_i6" style:display-name="Hang 7 Indent 6" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="6cm" fo:margin-right="0cm" fo:text-indent="1cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h7_i7" style:display-name="Hang 7 Indent 7" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="7cm" fo:margin-right="0cm" fo:text-indent="0cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h7_i8" style:display-name="Hang 7 Indent 8" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="8cm" fo:margin-right="0cm" fo:text-indent="-1cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h7_i9" style:display-name="Hang 7 Indent 9" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="9cm" fo:margin-right="0cm" fo:text-indent="-2cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h8_i0" style:display-name="Hang 8 Indent 0" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="0cm" fo:margin-right="0cm" fo:text-indent="8cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h8_i1" style:display-name="Hang 8 Indent 1" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="1cm" fo:margin-right="0cm" fo:text-indent="7cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h8_i2" style:display-name="Hang 8 Indent 2" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="2cm" fo:margin-right="0cm" fo:text-indent="6cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h8_i3" style:display-name="Hang 8 Indent 3" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="3cm" fo:margin-right="0cm" fo:text-indent="5cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h8_i4" style:display-name="Hang 8 Indent 4" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="4cm" fo:margin-right="0cm" fo:text-indent="4cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h8_i5" style:display-name="Hang 8 Indent 5" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="5cm" fo:margin-right="0cm" fo:text-indent="3cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h8_i6" style:display-name="Hang 8 Indent 6" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="6cm" fo:margin-right="0cm" fo:text-indent="2cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h8_i7" style:display-name="Hang 8 Indent 7" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="7cm" fo:margin-right="0cm" fo:text-indent="1cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h8_i8" style:display-name="Hang 8 Indent 8" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="8cm" fo:margin-right="0cm" fo:text-indent="0cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h8_i9" style:display-name="Hang 8 Indent 9" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="9cm" fo:margin-right="0cm" fo:text-indent="-1cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h9_i0" style:display-name="Hang 9 Indent 0" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="0cm" fo:margin-right="0cm" fo:text-indent="9cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h9_i1" style:display-name="Hang 9 Indent 1" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="1cm" fo:margin-right="0cm" fo:text-indent="8cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h9_i2" style:display-name="Hang 9 Indent 2" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="2cm" fo:margin-right="0cm" fo:text-indent="7cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h9_i3" style:display-name="Hang 9 Indent 3" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="3cm" fo:margin-right="0cm" fo:text-indent="6cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h9_i4" style:display-name="Hang 9 Indent 4" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="4cm" fo:margin-right="0cm" fo:text-indent="5cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h9_i5" style:display-name="Hang 9 Indent 5" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="5cm" fo:margin-right="0cm" fo:text-indent="4cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h9_i6" style:display-name="Hang 9 Indent 6" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="6cm" fo:margin-right="0cm" fo:text-indent="3cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h9_i7" style:display-name="Hang 9 Indent 7" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="7cm" fo:margin-right="0cm" fo:text-indent="2cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h9_i8" style:display-name="Hang 9 Indent 8" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="8cm" fo:margin-right="0cm" fo:text-indent="1cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="P_h9_i9" style:display-name="Hang 9 Indent 9" style:family="paragraph" style:parent-style-name="Text_body" style:class="text"><style:paragraph-properties fo:margin-left="9cm" fo:margin-right="0cm" fo:text-indent="0cm" style:auto-text-indent="false"><style:tab-stops><style:tab-stop style:position="0cm"/></style:tab-stops></style:paragraph-properties></style:style>
    <style:style style:name="Span_bold" style:family="text"><style:text-properties fo:font-weight="bold" style:font-weight-asian="bold" style:font-weight-complex="bold"/></style:style>
    <style:style style:name="Span_italic" style:family="text"><style:text-properties fo:font-style="italic" style:font-style-asian="italic" style:font-style-complex="italic"/></style:style>
    <style:style style:name="Span_underscore" style:family="text"><style:text-properties style:text-underline-style="solid" style:text-underline-width="auto" style:text-underline-color="font-color"/></style:style>
    <style:style style:name="Span_superscript" style:family="text"><style:text-properties style:text-position="super 58%"/></style:style>
    <style:style style:name="Span_subscript" style:family="text"><style:text-properties style:text-position="sub 58%"/></style:style>
    <style:style style:name="Span_monospace" style:family="text"><style:text-properties style:font-name="DejaVu Sans Mono" fo:font-size="10pt" fo:font-weight="normal" fo:background-color="#e6e6e6"/></style:style>
    <style:style style:name="Heading" style:family="paragraph" style:next-style-name="Text_body" style:class="text"> <style:paragraph-properties fo:margin-top="0.423cm" fo:margin-bottom="0.212cm" fo:keep-with-next="always"/><style:text-properties style:font-name="Bitstream Vera Sans" fo:font-size="14pt" style:font-size-asian="14pt" style:font-name-complex="Tahoma" style:font-size-complex="14pt"/></style:style>
    <style:style style:name="H_1" style:display-name="Heading 1" style:family="paragraph" style:next-style-name="Text_body" style:default-outline-level="1" style:class="text"><style:text-properties fo:font-size="120%" fo:font-weight="bold" style:font-size-asian="120%" style:font-weight-asian="bold" style:font-size-complex="115%" style:font-weight-complex="bold"/></style:style>
    <style:style style:name="H_2" style:display-name="Heading 2" style:family="paragraph" style:next-style-name="Text_body" style:default-outline-level="2" style:class="text"><style:text-properties fo:font-size="115%" fo:font-weight="bold" style:font-size-asian="115%" style:font-weight-asian="bold" style:font-size-complex="115%" style:font-weight-complex="bold"/></style:style>
    <style:style style:name="H_3" style:display-name="Heading 3" style:family="paragraph" style:next-style-name="Text_body" style:default-outline-level="3" style:class="text"><style:text-properties fo:font-size="110%" fo:font-weight="bold" style:font-size-asian="110%" style:font-weight-asian="bold" style:font-size-complex="115%" style:font-weight-complex="bold"/></style:style>
    <style:style style:name="H_4" style:display-name="Heading 4" style:family="paragraph" style:next-style-name="Text_body" style:default-outline-level="4" style:class="text"><style:text-properties fo:font-size="12pt" fo:font-style="italic" fo:font-weight="bold" style:font-size-asian="12pt" style:font-style-asian="italic" style:font-weight-asian="bold" style:font-size-complex="12pt" style:font-style-complex="italic" style:font-weight-complex="bold"/></style:style>
    <style:style style:name="H_5" style:display-name="Heading 5" style:family="paragraph" style:next-style-name="Text_body" style:default-outline-level="5" style:class="text"><style:text-properties fo:font-size="90%" fo:font-style="italic" fo:font-weight="bold" style:font-size-asian="90%" style:font-style-asian="italic" style:font-weight-asian="bold" style:font-size-complex="90%" style:font-style-complex="italic" style:font-weight-complex="bold"/></style:style>
    <style:style style:name="H_6" style:display-name="Heading 6" style:family="paragraph" style:next-style-name="Text_body" style:default-outline-level="6" style:class="text"><style:text-properties fo:font-size="80%" fo:font-style="italic" fo:font-weight="bold" style:font-size-asian="80%" style:font-style-asian="italic" style:font-weight-asian="bold" style:font-size-complex="80%" style:font-style-complex="italic" style:font-weight-complex="bold"/></style:style>
    <style:style style:name="P_group" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties fo:margin-top="0cm" fo:margin-bottom="0cm" fo:line-height="100%" fo:text-align="justify" style:justify-single-word="false"/></style:style>
    <style:style style:name="P_code" style:family="paragraph" style:parent-style-name="Standard"><style:paragraph-properties fo:margin-top="0cm" fo:margin-bottom="0cm" fo:line-height="100%" fo:text-align="start" style:justify-single-word="false"/><style:text-properties style:font-name="DejaVu Sans Mono" fo:font-size="9pt" fo:font-weight="normal" fo:background-color="#e6e6e6"/></style:style>
    <style:style style:name="Footnote" style:family="paragraph" style:class="extra"><style:paragraph-properties fo:margin-left="0.499cm" fo:margin-right="0cm" fo:text-indent="-0.499cm" style:auto-text-indent="false" text:number-lines="false" text:line-number="0"/> <style:text-properties fo:font-size="10pt" style:font-size-asian="10pt" style:font-size-complex="10pt"/></style:style>
    <style:style style:name="Table_Contents" style:display-name="Table Contents" style:family="paragraph" style:parent-style-name="Standard" style:class="extra"><style:paragraph-properties text:number-lines="false" text:line-number="0"/></style:style>
    <style:style style:name="Footnote_symbol" style:display-name="Footnote Symbol" style:family="text"/>
    <style:style style:name="Footnote_anchor" style:display-name="Footnote Anchor" style:family="text"><style:text-properties style:text-position="super 58%"/></style:style>
    <style:style style:name="Internet_link" style:display-name="Internet link" style:family="text"><style:text-properties fo:color="#000080" fo:language="zxx" fo:country="none" style:text-underline-style="solid" style:text-underline-width="auto" style:text-underline-color="font-color" style:language-asian="zxx" style:country-asian="none" style:language-complex="zxx" style:country-complex="none"/></style:style>
    <style:style style:name="Graphics" style:family="graphic"><style:graphic-properties text:anchor-type="paragraph" svg:x="0cm" svg:y="0cm" style:wrap="dynamic" style:number-wrapped-paragraphs="no-limit" style:wrap-contour="false" style:vertical-pos="top" style:vertical-rel="paragraph" style:horizontal-pos="center" style:horizontal-rel="paragraph"/></style:style>
    <text:outline-style style:name="Outline"><text:outline-level-style text:level="1" style:num-format=""><style:list-level-properties text:min-label-distance="0.381cm"/></text:outline-level-style>
      <text:outline-level-style text:level="2" style:num-format=""><style:list-level-properties text:min-label-distance="0.381cm"/></text:outline-level-style>
      <text:outline-level-style text:level="3" style:num-format=""><style:list-level-properties text:min-label-distance="0.381cm"/></text:outline-level-style>
      <text:outline-level-style text:level="4" style:num-format=""><style:list-level-properties text:min-label-distance="0.381cm"/></text:outline-level-style>
      <text:outline-level-style text:level="5" style:num-format=""><style:list-level-properties text:min-label-distance="0.381cm"/></text:outline-level-style>
      <text:outline-level-style text:level="6" style:num-format=""><style:list-level-properties text:min-label-distance="0.381cm"/></text:outline-level-style>
      <text:outline-level-style text:level="7" style:num-format=""><style:list-level-properties text:min-label-distance="0.381cm"/></text:outline-level-style>
      <text:outline-level-style text:level="8" style:num-format=""><style:list-level-properties text:min-label-distance="0.381cm"/></text:outline-level-style>
      <text:outline-level-style text:level="9" style:num-format=""><style:list-level-properties text:min-label-distance="0.381cm"/></text:outline-level-style>
      <text:outline-level-style text:level="10" style:num-format=""><style:list-level-properties text:min-label-distance="0.381cm"/></text:outline-level-style>
    </text:outline-style>
    <text:notes-configuration text:note-class="footnote" text:citation-style-name="Footnote_symbol" text:citation-body-style-name="Footnote_anchor" style:num-format="1" text:start-value="0" text:footnotes-position="page" text:start-numbering-at="document"/>
    <text:notes-configuration text:note-class="endnote" style:num-format="i" text:start-value="0"/>
    <text:linenumbering-configuration text:number-lines="false" text:offset="0.499cm" style:num-format="1" text:number-position="left" text:increment="5"/>
    <style:style style:name="fr1" style:family="graphic" style:parent-style-name="Graphics"><style:graphic-properties style:wrap="none" style:horizontal-pos="left" style:horizontal-rel="paragraph" style:mirror="none" fo:clip="rect(0cm 0cm 0cm 0cm)" draw:luminance="0%" draw:contrast="0%" draw:red="0%" draw:green="0%" draw:blue="0%" draw:gamma="100%" draw:color-inversion="false" draw:image-opacity="100%" draw:color-mode="standard"/></style:style>
    <style:style style:name="gr1" style:family="graphic"><style:graphic-properties draw:stroke="none" draw:fill="none" draw:textarea-horizontal-align="center" draw:textarea-vertical-align="middle" draw:color-mode="standard" draw:luminance="0%" draw:contrast="0%" draw:gamma="100%" draw:red="0%" draw:green="0%" draw:blue="0%" fo:clip="rect(0cm 0cm 0cm 0cm)" draw:image-opacity="100%" style:mirror="none" style:run-through="background" style:wrap="none" style:vertical-pos="top" style:vertical-rel="baseline" style:horizontal-pos="left" style:horizontal-rel="paragraph" draw:wrap-influence-on-position="once-concurrent" style:flow-with-text="false"/></style:style>
    <style:style style:name="gr2" style:family="graphic"><style:graphic-properties draw:stroke="none" draw:fill="none" draw:textarea-horizontal-align="center" draw:textarea-vertical-align="middle" draw:color-mode="standard" draw:luminance="0%" draw:contrast="0%" draw:gamma="100%" draw:red="0%" draw:green="0%" draw:blue="0%" fo:clip="rect(0cm 0cm 0cm 0cm)" draw:image-opacity="100%" style:mirror="none" style:run-through="background" style:wrap="none" style:vertical-pos="middle" style:vertical-rel="baseline" style:horizontal-pos="left" style:horizontal-rel="paragraph" draw:wrap-influence-on-position="once-concurrent" style:flow-with-text="false"/></style:style>
  </office:styles>
  <office:automatic-styles>
    <style:page-layout style:name="Mpm1">
      <style:page-layout-properties fo:page-width="20.999cm" fo:page-height="29.699cm" style:num-format="1" style:print-orientation="portrait" fo:margin-top="2cm" fo:margin-bottom="2cm" fo:margin-left="2cm" fo:margin-right="2cm" style:writing-mode="lr-tb" style:footnote-max-height="0cm">
        <style:footnote-sep style:width="0.018cm" style:distance-before-sep="0.101cm" style:distance-after-sep="0.101cm" style:line-style="none" style:adjustment="left" style:rel-width="25%" style:color="#000000"/>
      </style:page-layout-properties>
      <style:header-style/>
      <style:footer-style/>
    </style:page-layout>
  </office:automatic-styles>
  <office:master-styles>
    <style:master-page style:name="Standard" style:page-layout-name="Mpm1"/>
  </office:master-styles>
</office:document-styles>
WOK
      x=x.strip
      x=x.gsub(/\n+/m,'') unless @md.opt.act[:maintenance][:set]==:on
      x
    end
    def mimetype
      x=<<WOK
application/vnd.oasis.opendocument.text
WOK
      x=x.strip
    end
  end
  class FormatObjBreak
    def initialize(md,t_o)
      @md,@t_o=md,t_o
    end
    def br_page
      @t_o.obj='<text:p text:style-name="P_page_break"> </text:p>'
      @t_o
    end
    def br_page_line
      sep='_'
      @t_o.obj=%{<text:p text:style-name="P_normal">#{sep*60}</text:p>}
      @t_o
    end
    def obj_sep #center later
      sep='--- '
      @t_o.obj=%{<text:p text:style-name="P_normal">#{sep*20}</text:p>}
      @t_o
    end
  end
  class XML
  end
end
__END__
