/* Public domain. */

#ifndef BIGUINT_H
#define BIGUINT_H

#include "gccattributes.h"
#include "uint32.h"

#define BIGUINT_MAXLIMBS 64
#define FMT_BIGUINT ((BIGUINT_MAXLIMBS<<3) + 1)

extern void bu_pack (char *, uint32 const *, unsigned int) ;
extern void bu_unpack (char const *, uint32 *, unsigned int) ;
extern void bu_pack_big (char *, uint32 const *, unsigned int) ;
extern void bu_unpack_big (char const *, uint32 *, unsigned int) ;
extern unsigned int bu_fmt (char *, uint32 const *, unsigned int) ;

extern void bu_zero (uint32 *, unsigned int) ;
extern void bu_copy (uint32 *, uint32 const *, unsigned int) ;
extern unsigned int bu_len (uint32 const *, unsigned int) gccattr_pure ;
extern int bu_cmp (uint32 const *, uint32 const *, unsigned int) gccattr_pure ;

#define bu_add(c, a, b, n) bu_addc(c, a, b, n, 0)
extern unsigned char bu_addc (uint32 *, uint32 const *, uint32 const *, unsigned int, unsigned char) ;
#define bu_sub(c, a, b, n) bu_subc(c, a, b, n, 0)
extern unsigned char bu_subc (uint32 *, uint32 const *, uint32 const *, unsigned int, unsigned char) ;
extern void bu_mul (uint32 *, uint32 const *, unsigned int, uint32 const *, unsigned int) ;
extern void bu_div (uint32 const *, uint32 const *, uint32 *, uint32 *, unsigned int) ;
extern void bu_div_unsafe (uint32 const *, uint32 const *, uint32 *, uint32 *, unsigned int) ;

#define bu_slb(a, n) bu_slbc(a, n, 0)
extern unsigned char bu_slbc (uint32 *, unsigned int, unsigned char) ;
#define bu_srb(a, n) bu_srbc(a, n, 0)
extern unsigned char bu_srbc (uint32 *, unsigned int, unsigned char) ;

extern void bu_addmod (uint32 *, uint32 const *, uint32 const *, uint32 const *, unsigned int) ;
extern void bu_submod (uint32 *, uint32 const *, uint32 const *, uint32 const *, unsigned int) ;
extern int bu_invmod (uint32 *, uint32 const *, unsigned int) ;
extern int bu_divmod (uint32 *, uint32 const *, uint32 const *, uint32 const *, unsigned int) ;

#endif
