-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with E_Strings;

--# inherit E_Strings,
--#         SPARK_IO;

package StringList is

   type Object is private;
   Null_Object : constant Object;

   type Iterator is private;

   ------------------------------------------------------------------------
   -- Constructors
   ------------------------------------------------------------------------

   procedure Add_To_Front (To_List  : in out Object;
                           The_Item : in     E_Strings.T);
   --# derives To_List from *,
   --#                      The_Item;
   --
   -- Adds the TheItem to the front of ToList.
   -- No change if TheItem is already present.

   procedure Add_To_Back (To_List  : in out Object;
                          The_Item : in     E_Strings.T);
   --# derives To_List from *,
   --#                      The_Item;
   --
   -- Adds the TheItem to the back of ToList.

   -- Assuming ToList is already sorted, then adds TheItem
   -- to the list so it remains sorted.  Here, "sorted" is
   -- defined by the "<=" operator for Standard.String
   procedure Add_In_Lex_Order (To_List  : in out Object;
                               The_Item : in     E_Strings.T);
   --# derives To_List from *,
   --#                      The_Item;

   function Get_First (In_List : Object) return Iterator;
   --
   -- Returns an iterator for the first item in the list

   function Next (It : Iterator) return Iterator;
   --
   -- Returns the next iterator.

   ------------------------------------------------------------------------
   -- Accessors
   ------------------------------------------------------------------------

   function Is_Null (It : Iterator) return Boolean;

   function Value (It : Iterator) return E_Strings.T;

   ------------------------------------------------------------------------
   -- Debug support
   ------------------------------------------------------------------------

   type Orientation is (Vertical, Horizontal);

   procedure Output (The_List : in Object;
                     How      : in Orientation);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                How,
   --#                                The_List;

private

   --# hide StringList;

   type Node;

   type Object is access Node;
   Null_Object : constant Object := null;

   type Node is record
      The_Item : E_Strings.T;
      Next     : Object;
   end record;

   type Iterator is new Object;

   Null_Iterator : constant Iterator := Iterator (Null_Object);

end StringList;
