use ui;
use progvis:data;

// Default view for the built-in types. Called by the default view hints to create a default view
// for some data.
Drawable? defaultView(World world, Data data) on Render {
	if (data as progvis:data:Thread) {
		return ThreadView(data);
	} else if (data as Composite) {
		return WithCaption(CompositeView(data), data.title(world));
	} else if (data as Array) {
		return ArrayView(data);
	} else if (data as Primitive) {
		return PrimitiveView(data);
	} else if (data as Pointer) {
		return PointerView(data);
	} else if (data as Pad) {
		return PadView(data);
	}

	null;
}

// Default decoration.
Drawable defaultDecorate(Allocation alloc, Drawable data) on Render {
	if (data as ThreadView) {
		// Let threads know about their allocation so that they can disappear.
		data.alloc = alloc;
	}

	data;
}
