/*
 *   Copyright (C) 2008, 2009 Nicolas Vion <nico@yojik.eu>
 *
 *   This file is part of Swac-explore.
 * 
 *   Swac-explore is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   Swac-explore is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with Swac-explore.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "config.h"
#include <gtkmmconfig.h>
#include <gdk/gdkkeysyms.h>
#include <gtkmm/accelgroup.h>
#include <gtk/gtkimagemenuitem.h>
#include <gtkmm/image.h>
#include <gtkmm/stockid.h>
#include <gtkmm/stock.h>
#include "explorer_static.hh"


ExplorerStatic::ExplorerStatic() : 
	Gtk::Window(Gtk::WINDOW_TOPLEVEL),

	tool_search_icon(Gtk::StockID(Gtk::Stock::FIND), Gtk::ICON_SIZE_MENU),
	toolbutton1(Gtk::StockID(Gtk::Stock::MEDIA_PLAY)),
	toolbutton2(Gtk::StockID(Gtk::Stock::QUIT)),
	toolbutton5(Gtk::StockID(Gtk::Stock::ABOUT))
{  
	toolbar1.append(tool_search_item);
	toolbar1.append(toolitem1);

	toolbar1.append(separatortoolitem1);
	toolbar1.append(toolbutton1);
	toolbar1.append(separatortoolitem2);
	toolbar1.append(toolbutton5);
	toolbar1.append(toolbutton2);

	toolitem1.add(entry3);

	tool_search_item.add(tool_search_icon);

	combobox1.set_size_request(150,-1);
	treeview2.set_size_request(175,-1);

	scrolledwindow2.set_policy(Gtk::POLICY_NEVER, Gtk::POLICY_AUTOMATIC);
	scrolledwindow2.property_window_placement().set_value(Gtk::CORNER_TOP_LEFT);
	scrolledwindow2.add(treeview2);

	vbox2.pack_start(combobox1, Gtk::PACK_SHRINK, 0);
	vbox2.pack_start(scrolledwindow2);
	vbox2.pack_start(combobox2, Gtk::PACK_SHRINK, 0);

	treeview1.set_flags(Gtk::CAN_FOCUS);
	treeview1.set_enable_search(true);

	scrolledwindow3.set_shadow_type(Gtk::SHADOW_IN);
	scrolledwindow3.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	scrolledwindow3.add(treeview1);

	scrolledwindow4.set_shadow_type(Gtk::SHADOW_IN);
	scrolledwindow4.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	scrolledwindow4.add(treeview3);

	vpaned1.pack1(scrolledwindow3, Gtk::SHRINK);
	vpaned1.pack2(scrolledwindow4, Gtk::SHRINK);

	hpaned1.pack1(vbox2, Gtk::AttachOptions(0));
	hpaned1.pack2(vpaned1, Gtk::EXPAND|Gtk::SHRINK);

	vbox1.pack_start(toolbar1, Gtk::PACK_SHRINK, 0);
	vbox1.pack_start(hpaned1);
	vbox1.pack_start(statusbar1, Gtk::PACK_SHRINK, 0);

	set_title("SWAC Explore");
	set_default_size(800,600);
	property_window_position().set_value(Gtk::WIN_POS_CENTER);
	add(vbox1);

	//=== Sounds List ===
	store_sounds = Gtk::ListStore::create(listview);
	treeview1.set_model(store_sounds);
	
	//--Column for icon
	Gtk::TreeViewColumn *column;
	Gtk::CellRendererPixbuf* my_render = new Gtk::CellRendererPixbuf;
	my_render->set_property("stock_id", Gtk::StockID(Gtk::Stock::ABOUT));

	treeview1.append_column("", *my_render);
	if ((column = treeview1.get_column(0)) != NULL) {
		column->set_sizing(Gtk::TREE_VIEW_COLUMN_FIXED);
		column->set_fixed_width(32);
	}

	//--Other columns
	SOUNDS_LIST_INIT;

	store_index = Gtk::ListStore::create(listbox);
	treeview2.set_model(store_index);
	treeview2.set_headers_visible(false);
	treeview2.append_column("", listbox.caption);

	//=== Languages ===
	store_lang = Gtk::ListStore::create(listext);
	combobox1.set_model(store_lang);
	combobox1.pack_start(listext.caption);
	combobox1.pack_start(listext.value);

	//=== Fields for index ===
	store_fields = Gtk::ListStore::create(listext);
	combobox2.set_model(store_fields);
	combobox2.pack_start(listext.caption);
	
	//=== Sound Info =======
	store_info = Gtk::TreeStore::create(listsoundinfo);
	treeview3.set_model(store_info);
	treeview3.set_headers_visible(false);

	//--Col 1
	Gtk::CellRendererText* my_render_col1 = new Gtk::CellRendererText;

	treeview3.append_column("Field", *my_render_col1);
	if ((column = treeview3.get_column(0)) != NULL) {
		column->add_attribute(my_render_col1->property_text(), listsoundinfo.caption);
		column->add_attribute(my_render_col1->property_weight(), listsoundinfo.weight);
	}

	//--Col 2
	Gtk::CellRendererText* my_render_col2 = new Gtk::CellRendererText;
	my_render_col2->set_property("wrap_mode", Pango::WRAP_WORD);
	my_render_col2->set_property("wrap_width", 450);
	my_render_col2->set_property("foreground_gdk", Gdk::Color("#606060"));
	my_render_col2->set_property("editable", true);

	treeview3.append_column("Value", *my_render_col2);
	if ((column = treeview3.get_column(1)) != NULL)
		column->add_attribute(my_render_col2->property_text(), listsoundinfo.value);

	SOUND_INFO_INIT;
	treeview3.expand_all();

	statusbar1.push("Welcome to SWAC Explorer!");

	show_all_children();
}

