/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */
#ifndef UPM_EXTERNALINTERFACE_H
#define UPM_EXTERNALINTERFACE_H

#include <QObject>

#include "common.h"

enum batterySaverState
{
    batterySaverOff = 0,
    batterySaverOn,
    batterySaverUnavailable
};

class UpmExternalInterface : public QObject, protected QDBusContext
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.ukui.powerManager")
public:
    explicit UpmExternalInterface(QObject *parent = nullptr);

private slots:
    void dealBatterySaveSwitchChanged(QVariant);
    void dealAcOnlineStateChanged(int, bool);

public slots:
    void SetBatterySaver(const int);
    int GetBatterySaver();

signals:
    void PowerConfigChanged(QStringList);
};

#endif // UPM_EXTERNALINTERFACE_H
