/* -*- Mode: C++; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "powermanager-brightness.h"


PowerManagerBrightness::PowerManagerBrightness(QObject *parent)
{
    m_pPowerManger = new QGSettings(POWER_MANAGER_SCHEMA);
}

int PowerManagerBrightness::getBrightness()
{
    return m_pPowerManger->get(BRIGHTNESS_AC_KEY).toInt();
}

int PowerManagerBrightness::setBrightness(int brightness)
{
    return m_pPowerManger->trySet(BRIGHTNESS_AC_KEY, brightness);
}

int PowerManagerBrightness::connectTheSignal()
{
    connect(m_pPowerManger, SIGNAL(changed(QString)), this, SLOT(doChanged(QString)));
    return 0;
}

QString PowerManagerBrightness::backend()
{
    return "power manager";
}

void PowerManagerBrightness::doChanged(QString key)
{
    if (key == BRIGHTNESS_AC_KEY) {
        int brightness = m_pPowerManger->get(key).toInt();
        if (brightness > 0 && brightness <= 100) {

            QDBusMessage notifySignal =
                    QDBusMessage::createSignal(DBUS_GC_BRIGHTNESS_PATH, DBUS_GC_BRIGHTNESS_INTERFACE, DBUS_GC_BRIGHTNESS_SIGNAL_PRIMARYCHANGED_END);

            notifySignal.setArguments({QVariant::fromValue(brightness)});
            QDBusConnection::sessionBus().send(notifySignal);
        }
    }
}
