/***************************************************************************
                          cdialogpicturemap.cpp  -  description
                             -------------------
    begin                : Sat Apr 26 2003
    copyright            : (C) 2003-2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cdialogpicturemap.h"

#include <qlabel.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <qevent.h>
//Added by qt3to4:
#include <QMouseEvent>

/** */
CDialogPictureMap::CDialogPictureMap( QWidget * parent, const char * name, bool modal, Qt::WFlags f )
#if QT_VERSION < 0x040000
	: QDialog(parent,name,modal,f)
#else
	: QDialog(parent,f)
#endif
{
	setModal(modal);
	setObjectName(name);
	
	m_pGridLayout = new QGridLayout(this);
	
	// Q3GridLayout is QGridLayout with margin and spacing set to zero
	m_pGridLayout->setMargin(0);
	m_pGridLayout->setSpacing(0);
	
	m_pLabel = new QLabel(this);
	m_pGridLayout->addWidget(m_pLabel,0,0);
	m_pLabel->show();

	m_nX = m_nY = 0;

	m_pLabel->installEventFilter(this);
}

/** */
CDialogPictureMap::~CDialogPictureMap()
{
	delete m_pGridLayout;
	delete m_pLabel;
}

/** */
void CDialogPictureMap::SetPixmap( QPixmap & pixmap )
{
	m_pLabel->setPixmap(pixmap);
	resize(pixmap.width(),pixmap.height());
}

/** */
void CDialogPictureMap::GetXY( int & x, int & y )
{
	x = m_nX;
	y = m_nY;
}

/** event filter */
bool CDialogPictureMap::eventFilter( QObject * object, QEvent * event )
{
	if ((event->type() == QEvent::MouseButtonDblClick)&&((QLabel*)object==m_pLabel))
	{
		QMouseEvent * e = (QMouseEvent*)event;

		m_nX = e->x();
		m_nY = e->y();

		//printf("EVENT %d %d!\n",e->x(),e->y());

		accept();
	}

	return QWidget::eventFilter( object, event );    // standard event processing
}
