## Contributing to vedo
Thank you for considering contributing to vedo!

vedo is an open-source 3D visualization library for scientific data in Python. It aims to provide an easy-to-use and flexible toolset for creating publication-quality visualizations of complex 3D data.

We welcome all contributions, including bug reports, feature requests, and code contributions. This file outlines the guidelines for contributing to the vedo project.

### Reporting bugs and requesting features
If you encounter a bug in vedo, or would like to request a new feature, please open an issue on the vedo GitHub repository. When opening an issue, please provide as much detail as possible about the problem or feature request, including code snippets, screenshots, or other relevant information.

### Contributing code
If you would like to contribute code to vedo, please follow these guidelines:

Fork the vedo repository and create a new branch for your changes.
Make your changes, including adding tests and updating documentation as necessary.

Submit a pull request to the vedo repository.
When submitting a pull request, please provide a clear and detailed description of your changes, including the motivation for the changes and any relevant background information.

All contributions will be reviewed by the vedo development team, and we may request changes or ask for additional information before merging your changes.

### Code style
When contributing code to vedo, please follow the PEP 8 style guide.

###Licensing
All contributions to vedo are subject to the MIT license. 
By contributing to vedo, you agree to license your contributions under the terms of this license.

### Thank you!
We appreciate your interest in contributing to vedo, and we look forward to working with you to make it even better!
