/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#include "TLogo.h"

TLogo::TLogo()
{
	renderer = new QSvgRenderer(QLatin1String(":/img/logo_gray.svg"));
	this->setSharedRenderer(renderer);
	w_scale = 1.0;
	h_scale = 1.0;
}

void TLogo::setSize(QRect bound)
{
	qreal w_new = (qreal)bound.width() / (qreal)renderer->defaultSize().width();
	qreal h_new = (qreal)bound.height() / (qreal)renderer->defaultSize().height();
	
	qreal to_one_w = 1.0 / w_scale;
	qreal to_one_h = 1.0 / h_scale;
	
	this->scale(to_one_w * w_new, to_one_h * h_new);
	this->setPos(bound.x(), bound.y());
	
	w_scale = w_new;
	h_scale = h_new;
}

void TLogo::paint(QPainter * painter, const QStyleOptionGraphicsItem* option,
					   QWidget* widget)

{
	painter->setOpacity(0.2);
	QGraphicsSvgItem::paint(painter, option, widget);
	painter->setOpacity(1.0);

}
